/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.rng.doctype;

import com.xmlmind.xmledit.doc.Attribute;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.Text;
import com.xmlmind.xmledit.doc.TextNode;
import com.xmlmind.xmledit.doctype.AttributeType;
import com.xmlmind.xmledit.doctype.CommentItem;
import com.xmlmind.xmledit.doctype.Data;
import com.xmlmind.xmledit.doctype.DataFormatException;
import com.xmlmind.xmledit.doctype.DataType;
import com.xmlmind.xmledit.doctype.ElementType;
import com.xmlmind.xmledit.doctype.Field;
import com.xmlmind.xmledit.doctype.Item;
import com.xmlmind.xmledit.doctype.NameClass;
import com.xmlmind.xmledit.doctype.Structure;
import com.xmlmind.xmledit.doctype.TextItem;
import com.xmlmind.xmledit.doctype.UncheckedUnparsedEntities;
import com.xmlmind.xmledit.rng.doctype.AttributeField;
import com.xmlmind.xmledit.rng.doctype.Builder;
import com.xmlmind.xmledit.rng.doctype.ChoicePattern;
import com.xmlmind.xmledit.rng.doctype.EmptyPattern;
import com.xmlmind.xmledit.rng.doctype.FieldBase;
import com.xmlmind.xmledit.rng.doctype.FieldList;
import com.xmlmind.xmledit.rng.doctype.InterleavePattern;
import com.xmlmind.xmledit.rng.doctype.ItemList;
import com.xmlmind.xmledit.rng.doctype.Matcher;
import com.xmlmind.xmledit.rng.doctype.NameClassBase;
import com.xmlmind.xmledit.rng.doctype.NotAllowedPattern;
import com.xmlmind.xmledit.rng.doctype.Occurrence;
import com.xmlmind.xmledit.rng.doctype.OneOrMorePattern;
import com.xmlmind.xmledit.rng.doctype.OverlapDetector;
import com.xmlmind.xmledit.rng.doctype.Pattern;
import com.xmlmind.xmledit.rng.doctype.PatternList;
import com.xmlmind.xmledit.rng.doctype.PatternStack;
import com.xmlmind.xmledit.rng.doctype.SingleNameClass;
import com.xmlmind.xmledit.rng.doctype.TextPattern;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.NamespaceToPrefixes;
import com.xmlmind.xmledit.xmlutil.XMLUtil;
import com.xmlmind.xmledit.xsd.datatype.IDType;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

final class ElementField
extends FieldBase
implements ElementType {
    public int contentType;
    public AttributeField[] attributeFields;
    public boolean[] attributeIsRequired;
    public ElementField[] childElementFields;
    boolean hasAttributeDefaultValues;
    private IdentityHashMap ambiguousFields;
    private static final int MIX_EMPTY = 0;
    private static final int MIX_TEXT = 1;
    private static final int MIX_ELEMENT_ONLY = 2;
    private static final int MIX_MIXED = 3;
    private static final int MIX_OTHER = 4;
    private static final QuickMatcher EMPTY_QUICK_MATCHER = new QuickMatcher();
    static final int TEST_CREATE_INSTANCE = 0x40000000;
    public static final int NOT_AMBIGUOUS = 0;
    public static final int MAY_BE_AMBIGUOUS = 1;
    public static final int AMBIGUOUS = 2;

    public ElementField(NameClassBase nameClassBase, Pattern pattern, Builder builder) {
        this.init1(nameClassBase, pattern, builder);
        this.init2();
    }

    ElementField() {
    }

    void init1(NameClassBase nameClassBase, Pattern pattern, Builder builder) {
        this.init0(nameClassBase, pattern, builder);
        PatternStack patternStack = new PatternStack();
        IdentityHashMap identityHashMap = new IdentityHashMap();
        IdentityHashMap identityHashMap2 = new IdentityHashMap();
        this.contentType = pattern.scan(patternStack, identityHashMap, identityHashMap2);
        int n = identityHashMap.size();
        this.attributeFields = new AttributeField[n];
        this.attributeIsRequired = new boolean[n];
        this.hasAttributeDefaultValues = false;
        if (n > 0) {
            n = 0;
            Iterator iterator = identityHashMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                AttributeField attributeField = (AttributeField)entry.getKey();
                boolean bl = (Boolean)entry.getValue();
                this.attributeFields[n] = attributeField;
                boolean bl2 = attributeField.getFieldName() == null;
                this.attributeIsRequired[n] = bl && !bl2;
                ++n;
                if (this.hasAttributeDefaultValues || attributeField.defaultValueAnnotation == null) continue;
                this.hasAttributeDefaultValues = true;
            }
        }
        this.childElementFields = new ElementField[identityHashMap2.size()];
        identityHashMap2.values().toArray(this.childElementFields);
        switch (this.contentType) {
            case 1: {
                this.initDataType();
                break;
            }
            case 3: {
                this.contentType = this.getMixedContentType();
            }
        }
    }

    protected int scan(PatternStack patternStack, IdentityHashMap identityHashMap, IdentityHashMap identityHashMap2) {
        identityHashMap2.put(this, this);
        return 2;
    }

    private int getMixedContentType() {
        Pattern pattern = this.pattern;
        if (this.attributeFields.length > 0) {
            if (pattern.attributesSeparatedFromElements() > 2) {
                return 5;
            }
            pattern = pattern.withoutAttributes(this.builder);
        }
        if (!pattern.nullable) {
            return 5;
        }
        if (pattern == TextPattern.INSTANCE) {
            return 4;
        }
        PatternList patternList = new PatternList();
        Occurrence occurrence = Occurrence.which(pattern);
        if (occurrence.pattern instanceof InterleavePattern) {
            InterleavePattern interleavePattern = (InterleavePattern)occurrence.pattern;
            interleavePattern.getInterleaved(patternList);
        } else {
            patternList.add(pattern);
        }
        boolean bl = false;
        int n = 0;
        block6: while (n < patternList.size) {
            Pattern pattern2 = patternList.list[n];
            switch (ElementField.scanMix(pattern2)) {
                case 0: {
                    break;
                }
                case 1: {
                    bl = true;
                    break;
                }
                case 2: {
                    occurrence = Occurrence.which(pattern2);
                    if (occurrence.occurrence == 2 || occurrence.occurrence == 3 && occurrence.pattern.nullable) break;
                    break block6;
                }
                case 3: {
                    occurrence = Occurrence.which(pattern2);
                    if (occurrence.occurrence != 2 && occurrence.occurrence != 3) break block6;
                    bl = true;
                    break;
                }
                default: {
                    break block6;
                }
            }
            ++n;
        }
        if (bl && n == patternList.size) {
            return 4;
        }
        return 5;
    }

    private static final int scanMix(Pattern pattern) {
        if (pattern == EmptyPattern.INSTANCE) {
            return 0;
        }
        if (pattern == TextPattern.INSTANCE) {
            return 1;
        }
        if (pattern instanceof ElementField) {
            return 2;
        }
        if (pattern instanceof OneOrMorePattern) {
            OneOrMorePattern oneOrMorePattern = (OneOrMorePattern)pattern;
            return ElementField.scanMix(oneOrMorePattern.pattern);
        }
        if (pattern instanceof ChoicePattern) {
            ChoicePattern choicePattern = (ChoicePattern)pattern;
            int n = ElementField.scanMix(choicePattern.pattern1);
            int n2 = ElementField.scanMix(choicePattern.pattern2);
            if (n == 1 && n2 == 2 || n == 2 && n2 == 1) {
                return 3;
            }
            return Math.max(n, n2);
        }
        return 4;
    }

    void init2() {
        if (this.attributeFields.length > 0) {
            this.checkAmbiguity(this.attributeFields, true);
        }
        if (this.childElementFields.length > 0) {
            this.checkAmbiguity(this.childElementFields, false);
        }
    }

    private void checkAmbiguity(Field[] fieldArray, boolean bl) {
        Object object;
        Object object2;
        Object object3;
        IdentityHashMap<Object, Object> identityHashMap = new IdentityHashMap<Object, Object>();
        Field[] fieldArray2 = null;
        int n = 0;
        int n2 = 0;
        while (n2 < fieldArray.length) {
            object3 = fieldArray[n2];
            object2 = object3.getFieldName();
            if (object2 != null) {
                object = (FieldList)identityHashMap.get(object2);
                if (object == null) {
                    object = new FieldList();
                    identityHashMap.put(object2, object);
                }
                ((FieldList)object).add((Field)object3);
            } else {
                if (fieldArray2 == null) {
                    fieldArray2 = new Field[fieldArray.length];
                }
                fieldArray2[n++] = object3;
            }
            ++n2;
        }
        object3 = identityHashMap.values().iterator();
        while (object3.hasNext()) {
            object2 = (FieldList)object3.next();
            if (((FieldList)object2).size <= 1) continue;
            if (bl) {
                this.checkAttributeAmbiguity((FieldList)object2);
                continue;
            }
            this.checkElementAmbiguity((FieldList)object2);
        }
        int n3 = 0;
        while (n3 < n) {
            object = fieldArray2[n3];
            NameClass nameClass = object.getFieldNameClass();
            if (n > 1) {
                int n4 = 0;
                while (n4 < n) {
                    Field field;
                    NameClass nameClass2;
                    if (n4 != n3 && OverlapDetector.overlap((NameClassBase)nameClass, (NameClassBase)(nameClass2 = (field = fieldArray2[n4]).getFieldNameClass()))) {
                        this.addAmbiguousField((Field)object, Boolean.FALSE);
                        this.addAmbiguousField(field, Boolean.FALSE);
                    }
                    ++n4;
                }
            }
            object3 = identityHashMap.entrySet().iterator();
            while (object3.hasNext()) {
                Map.Entry entry = object3.next();
                if (!nameClass.containsName((Name)entry.getKey())) continue;
                this.addAmbiguousField((Field)object, Boolean.FALSE);
                this.addAmbiguousFields((FieldList)entry.getValue(), Boolean.FALSE);
            }
            ++n3;
        }
    }

    private void checkAttributeAmbiguity(FieldList fieldList) {
        int n = fieldList.size;
        Field[] fieldArray = fieldList.list;
        int n2 = 0;
        while (n2 < n) {
            AttributeField attributeField = (AttributeField)fieldArray[n2];
            if (attributeField.fixedValue != null) {
                boolean bl = false;
                int n3 = 0;
                while (n3 < n) {
                    if (n3 != n2) {
                        AttributeField attributeField2 = (AttributeField)fieldArray[n3];
                        if (attributeField2.fixedValue == null || attributeField2.fixedValue.equals(attributeField.fixedValue)) {
                            bl = true;
                            break;
                        }
                    }
                    ++n3;
                }
                this.addAmbiguousField(attributeField, bl ? Boolean.FALSE : Boolean.TRUE);
            } else {
                this.addAmbiguousField(attributeField, Boolean.FALSE);
            }
            ++n2;
        }
    }

    private void checkElementAmbiguity(FieldList fieldList) {
        int n = fieldList.size;
        Field[] fieldArray = fieldList.list;
        int n2 = 0;
        while (n2 < n) {
            ElementField elementField = (ElementField)fieldArray[n2];
            if (elementField.fixedValue != null) {
                boolean bl = false;
                int n3 = 0;
                while (n3 < n) {
                    if (n3 != n2) {
                        ElementField elementField2 = (ElementField)fieldArray[n3];
                        if (elementField2.fixedValue == null || elementField2.fixedValue.equals(elementField.fixedValue)) {
                            bl = true;
                            break;
                        }
                    }
                    ++n3;
                }
                this.addAmbiguousField(elementField, bl ? Boolean.FALSE : Boolean.TRUE);
            } else {
                Object object;
                int n4;
                Object object2;
                QuickMatcher quickMatcher = null;
                AttributeField[] attributeFieldArray = elementField.attributeFields;
                int n5 = 0;
                while (n5 < attributeFieldArray.length) {
                    object2 = attributeFieldArray[n5].getFieldName();
                    if (object2 != null) {
                        int n6;
                        Object object3;
                        n4 = 0;
                        int n7 = 0;
                        block3: while (n7 < n) {
                            if (n7 != n2) {
                                object3 = (ElementField)fieldArray[n7];
                                AttributeField[] attributeFieldArray2 = ((ElementField)object3).attributeFields;
                                n6 = 0;
                                while (n6 < attributeFieldArray2.length) {
                                    if (attributeFieldArray2[n6].nameClass.containsName((Name)object2)) {
                                        n4 = 1;
                                        break block3;
                                    }
                                    ++n6;
                                }
                            }
                            ++n7;
                        }
                        if (n4 == 0) {
                            if (quickMatcher == null) {
                                quickMatcher = new QuickMatcher();
                            }
                            quickMatcher.addAttribute((Name)object2, null);
                        } else {
                            object3 = attributeFieldArray[n5].fixedValue;
                            if (object3 != null) {
                                boolean bl = true;
                                n6 = 0;
                                while (n6 < n) {
                                    if (n6 != n2) {
                                        object = (ElementField)fieldArray[n6];
                                        AttributeField[] attributeFieldArray3 = object.attributeFields;
                                        boolean bl2 = false;
                                        int n8 = 0;
                                        while (n8 < attributeFieldArray3.length) {
                                            AttributeField attributeField = attributeFieldArray3[n8];
                                            if (attributeField.nameClass.containsName((Name)object2) && attributeField.fixedValue != null && !attributeField.fixedValue.equals(object3)) {
                                                bl2 = true;
                                                break;
                                            }
                                            ++n8;
                                        }
                                        if (!bl2) {
                                            bl = false;
                                            break;
                                        }
                                    }
                                    ++n6;
                                }
                                if (bl) {
                                    if (quickMatcher == null) {
                                        quickMatcher = new QuickMatcher();
                                    }
                                    quickMatcher.addAttribute((Name)object2, attributeFieldArray[n5]);
                                }
                            }
                        }
                    }
                    ++n5;
                }
                object2 = elementField.childElementFields;
                n4 = 0;
                while (n4 < ((ElementField[])object2).length) {
                    Name name = object2[n4].getFieldName();
                    if (name != null) {
                        boolean bl = false;
                        int n9 = 0;
                        block8: while (n9 < n) {
                            if (n9 != n2) {
                                ElementField elementField3 = (ElementField)fieldArray[n9];
                                object = elementField3.childElementFields;
                                int n10 = 0;
                                while (n10 < ((ElementField[])object).length) {
                                    if (object[n10].nameClass.containsName(name)) {
                                        bl = true;
                                        break block8;
                                    }
                                    ++n10;
                                }
                            }
                            ++n9;
                        }
                        if (!bl) {
                            if (quickMatcher == null) {
                                quickMatcher = new QuickMatcher();
                            }
                            quickMatcher.addChildElement(name);
                        }
                    }
                    ++n4;
                }
                if (quickMatcher == null) {
                    quickMatcher = EMPTY_QUICK_MATCHER;
                }
                this.addAmbiguousField(elementField, quickMatcher);
            }
            ++n2;
        }
    }

    private void addAmbiguousField(Field field, Object object) {
        if (this.ambiguousFields == null) {
            this.ambiguousFields = new IdentityHashMap();
        }
        this.ambiguousFields.put(field, object);
    }

    private void addAmbiguousFields(FieldList fieldList, Object object) {
        if (this.ambiguousFields == null) {
            this.ambiguousFields = new IdentityHashMap();
        }
        int n = 0;
        while (n < fieldList.size) {
            this.ambiguousFields.put(fieldList.list[n], object);
            ++n;
        }
    }

    public int hashCode() {
        return this.nameClass.hashCode() ^ System.identityHashCode(this.pattern);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ElementField)) {
            return false;
        }
        ElementField elementField = (ElementField)object;
        return this.nameClass.equals(elementField.nameClass) && this.pattern == elementField.pattern;
    }

    public void toString(int n, NamespaceToPrefixes namespaceToPrefixes, StringBuffer stringBuffer) {
        boolean bl;
        boolean bl2 = bl = stringBuffer.length() == 0;
        if (!bl) {
            n = -1;
        }
        stringBuffer.append("element ");
        this.nameClass.toLabel(false, namespaceToPrefixes, stringBuffer);
        stringBuffer.append(" {");
        if (n >= 0) {
            stringBuffer.append('\n');
            Pattern.indent(n + 2, stringBuffer);
        }
        if (bl) {
            this.pattern.toString(n >= 0 ? n + 2 : -1, namespaceToPrefixes, stringBuffer);
        } else {
            stringBuffer.append("...");
        }
        if (n >= 0) {
            stringBuffer.append('\n');
            Pattern.indent(n, stringBuffer);
        }
        stringBuffer.append("}");
    }

    public Pattern elementDeriv(ElementField elementField, Builder builder) {
        if (elementField == this) {
            return EmptyPattern.INSTANCE;
        }
        return NotAllowedPattern.INSTANCE;
    }

    public Pattern elementDeriv(Element element, IdentityHashMap identityHashMap, FieldBase[] fieldBaseArray, Builder builder) {
        if (this.nameClass.containsName(element.getName())) {
            if (identityHashMap != null) {
                Object v = identityHashMap.get(this);
                if (v == Boolean.FALSE) {
                    return NotAllowedPattern.INSTANCE;
                }
                if (v == Boolean.TRUE) {
                    Data data = null;
                    String string = element.getText();
                    if (string != null) {
                        try {
                            data = this.dataType.parseData(string, element, UncheckedUnparsedEntities.INSTANCE);
                        }
                        catch (DataFormatException dataFormatException) {
                            // empty catch block
                        }
                    }
                    if (!this.fixedValue.equals(data)) {
                        return NotAllowedPattern.INSTANCE;
                    }
                } else if (v != null && v instanceof QuickMatcher && !((QuickMatcher)v).match(element)) {
                    return NotAllowedPattern.INSTANCE;
                }
            }
            fieldBaseArray[0] = this;
            return EmptyPattern.INSTANCE;
        }
        return NotAllowedPattern.INSTANCE;
    }

    public int getElementContentType() {
        return this.contentType;
    }

    public DataType getElementDataType() {
        return this.dataType;
    }

    public Object getElementFixedValue() {
        return this.fixedValue;
    }

    public Object getElementDefaultValue() {
        return null;
    }

    public Field[] getAttributeFields() {
        return this.attributeFields;
    }

    public void getAttributeFields(Name name, List list) {
        list.clear();
        int n = 0;
        while (n < this.attributeFields.length) {
            AttributeField attributeField = this.attributeFields[n];
            Name name2 = attributeField.getFieldName();
            if (name2 == null) {
                if (attributeField.getFieldNameClass().containsName(name)) {
                    list.add(attributeField);
                }
            } else if (name == name2) {
                list.add(attributeField);
            }
            ++n;
        }
    }

    public boolean isRequiredAttribute(Field field) {
        int n = 0;
        while (n < this.attributeFields.length) {
            if (this.attributeFields[n] == field) {
                return this.attributeIsRequired[n];
            }
            ++n;
        }
        return false;
    }

    public Data getAttributeDefaultValue(Name name) {
        int n = 0;
        while (n < this.attributeFields.length) {
            AttributeField attributeField = this.attributeFields[n];
            if (name == attributeField.getFieldName()) {
                return attributeField.getAttributeDefaultValue();
            }
            ++n;
        }
        return null;
    }

    public Field[] getChildElementFields() {
        return this.childElementFields;
    }

    public void getChildElementFields(Name name, List list) {
        list.clear();
        int n = 0;
        while (n < this.childElementFields.length) {
            ElementField elementField = this.childElementFields[n];
            Name name2 = elementField.getFieldName();
            if (name2 == null) {
                if (elementField.getFieldNameClass().containsName(name)) {
                    list.add(elementField);
                }
            } else if (name == name2) {
                list.add(elementField);
            }
            ++n;
        }
    }

    public boolean canCheckAttributeStructure() {
        return false;
    }

    public boolean checkStructure(Field[] fieldArray, int n, Item[] itemArray, int n2) {
        return Matcher.match(this.pattern, fieldArray, n, itemArray, n2, this.builder);
    }

    public boolean checkAttributeStructure(Field[] fieldArray, int n, Item[] itemArray, int n2) {
        return this.checkStructure(fieldArray, n, itemArray, n2);
    }

    public boolean checkElementStructure(Field[] fieldArray, int n, Item[] itemArray, int n2) {
        return this.checkStructure(fieldArray, n, itemArray, n2);
    }

    public boolean getStructure(Attribute[] attributeArray, int n, Node[] nodeArray, int n2, boolean bl, Structure structure) {
        return Matcher.match(this.pattern, this.ambiguousFields, attributeArray, n, nodeArray, n2, bl, structure, this.builder);
    }

    public boolean getStructure(Element element, boolean bl, Structure structure) {
        return Matcher.match(this.pattern, this.ambiguousFields, element, bl, structure, this.builder);
    }

    public boolean getAttributeStructure(Attribute[] attributeArray, int n, Node[] nodeArray, int n2, boolean bl, Structure structure) {
        return this.getStructure(attributeArray, n, nodeArray, n2, bl, structure);
    }

    public boolean getAttributeStructure(Element element, boolean bl, Structure structure) {
        return this.getStructure(element, bl, structure);
    }

    public boolean getElementStructure(Attribute[] attributeArray, int n, Node[] nodeArray, int n2, boolean bl, Structure structure) {
        return this.getStructure(attributeArray, n, nodeArray, n2, bl, structure);
    }

    public boolean getElementStructure(Element element, boolean bl, Structure structure) {
        return this.getStructure(element, bl, structure);
    }

    public AttributeType getAttributeType(Field field, Name name) {
        return (AttributeField)field;
    }

    public ElementType getChildElementType(Field field, Name name) {
        return (ElementField)field;
    }

    public ElementType getChildElementType(Field field, Element element) {
        return (ElementField)field;
    }

    public Element createInstance(Name name, int n) {
        Element element = new Element(name);
        ItemList itemList = new ItemList();
        if (!this.expand(n, itemList)) {
            return element;
        }
        this.initElement(n, itemList.list, 1, itemList.size, element);
        if (this.fixedValue != null) {
            ElementField.initFixedValue(this, element);
        }
        ElementField.initText(this, n, element);
        return element;
    }

    private int initElement(int n, Item[] itemArray, int n2, int n3, Element element) {
        int n4 = n2;
        while (n4 < n3) {
            Object object;
            Name name;
            Object object2;
            Item item = itemArray[n4];
            if (item == CommentItem.INSTANCE) break;
            if (item == TextItem.INSTANCE) {
                object2 = new Text();
                if ((n & 0x40000000) != 0) {
                    ((TextNode)object2).setText("#text");
                }
                element.appendChild((Node)object2);
            } else if (item instanceof AttributeField) {
                object2 = (AttributeField)item;
                name = ((AttributeField)object2).nameClass.getInstance();
                object = null;
                if ((n & 0x20) != 0) {
                    object = "";
                } else if ((n & 2) != 0 && ((AttributeField)object2).dataType instanceof IDType) {
                    object = XMLUtil.getUniqueId();
                }
                if (object == null) {
                    object = ((AttributeField)object2).fixedValue != null ? ((AttributeField)object2).fixedValue.formatData(null) : "???";
                }
                if (name != null) {
                    element.putAttribute(name, (String)object);
                }
            } else {
                object2 = (ElementField)item;
                name = ((ElementField)object2).nameClass.getInstance();
                object = new Element(name == null ? Name.get("x") : name);
                n4 = this.initElement(n, itemArray, n4 + 1, n3, (Element)object);
                if (name != null) {
                    if (((ElementField)object2).fixedValue != null) {
                        ElementField.initFixedValue((ElementField)object2, (Element)object);
                    }
                    ElementField.initText((ElementField)object2, n, (Element)object);
                    element.appendChild((Node)object);
                }
            }
            ++n4;
        }
        return n4;
    }

    private static final void initFixedValue(ElementField elementField, Element element) {
        TextNode textNode = null;
        Node node = element.getFirstChild();
        while (node != null) {
            if (node instanceof Text) {
                if (textNode == null) {
                    textNode = (Text)node;
                } else {
                    textNode = null;
                    break;
                }
            }
            node = node.getNextSibling();
        }
        if (textNode != null) {
            textNode.setText(elementField.fixedValue.formatData(null));
        }
    }

    private static final void initText(ElementField elementField, int n, Element element) {
        switch (elementField.contentType) {
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                if (!element.hasNoContent() || elementField.contentType == 5 && element.getAttributeCount() != 0) break;
                Text text = new Text();
                if ((n & 0x40000000) != 0) {
                    text.setText("#text");
                }
                element.appendChild(text);
            }
        }
    }

    protected int getComplexity(boolean bl) {
        int n = 200;
        n = this.nameClass instanceof SingleNameClass ? (n += ((SingleNameClass)this.nameClass).name.getLocalPart().length()) : (n += 1000);
        if (bl) {
            n += this.pattern.getComplexity(false);
        }
        return n;
    }

    protected boolean expand(int n, ItemList itemList) {
        if ((n & 4) != 0 || itemList.size == 0) {
            if (!ElementField.checkRecursion(itemList, this)) {
                return false;
            }
            int n2 = itemList.size;
            itemList.add(this);
            if (!this.pattern.expand(n, itemList)) {
                itemList.setSize(n2);
                return false;
            }
            itemList.add(CommentItem.INSTANCE);
        }
        return true;
    }

    private static boolean checkRecursion(ItemList itemList, ElementField elementField) {
        int n = 0;
        int n2 = itemList.size - 1;
        while (n2 >= 0) {
            Item item = itemList.list[n2];
            if (item == CommentItem.INSTANCE) {
                ++n;
            } else if (item instanceof ElementField) {
                if (n > 0) {
                    --n;
                } else if (item == elementField) {
                    return false;
                }
            }
            --n2;
        }
        return true;
    }

    public int isAmbiguousField(Field field) {
        if (this.ambiguousFields == null) {
            return 0;
        }
        Object v = this.ambiguousFields.get(field);
        if (v == null) {
            return 0;
        }
        if (v == Boolean.FALSE || v == EMPTY_QUICK_MATCHER) {
            return 2;
        }
        return 1;
    }

    public boolean hasAmbiguousFields() {
        return this.ambiguousFields != null;
    }

    private static final class QuickMatcher {
        private Name[] attributeNames = null;
        private AttributeField[] fixedAttributes = null;
        private Name[] childElementNames = null;

        private QuickMatcher() {
        }

        public void addAttribute(Name name, AttributeField attributeField) {
            if (this.attributeNames == null) {
                this.attributeNames = new Name[]{name};
                this.fixedAttributes = new AttributeField[]{attributeField};
            } else {
                Name[] nameArray = new Name[this.attributeNames.length + 1];
                System.arraycopy(this.attributeNames, 0, nameArray, 0, this.attributeNames.length);
                nameArray[this.attributeNames.length] = name;
                this.attributeNames = nameArray;
                AttributeField[] attributeFieldArray = new AttributeField[this.fixedAttributes.length + 1];
                System.arraycopy(this.fixedAttributes, 0, attributeFieldArray, 0, this.fixedAttributes.length);
                attributeFieldArray[this.fixedAttributes.length] = attributeField;
                this.fixedAttributes = attributeFieldArray;
            }
        }

        public void addChildElement(Name name) {
            if (this.childElementNames == null) {
                this.childElementNames = new Name[]{name};
            } else {
                Name[] nameArray = new Name[this.childElementNames.length + 1];
                System.arraycopy(this.childElementNames, 0, nameArray, 0, this.childElementNames.length);
                nameArray[this.childElementNames.length] = name;
                this.childElementNames = nameArray;
            }
        }

        public boolean match(Element element) {
            Object object;
            if (this.attributeNames != null) {
                int n = 0;
                while (n < this.attributeNames.length) {
                    object = element.getAttribute(this.attributeNames[n]);
                    if (object != null) {
                        if (this.fixedAttributes[n] == null) {
                            return true;
                        }
                        Data data = null;
                        try {
                            data = this.fixedAttributes[n].dataType.parseData((String)object, element, UncheckedUnparsedEntities.INSTANCE);
                        }
                        catch (DataFormatException dataFormatException) {
                            // empty catch block
                        }
                        return this.fixedAttributes[n].fixedValue.equals(data);
                    }
                    ++n;
                }
            }
            if (this.childElementNames != null) {
                Node node = element.getFirstChild();
                while (node != null) {
                    if (node instanceof Element) {
                        object = ((Element)node).getName();
                        int n = 0;
                        while (n < this.childElementNames.length) {
                            if (object == this.childElementNames[n]) {
                                return true;
                            }
                            ++n;
                        }
                    }
                    node = node.getNextSibling();
                }
            }
            return false;
        }
    }
}

