/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.rng.doctype;

import com.xmlmind.xmledit.rng.doctype.NameClassBase;
import com.xmlmind.xmledit.rng.doctype.NameClassVisitor;
import com.xmlmind.xmledit.rng.doctype.SingleNameClass;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.Namespace;

final class OverlapDetector
implements NameClassVisitor {
    private final NameClassBase nc1;
    private final NameClassBase nc2;
    private boolean overlaps = false;
    private static final String ILLEGAL = "\u0000";

    public static boolean overlap(NameClassBase nameClassBase, NameClassBase nameClassBase2) {
        if (nameClassBase2 instanceof SingleNameClass) {
            return nameClassBase.containsName(((SingleNameClass)nameClassBase2).name);
        }
        if (nameClassBase instanceof SingleNameClass) {
            return nameClassBase2.containsName(((SingleNameClass)nameClassBase).name);
        }
        return new OverlapDetector((NameClassBase)nameClassBase, (NameClassBase)nameClassBase2).overlaps;
    }

    private OverlapDetector(NameClassBase nameClassBase, NameClassBase nameClassBase2) {
        this.nc1 = nameClassBase;
        this.nc2 = nameClassBase2;
        nameClassBase.accept(this);
        nameClassBase2.accept(this);
    }

    public void visitName(Name name) {
        this.probe(name);
    }

    private void probe(Name name) {
        if (this.nc1.containsName(name) && this.nc2.containsName(name)) {
            this.overlaps = true;
        }
    }

    public void visitAnyName() {
        this.probe(Name.get(ILLEGAL, ILLEGAL));
    }

    public void visitAnyNameExcept(NameClassBase nameClassBase) {
        this.probe(Name.get(ILLEGAL, ILLEGAL));
        nameClassBase.accept(this);
    }

    public void visitNsName(Namespace namespace) {
        this.probe(Name.get(namespace, ILLEGAL));
    }

    public void visitNsNameExcept(Namespace namespace, NameClassBase nameClassBase) {
        this.probe(Name.get(namespace, ILLEGAL));
        nameClassBase.accept(this);
    }

    public void visitChoice(NameClassBase nameClassBase, NameClassBase nameClassBase2) {
        nameClassBase.accept(this);
        nameClassBase2.accept(this);
    }
}

