/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.rng.doctype;

import com.xmlmind.xmledit.doc.Attribute;
import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.ProcessingInstruction;
import com.xmlmind.xmledit.doc.Text;
import com.xmlmind.xmledit.doc.TextNode;
import com.xmlmind.xmledit.doc.XNode;
import com.xmlmind.xmledit.rng.doctype.SAXTraversalException;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.Namespace;
import com.xmlmind.xmledit.xmlutil.PreferredPrefix;
import com.xmlmind.xmledit.xmlutil.PrefixEntry;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

final class SAXTraversal
implements XMLReader,
Locator {
    public static final String NAMESPACES_FEATURE = "http://xml.org/sax/features/namespaces";
    public static final String NAMESPACE_PREFIX_FEATURE = "http://xml.org/sax/features/namespace-prefixes";
    public static final String VALIDATION_FEATURE = "http://xml.org/sax/features/validation";
    public static final String EXTERNAL_GENERAL_ENTITIES_FEATURE = "http://xml.org/sax/features/external-general-entities";
    public static final String EXTERNAL_PARAMETER_ENTITIES_FEATURE = "http://xml.org/sax/features/external-parameter-entities";
    public static final String PARAMETER_ENTITIES_FEATURE = "http://xml.org/sax/features/lexical-handler/parameter-entities";
    public static final String LEXICAL_HANDLER_PROPERTY = "http://xml.org/sax/properties/lexical-handler";
    public static final String DECLARATION_HANDLER_PROPERTY = "http://xml.org/sax/properties/declaration-handler";
    private Document boundDocument;
    private ArrayList traversedElements;
    private EntityResolver entityResolver;
    private DTDHandler dtdHandler;
    private ContentHandler contentHandler;
    private ErrorHandler errorHandler;
    private DefaultHandler defaultHandler = new DefaultHandler();
    private ContentHandler handleContent = this.defaultHandler;
    private ErrorHandler handleError = this.defaultHandler;
    private Document doc;
    private PreferredPrefix preferredPrefix;
    private ArrayList elements = null;
    private AttributesImpl attributes = new AttributesImpl();
    private int[] lineNumbers = new int[10];
    private int lineNumberCount = 0;

    public SAXTraversal() {
        this(null, null);
    }

    public SAXTraversal(Document document) {
        this(document, null);
    }

    public SAXTraversal(Document document, ArrayList arrayList) {
        this.boundDocument = document;
        this.traversedElements = arrayList;
    }

    public Document getBoundDocument() {
        return this.boundDocument;
    }

    public ArrayList getTraversedElements() {
        return this.traversedElements;
    }

    public void traverse(Document document) throws SAXException {
        this.traverse(document, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void traverse(Document document, ArrayList arrayList) throws SAXException {
        this.doc = document;
        if (arrayList != null) {
            arrayList.clear();
            this.elements = arrayList;
        } else {
            this.elements = new ArrayList();
        }
        try {
            this.doTraverse(document);
        }
        finally {
            document = null;
            this.preferredPrefix = null;
            this.elements = null;
            this.attributes.clear();
            this.popAllLineNumbers();
            this.handleContent = this.contentHandler;
            if (this.handleContent == null) {
                this.handleContent = this.defaultHandler;
            }
            this.handleError = this.errorHandler;
            if (this.handleError == null) {
                this.handleError = this.defaultHandler;
            }
        }
    }

    private void doTraverse(Document document) throws SAXException {
        this.handleContent.setDocumentLocator(this);
        this.handleContent.startDocument();
        Object object = document.getProperty("NAMESPACE_PREFIX_MAP");
        PrefixEntry[] prefixEntryArray = null;
        if (object instanceof PreferredPrefix) {
            this.preferredPrefix = (PreferredPrefix)object;
            prefixEntryArray = this.preferredPrefix.getAll();
        }
        if (prefixEntryArray == null) {
            SAXTraversalException sAXTraversalException = new SAXTraversalException("document '" + document.getLocation() + "' is not namespace-aware" + " (has no com.xmlmind.xmledit.xmlutil.PreferredPrefix)", this);
            this.handleError.fatalError(sAXTraversalException);
            throw sAXTraversalException;
        }
        int n = 0;
        while (n < prefixEntryArray.length) {
            PrefixEntry prefixEntry = prefixEntryArray[n];
            this.handleContent.startPrefixMapping(prefixEntry.prefix, prefixEntry.namespace.getURI());
            ++n;
        }
        this.traverse(document.getRootElement());
        int n2 = prefixEntryArray.length - 1;
        while (n2 >= 0) {
            this.handleContent.endPrefixMapping(prefixEntryArray[n2].prefix);
            --n2;
        }
        this.handleContent.endDocument();
    }

    private void traverse(Element element) throws SAXException {
        Object object;
        XNode xNode;
        this.elements.add(element);
        this.pushLineNumber(this.elements.size());
        Name name = element.getName();
        Namespace namespace = name.getNamespace();
        String string = namespace.getURI();
        String string2 = name.getLocalPart();
        String string3 = this.makeQName(namespace, string2);
        this.attributes.clear();
        Enumeration enumeration = element.getAttributes();
        while (enumeration.hasMoreElements()) {
            xNode = (Attribute)enumeration.nextElement();
            object = ((Attribute)xNode).name.getNamespace();
            String string4 = ((Attribute)xNode).name.getLocalPart();
            String string5 = this.makeQName((Namespace)object, string4);
            this.attributes.addAttribute(((Namespace)object).getURI(), string4, string5, "CDATA", ((Attribute)xNode).value);
        }
        this.handleContent.startElement(string, string2, string3, this.attributes);
        xNode = element.getFirstChild();
        while (xNode != null) {
            switch (((Node)xNode).getNodeType()) {
                case 0: {
                    object = (Text)xNode;
                    this.handleContent.characters(((TextNode)object).getTextChars(), 0, ((TextNode)object).getTextLength());
                    break;
                }
                case 2: {
                    object = (ProcessingInstruction)xNode;
                    this.handleContent.processingInstruction(((ProcessingInstruction)object).getTarget(), ((TextNode)object).getText());
                    break;
                }
                case 4: {
                    this.traverse((Element)xNode);
                }
            }
            xNode = ((Node)xNode).getNextSibling();
        }
        this.handleContent.endElement(string, string2, string3);
        this.popLineNumber();
    }

    private String makeQName(Namespace namespace, String string) throws SAXException {
        String string2;
        if (namespace == Namespace.NONE) {
            string2 = string;
        } else if (namespace == Namespace.XML) {
            string2 = "xml:" + string;
        } else {
            String string3 = this.preferredPrefix.get(namespace);
            if (string3 == null) {
                SAXTraversalException sAXTraversalException = new SAXTraversalException("don't find a prefix for namespace '" + namespace + "'", this);
                this.handleError.fatalError(sAXTraversalException);
                throw sAXTraversalException;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string3);
            stringBuffer.append(':');
            stringBuffer.append(string);
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    private void pushLineNumber(int n) {
        if (this.lineNumberCount == this.lineNumbers.length) {
            int[] nArray = new int[2 * this.lineNumberCount];
            System.arraycopy(this.lineNumbers, 0, nArray, 0, this.lineNumberCount);
            this.lineNumbers = nArray;
        }
        this.lineNumbers[this.lineNumberCount++] = n;
    }

    private void popLineNumber() {
        --this.lineNumberCount;
    }

    private void popAllLineNumbers() {
        this.lineNumberCount = 0;
    }

    public Document getDocument() {
        return this.doc;
    }

    public Element getElementAt(int n) {
        if (this.elements == null) {
            return null;
        }
        return SAXTraversal.getElementAt(this.elements, n);
    }

    public static Element getElementAt(ArrayList arrayList, int n) {
        if (n > 0 && n <= arrayList.size()) {
            return (Element)arrayList.get(n - 1);
        }
        return null;
    }

    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (NAMESPACES_FEATURE.equals(string)) {
            return true;
        }
        if (NAMESPACE_PREFIX_FEATURE.equals(string)) {
            return false;
        }
        if (VALIDATION_FEATURE.equals(string)) {
            return false;
        }
        if (EXTERNAL_GENERAL_ENTITIES_FEATURE.equals(string)) {
            return false;
        }
        if (EXTERNAL_PARAMETER_ENTITIES_FEATURE.equals(string)) {
            return false;
        }
        if (PARAMETER_ENTITIES_FEATURE.equals(string)) {
            return false;
        }
        throw new SAXNotRecognizedException("unknown feature " + string);
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (NAMESPACES_FEATURE.equals(string)) {
            if (!bl) {
                throw new SAXNotSupportedException("unsupported value for feature " + string);
            }
        } else if (NAMESPACE_PREFIX_FEATURE.equals(string)) {
            if (bl) {
                throw new SAXNotSupportedException("unsupported value for feature " + string);
            }
        } else if (VALIDATION_FEATURE.equals(string)) {
            if (bl) {
                throw new SAXNotSupportedException("unsupported value for feature " + string);
            }
        } else if (EXTERNAL_GENERAL_ENTITIES_FEATURE.equals(string)) {
            if (bl) {
                throw new SAXNotSupportedException("unsupported value for feature " + string);
            }
        } else if (EXTERNAL_PARAMETER_ENTITIES_FEATURE.equals(string)) {
            if (bl) {
                throw new SAXNotSupportedException(string);
            }
        } else if (PARAMETER_ENTITIES_FEATURE.equals("unsupported value for feature " + string)) {
            if (bl) {
                throw new SAXNotSupportedException("unsupported value for feature " + string);
            }
        } else {
            throw new SAXNotRecognizedException("unknown feature " + string);
        }
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (LEXICAL_HANDLER_PROPERTY.equals(string) || DECLARATION_HANDLER_PROPERTY.equals(string)) {
            return null;
        }
        throw new SAXNotRecognizedException("unknown property " + string);
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (LEXICAL_HANDLER_PROPERTY.equals(string) || DECLARATION_HANDLER_PROPERTY.equals(string)) {
            if (object != null) {
                throw new SAXNotSupportedException("unsupported value for property " + string);
            }
        } else {
            throw new SAXNotRecognizedException("unknown property " + string);
        }
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        this.dtdHandler = dTDHandler;
    }

    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = this.handleContent = contentHandler;
        if (this.handleContent == null) {
            this.handleContent = this.defaultHandler;
        }
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = this.handleError = errorHandler;
        if (this.handleError == null) {
            this.handleError = this.defaultHandler;
        }
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void parse(String string) throws IOException, SAXException {
        this.parse((InputSource)null);
    }

    public void parse(InputSource inputSource) throws IOException, SAXException {
        if (this.boundDocument == null) {
            throw new UnsupportedOperationException("no bound document, please directly use traverse(Document)");
        }
        this.traverse(this.boundDocument, this.traversedElements);
    }

    public String getPublicId() {
        return null;
    }

    public String getSystemId() {
        URL uRL;
        if (this.doc == null || (uRL = this.doc.getLocation()) == null) {
            return null;
        }
        return uRL.toExternalForm();
    }

    public int getLineNumber() {
        return this.lineNumberCount > 0 ? this.lineNumbers[this.lineNumberCount - 1] : -1;
    }

    public int getColumnNumber() {
        return -1;
    }
}

