/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.rng.doctype;

import com.thaiopensource.relaxng.impl.AttributePattern;
import com.thaiopensource.relaxng.impl.CombineSchema;
import com.thaiopensource.relaxng.impl.ElementPattern;
import com.thaiopensource.relaxng.impl.NameClass;
import com.thaiopensource.relaxng.impl.NullNameClass;
import com.thaiopensource.relaxng.impl.PatternSchema;
import com.thaiopensource.relaxng.impl.RefPattern;
import com.thaiopensource.relaxng.impl.SimpleNameClass;
import com.thaiopensource.relaxng.impl.StringDatatype;
import com.thaiopensource.relaxng.impl.TokenDatatype;
import com.thaiopensource.validate.Schema;
import com.xmlmind.xmledit.doctype.Data;
import com.xmlmind.xmledit.doctype.DataType;
import com.xmlmind.xmledit.rng.datatype.TypeImpl;
import com.xmlmind.xmledit.rng.doctype.AnyNameClass;
import com.xmlmind.xmledit.rng.doctype.AnyNameExceptNameClass;
import com.xmlmind.xmledit.rng.doctype.AttributeField;
import com.xmlmind.xmledit.rng.doctype.Builder;
import com.xmlmind.xmledit.rng.doctype.ChoiceNameClass;
import com.xmlmind.xmledit.rng.doctype.ChoicePattern;
import com.xmlmind.xmledit.rng.doctype.DTDCompatibilityException;
import com.xmlmind.xmledit.rng.doctype.DataExceptPattern;
import com.xmlmind.xmledit.rng.doctype.DataPattern;
import com.xmlmind.xmledit.rng.doctype.ElementField;
import com.xmlmind.xmledit.rng.doctype.EmptyPattern;
import com.xmlmind.xmledit.rng.doctype.FieldBase;
import com.xmlmind.xmledit.rng.doctype.GroupPattern;
import com.xmlmind.xmledit.rng.doctype.InterleavePattern;
import com.xmlmind.xmledit.rng.doctype.ListPattern;
import com.xmlmind.xmledit.rng.doctype.Msg;
import com.xmlmind.xmledit.rng.doctype.NameClassBase;
import com.xmlmind.xmledit.rng.doctype.NotAllowedPattern;
import com.xmlmind.xmledit.rng.doctype.NsNameClass;
import com.xmlmind.xmledit.rng.doctype.NsNameExceptNameClass;
import com.xmlmind.xmledit.rng.doctype.OneOrMorePattern;
import com.xmlmind.xmledit.rng.doctype.Pattern;
import com.xmlmind.xmledit.rng.doctype.SingleNameClass;
import com.xmlmind.xmledit.rng.doctype.TextPattern;
import com.xmlmind.xmledit.rng.doctype.TranslatorException;
import com.xmlmind.xmledit.rng.doctype.ValuePattern;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.Namespace;
import com.xmlmind.xmledit.xmlutil.PreferredPrefix;
import com.xmlmind.xmledit.xmlutil.PrefixEntry;
import com.xmlmind.xmledit.xsd.datatype.StringType;
import com.xmlmind.xmledit.xsd.datatype.StringValue;
import com.xmlmind.xmledit.xsd.datatype.TokenType;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import org.relaxng.datatype.Datatype;
import org.xml.sax.Locator;

final class Translator {
    private Builder builder;
    private IdentityHashMap translated = new IdentityHashMap();
    private HashSet sources = new HashSet();
    private PreferredPrefix prefixes = new PreferredPrefix();
    private boolean checkAttributeDefaultValues;

    Translator() {
    }

    public Pattern translate(Schema schema, Builder builder) throws TranslatorException {
        com.thaiopensource.relaxng.impl.Pattern pattern = this.findStartPattern(schema);
        if (pattern == null) {
            throw new TranslatorException("cannot find start pattern");
        }
        this.builder = builder;
        this.translated.clear();
        this.sources.clear();
        this.prefixes.clear();
        this.checkAttributeDefaultValues = false;
        Pattern pattern2 = this.translate(pattern);
        this.initElementFields();
        if (this.checkAttributeDefaultValues) {
            this.checkAttributeDefaultValues();
        }
        return pattern2;
    }

    public URL[] getSourceURLs() {
        URL[] uRLArray;
        int n = this.sources.size();
        URL[] uRLArray2 = new URL[n];
        n = 0;
        Iterator iterator = this.sources.iterator();
        while (iterator.hasNext()) {
            uRLArray = (URL[])iterator.next();
            try {
                uRLArray2[n++] = new URL((String)uRLArray);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (n != uRLArray2.length) {
            uRLArray = new URL[n];
            System.arraycopy(uRLArray2, 0, uRLArray, 0, n);
            uRLArray2 = uRLArray;
        }
        return uRLArray2;
    }

    public PrefixEntry[] getPreferredPrefixes() {
        if (this.prefixes.size() == 0) {
            return null;
        }
        return this.prefixes.getAll();
    }

    private com.thaiopensource.relaxng.impl.Pattern findStartPattern(Schema schema) {
        if (schema instanceof PatternSchema) {
            PatternSchema patternSchema = (PatternSchema)schema;
            return patternSchema.getStartPattern();
        }
        if (schema instanceof CombineSchema) {
            CombineSchema combineSchema = (CombineSchema)schema;
            com.thaiopensource.relaxng.impl.Pattern pattern = this.findStartPattern(combineSchema.getSchema1());
            if (pattern != null) {
                return pattern;
            }
            return this.findStartPattern(combineSchema.getSchema2());
        }
        return null;
    }

    private Pattern translate(com.thaiopensource.relaxng.impl.Pattern pattern) throws TranslatorException {
        Pattern pattern2 = (Pattern)this.translated.get(pattern);
        if (pattern2 != null) {
            return pattern2;
        }
        if (pattern instanceof com.thaiopensource.relaxng.impl.GroupPattern) {
            com.thaiopensource.relaxng.impl.GroupPattern groupPattern = (com.thaiopensource.relaxng.impl.GroupPattern)pattern;
            Pattern pattern3 = this.translate(groupPattern.getOperand1());
            Pattern pattern4 = this.translate(groupPattern.getOperand2());
            pattern2 = pattern3 == NotAllowedPattern.INSTANCE || pattern4 == NotAllowedPattern.INSTANCE ? NotAllowedPattern.INSTANCE : new GroupPattern(pattern3, pattern4);
        } else if (pattern instanceof com.thaiopensource.relaxng.impl.ChoicePattern) {
            com.thaiopensource.relaxng.impl.ChoicePattern choicePattern = (com.thaiopensource.relaxng.impl.ChoicePattern)pattern;
            Pattern pattern5 = this.translate(choicePattern.getOperand1());
            Pattern pattern6 = this.translate(choicePattern.getOperand2());
            pattern2 = pattern5 == NotAllowedPattern.INSTANCE ? pattern6 : (pattern6 == NotAllowedPattern.INSTANCE ? pattern5 : new ChoicePattern(pattern5, pattern6));
        } else if (pattern instanceof com.thaiopensource.relaxng.impl.EmptyPattern) {
            pattern2 = EmptyPattern.INSTANCE;
        } else if (pattern instanceof com.thaiopensource.relaxng.impl.OneOrMorePattern) {
            com.thaiopensource.relaxng.impl.OneOrMorePattern oneOrMorePattern = (com.thaiopensource.relaxng.impl.OneOrMorePattern)pattern;
            Pattern pattern7 = this.translate(oneOrMorePattern.getOperand());
            pattern2 = pattern7 == NotAllowedPattern.INSTANCE ? NotAllowedPattern.INSTANCE : new OneOrMorePattern(pattern7);
        } else {
            if (pattern instanceof RefPattern) {
                RefPattern refPattern = (RefPattern)pattern;
                return this.translate(refPattern.getPattern());
            }
            if (pattern instanceof ElementPattern) {
                ElementPattern elementPattern = (ElementPattern)pattern;
                this.sources.add(elementPattern.getLocator().getSystemId());
                NameClass nameClass = elementPattern.getNameClass();
                if (nameClass instanceof NullNameClass) {
                    pattern2 = NotAllowedPattern.INSTANCE;
                } else {
                    SimpleNameClass[] simpleNameClassArray = Translator.getChoiceOfSimpleNameClass(nameClass);
                    pattern2 = simpleNameClassArray != null ? Translator.makeChoiceOfElements((NameClass[])simpleNameClassArray, 0) : new ElementField();
                    this.translated.put(pattern, pattern2);
                    this.translate(elementPattern.getContent());
                }
            } else if (pattern instanceof AttributePattern) {
                AttributePattern attributePattern = (AttributePattern)pattern;
                this.sources.add(attributePattern.getLocator().getSystemId());
                NameClass nameClass = attributePattern.getNameClass();
                if (nameClass instanceof NullNameClass) {
                    pattern2 = NotAllowedPattern.INSTANCE;
                } else {
                    String string = attributePattern.getDefaultValue();
                    if (!this.checkAttributeDefaultValues && string != null) {
                        this.checkAttributeDefaultValues = true;
                    }
                    SimpleNameClass[] simpleNameClassArray = Translator.getChoiceOfSimpleNameClass(nameClass);
                    Pattern pattern8 = this.translate(attributePattern.getContent());
                    pattern2 = simpleNameClassArray != null ? this.makeChoiceOfAttributes((NameClass[])simpleNameClassArray, 0, pattern8, string, this.builder) : new AttributeField(this.translate(nameClass), pattern8, string, this.builder);
                }
            } else if (pattern instanceof com.thaiopensource.relaxng.impl.TextPattern) {
                pattern2 = TextPattern.INSTANCE;
            } else if (pattern instanceof com.thaiopensource.relaxng.impl.InterleavePattern) {
                com.thaiopensource.relaxng.impl.InterleavePattern interleavePattern = (com.thaiopensource.relaxng.impl.InterleavePattern)pattern;
                Pattern pattern9 = this.translate(interleavePattern.getOperand1());
                Pattern pattern10 = this.translate(interleavePattern.getOperand2());
                pattern2 = pattern9 == NotAllowedPattern.INSTANCE || pattern10 == NotAllowedPattern.INSTANCE ? NotAllowedPattern.INSTANCE : new InterleavePattern(pattern9, pattern10);
            } else if (pattern instanceof com.thaiopensource.relaxng.impl.ValuePattern) {
                com.thaiopensource.relaxng.impl.ValuePattern valuePattern = (com.thaiopensource.relaxng.impl.ValuePattern)pattern;
                pattern2 = new ValuePattern(Translator.translate(valuePattern.getValue(), valuePattern.getDatatype()), Translator.translate(valuePattern.getDatatype()));
            } else if (pattern instanceof com.thaiopensource.relaxng.impl.DataPattern) {
                com.thaiopensource.relaxng.impl.DataPattern dataPattern = (com.thaiopensource.relaxng.impl.DataPattern)pattern;
                pattern2 = new DataPattern(Translator.translate(dataPattern.getDatatype()));
            } else if (pattern instanceof com.thaiopensource.relaxng.impl.ListPattern) {
                com.thaiopensource.relaxng.impl.ListPattern listPattern = (com.thaiopensource.relaxng.impl.ListPattern)pattern;
                pattern2 = new ListPattern(this.translate(listPattern.getOperand()));
            } else if (pattern instanceof com.thaiopensource.relaxng.impl.DataExceptPattern) {
                com.thaiopensource.relaxng.impl.DataExceptPattern dataExceptPattern = (com.thaiopensource.relaxng.impl.DataExceptPattern)pattern;
                pattern2 = new DataExceptPattern(Translator.translate(dataExceptPattern.getDatatype()), this.translate(dataExceptPattern.getExcept()));
            } else if (pattern instanceof com.thaiopensource.relaxng.impl.NotAllowedPattern) {
                pattern2 = NotAllowedPattern.INSTANCE;
            } else {
                throw new TranslatorException("unexpected " + pattern.getClass().getName());
            }
        }
        if (!(pattern instanceof ElementPattern)) {
            this.translated.put(pattern, pattern2);
        }
        return pattern2;
    }

    private static SimpleNameClass[] getChoiceOfSimpleNameClass(NameClass nameClass) {
        if (!(nameClass instanceof com.thaiopensource.relaxng.impl.ChoiceNameClass)) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        if (!Translator.getChoiceOfSimpleNameClass(nameClass, arrayList)) {
            return null;
        }
        SimpleNameClass[] simpleNameClassArray = new SimpleNameClass[arrayList.size()];
        arrayList.toArray(simpleNameClassArray);
        return simpleNameClassArray;
    }

    private static boolean getChoiceOfSimpleNameClass(NameClass nameClass, ArrayList arrayList) {
        if (nameClass instanceof SimpleNameClass) {
            arrayList.add(nameClass);
            return true;
        }
        if (nameClass instanceof com.thaiopensource.relaxng.impl.ChoiceNameClass) {
            com.thaiopensource.relaxng.impl.ChoiceNameClass choiceNameClass = (com.thaiopensource.relaxng.impl.ChoiceNameClass)nameClass;
            return Translator.getChoiceOfSimpleNameClass(choiceNameClass.getOperand1(), arrayList) && Translator.getChoiceOfSimpleNameClass(choiceNameClass.getOperand2(), arrayList);
        }
        return false;
    }

    private static Pattern makeChoiceOfElements(NameClass[] nameClassArray, int n) throws TranslatorException {
        if (n + 1 == nameClassArray.length) {
            return new ElementField();
        }
        return new ChoicePattern(new ElementField(), Translator.makeChoiceOfElements(nameClassArray, n + 1));
    }

    private Pattern makeChoiceOfAttributes(NameClass[] nameClassArray, int n, Pattern pattern, String string, Builder builder) throws TranslatorException {
        if (n + 1 == nameClassArray.length) {
            return new AttributeField(this.translate(nameClassArray[n]), pattern, string, builder);
        }
        return new ChoicePattern(new AttributeField(this.translate(nameClassArray[n]), pattern, string, builder), this.makeChoiceOfAttributes(nameClassArray, n + 1, pattern, string, builder));
    }

    private NameClassBase translate(NameClass nameClass) throws TranslatorException {
        if (nameClass instanceof SimpleNameClass) {
            SimpleNameClass simpleNameClass = (SimpleNameClass)nameClass;
            com.thaiopensource.xml.util.Name name = simpleNameClass.getName();
            Namespace namespace = Namespace.get(name.getNamespaceUri());
            if (namespace != Namespace.NONE && namespace != Namespace.XML) {
                this.prefixes.add(namespace, "ns");
            }
            return new SingleNameClass(Name.get(namespace, name.getLocalName()));
        }
        if (nameClass instanceof com.thaiopensource.relaxng.impl.AnyNameClass) {
            return new AnyNameClass();
        }
        if (nameClass instanceof com.thaiopensource.relaxng.impl.AnyNameExceptNameClass) {
            com.thaiopensource.relaxng.impl.AnyNameExceptNameClass anyNameExceptNameClass = (com.thaiopensource.relaxng.impl.AnyNameExceptNameClass)nameClass;
            return new AnyNameExceptNameClass(this.translate(anyNameExceptNameClass.getExcept()));
        }
        if (nameClass instanceof com.thaiopensource.relaxng.impl.NsNameClass) {
            com.thaiopensource.relaxng.impl.NsNameClass nsNameClass = (com.thaiopensource.relaxng.impl.NsNameClass)nameClass;
            Namespace namespace = Namespace.get(nsNameClass.getNamespace());
            if (namespace != Namespace.NONE && namespace != Namespace.XML) {
                this.prefixes.add(namespace, "ns");
            }
            return new NsNameClass(namespace);
        }
        if (nameClass instanceof com.thaiopensource.relaxng.impl.NsNameExceptNameClass) {
            com.thaiopensource.relaxng.impl.NsNameExceptNameClass nsNameExceptNameClass = (com.thaiopensource.relaxng.impl.NsNameExceptNameClass)nameClass;
            Namespace namespace = Namespace.get(nsNameExceptNameClass.getNamespace());
            if (namespace != Namespace.NONE && namespace != Namespace.XML) {
                this.prefixes.add(namespace, "ns");
            }
            return new NsNameExceptNameClass(namespace, this.translate(nsNameExceptNameClass.getExcept()));
        }
        if (nameClass instanceof com.thaiopensource.relaxng.impl.ChoiceNameClass) {
            com.thaiopensource.relaxng.impl.ChoiceNameClass choiceNameClass = (com.thaiopensource.relaxng.impl.ChoiceNameClass)nameClass;
            return new ChoiceNameClass(this.translate(choiceNameClass.getOperand1()), this.translate(choiceNameClass.getOperand2()));
        }
        throw new TranslatorException("unexpected " + nameClass.getClass().getName());
    }

    private static DataType translate(Datatype datatype) throws TranslatorException {
        if (datatype instanceof TokenDatatype) {
            return TokenType.BASE;
        }
        if (datatype instanceof StringDatatype) {
            return StringType.BASE;
        }
        if (datatype instanceof TypeImpl) {
            return ((TypeImpl)datatype).getDataType();
        }
        throw new TranslatorException("datatype not supported " + datatype.getClass().getName());
    }

    private static Data translate(Object object, Datatype datatype) throws TranslatorException {
        if (datatype instanceof TokenDatatype || datatype instanceof StringDatatype) {
            return new StringValue((String)object);
        }
        if (datatype instanceof TypeImpl) {
            return (Data)object;
        }
        throw new TranslatorException("datatype not supported " + datatype.getClass().getName());
    }

    private void initElementFields() throws TranslatorException {
        Object object;
        Object v;
        Object k;
        Map.Entry entry;
        Iterator iterator = this.translated.entrySet().iterator();
        block0: while (iterator.hasNext()) {
            entry = iterator.next();
            k = entry.getKey();
            v = entry.getValue();
            if (!(k instanceof ElementPattern)) continue;
            object = (ElementPattern)k;
            Pattern pattern = this.translate(object.getContent());
            if (v instanceof ChoicePattern) {
                ChoicePattern choicePattern = (ChoicePattern)v;
                SimpleNameClass[] simpleNameClassArray = Translator.getChoiceOfSimpleNameClass(object.getNameClass());
                int n = 0;
                while (true) {
                    ((ElementField)choicePattern.pattern1).init1(this.translate((NameClass)simpleNameClassArray[n++]), pattern, this.builder);
                    if (choicePattern.pattern2 instanceof ElementField) {
                        ((ElementField)choicePattern.pattern2).init1(this.translate((NameClass)simpleNameClassArray[n++]), pattern, this.builder);
                        continue block0;
                    }
                    choicePattern = (ChoicePattern)choicePattern.pattern2;
                }
            }
            ((ElementField)v).init1(this.translate(object.getNameClass()), pattern, this.builder);
        }
        iterator = this.translated.entrySet().iterator();
        block2: while (iterator.hasNext()) {
            entry = iterator.next();
            k = entry.getKey();
            v = entry.getValue();
            if (!(k instanceof ElementPattern)) continue;
            if (v instanceof ChoicePattern) {
                object = (ChoicePattern)v;
                while (true) {
                    ((ElementField)object.pattern1).init2();
                    if (object.pattern2 instanceof ElementField) {
                        ((ElementField)object.pattern2).init2();
                        continue block2;
                    }
                    object = (ChoicePattern)object.pattern2;
                }
            }
            ((ElementField)v).init2();
        }
    }

    private void checkAttributeDefaultValues() throws TranslatorException {
        Object object;
        FieldBase fieldBase;
        AttributePattern attributePattern;
        Object object2;
        Object[] objectArray;
        DTDCompatibilityException dTDCompatibilityException = new DTDCompatibilityException();
        IdentityHashMap<Name, Object[]> identityHashMap = new IdentityHashMap<Name, Object[]>();
        Iterator iterator = this.translated.entrySet().iterator();
        while (iterator.hasNext()) {
            objectArray = iterator.next();
            Object k = objectArray.getKey();
            object2 = objectArray.getValue();
            if (k instanceof AttributePattern) {
                attributePattern = (AttributePattern)k;
                fieldBase = (AttributeField)object2;
                if (((AttributeField)fieldBase).defaultValueAnnotation == null) continue;
                if (fieldBase.getFieldName() == null) {
                    Translator.addError(attributePattern.getLocator(), fieldBase, Msg.msg("defaultValueForWildcard"), dTDCompatibilityException);
                    continue;
                }
                if (((AttributeField)fieldBase).dataType.isContextDependentDataType()) {
                    Translator.addError(attributePattern.getLocator(), fieldBase, Msg.msg("defaultValueForContextDependentDataType", ((AttributeField)fieldBase).dataType.getDataTypeLabel(null)), dTDCompatibilityException);
                    continue;
                }
                if (((AttributeField)fieldBase).defaultValue != null) continue;
                Translator.addError(attributePattern.getLocator(), fieldBase, Msg.msg("invalidAttributeDefaultValue", ((AttributeField)fieldBase).defaultValueAnnotation), dTDCompatibilityException);
                continue;
            }
            if (!(k instanceof ElementPattern)) continue;
            attributePattern = (ElementPattern)k;
            fieldBase = (ElementField)object2;
            Name name = fieldBase.getFieldName();
            if (((ElementField)fieldBase).hasAttributeDefaultValues) {
                if (name == null) {
                    Translator.addError(attributePattern.getLocator(), fieldBase, Msg.msg("wildcardHasAttributeDefaultValues"), dTDCompatibilityException);
                } else {
                    object = ((ElementField)fieldBase).attributeFields;
                    boolean[] blArray = ((ElementField)fieldBase).attributeIsRequired;
                    int n = 0;
                    while (n < ((Object[])object).length) {
                        Object object3 = object[n];
                        if (((AttributeField)object3).defaultValueAnnotation != null && blArray[n]) {
                            Translator.addError(attributePattern.getLocator(), fieldBase, Msg.msg("defaultValueForRequiredAttribute", ((AttributeField)object3).nameClass), dTDCompatibilityException);
                        }
                        ++n;
                    }
                }
            }
            if (name == null) continue;
            object = (Object[])identityHashMap.get(name);
            if (object == null) {
                object = new Object[]{attributePattern, fieldBase};
            } else {
                int n = ((Object[])object).length;
                Object[] objectArray2 = new Object[n + 2];
                System.arraycopy(object, 0, objectArray2, 0, n);
                objectArray2[n] = attributePattern;
                objectArray2[n + 1] = fieldBase;
                object = objectArray2;
            }
            identityHashMap.put(name, (Object[])object);
        }
        if (dTDCompatibilityException.getErrorCount() == 0) {
            iterator = identityHashMap.values().iterator();
            while (iterator.hasNext()) {
                objectArray = (Object[])iterator.next();
                if (objectArray.length <= 2) continue;
                int n = 0;
                while (n < objectArray.length) {
                    object2 = (ElementField)objectArray[n + 1];
                    if (((ElementField)object2).hasAttributeDefaultValues) {
                        attributePattern = (ElementPattern)objectArray[n];
                        fieldBase = ((ElementField)object2).attributeFields;
                        int n2 = 0;
                        while (n2 < ((FieldBase)fieldBase).length) {
                            object = fieldBase[n2];
                            if (object.defaultValue != null && !Translator.checkConsistency(objectArray, (AttributeField)object, object2)) {
                                Translator.addError(attributePattern.getLocator(), object2, Msg.msg("inconsistentAttributeDefaultValue", new Integer(objectArray.length / 2), ((ElementField)object2).nameClass, object.nameClass, object.defaultValueAnnotation), dTDCompatibilityException);
                            }
                            ++n2;
                        }
                    }
                    n += 2;
                }
            }
        }
        if (dTDCompatibilityException.getErrorCount() > 0) {
            throw dTDCompatibilityException;
        }
    }

    private static final boolean checkConsistency(Object[] objectArray, AttributeField attributeField, ElementField elementField) {
        Name name = attributeField.getFieldName();
        int n = 0;
        while (n < objectArray.length) {
            ElementField elementField2 = (ElementField)objectArray[n + 1];
            if (elementField2 != elementField) {
                if (!elementField2.hasAttributeDefaultValues) {
                    return false;
                }
                boolean bl = false;
                AttributeField[] attributeFieldArray = elementField2.attributeFields;
                int n2 = 0;
                while (n2 < attributeFieldArray.length) {
                    AttributeField attributeField2 = attributeFieldArray[n2];
                    if (name == attributeField2.getFieldName() && attributeField.defaultValue.equals(attributeField2.defaultValue)) {
                        bl = true;
                        break;
                    }
                    ++n2;
                }
                if (!bl) {
                    return false;
                }
            }
            n += 2;
        }
        return true;
    }

    private static final void addError(Locator locator, FieldBase fieldBase, String string, DTDCompatibilityException dTDCompatibilityException) {
        StringBuffer stringBuffer = new StringBuffer();
        if (fieldBase instanceof AttributeField) {
            stringBuffer.append(Msg.msg("attribute"));
        } else {
            stringBuffer.append(Msg.msg("element"));
        }
        stringBuffer.append(" \"");
        stringBuffer.append(fieldBase.nameClass);
        stringBuffer.append("\": ");
        stringBuffer.append(string);
        DTDCompatibilityException.Error error = new DTDCompatibilityException.Error(locator.getSystemId(), locator.getLineNumber(), locator.getColumnNumber(), stringBuffer.toString());
        dTDCompatibilityException.addError(error);
    }
}

