/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.search;

import com.xmlmind.xmledit.doc.Comment;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.ProcessingInstruction;
import com.xmlmind.xmledit.doc.Text;
import com.xmlmind.xmledit.doc.TextNode;
import com.xmlmind.xmledit.doc.Traversal;
import com.xmlmind.xmledit.doctype.DocumentType;
import com.xmlmind.xmledit.doctype.ElementType;
import com.xmlmind.xmledit.doctype.UnconstrainedDocumentType;
import com.xmlmind.xmledit.edit.TextOffset;
import java.util.ArrayList;
import java.util.IdentityHashMap;

public class ElementCharSequence
implements CharSequence {
    public static final int MARK_NONE = 0;
    public static final int MARK_ALL = 1;
    public static final int MARK_LAST = 2;
    public static final String DEFAULT_EMPTY_TEXT_CONTENT = " ";
    public static final String DEFAULT_PARAGRAPH_MARK = "\n\n";
    private String emptyTextContent;
    private int emptyTextContentLength;
    private int markParagraphs;
    private String paragraphMark;
    private Entry[] entries;
    private int length;
    private Entry cachedEntry;
    private int cachedEntryFirst;
    private int cachedEntryEnd;
    private static final Entry[] NO_ENTRIES = new Entry[0];

    public ElementCharSequence(Element element) {
        this(element, null, null, DEFAULT_EMPTY_TEXT_CONTENT, 2, DEFAULT_PARAGRAPH_MARK);
    }

    public ElementCharSequence(Element element, String string, int n, String string2) {
        this(element, null, null, string, n, string2);
    }

    public ElementCharSequence(TextOffset textOffset, TextOffset textOffset2) {
        this(null, textOffset, textOffset2, DEFAULT_EMPTY_TEXT_CONTENT, 2, DEFAULT_PARAGRAPH_MARK);
    }

    public ElementCharSequence(TextOffset textOffset, TextOffset textOffset2, String string, int n, String string2) {
        this(null, textOffset, textOffset2, string, n, string2);
    }

    public ElementCharSequence(Element element, TextOffset textOffset, TextOffset textOffset2, String string, int n, String string2) {
        Object object;
        if (string == null || string.length() == 0) {
            string = DEFAULT_EMPTY_TEXT_CONTENT;
        }
        this.emptyTextContent = string;
        this.emptyTextContentLength = string.length();
        this.markParagraphs = n;
        if (string2 == null || string2.length() == 0) {
            string2 = DEFAULT_PARAGRAPH_MARK;
        }
        this.paragraphMark = string2;
        int n2 = string2.length();
        if (element == null) {
            if (textOffset == null) {
                if (textOffset2 != null) {
                    element = textOffset2.text.getDocument().getRootElement();
                }
            } else {
                element = textOffset.text.getDocument().getRootElement();
            }
        }
        if (element == null) {
            throw new IllegalArgumentException("unspecified text range");
        }
        IdentityHashMap identityHashMap = new IdentityHashMap();
        DocumentType documentType = (DocumentType)element.getDocument().getProperty("DOCUMENT_TYPE");
        if (documentType != null && documentType instanceof UnconstrainedDocumentType) {
            documentType = null;
        }
        DocumentType documentType2 = documentType;
        if (textOffset == null && (object = (TextNode)Traversal.traverse(element, Traversal.textNodeFinder)) != null) {
            textOffset = new TextOffset((TextNode)object, 0);
        }
        if (textOffset == null) {
            this.entries = new Entry[0];
            this.length = 0;
            return;
        }
        if (textOffset2 == null) {
            textOffset2 = new TextOffset();
            textOffset2.text = (TextNode)Traversal.traverseBackwards(element, Traversal.textNodeFinder);
            textOffset2.offset = textOffset2.text.getTextLength();
        }
        if (textOffset.text == textOffset2.text) {
            this.length = textOffset2.offset - textOffset.offset;
            if (this.length > 0) {
                object = new Entry(0, textOffset.text, textOffset.offset, this.length);
                this.entries = new Entry[1];
                this.entries[0] = object;
            } else {
                this.entries = new Entry[0];
                this.length = 0;
            }
            return;
        }
        object = new ArrayList();
        int n3 = textOffset.text.getTextLength();
        if (n3 == 0) {
            ((ArrayList)object).add(new Entry(0, textOffset.text, 0, 0));
            this.length = this.emptyTextContentLength;
            this.markAsParagraph(textOffset.text, identityHashMap, documentType2, n2);
        } else if ((n3 -= textOffset.offset) > 0) {
            ((ArrayList)object).add(new Entry(0, textOffset.text, textOffset.offset, n3));
            this.length = n3;
            this.markAsParagraph(textOffset.text, identityHashMap, documentType2, n2);
        } else {
            this.length = 0;
        }
        final TextNode textNode = textOffset2.text;
        TextNode textNode2 = (TextNode)Traversal.traverseAfter(textOffset.text, new Traversal.HandlerBase((ArrayList)object, identityHashMap, documentType2, n2){
            private final /* synthetic */ ArrayList val$entryList;
            private final /* synthetic */ IdentityHashMap val$mixElements;
            private final /* synthetic */ DocumentType val$docType;
            private final /* synthetic */ int val$paragraphMarkLength;
            {
                this.val$entryList = arrayList;
                this.val$mixElements = identityHashMap;
                this.val$docType = documentType;
                this.val$paragraphMarkLength = n;
            }

            public Object processText(Text text) {
                return this.processTextNode(text);
            }

            public Object processPI(ProcessingInstruction processingInstruction) {
                return this.processTextNode(processingInstruction);
            }

            public Object processComment(Comment comment) {
                return this.processTextNode(comment);
            }

            private Object processTextNode(TextNode textNode2) {
                if (textNode2 == textNode) {
                    return textNode;
                }
                int n = textNode2.getTextLength();
                this.val$entryList.add(new Entry(ElementCharSequence.this.length, textNode2, 0, n));
                if (n == 0) {
                    ElementCharSequence.this.length += ElementCharSequence.this.emptyTextContentLength;
                } else {
                    ElementCharSequence.this.length += n;
                }
                ElementCharSequence.this.markAsParagraph(textNode2, this.val$mixElements, this.val$docType, this.val$paragraphMarkLength);
                return null;
            }
        });
        if (textNode2 == null) {
            this.entries = new Entry[0];
            this.length = 0;
            return;
        }
        n3 = textOffset2.text.getTextLength();
        if (n3 == 0) {
            ((ArrayList)object).add(new Entry(this.length, textOffset2.text, 0, 0));
            this.length += this.emptyTextContentLength;
        } else if ((n3 = Math.min(textOffset2.offset, n3)) > 0) {
            ((ArrayList)object).add(new Entry(this.length, textOffset2.text, 0, n3));
            this.length += n3;
        }
        this.entries = ((ArrayList)object).toArray(NO_ENTRIES);
    }

    /*
     * Unable to fully structure code
     */
    private void markAsParagraph(TextNode var1_1, IdentityHashMap var2_2, DocumentType var3_3, int var4_4) {
        switch (this.markParagraphs) {
            case 1: {
                this.length += var4_4;
                break;
            }
            case 2: {
                if (!(var1_1 instanceof Text)) {
                    this.length += var4_4;
                    break;
                }
                var5_5 = var1_1.getParentElement();
                if (!ElementCharSequence.isMix(var5_5, var2_2, var3_3)) {
                    this.length += var4_4;
                    break;
                }
                if (var1_1 != var5_5.getLastChild()) ** GOTO lbl34
                var7_6 = var5_5.getParentElement();
                var6_8 = true;
                while (var7_6 != null && ElementCharSequence.isMix(var7_6, var2_2, var3_3)) {
                    if (var5_5 == var7_6.getLastChild()) ** GOTO lbl30
                    var8_9 = var5_5.getNextSibling();
                    switch (var8_9.getNodeType()) {
                        case 1: 
                        case 2: {
                            var6_8 = true;
                            break;
                        }
                        case 4: {
                            var6_8 = ElementCharSequence.isMix((Element)var8_9, var2_2, var3_3) == false;
                            break;
                        }
                        default: {
                            var6_8 = false;
                            break;
                        }
                    }
                    ** GOTO lbl44
lbl30:
                    // 1 sources

                    var5_5 = var7_6;
                    var7_6 = var5_5.getParentElement();
                }
                ** GOTO lbl44
lbl34:
                // 1 sources

                var7_7 = var1_1.getNextSibling();
                switch (var7_7.getNodeType()) {
                    case 1: 
                    case 2: {
                        var6_8 = true;
                        break;
                    }
                    case 4: {
                        var6_8 = ElementCharSequence.isMix((Element)var7_7, var2_2, var3_3) == false;
                        break;
                    }
                    default: {
                        var6_8 = false;
                    }
                }
lbl44:
                // 5 sources

                if (!var6_8) break;
                this.length += var4_4;
            }
        }
    }

    private static final boolean isMix(Element element, IdentityHashMap identityHashMap, DocumentType documentType) {
        if (documentType == null) {
            return false;
        }
        Boolean bl = (Boolean)identityHashMap.get(element);
        if (bl == null) {
            bl = Boolean.FALSE;
            ElementType elementType = documentType.getElementType(element);
            if (elementType != null) {
                switch (elementType.getElementContentType()) {
                    case 3: 
                    case 4: 
                    case 5: {
                        bl = Boolean.TRUE;
                    }
                }
            }
            identityHashMap.put(element, bl);
        }
        return bl;
    }

    public int length() {
        return this.length;
    }

    public char charAt(int n) {
        Entry entry = this.findEntry(n);
        if (entry == null) {
            throw new IndexOutOfBoundsException(Integer.toString(n));
        }
        int n2 = entry.offset;
        int n3 = n2 + (n - entry.index);
        int n4 = entry.count;
        int n5 = n2 + n4;
        if (n3 < n5) {
            return entry.text.getTextChar(n3);
        }
        if (n4 == 0) {
            if ((n3 -= n2) < this.emptyTextContentLength) {
                return this.emptyTextContent.charAt(n3);
            }
            return this.paragraphMark.charAt(n3 - this.emptyTextContentLength);
        }
        return this.paragraphMark.charAt(n3 - n5);
    }

    public CharSequence subSequence(int n, int n2) {
        TextOffset textOffset = this.getTextOffset(n);
        TextOffset textOffset2 = this.getTextOffset(n2);
        return new ElementCharSequence(textOffset, textOffset2, this.emptyTextContent, this.markParagraphs, this.paragraphMark);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.entries.length - 1;
        int n2 = 0;
        while (n2 <= n) {
            int n3;
            int n4;
            Entry entry = this.entries[n2];
            if (entry.count == 0) {
                stringBuffer.append(this.emptyTextContent);
                n4 = entry.index + this.emptyTextContentLength;
            } else {
                char[] cArray = entry.text.getTextChars();
                stringBuffer.append(cArray, entry.offset, entry.count);
                n4 = entry.index + entry.count;
            }
            int n5 = n3 = n2 < n ? this.entries[n2 + 1].index : this.length;
            if (n4 < n3) {
                stringBuffer.append(this.paragraphMark);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public TextOffset getTextOffset(int n) {
        TextOffset textOffset = new TextOffset();
        this.getTextOffset(n, textOffset);
        return textOffset;
    }

    public void getTextOffset(int n, TextOffset textOffset) {
        Entry entry = n == this.length ? (this.entries.length > 0 ? this.entries[this.entries.length - 1] : null) : this.findEntry(n);
        if (entry == null) {
            throw new IndexOutOfBoundsException(Integer.toString(n));
        }
        int n2 = entry.offset;
        int n3 = n2 + (n - entry.index);
        int n4 = entry.count;
        int n5 = n2 + n4;
        if (n3 > n5) {
            n3 = n5;
        }
        textOffset.text = entry.text;
        textOffset.offset = n3;
    }

    private Entry findEntry(int n) {
        if (this.cachedEntry != null) {
            if (n >= this.cachedEntryFirst && n < this.cachedEntryEnd) {
                return this.cachedEntry;
            }
            this.cachedEntry = null;
            this.cachedEntryEnd = -1;
            this.cachedEntryFirst = -1;
        }
        int n2 = 0;
        int n3 = this.entries.length - 1;
        while (n2 <= n3) {
            int n4;
            int n5 = n2 + (n3 - n2) / 2;
            Entry entry = this.entries[n5];
            int n6 = entry.index;
            int n7 = n4 = n5 < this.entries.length - 1 ? this.entries[n5 + 1].index : this.length;
            if (n >= n6 && n < n4) {
                this.cachedEntry = entry;
                this.cachedEntryFirst = n6;
                this.cachedEntryEnd = n4;
                return entry;
            }
            if (n < n6) {
                n3 = n5 - 1;
                continue;
            }
            n2 = n5 + 1;
        }
        return null;
    }

    private static final class Entry {
        public int index;
        public TextNode text;
        public int offset;
        public int count;

        public Entry() {
        }

        public Entry(int n, TextNode textNode, int n2, int n3) {
            this.index = n;
            this.text = textNode;
            this.offset = n2;
            this.count = n3;
        }
    }
}

