/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.search;

import com.xmlmind.xmledit.command.RecordableCommand;
import com.xmlmind.xmledit.edit.MarkManager;
import com.xmlmind.xmledit.edit.TextLocation;
import com.xmlmind.xmledit.edit.TextOffset;
import com.xmlmind.xmledit.gadget.Command;
import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.guiutil.ShowStatus;
import com.xmlmind.xmledit.search.Msg;
import com.xmlmind.xmledit.search.SearchDialog;
import com.xmlmind.xmledit.search.SearchForm;
import com.xmlmind.xmledit.search.SearchReplaceForm;
import com.xmlmind.xmledit.search.SearchReplaceText;
import com.xmlmind.xmledit.search.SearchUtil;
import com.xmlmind.xmledit.util.StringUtil;
import com.xmlmind.xmledit.view.DocumentView;
import java.util.regex.Matcher;
import javax.swing.JTextField;

public class Search
extends RecordableCommand {
    private SearchForm.Info searchInfo = new SearchForm.Info();
    private SearchForm searchForm;

    public boolean prepareCommand(Gadget gadget, String string, int n, int n2) {
        DocumentView documentView = (DocumentView)gadget;
        MarkManager markManager = documentView.getMarkManager();
        if (markManager == null) {
            return false;
        }
        TextLocation textLocation = markManager.getDot();
        return textLocation != null;
    }

    protected Object doExecuteCommand(DocumentView documentView, String string, int n, int n2) {
        int n3;
        int n4;
        Object object;
        Object object2;
        boolean bl;
        if (string == null || (string = string.trim()).length() == 0) {
            bl = true;
        } else {
            int n5;
            if (string.startsWith("[") && (n5 = string.indexOf(93, 1)) >= 1) {
                object2 = string.substring(1, n5);
                string = string.substring(n5 + 1).trim();
                this.searchInfo.ignoreCase = ((String)object2).indexOf(105) >= 0;
                this.searchInfo.wholeWord = ((String)object2).indexOf(119) >= 0;
                this.searchInfo.regularExpression = ((String)object2).indexOf(114) >= 0;
                this.searchInfo.smartMode = ((String)object2).indexOf(115) >= 0;
                this.searchInfo.backwards = ((String)object2).indexOf(98) >= 0;
                boolean bl2 = this.searchInfo.extendSelection = ((String)object2).indexOf(120) >= 0;
            }
            if (string.startsWith("\"") || string.startsWith("'")) {
                String[] stringArray = StringUtil.splitArguments(string);
                string = stringArray.length == 1 ? stringArray[0] : null;
            }
            if (string == null || string.length() == 0) {
                bl = true;
            } else {
                this.searchInfo.searched = string;
                bl = false;
            }
        }
        if (bl) {
            if (this.searchForm == null) {
                this.searchForm = new SearchForm(true, true);
                this.searchForm.getSearchedField().setActionCommand("ok");
            }
            SearchDialog searchDialog = new SearchDialog(documentView.getPanel(), Msg.msg("S.title"), false, this.searchForm);
            object2 = this.searchForm.getSearchedField();
            ((JTextField)object2).addActionListener(searchDialog);
            object = searchDialog.getInfo(this.searchInfo);
            ((JTextField)object2).removeActionListener(searchDialog);
            if (object == null) {
                return Command.EXECUTION_FAILED;
            }
            this.searchForm.addToSearchHistory(((SearchForm.Info)object).searched);
            this.searchInfo.searched = ((SearchForm.Info)object).searched;
            this.searchInfo.ignoreCase = ((SearchForm.Info)object).ignoreCase;
            this.searchInfo.wholeWord = ((SearchForm.Info)object).wholeWord;
            this.searchInfo.regularExpression = ((SearchForm.Info)object).regularExpression;
            this.searchInfo.smartMode = ((SearchForm.Info)object).smartMode;
            this.searchInfo.backwards = ((SearchForm.Info)object).backwards;
            this.searchInfo.extendSelection = ((SearchForm.Info)object).extendSelection;
        }
        Matcher matcher = null;
        if (this.searchInfo.regularExpression && (matcher = SearchUtil.createMatcher(this.searchInfo.searched, this.searchInfo.ignoreCase, documentView.getPanel())) == null) {
            return Command.EXECUTION_FAILED;
        }
        object2 = new SearchReplaceForm.Info();
        ((SearchReplaceForm.Info)object2).searched = this.searchInfo.searched;
        ((SearchReplaceForm.Info)object2).replacement = null;
        ((SearchReplaceForm.Info)object2).ignoreCase = this.searchInfo.ignoreCase;
        ((SearchReplaceForm.Info)object2).wholeWord = this.searchInfo.wholeWord;
        ((SearchReplaceForm.Info)object2).regularExpression = this.searchInfo.regularExpression;
        ((SearchReplaceForm.Info)object2).smartMode = this.searchInfo.smartMode;
        ((SearchReplaceForm.Info)object2).backwards = this.searchInfo.backwards;
        object = SearchUtil.createSearchReplaceText(documentView, (SearchReplaceForm.Info)object2, matcher);
        if (object == null) {
            return Command.EXECUTION_FAILED;
        }
        TextOffset[] textOffsetArray = ((SearchReplaceText)object).search();
        if (textOffsetArray == null) {
            ShowStatus.showStatus(Msg.msg("SRP.searchedTextNotFound", ShowStatus.shorten(this.searchInfo.searched, 20)));
            return Command.EXECUTION_FAILED;
        }
        ShowStatus.showStatus("");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        if (this.searchInfo.ignoreCase) {
            stringBuffer.append('i');
        }
        if (this.searchInfo.wholeWord) {
            stringBuffer.append('w');
        }
        if (this.searchInfo.regularExpression) {
            stringBuffer.append('r');
        }
        if (this.searchInfo.smartMode) {
            stringBuffer.append('s');
        }
        if (this.searchInfo.backwards) {
            stringBuffer.append('b');
        }
        if (this.searchInfo.extendSelection) {
            stringBuffer.append('x');
        }
        stringBuffer.append("] ");
        stringBuffer.append(StringUtil.quoteArgument(this.searchInfo.searched));
        documentView.addToCommandHistory(this, stringBuffer.toString(), Msg.msg("S.title"));
        if (this.searchInfo.backwards) {
            n4 = 1;
            n3 = 0;
        } else {
            n4 = 0;
            n3 = 1;
        }
        TextOffset textOffset = textOffsetArray[n4];
        TextOffset textOffset2 = textOffsetArray[n3];
        if (this.searchInfo.extendSelection) {
            TextLocation textLocation = documentView.getMarkManager().getDot();
            textOffset.text = textLocation.getTextNode();
            textOffset.offset = textLocation.getOffset();
        }
        documentView.selectShowText(textOffset.text, textOffset.offset, textOffset2.text, textOffset2.offset);
        return null;
    }
}

