/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.search;

import com.xmlmind.xmledit.command.RecordableCommand;
import com.xmlmind.xmledit.edit.MarkManager;
import com.xmlmind.xmledit.edit.TextLocation;
import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.search.Msg;
import com.xmlmind.xmledit.search.SearchReplaceDialog;
import com.xmlmind.xmledit.search.SearchReplacePane;
import com.xmlmind.xmledit.view.DocumentView;

public class SearchReplace
extends RecordableCommand {
    private static boolean dialogHasHelp;
    private SearchReplacePane searchReplacePane;
    private int op;
    private static final int SEARCH = 0;
    private static final int SEARCH_BACKWARDS = 1;
    private static final int REPLACE = 2;
    private static final int REPLACE_BACKWARDS = 3;
    private static final int FIND_AGAIN = 4;
    private static final int FIND_AGAIN_BACKWARDS = 5;

    public static void setDialogHasHelp(boolean bl) {
        dialogHasHelp = bl;
    }

    public static boolean getDialogHasHelp() {
        return dialogHasHelp;
    }

    public boolean prepareCommand(Gadget gadget, String string, int n, int n2) {
        DocumentView documentView = (DocumentView)gadget;
        MarkManager markManager = documentView.getMarkManager();
        if (markManager == null) {
            return false;
        }
        TextLocation textLocation = markManager.getDot();
        if (textLocation == null) {
            return false;
        }
        this.op = -1;
        if (string != null) {
            if ("search".equals(string)) {
                this.op = 0;
            } else if ("searchBackwards".equals(string)) {
                this.op = 1;
            } else if ("replace".equals(string)) {
                this.op = 2;
            } else if ("replaceBackwards".equals(string)) {
                this.op = 3;
            } else if ("findAgain".equals(string)) {
                this.op = 4;
            } else if ("findAgainBackwards".equals(string)) {
                this.op = 5;
            } else {
                return false;
            }
        }
        return true;
    }

    protected Object doExecuteCommand(DocumentView documentView, String string, int n, int n2) {
        if (this.searchReplacePane == null) {
            this.searchReplacePane = new SearchReplacePane(true);
        }
        this.searchReplacePane.setDocumentView(documentView);
        switch (this.op) {
            case 0: {
                this.searchReplacePane.search(false);
                break;
            }
            case 1: {
                this.searchReplacePane.search(true);
                break;
            }
            case 2: {
                this.searchReplacePane.searchReplace(false);
                break;
            }
            case 3: {
                this.searchReplacePane.searchReplace(true);
                break;
            }
            case 4: {
                this.searchReplacePane.findAgain(false);
                return null;
            }
            case 5: {
                this.searchReplacePane.findAgain(true);
                return null;
            }
        }
        SearchReplaceDialog searchReplaceDialog = new SearchReplaceDialog(documentView.getPanel(), Msg.msg("SR.title"), dialogHasHelp, this.searchReplacePane);
        searchReplaceDialog.open(9);
        this.searchReplacePane.setDocumentView(null);
        return null;
    }
}

