/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.search;

import com.xmlmind.xmledit.guiutil.DialogUtil;
import com.xmlmind.xmledit.search.Msg;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class SearchReplaceForm
extends JPanel
implements ItemListener {
    private boolean hasReplace;
    private boolean hasSmartMode;
    private JComboBox searched;
    private JCheckBox replaceToggle;
    private JComboBox replacement;
    private JCheckBox ignoreCase;
    private JCheckBox wholeWord;
    private JCheckBox regularExpression;
    private JCheckBox smartMode;
    private ButtonGroup directionGroup;
    private JRadioButton directionUp;
    private JRadioButton directionDown;
    private static final String[] NO_STRINGS = new String[0];

    public SearchReplaceForm() {
        this(true, true);
    }

    public SearchReplaceForm(boolean bl, boolean bl2) {
        super(new GridBagLayout());
        this.hasReplace = bl;
        this.hasSmartMode = bl2;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 2;
        gridBagConstraints.insets.left = 2;
        gridBagConstraints.insets.right = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 3;
        String string = Msg.msg("SRF.searched");
        JLabel jLabel = new JLabel(DialogUtil.buttonLabel(string));
        DialogUtil.setDisplayedMnemonic(jLabel, string);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)jLabel, gridBagConstraints);
        this.searched = new JComboBox();
        this.searched.setEditable(true);
        this.getSearchedField().setColumns(20);
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.top = 1;
        this.add((Component)this.searched, gridBagConstraints);
        jLabel.setLabelFor(this.searched);
        string = Msg.msg("SRF.replacement");
        this.replaceToggle = new JCheckBox(DialogUtil.buttonLabel(string));
        DialogUtil.setMnemonic(this.replaceToggle, string);
        if (bl) {
            this.replaceToggle.addItemListener(this);
            ++gridBagConstraints.gridy;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.insets.top = 2;
            this.add((Component)this.replaceToggle, gridBagConstraints);
        }
        this.replacement = new JComboBox();
        this.replacement.setEditable(true);
        this.getReplacementField().setColumns(20);
        if (bl) {
            ++gridBagConstraints.gridy;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets.top = 1;
            this.add((Component)this.replacement, gridBagConstraints);
        }
        string = Msg.msg("SRF.ignoreCase");
        this.ignoreCase = new JCheckBox(DialogUtil.buttonLabel(string));
        DialogUtil.setMnemonic(this.ignoreCase, string);
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.top = 2;
        this.add((Component)this.ignoreCase, gridBagConstraints);
        string = Msg.msg("SRF.wholeWord");
        this.wholeWord = new JCheckBox(DialogUtil.buttonLabel(string));
        DialogUtil.setMnemonic(this.wholeWord, string);
        ++gridBagConstraints.gridy;
        this.add((Component)this.wholeWord, gridBagConstraints);
        string = Msg.msg("SRF.regularExpression");
        this.regularExpression = new JCheckBox(DialogUtil.buttonLabel(string));
        DialogUtil.setMnemonic(this.regularExpression, string);
        ++gridBagConstraints.gridy;
        this.add((Component)this.regularExpression, gridBagConstraints);
        string = Msg.msg("SRF.smartMode");
        this.smartMode = new JCheckBox(DialogUtil.buttonLabel(string));
        DialogUtil.setMnemonic(this.smartMode, string);
        if (bl2) {
            ++gridBagConstraints.gridy;
            this.add((Component)this.smartMode, gridBagConstraints);
        }
        string = Msg.msg("SRF.direction");
        jLabel = new JLabel(string);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.insets.bottom = 2;
        this.add((Component)jLabel, gridBagConstraints);
        string = Msg.msg("SRF.up");
        this.directionUp = new JRadioButton(DialogUtil.buttonLabel(string));
        DialogUtil.setMnemonic(this.directionUp, string);
        ++gridBagConstraints.gridx;
        this.add((Component)this.directionUp, gridBagConstraints);
        string = Msg.msg("SRF.down");
        this.directionDown = new JRadioButton(DialogUtil.buttonLabel(string));
        this.directionDown.setSelected(true);
        DialogUtil.setMnemonic(this.directionDown, string);
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets.right = 2;
        this.add((Component)this.directionDown, gridBagConstraints);
        this.directionGroup = new ButtonGroup();
        this.directionGroup.add(this.directionUp);
        this.directionGroup.add(this.directionDown);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.toggleReplace();
    }

    private void toggleReplace() {
        JTextField jTextField = this.getReplacementField();
        if (this.replaceToggle.isSelected()) {
            JTextField jTextField2 = this.getSearchedField();
            jTextField.setBackground(jTextField2.getBackground());
            this.replacement.setEnabled(true);
        } else {
            this.replacement.setSelectedItem("");
            jTextField.setBackground(this.getBackground());
            this.replacement.setEnabled(false);
        }
    }

    public JTextField getSearchedField() {
        return (JTextField)this.searched.getEditor().getEditorComponent();
    }

    public JTextField getReplacementField() {
        return (JTextField)this.replacement.getEditor().getEditorComponent();
    }

    public void addActionListener(ActionListener actionListener) {
        this.getSearchedField().addActionListener(actionListener);
        this.getReplacementField().addActionListener(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.getSearchedField().removeActionListener(actionListener);
        this.getReplacementField().removeActionListener(actionListener);
    }

    public void setActionCommand(String string) {
        this.getSearchedField().setActionCommand(string);
        this.getReplacementField().setActionCommand(string);
    }

    public void setDirection(boolean bl) {
        if (bl) {
            this.directionUp.setSelected(true);
        } else {
            this.directionDown.setSelected(true);
        }
    }

    public void setReplacing(boolean bl) {
        this.replaceToggle.setSelected(this.hasReplace ? bl : false);
    }

    public void setInfo(Info info) {
        String string;
        this.searched.setSelectedItem(info.searched == null ? "" : info.searched);
        String string2 = string = this.hasReplace ? info.replacement : null;
        if (string == null) {
            this.replaceToggle.setSelected(false);
            this.replacement.setSelectedItem("");
        } else {
            this.replaceToggle.setSelected(true);
            this.replacement.setSelectedItem(string);
        }
        this.toggleReplace();
        this.ignoreCase.setSelected(info.ignoreCase);
        this.wholeWord.setSelected(info.wholeWord);
        this.regularExpression.setSelected(info.regularExpression);
        this.smartMode.setSelected(info.smartMode);
        this.directionUp.setSelected(info.backwards);
        this.directionDown.setSelected(!info.backwards);
    }

    public Info getInfo() {
        Info info = new Info();
        JTextField jTextField = this.getSearchedField();
        info.searched = jTextField.getText();
        this.searched.setSelectedItem(info.searched);
        JTextField jTextField2 = this.getReplacementField();
        info.replacement = jTextField2.getText();
        this.replacement.setSelectedItem(info.replacement);
        if (!this.replaceToggle.isSelected()) {
            info.replacement = null;
        }
        info.ignoreCase = this.ignoreCase.isSelected();
        info.wholeWord = this.wholeWord.isSelected();
        info.regularExpression = this.regularExpression.isSelected();
        info.smartMode = this.smartMode.isSelected();
        info.backwards = this.directionUp.isSelected();
        return info;
    }

    public void addToSearchHistory(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.searched.getModel();
        Object object = defaultComboBoxModel.getSelectedItem();
        defaultComboBoxModel.removeElement(string);
        int n = defaultComboBoxModel.getSize();
        if (n == 10) {
            defaultComboBoxModel.removeElementAt(n - 1);
        }
        defaultComboBoxModel.insertElementAt(string, 0);
        defaultComboBoxModel.setSelectedItem(object);
    }

    public void setSearchHistory(String[] stringArray) {
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.searched.getModel();
        Object object = defaultComboBoxModel.getSelectedItem();
        defaultComboBoxModel.removeAllElements();
        int n = 0;
        while (n < stringArray.length) {
            defaultComboBoxModel.addElement(stringArray[n]);
            ++n;
        }
        defaultComboBoxModel.setSelectedItem(object);
    }

    public String[] getSearchHistory() {
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.searched.getModel();
        int n = defaultComboBoxModel.getSize();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = (String)defaultComboBoxModel.getElementAt(n2);
            ++n2;
        }
        return stringArray;
    }

    public void addToReplaceHistory(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.replacement.getModel();
        Object object = defaultComboBoxModel.getSelectedItem();
        defaultComboBoxModel.removeElement(string);
        int n = defaultComboBoxModel.getSize();
        if (n == 10) {
            defaultComboBoxModel.removeElementAt(n - 1);
        }
        defaultComboBoxModel.insertElementAt(string, 0);
        defaultComboBoxModel.setSelectedItem(object);
    }

    public void setReplaceHistory(String[] stringArray) {
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.replacement.getModel();
        Object object = defaultComboBoxModel.getSelectedItem();
        defaultComboBoxModel.removeAllElements();
        int n = 0;
        while (n < stringArray.length) {
            defaultComboBoxModel.addElement(stringArray[n]);
            ++n;
        }
        defaultComboBoxModel.setSelectedItem(object);
    }

    public String[] getReplaceHistory() {
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.replacement.getModel();
        int n = defaultComboBoxModel.getSize();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = (String)defaultComboBoxModel.getElementAt(n2);
            ++n2;
        }
        return stringArray;
    }

    public void setEnabled(boolean bl) {
        if (bl != this.isEnabled()) {
            super.setEnabled(bl);
            this.searched.setEnabled(bl);
            this.replaceToggle.setEnabled(bl);
            this.replacement.setEnabled(bl && this.replaceToggle.isSelected());
            this.ignoreCase.setEnabled(bl);
            this.wholeWord.setEnabled(bl);
            this.regularExpression.setEnabled(bl);
            this.smartMode.setEnabled(bl);
            this.directionUp.setEnabled(bl);
            this.directionDown.setEnabled(bl);
        }
    }

    public static class Info {
        public String searched;
        public String replacement;
        public boolean ignoreCase;
        public boolean wholeWord;
        public boolean regularExpression;
        public boolean smartMode;
        public boolean backwards;
    }
}

