/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.search;

import com.xmlmind.xmledit.edit.TextOffset;
import com.xmlmind.xmledit.edit.TextRange;
import com.xmlmind.xmledit.guiutil.Alert;
import com.xmlmind.xmledit.guiutil.DialogUtil;
import com.xmlmind.xmledit.guiutil.ShowStatus;
import com.xmlmind.xmledit.guiutil.TextIcon;
import com.xmlmind.xmledit.search.Msg;
import com.xmlmind.xmledit.search.SearchReplaceForm;
import com.xmlmind.xmledit.search.SearchReplaceText;
import com.xmlmind.xmledit.search.SearchUtil;
import com.xmlmind.xmledit.view.DocumentView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.regex.Matcher;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class SearchReplacePane
extends JPanel
implements ActionListener {
    protected TextIcon[] functionKeyIcons = new TextIcon[6];
    protected SearchReplaceForm searchReplaceForm;
    protected JButton startButton;
    protected JButton skipButton;
    protected JButton skipElementButton;
    protected JButton replaceButton;
    protected JButton replaceAllButton;
    protected boolean done = true;
    protected SearchReplaceForm.Info searchReplaceInfo = null;
    protected SearchReplaceText searchReplaceText = null;
    protected TextOffset selectionMark = null;
    protected TextOffset selectionDot = null;
    protected DocumentView docView = null;

    public SearchReplacePane(boolean bl) {
        super(new GridBagLayout());
        this.registerKeyBoardActions();
        this.createFunctionKeyIcons();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        this.searchReplaceForm = new SearchReplaceForm();
        this.searchReplaceForm.setActionCommand("start");
        this.searchReplaceForm.addActionListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        if (bl) {
            gridBagConstraints.gridheight = 5;
        }
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.searchReplaceForm, gridBagConstraints);
        String string = Msg.msg("SRP.start");
        this.startButton = new JButton(string);
        this.startButton.setActionCommand("start");
        this.startButton.addActionListener(this);
        if (bl) {
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridheight = 1;
        } else {
            ++gridBagConstraints.gridy;
        }
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        if (bl) {
            gridBagConstraints.insets.top = 2;
            gridBagConstraints.insets.left = 7;
        } else {
            gridBagConstraints.insets.left = 2;
        }
        gridBagConstraints.insets.right = 2;
        this.add((Component)this.startButton, gridBagConstraints);
        this.configureButton(this.startButton);
        string = Msg.msg("SRP.skip");
        this.skipButton = new JButton(string);
        this.skipButton.setActionCommand("skip");
        this.skipButton.addActionListener(this);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.top = 1;
        this.add((Component)this.skipButton, gridBagConstraints);
        this.configureButton(this.skipButton);
        string = Msg.msg("SRP.skipElement");
        this.skipElementButton = new JButton(string);
        this.skipElementButton.setActionCommand("skipElement");
        this.skipElementButton.addActionListener(this);
        ++gridBagConstraints.gridy;
        this.add((Component)this.skipElementButton, gridBagConstraints);
        this.configureButton(this.skipElementButton);
        string = Msg.msg("SRP.doReplace");
        this.replaceButton = new JButton(string);
        this.replaceButton.setActionCommand("replace");
        this.replaceButton.addActionListener(this);
        ++gridBagConstraints.gridy;
        this.add((Component)this.replaceButton, gridBagConstraints);
        this.configureButton(this.replaceButton);
        string = Msg.msg("SRP.replaceAll");
        this.replaceAllButton = new JButton(string);
        this.replaceAllButton.setActionCommand("replaceAll");
        this.replaceAllButton.addActionListener(this);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.bottom = 2;
        this.add((Component)this.replaceAllButton, gridBagConstraints);
        this.configureButton(this.replaceAllButton);
        this.searchReplaceForm.setInfo(this.defaultInfo());
        this.setDone(true);
    }

    protected void registerKeyBoardActions() {
        this.registerKeyboardAction(this, "stop", KeyStroke.getKeyStroke(113, 0), 1);
        this.registerKeyboardAction(this, "skip", KeyStroke.getKeyStroke(114, 0), 1);
        this.registerKeyboardAction(this, "skipElement", KeyStroke.getKeyStroke(115, 0), 1);
        this.registerKeyboardAction(this, "replace", KeyStroke.getKeyStroke(116, 0), 1);
        this.registerKeyboardAction(this, "replaceAll", KeyStroke.getKeyStroke(117, 0), 1);
    }

    protected void createFunctionKeyIcons() {
        Font font = this.getFont();
        font = new Font(font.getFamily(), 1, Math.max(10, font.getSize() - 2));
        Color color = this.getBackground().darker().darker();
        color = new Color(color.getRed(), color.getGreen(), Math.max(192, color.getBlue()));
        int n = 0;
        this.functionKeyIcons[n++] = new TextIcon(this, "F9", font, null, null);
        while (n < this.functionKeyIcons.length) {
            this.functionKeyIcons[n] = new TextIcon(this, "F" + (1 + n), font, color, null);
            ++n;
        }
    }

    protected SearchReplaceForm.Info defaultInfo() {
        SearchReplaceForm.Info info = new SearchReplaceForm.Info();
        info.searched = "";
        info.replacement = null;
        info.ignoreCase = true;
        info.wholeWord = false;
        info.regularExpression = false;
        info.smartMode = true;
        info.backwards = false;
        return info;
    }

    protected void configureButton(JButton jButton) {
        jButton.setIcon(this.functionKeyIcons[0]);
        DialogUtil.setIconic(jButton);
        jButton.setHorizontalAlignment(2);
    }

    protected void setDone(boolean bl) {
        String string;
        String string2;
        this.done = bl;
        this.searchReplaceInfo = null;
        this.searchReplaceText = null;
        this.selectionMark = null;
        this.selectionDot = null;
        if (bl) {
            string2 = Msg.msg("SRP.start");
            string = "start";
        } else {
            string2 = Msg.msg("SRP.stop");
            string = "stop";
        }
        this.startButton.setText(string2);
        this.startButton.setActionCommand(string);
        if (bl) {
            this.startButton.setIcon(this.functionKeyIcons[0]);
            this.skipButton.setIcon(this.functionKeyIcons[0]);
            this.skipElementButton.setIcon(this.functionKeyIcons[0]);
            this.replaceButton.setIcon(this.functionKeyIcons[0]);
            this.replaceAllButton.setIcon(this.functionKeyIcons[0]);
        } else {
            this.startButton.setIcon(this.functionKeyIcons[1]);
            this.skipButton.setIcon(this.functionKeyIcons[2]);
            this.skipElementButton.setIcon(this.functionKeyIcons[3]);
            this.replaceButton.setIcon(this.functionKeyIcons[4]);
            this.replaceAllButton.setIcon(this.functionKeyIcons[5]);
        }
        this.searchReplaceForm.setEnabled(bl);
        this.skipButton.setEnabled(!bl);
        this.skipElementButton.setEnabled(!bl);
        this.replaceButton.setEnabled(false);
        this.replaceAllButton.setEnabled(false);
    }

    public JTextField getSearchedField() {
        return this.searchReplaceForm.getSearchedField();
    }

    public void setDocumentView(DocumentView documentView) {
        boolean bl;
        if (!this.done) {
            this.setDone(true);
        }
        this.docView = documentView;
        boolean bl2 = bl = documentView != null && documentView.getDocument() != null;
        if (this.startButton.isEnabled() != bl) {
            this.searchReplaceForm.setEnabled(bl);
            this.startButton.setEnabled(bl);
        }
    }

    public DocumentView getDocumentView() {
        return this.docView;
    }

    public void search(boolean bl) {
        if (this.docView == null || this.docView.getDocument() == null) {
            return;
        }
        if (!this.done) {
            this.setDone(true);
        }
        this.searchReplaceForm.setReplacing(false);
        this.searchReplaceForm.setDirection(bl);
        JTextField jTextField = this.searchReplaceForm.getSearchedField();
        jTextField.selectAll();
        jTextField.requestFocus();
    }

    public void searchReplace(boolean bl) {
        if (this.docView == null || this.docView.getDocument() == null) {
            return;
        }
        if (!this.done) {
            this.setDone(true);
        }
        this.searchReplaceForm.setReplacing(true);
        this.searchReplaceForm.setDirection(bl);
        JTextField jTextField = this.searchReplaceForm.getReplacementField();
        jTextField.selectAll();
        jTextField = this.searchReplaceForm.getSearchedField();
        jTextField.selectAll();
        jTextField.requestFocus();
    }

    public void findAgain(boolean bl) {
        Object[] objectArray;
        if (this.docView == null || this.docView.getDocument() == null) {
            return;
        }
        if (!this.done) {
            this.setDone(true);
        }
        if ((objectArray = this.getSearchReplaceInfo()) == null) {
            return;
        }
        SearchReplaceForm.Info info = (SearchReplaceForm.Info)objectArray[0];
        Matcher matcher = (Matcher)objectArray[1];
        info.backwards = bl;
        info.replacement = null;
        SearchReplaceText searchReplaceText = SearchUtil.createSearchReplaceText(this.docView, info, matcher);
        if (searchReplaceText == null) {
            return;
        }
        TextOffset[] textOffsetArray = searchReplaceText.search();
        if (textOffsetArray == null) {
            ShowStatus.showStatus(Msg.msg("SRP.searchedTextNotFound", ShowStatus.shorten(info.searched, 20)));
        } else {
            int n;
            int n2;
            ShowStatus.showStatus("");
            if (info.backwards) {
                n2 = 1;
                n = 0;
            } else {
                n2 = 0;
                n = 1;
            }
            TextOffset textOffset = textOffsetArray[n2];
            TextOffset textOffset2 = textOffsetArray[n];
            this.docView.selectShowText(textOffset.text, textOffset.offset, textOffset2.text, textOffset2.offset);
        }
    }

    public void cancel() {
        if (!this.done) {
            this.setDone(true);
        }
    }

    protected Object[] getSearchReplaceInfo() {
        SearchReplaceForm.Info info = this.searchReplaceForm.getInfo();
        if (info.searched.length() == 0) {
            DialogUtil.badField(this.searchReplaceForm.getSearchedField());
            Alert.showError(this.docView.getPanel(), Msg.msg("SRP.noSearchedText"));
            return null;
        }
        Matcher matcher = null;
        if (info.regularExpression && (matcher = SearchUtil.createMatcher(info.searched, info.ignoreCase, this.docView.getPanel())) == null) {
            DialogUtil.badField(this.searchReplaceForm.getSearchedField());
            return null;
        }
        this.searchReplaceForm.addToSearchHistory(info.searched);
        this.searchReplaceForm.addToReplaceHistory(info.replacement);
        return new Object[]{info, matcher};
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("start".equals(string)) {
            this.start();
        } else if ("stop".equals(string)) {
            this.stop();
        } else if ("skip".equals(string)) {
            this.skip();
        } else if ("skipElement".equals(string)) {
            this.skipElement();
        } else if ("replace".equals(string)) {
            this.replace();
        } else if ("replaceAll".equals(string)) {
            this.replaceAll();
        } else if ("cancel".equals(string)) {
            this.cancel();
        }
    }

    protected boolean start() {
        this.setDone(false);
        Object[] objectArray = this.getSearchReplaceInfo();
        if (objectArray == null) {
            this.setDone(true);
            return false;
        }
        this.searchReplaceInfo = (SearchReplaceForm.Info)objectArray[0];
        Matcher matcher = (Matcher)objectArray[1];
        if (this.searchReplaceInfo.replacement != null) {
            this.replaceButton.setEnabled(true);
            this.replaceAllButton.setEnabled(true);
        }
        this.searchReplaceText = SearchUtil.createSearchReplaceText(this.docView, this.searchReplaceInfo, matcher);
        if (this.searchReplaceText == null) {
            this.setDone(true);
            return false;
        }
        TextOffset[] textOffsetArray = this.searchReplaceText.search();
        if (textOffsetArray == null) {
            this.searchFailed();
            return false;
        }
        this.searchSuccessful(textOffsetArray);
        return true;
    }

    protected void searchFailed() {
        ShowStatus.showStatus(Msg.msg("SRP.searchedTextNotFound", ShowStatus.shorten(this.searchReplaceInfo.searched, 20)));
        this.setDone(true);
    }

    protected void searchSuccessful(TextOffset[] textOffsetArray) {
        int n;
        int n2;
        ShowStatus.showStatus("");
        if (this.searchReplaceInfo.backwards) {
            n2 = 1;
            n = 0;
        } else {
            n2 = 0;
            n = 1;
        }
        this.selectionMark = textOffsetArray[n2].copy();
        this.selectionDot = textOffsetArray[n].copy();
        this.docView.selectShowText(this.selectionMark.text, this.selectionMark.offset, this.selectionDot.text, this.selectionDot.offset);
    }

    protected void stop() {
        this.cancel();
    }

    protected void skip() {
        if (this.done) {
            return;
        }
        TextOffset[] textOffsetArray = this.searchReplaceText.search();
        if (textOffsetArray == null) {
            this.searchFailed();
            return;
        }
        this.searchSuccessful(textOffsetArray);
    }

    protected void skipElement() {
        if (this.done) {
            return;
        }
        TextOffset[] textOffsetArray = this.searchReplaceText.skipElement();
        if (textOffsetArray == null) {
            this.searchFailed();
            return;
        }
        this.searchSuccessful(textOffsetArray);
    }

    protected void replace() {
        TextOffset[] textOffsetArray;
        if (this.done) {
            return;
        }
        this.selectionMark = null;
        this.selectionDot = null;
        TextRange textRange = this.searchReplaceText.replace();
        if (textRange != null) {
            this.docView.describeUndo(Msg.msg("SRP.searchReplaceText"));
        }
        if ((textOffsetArray = this.searchReplaceText.search()) != null) {
            this.searchSuccessful(textOffsetArray);
            return;
        }
        String string = Msg.msg("SRP.replacedText", new Integer(this.searchReplaceText.getReplacementCount()), ShowStatus.shorten(this.searchReplaceInfo.searched, 20));
        this.setDone(true);
        if (textRange != null) {
            this.docView.selectShowText(textRange.text, textRange.offset, textRange.text, textRange.offset + textRange.count);
        }
        ShowStatus.showStatus(string);
    }

    protected void replaceAll() {
        if (this.done) {
            return;
        }
        this.selectionMark = null;
        this.selectionDot = null;
        TextRange[] textRangeArray = this.searchReplaceText.replaceAll();
        if (textRangeArray.length > 0) {
            this.docView.describeUndo(Msg.msg("SRP.searchReplaceAllText"));
        }
        String string = Msg.msg("SRP.replacedText", new Integer(this.searchReplaceText.getReplacementCount()), ShowStatus.shorten(this.searchReplaceInfo.searched, 20));
        this.setDone(true);
        if (textRangeArray.length > 0) {
            TextRange textRange = textRangeArray[textRangeArray.length - 1];
            this.docView.selectShowText(textRange.text, textRange.offset, textRange.text, textRange.offset + textRange.count);
        }
        ShowStatus.showStatus(string);
    }
}

