/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.search;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.TextNode;
import com.xmlmind.xmledit.doc.Traversal;
import com.xmlmind.xmledit.doc.Tree;
import com.xmlmind.xmledit.doctype.DocumentType;
import com.xmlmind.xmledit.edit.PositionToTextOffset;
import com.xmlmind.xmledit.edit.TextEditor;
import com.xmlmind.xmledit.edit.TextOffset;
import com.xmlmind.xmledit.edit.TextOffsetToPosition;
import com.xmlmind.xmledit.edit.TextRange;
import com.xmlmind.xmledit.search.ElementCharSequence;
import com.xmlmind.xmledit.util.CharSequenceUtil;
import com.xmlmind.xmledit.util.GroupCapture;
import com.xmlmind.xmledit.util.StringUtil;
import java.util.ArrayList;
import java.util.regex.Matcher;

public class SearchReplaceText {
    public static final int MARK_NONE = 1;
    public static final int MARK_ALL = 2;
    public static final int MARK_LAST = 4;
    public static final int IGNORE_CASE = 8;
    public static final int WHOLE_WORD = 16;
    public static final int BACKWARDS = 32;
    public static final int REPLACE_CHARS = 64;
    public static final String DEFAULT_EMPTY_TEXT_CONTENT = " ";
    public static final String DEFAULT_PARAGRAPH_MARK = "\n\n";
    private Element searchedElement;
    private TextOffset searchBegin;
    private TextOffset searchEnd;
    private TextEditor textEditor;
    private String searched;
    private Matcher matcher;
    private String replacement;
    private boolean ignoreCase;
    private boolean wholeWord;
    private boolean backwards;
    private boolean replaceChars;
    private int markParagraphs;
    private String emptyTextContent;
    private String paragraphMark;
    private ElementCharSequence chars;
    private int searchFrom;
    private String replacementText;
    private TextOffset foundBegin;
    private TextOffset foundEnd;
    private int replacementCount;
    private TextOffsetToPosition textOffsetToPos = null;
    private PositionToTextOffset posToTextOffset = null;
    private static final TextRange[] NO_TEXT_RANGES = new TextRange[0];

    public SearchReplaceText(Element element, String string, String string2, int n) {
        this(element, null, null, string, null, string2, n, DEFAULT_EMPTY_TEXT_CONTENT, DEFAULT_PARAGRAPH_MARK);
    }

    public SearchReplaceText(Element element, String string, String string2, int n, String string3, String string4) {
        this(element, null, null, string, null, string2, n, string3, string4);
    }

    public SearchReplaceText(TextOffset textOffset, TextOffset textOffset2, String string, String string2, int n) {
        this(null, textOffset, textOffset2, string, null, string2, n, DEFAULT_EMPTY_TEXT_CONTENT, DEFAULT_PARAGRAPH_MARK);
    }

    public SearchReplaceText(TextOffset textOffset, TextOffset textOffset2, String string, String string2, int n, String string3, String string4) {
        this(null, textOffset, textOffset2, string, null, string2, n, string3, string4);
    }

    public SearchReplaceText(Element element, TextOffset textOffset, TextOffset textOffset2, String string, String string2, int n) {
        this(element, textOffset, textOffset2, string, null, string2, n, DEFAULT_EMPTY_TEXT_CONTENT, DEFAULT_PARAGRAPH_MARK);
    }

    public SearchReplaceText(Element element, TextOffset textOffset, TextOffset textOffset2, String string, String string2, int n, String string3, String string4) {
        this(element, textOffset, textOffset2, string, null, string2, n, string3, string4);
    }

    public SearchReplaceText(Element element, Matcher matcher, String string, int n) {
        this(element, null, null, null, matcher, string, n, DEFAULT_EMPTY_TEXT_CONTENT, DEFAULT_PARAGRAPH_MARK);
    }

    public SearchReplaceText(Element element, Matcher matcher, String string, int n, String string2, String string3) {
        this(element, null, null, null, matcher, string, n, string2, string3);
    }

    public SearchReplaceText(TextOffset textOffset, TextOffset textOffset2, Matcher matcher, String string, int n) {
        this(null, textOffset, textOffset2, null, matcher, string, n, DEFAULT_EMPTY_TEXT_CONTENT, DEFAULT_PARAGRAPH_MARK);
    }

    public SearchReplaceText(TextOffset textOffset, TextOffset textOffset2, Matcher matcher, String string, int n, String string2, String string3) {
        this(null, textOffset, textOffset2, null, matcher, string, n, string2, string3);
    }

    public SearchReplaceText(Element element, TextOffset textOffset, TextOffset textOffset2, Matcher matcher, String string, int n) {
        this(element, textOffset, textOffset2, null, matcher, string, n, DEFAULT_EMPTY_TEXT_CONTENT, DEFAULT_PARAGRAPH_MARK);
    }

    public SearchReplaceText(Element element, TextOffset textOffset, TextOffset textOffset2, Matcher matcher, String string, int n, String string2, String string3) {
        this(element, textOffset, textOffset2, null, matcher, string, n, string2, string3);
    }

    private SearchReplaceText(Element element, TextOffset textOffset, TextOffset textOffset2, String string, Matcher matcher, String string2, int n, String string3, String string4) {
        if (element == null) {
            if (textOffset == null) {
                if (textOffset2 != null) {
                    element = textOffset2.text.getDocument().getRootElement();
                }
            } else {
                element = textOffset.text.getDocument().getRootElement();
            }
        }
        if (element == null) {
            throw new IllegalArgumentException("unspecified text range");
        }
        this.searchedElement = element;
        DocumentType documentType = (DocumentType)element.getDocument().getProperty("DOCUMENT_TYPE");
        this.textEditor = new TextEditor(documentType);
        this.searchBegin = textOffset;
        this.searchEnd = textOffset2;
        if (matcher == null) {
            if (string == null || string.length() == 0) {
                throw new IllegalArgumentException("nothing to search");
            }
            this.searched = string;
        } else {
            this.matcher = matcher;
        }
        this.replacement = string2;
        this.ignoreCase = (n & 8) != 0;
        this.wholeWord = (n & 0x10) != 0;
        this.backwards = (n & 0x20) != 0;
        boolean bl = this.replaceChars = (n & 0x40) != 0;
        if (string3 == null || string3.length() == 0) {
            string3 = DEFAULT_EMPTY_TEXT_CONTENT;
        }
        this.emptyTextContent = string3;
        this.markParagraphs = (n & 1) != 0 ? 0 : ((n & 2) != 0 ? 1 : 2);
        if (string4 == null || string4.length() == 0) {
            string4 = DEFAULT_PARAGRAPH_MARK;
        }
        this.paragraphMark = string4;
        this.chars = new ElementCharSequence(element, textOffset, textOffset2, string3, this.markParagraphs, string4);
        int n2 = this.chars.length();
        if (n2 > 0) {
            if (this.searchBegin == null) {
                this.searchBegin = this.chars.getTextOffset(0);
            }
            if (this.searchEnd == null) {
                this.searchEnd = this.chars.getTextOffset(n2);
            }
        }
        this.searchFrom = this.backwards ? n2 : 0;
        this.foundEnd = null;
        this.foundBegin = null;
        this.replacementText = null;
        this.replacementCount = 0;
    }

    public TextOffset[] search() {
        TextNode textNode;
        String string;
        int n;
        if (this.searchFrom < 0) {
            return null;
        }
        while (true) {
            if (this.matcher != null) {
                GroupCapture[] groupCaptureArray = this.backwards ? SearchReplaceText.getMatchBackwards(this.matcher, this.chars, this.searchFrom) : SearchReplaceText.getMatch(this.matcher, this.chars, this.searchFrom);
                if (groupCaptureArray == null) {
                    n = -1;
                    string = null;
                    this.replacementText = null;
                } else {
                    n = groupCaptureArray[0].getStartIndex();
                    string = groupCaptureArray[0].getText();
                    this.replacementText = this.replacement == null ? null : SearchReplaceText.substituteMatchVars(this.replacement, groupCaptureArray);
                }
            } else {
                n = this.backwards ? CharSequenceUtil.lastIndexOf(this.chars, this.searched, this.searchFrom, this.ignoreCase) : CharSequenceUtil.indexOf(this.chars, this.searched, this.searchFrom, this.ignoreCase);
                if (n < 0) {
                    string = null;
                    this.replacementText = null;
                } else {
                    string = this.searched;
                    this.replacementText = this.replacement;
                }
            }
            if (string == null) {
                this.searchFrom = -1;
                break;
            }
            int n2 = n + string.length();
            this.searchFrom = this.backwards ? n - 1 : n2;
            if (!this.wholeWord || (n == 0 || Character.isWhitespace(this.chars.charAt(n - 1))) && (n2 == this.chars.length() || Character.isWhitespace(this.chars.charAt(n2)))) break;
            if (this.backwards) {
                --this.searchFrom;
                continue;
            }
            ++this.searchFrom;
        }
        if (string == null) {
            this.foundEnd = null;
            this.foundBegin = null;
            return null;
        }
        this.foundBegin = this.chars.getTextOffset(n);
        this.foundEnd = this.chars.getTextOffset(n + string.length());
        if (this.foundEnd.offset == 0 && this.foundBegin.text != this.foundEnd.text && (textNode = (TextNode)Traversal.traverseBefore(this.foundEnd.text, Traversal.textNodeFinder)) != null) {
            this.foundEnd.text = textNode;
            this.foundEnd.offset = textNode.getTextLength();
        }
        return new TextOffset[]{this.foundBegin, this.foundEnd};
    }

    private static final GroupCapture[] getMatch(Matcher matcher, CharSequence charSequence, int n) {
        matcher.reset(charSequence);
        if (!matcher.find(n)) {
            return null;
        }
        return GroupCapture.getAll(matcher);
    }

    private static final GroupCapture[] getMatchBackwards(Matcher matcher, CharSequence charSequence, int n) {
        int n2 = n - 1;
        while (n2 >= 0) {
            GroupCapture[] groupCaptureArray = SearchReplaceText.getMatch(matcher, charSequence, n2);
            if (groupCaptureArray != null && groupCaptureArray[0].getStartIndex() == n2) {
                return groupCaptureArray;
            }
            --n2;
        }
        return null;
    }

    public static final String substituteMatchVars(String string, GroupCapture[] groupCaptureArray) {
        if (string.indexOf(36) < 0) {
            return string;
        }
        String string2 = string;
        string2 = StringUtil.replaceAll(string2, "$$", "\u0000");
        int n = groupCaptureArray.length - 1;
        while (n >= 0) {
            string2 = StringUtil.replaceAll(string2, "$" + n, groupCaptureArray[n].getText());
            --n;
        }
        return string2.replace('\u0000', '$');
    }

    public TextOffset[] getFound() {
        if (this.foundBegin == null || this.foundEnd == null) {
            return null;
        }
        return new TextOffset[]{this.foundBegin, this.foundEnd};
    }

    public TextOffset[] skipElement() {
        int n;
        if (this.searchFrom < 0) {
            return null;
        }
        TextOffset textOffset = new TextOffset();
        int n2 = this.chars.length();
        if (this.backwards) {
            n = this.searchFrom + 1;
            if (n >= n2) {
                n = n2 - 1;
            }
            this.chars.getTextOffset(n, textOffset);
            TextNode textNode = textOffset.text;
            Tree tree = textNode.getParent();
            --n;
            while (n >= 0) {
                this.chars.getTextOffset(n, textOffset);
                TextNode textNode2 = textOffset.text;
                if (textNode2 != textNode) {
                    Tree tree2 = textNode2.getParent();
                    if (!tree2.isDescendantOf(tree)) break;
                    textNode = textNode2;
                }
                --n;
            }
        } else {
            n = this.searchFrom - 1;
            if (n < 0) {
                n = 0;
            }
            this.chars.getTextOffset(n, textOffset);
            TextNode textNode = textOffset.text;
            Tree tree = textNode.getParent();
            ++n;
            while (n < n2) {
                this.chars.getTextOffset(n, textOffset);
                TextNode textNode3 = textOffset.text;
                if (textNode3 != textNode) {
                    Tree tree3 = textNode3.getParent();
                    if (!tree3.isDescendantOf(tree)) break;
                    textNode = textNode3;
                }
                ++n;
            }
        }
        if (n < 0 || n >= n2) {
            this.searchFrom = -1;
            this.foundEnd = null;
            this.foundBegin = null;
            this.replacementText = null;
            return null;
        }
        this.searchFrom = n;
        return this.search();
    }

    public boolean canReplace() {
        return this.replacementText != null && this.foundBegin != null && this.foundEnd != null && this.textEditor.canEdit(this.foundBegin.text, this.foundBegin.offset, this.foundEnd.text, this.foundEnd.offset);
    }

    public TextRange replace() {
        TextOffset textOffset;
        TextOffset textOffset2;
        if (!this.canReplace()) {
            return null;
        }
        int n = -1;
        int n2 = -1;
        if (this.backwards) {
            n = this.textOffsetToPosition().getFromBegin(this.searchBegin);
        } else {
            n2 = this.textOffsetToPosition().getFromEnd(this.searchEnd);
        }
        int n3 = this.textOffsetToPosition().getFromBegin(this.foundBegin);
        if (this.replacementText.length() == 0) {
            if (this.replaceChars) {
                this.textEditor.deleteChars(this.foundBegin.text, this.foundBegin.offset, this.foundEnd.text, this.foundEnd.offset);
            } else {
                this.textEditor.delete(this.foundBegin.text, this.foundBegin.offset, this.foundEnd.text, this.foundEnd.offset);
            }
        } else {
            boolean bl = false;
            if (this.replaceChars) {
                bl = true;
            } else if (this.replacementText.startsWith("<?xml ") || !this.textEditor.canPaste(this.foundBegin.text, this.foundBegin.offset, this.foundEnd.text, this.foundEnd.offset, this.replacementText)) {
                bl = true;
            } else {
                this.textEditor.paste(this.foundBegin.text, this.foundBegin.offset, this.foundEnd.text, this.foundEnd.offset, this.replacementText);
            }
            if (bl) {
                this.textEditor.pasteChars(this.foundBegin.text, this.foundBegin.offset, this.foundEnd.text, this.foundEnd.offset, this.replacementText);
            }
        }
        Document document = this.searchedElement.getDocument();
        this.foundBegin = this.positionToTextOffset().getFromBegin(document, n3);
        ++this.replacementCount;
        TextRange textRange = new TextRange(this.foundBegin.text, this.foundBegin.offset, this.replacementText.length());
        if (this.backwards) {
            textOffset2 = this.positionToTextOffset().getFromBegin(document, n);
            textOffset = this.foundBegin;
        } else {
            this.foundBegin.offset += textRange.count;
            textOffset2 = this.foundBegin;
            textOffset = this.positionToTextOffset().getFromEnd(document, n2);
        }
        this.chars = new ElementCharSequence(this.searchedElement, textOffset2, textOffset, this.emptyTextContent, this.markParagraphs, this.paragraphMark);
        this.searchFrom = this.backwards ? this.chars.length() - 1 : 0;
        this.foundEnd = null;
        this.foundBegin = null;
        this.replacementText = null;
        return textRange;
    }

    private TextOffsetToPosition textOffsetToPosition() {
        if (this.textOffsetToPos == null) {
            this.textOffsetToPos = new TextOffsetToPosition();
        }
        return this.textOffsetToPos;
    }

    private PositionToTextOffset positionToTextOffset() {
        if (this.posToTextOffset == null) {
            this.posToTextOffset = new PositionToTextOffset();
        }
        return this.posToTextOffset;
    }

    public TextRange[] replaceAll() {
        TextRange[] textRangeArray;
        if (this.replacementText == null || this.foundBegin == null || this.foundEnd == null) {
            return null;
        }
        ArrayList<TextRange[]> arrayList = new ArrayList<TextRange[]>();
        Document document = this.searchedElement.getDocument();
        document.beginBatchEditing();
        do {
            if ((textRangeArray = this.replace()) == null) continue;
            arrayList.add(textRangeArray);
        } while (this.search() != null);
        document.endBatchEditing();
        textRangeArray = arrayList.toArray(NO_TEXT_RANGES);
        return textRangeArray;
    }

    public int getReplacementCount() {
        return this.replacementCount;
    }
}

