/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.spell;

import com.xmlmind.spellcheck.engine.SpellChecker;
import com.xmlmind.spellcheck.engine.SpellException;
import com.xmlmind.spellcheck.util.CharSequence;
import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.TextNode;
import com.xmlmind.xmledit.doc.Traversal;
import com.xmlmind.xmledit.doc.Tree;
import com.xmlmind.xmledit.edit.MarkManager;
import com.xmlmind.xmledit.edit.TextEditor;
import com.xmlmind.xmledit.edit.TextLocation;
import com.xmlmind.xmledit.edit.TextOffset;
import com.xmlmind.xmledit.guiutil.Alert;
import com.xmlmind.xmledit.guiutil.DialogUtil;
import com.xmlmind.xmledit.guiutil.ShowStatus;
import com.xmlmind.xmledit.guiutil.TextIcon;
import com.xmlmind.xmledit.guiutil.ThinBorder;
import com.xmlmind.xmledit.spell.CheckableCharSequence;
import com.xmlmind.xmledit.spell.Msg;
import com.xmlmind.xmledit.spell.SpellCheckerFactory;
import com.xmlmind.xmledit.util.StringUtil;
import com.xmlmind.xmledit.view.DocumentView;
import com.xmlmind.xmledit.xmlutil.XMLUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.HashMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SpellCheckPane
extends JPanel
implements ActionListener,
ListSelectionListener {
    protected TextIcon[] functionKeyIcons = new TextIcon[8];
    protected JTextField errorField;
    protected JTextField badWordField;
    protected JTextField replacementField;
    protected JList suggestionList;
    protected JComboBox languageCombo;
    protected JButton startButton;
    protected JButton replaceButton;
    protected JButton replaceAllButton;
    protected JButton ignoreButton;
    protected JButton ignoreAllButton;
    protected JButton skipElementButton;
    protected JButton learnButton;
    protected String[] languages;
    protected DocumentView docView;
    protected SpellChecker spellChecker = null;
    protected boolean done = true;
    protected TextOffset selectionMark = null;
    protected TextOffset selectionDot = null;
    protected int checkResult = 0;
    protected CheckableCharSequence charInput = null;
    protected HashMap ignoredWords = new HashMap();
    protected HashMap replacedWords = new HashMap();
    protected boolean mustSavePersonalDictionaries = false;
    protected static final String[] NO_SUGGESTIONS = new String[0];
    protected Traversal.TextNodeMatcher textNodeMatcher = new Traversal.TextNodeMatcher();

    public SpellCheckPane(boolean bl) {
        super(new GridBagLayout());
        this.registerKeyBoardActions();
        this.createFunctionKeyIcons();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.left = 2;
        gridBagConstraints.insets.right = 2;
        gridBagConstraints.anchor = 18;
        JPanel jPanel = this.createForm();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        if (bl) {
            gridBagConstraints.gridheight = 7;
        }
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)jPanel, gridBagConstraints);
        String string = Msg.msg("SCP.start");
        this.startButton = new JButton(string);
        this.startButton.setActionCommand("start");
        this.startButton.addActionListener(this);
        if (bl) {
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridheight = 1;
        } else {
            ++gridBagConstraints.gridy;
        }
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        if (bl) {
            gridBagConstraints.insets.top = 2;
            gridBagConstraints.insets.left = 7;
        } else {
            gridBagConstraints.insets.left = 2;
        }
        this.add((Component)this.startButton, gridBagConstraints);
        this.configureButton(this.startButton);
        string = Msg.msg("SCP.replace");
        this.replaceButton = new JButton(string);
        this.replaceButton.setActionCommand("replace");
        this.replaceButton.addActionListener(this);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.top = 1;
        this.add((Component)this.replaceButton, gridBagConstraints);
        this.configureButton(this.replaceButton);
        string = Msg.msg("SCP.replaceAll");
        this.replaceAllButton = new JButton(string);
        this.replaceAllButton.setActionCommand("replaceAll");
        this.replaceAllButton.addActionListener(this);
        ++gridBagConstraints.gridy;
        this.add((Component)this.replaceAllButton, gridBagConstraints);
        this.configureButton(this.replaceAllButton);
        string = Msg.msg("SCP.ignore");
        this.ignoreButton = new JButton(string);
        this.ignoreButton.setActionCommand("ignore");
        this.ignoreButton.addActionListener(this);
        ++gridBagConstraints.gridy;
        this.add((Component)this.ignoreButton, gridBagConstraints);
        this.configureButton(this.ignoreButton);
        string = Msg.msg("SCP.ignoreAll");
        this.ignoreAllButton = new JButton(string);
        this.ignoreAllButton.setActionCommand("ignoreAll");
        this.ignoreAllButton.addActionListener(this);
        ++gridBagConstraints.gridy;
        this.add((Component)this.ignoreAllButton, gridBagConstraints);
        this.configureButton(this.ignoreAllButton);
        string = Msg.msg("SCP.skipElement");
        this.skipElementButton = new JButton(string);
        this.skipElementButton.setActionCommand("skipElement");
        this.skipElementButton.addActionListener(this);
        ++gridBagConstraints.gridy;
        this.add((Component)this.skipElementButton, gridBagConstraints);
        this.configureButton(this.skipElementButton);
        string = Msg.msg("SCP.learn");
        this.learnButton = new JButton(string);
        this.learnButton.setActionCommand("learn");
        this.learnButton.addActionListener(this);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.bottom = 2;
        this.add((Component)this.learnButton, gridBagConstraints);
        this.configureButton(this.learnButton);
        this.initLanguages();
        this.setDone(true);
    }

    protected JPanel createForm() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 2;
        gridBagConstraints.insets.left = 2;
        gridBagConstraints.insets.right = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 2;
        this.errorField = new JTextField();
        this.errorField.setEditable(false);
        Color color = this.getBackground();
        this.errorField.setBorder(new ThinBorder(color, false, 0, 0));
        this.errorField.setForeground(Color.red.darker());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.errorField, gridBagConstraints);
        this.badWordField = new JTextField(20);
        this.badWordField.setEditable(false);
        this.badWordField.setBorder(new ThinBorder(color, false, 0, 0));
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.top = 1;
        jPanel.add((Component)this.badWordField, gridBagConstraints);
        String string = Msg.msg("SCP.replaceWith");
        JLabel jLabel = new JLabel(DialogUtil.buttonLabel(string));
        DialogUtil.setDisplayedMnemonic(jLabel, string);
        gridBagConstraints.insets.top = 2;
        ++gridBagConstraints.gridy;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.replacementField = new JTextField();
        this.replacementField.setActionCommand("replace");
        this.replacementField.addActionListener(this);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.top = 1;
        jPanel.add((Component)this.replacementField, gridBagConstraints);
        jLabel.setLabelFor(this.replacementField);
        string = Msg.msg("SCP.suggestions");
        jLabel = new JLabel(DialogUtil.buttonLabel(string));
        DialogUtil.setDisplayedMnemonic(jLabel, string);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.top = 2;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.suggestionList = new JList();
        this.suggestionList.addListSelectionListener(this);
        this.suggestionList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    SpellCheckPane.this.replace();
                }
            }
        });
        jLabel.setLabelFor(this.suggestionList);
        JScrollPane jScrollPane = new JScrollPane(this.suggestionList);
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets.top = 1;
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        string = Msg.msg("SCP.language");
        jLabel = new JLabel(DialogUtil.buttonLabel(string));
        DialogUtil.setDisplayedMnemonic(jLabel, string);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets.top = 2;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.insets.bottom = 2;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.languageCombo = new JComboBox();
        this.languageCombo.setEditable(false);
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets.right = 2;
        jPanel.add((Component)this.languageCombo, gridBagConstraints);
        jLabel.setLabelFor(this.languageCombo);
        return jPanel;
    }

    protected void registerKeyBoardActions() {
        this.registerKeyboardAction(this, "stop", KeyStroke.getKeyStroke(113, 0), 1);
        this.registerKeyboardAction(this, "replace", KeyStroke.getKeyStroke(114, 0), 1);
        this.registerKeyboardAction(this, "replaceAll", KeyStroke.getKeyStroke(115, 0), 1);
        this.registerKeyboardAction(this, "ignore", KeyStroke.getKeyStroke(116, 0), 1);
        this.registerKeyboardAction(this, "ignoreAll", KeyStroke.getKeyStroke(117, 0), 1);
        this.registerKeyboardAction(this, "skipElement", KeyStroke.getKeyStroke(118, 0), 1);
        this.registerKeyboardAction(this, "learn", KeyStroke.getKeyStroke(119, 0), 1);
    }

    protected void createFunctionKeyIcons() {
        Font font = this.getFont();
        font = new Font(font.getFamily(), 1, Math.max(10, font.getSize() - 2));
        Color color = this.getBackground().darker().darker();
        color = new Color(color.getRed(), color.getGreen(), Math.max(192, color.getBlue()));
        int n = 0;
        this.functionKeyIcons[n++] = new TextIcon(this, "F9", font, null, null);
        while (n < this.functionKeyIcons.length) {
            this.functionKeyIcons[n] = new TextIcon(this, "F" + (1 + n), font, color, null);
            ++n;
        }
    }

    protected void configureButton(JButton jButton) {
        jButton.setIcon(this.functionKeyIcons[0]);
        DialogUtil.setIconic(jButton);
        jButton.setHorizontalAlignment(2);
    }

    protected void initLanguages() {
        this.spellChecker = SpellCheckerFactory.getSpellChecker();
        if (this.spellChecker != null) {
            int n;
            this.languages = SpellCheckerFactory.getAvailableLanguages(false);
            this.languageCombo.setModel(new DefaultComboBoxModel<String>(SpellCheckerFactory.getAvailableLanguages(true)));
            String string = SpellCheckerFactory.getSelectedLanguage();
            if (string == null) {
                string = "en";
            }
            if ((n = StringUtil.indexOf(this.languages, string)) < 0 && (n = StringUtil.indexOf(this.languages, string = "en")) < 0) {
                n = 0;
                string = this.languages[0];
            }
            SpellCheckerFactory.setSelectedLanguage(string);
            this.languageCombo.setSelectedIndex(n);
            this.languageCombo.setActionCommand("selectLanguage");
            this.languageCombo.addActionListener(this);
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        String string = (String)this.suggestionList.getSelectedValue();
        if (string != null) {
            this.replacementField.setText(string);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("start".equals(string)) {
            this.start();
        } else if ("stop".equals(string)) {
            this.stop();
        } else if ("replace".equals(string)) {
            this.replace();
        } else if ("replaceAll".equals(string)) {
            this.replaceAll();
        } else if ("ignore".equals(string)) {
            this.ignore();
        } else if ("ignoreAll".equals(string)) {
            this.ignoreAll();
        } else if ("skipElement".equals(string)) {
            this.skipElement();
        } else if ("learn".equals(string)) {
            this.learn();
        } else if ("selectLanguage".equals(string)) {
            this.selectLanguage();
        } else if ("cancel".equals(string)) {
            this.cancel();
        }
    }

    public JTextField getReplacementField() {
        return this.replacementField;
    }

    public void setDocumentView(DocumentView documentView) {
        if (!this.done) {
            this.setDone(true);
        }
        this.docView = documentView;
        this.startButton.setEnabled(documentView != null && documentView.getDocument() != null);
    }

    public DocumentView getDocumentView() {
        return this.docView;
    }

    public boolean spellCheck() {
        if (this.docView == null || this.docView.getDocument() == null) {
            return true;
        }
        if (!this.done) {
            this.setDone(true);
        }
        this.start();
        return this.done;
    }

    public void cancel() {
        if (!this.done) {
            this.setDone(true);
        }
    }

    protected void setDone(boolean bl) {
        String string;
        String string2;
        this.done = bl;
        this.selectionMark = null;
        this.selectionDot = null;
        this.checkResult = 0;
        this.charInput = null;
        this.replacedWords.clear();
        if (this.mustSavePersonalDictionaries) {
            this.mustSavePersonalDictionaries = false;
            try {
                this.spellChecker.savePersonalDictionaries();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.errorField.setText("");
        this.badWordField.setText("");
        this.replacementField.setText("");
        this.suggestionList.setListData(NO_SUGGESTIONS);
        if (bl) {
            string2 = Msg.msg("SCP.start");
            string = "start";
        } else {
            string2 = Msg.msg("SCP.stop");
            string = "stop";
        }
        this.startButton.setText(string2);
        this.startButton.setActionCommand(string);
        if (bl) {
            this.startButton.setIcon(this.functionKeyIcons[0]);
            this.replaceButton.setIcon(this.functionKeyIcons[0]);
            this.replaceAllButton.setIcon(this.functionKeyIcons[0]);
            this.ignoreButton.setIcon(this.functionKeyIcons[0]);
            this.ignoreAllButton.setIcon(this.functionKeyIcons[0]);
            this.skipElementButton.setIcon(this.functionKeyIcons[0]);
            this.learnButton.setIcon(this.functionKeyIcons[0]);
        } else {
            this.startButton.setIcon(this.functionKeyIcons[1]);
            this.replaceButton.setIcon(this.functionKeyIcons[2]);
            this.replaceAllButton.setIcon(this.functionKeyIcons[3]);
            this.ignoreButton.setIcon(this.functionKeyIcons[4]);
            this.ignoreAllButton.setIcon(this.functionKeyIcons[5]);
            this.skipElementButton.setIcon(this.functionKeyIcons[6]);
            this.learnButton.setIcon(this.functionKeyIcons[7]);
        }
        this.replacementField.setEnabled(!bl);
        this.suggestionList.setEnabled(!bl);
        this.replaceButton.setEnabled(!bl);
        this.replaceAllButton.setEnabled(!bl);
        this.ignoreButton.setEnabled(!bl);
        this.ignoreAllButton.setEnabled(!bl);
        this.skipElementButton.setEnabled(!bl);
        this.learnButton.setEnabled(!bl);
    }

    protected void start() {
        this.spellChecker = SpellCheckerFactory.getSpellChecker();
        if (this.spellChecker == null) {
            Alert.showError(this.docView.getPanel(), Msg.msg("SCP.noDictionaries"));
            return;
        }
        this.setDone(false);
        ShowStatus.showStatus("");
        this.charInput = this.createCharSequence();
        if (this.charInput == null) {
            this.setDone(true);
            return;
        }
        this.spellChecker.setInput((CharSequence)this.charInput);
        try {
            this.checkResult = this.spellChecker.checkNext();
            this.showResult();
        }
        catch (SpellException spellException) {
            this.spellCheckerError((Exception)((Object)spellException));
        }
    }

    protected void spellCheckerError(Exception exception) {
        Alert.showError(this.docView.getPanel(), Msg.msg("SCP.spellCheckerError", exception.getClass().getName(), exception.getMessage()));
        this.setDone(true);
    }

    protected CheckableCharSequence createCharSequence() {
        Object object;
        MarkManager markManager = this.docView.getMarkManager();
        if (markManager == null) {
            return null;
        }
        TextLocation textLocation = markManager.getDot();
        if (textLocation == null) {
            Alert.showError(this.docView.getPanel(), Msg.msg("SCP.documentContainsNoText"));
            return null;
        }
        TextLocation textLocation2 = markManager.getMark();
        TextLocation textLocation3 = textLocation;
        if (textLocation2 != null) {
            object = textLocation2.getTextNode();
            int n = textLocation2.getOffset();
            TextNode textNode = textLocation.getTextNode();
            int n2 = textLocation.getOffset();
            if (object == textNode) {
                if (n > n2) {
                    textLocation3 = textLocation2;
                }
            } else {
                this.textNodeMatcher.searchedNode = textNode;
                if (Traversal.traverseAfter((Node)object, this.textNodeMatcher) == null) {
                    textLocation3 = textLocation2;
                }
            }
        }
        object = new TextOffset(textLocation3.getTextNode(), textLocation3.getOffset());
        char[] cArray = ((TextOffset)object).text.getTextChars();
        if (((TextOffset)object).offset < cArray.length && !XMLUtil.isXMLSpace(cArray[((TextOffset)object).offset])) {
            while (((TextOffset)object).offset > 0 && !XMLUtil.isXMLSpace(cArray[((TextOffset)object).offset - 1])) {
                --((TextOffset)object).offset;
            }
        }
        return new CheckableCharSequence(null, (TextOffset)object, null, null, 1, null);
    }

    protected void showResult() throws SpellException {
        block11: while (true) {
            switch (this.checkResult) {
                case 2: 
                case 3: {
                    String string = this.spellChecker.getWord();
                    if (this.ignoredWords.containsKey(string)) {
                        this.checkResult = this.spellChecker.checkNext();
                        continue block11;
                    }
                    String string2 = (String)this.replacedWords.get(string);
                    if (string2 != null) {
                        this.replaceBadWord(string2);
                        this.checkResult = this.spellChecker.checkNext();
                        continue block11;
                    }
                }
                case 4: 
                case 5: {
                    String string = this.spellChecker.getWord();
                    this.badWordField.setText(string);
                    int n = this.spellChecker.getPosition();
                    TextOffset textOffset = this.charInput.getTextOffset(n);
                    TextOffset textOffset2 = this.charInput.getTextOffset(n + string.length());
                    this.selectShowText(textOffset, textOffset2);
                    boolean bl = false;
                    switch (this.checkResult) {
                        case 2: {
                            this.errorField.setText(Msg.msg("SCP.unknownWord"));
                            bl = true;
                            break;
                        }
                        case 3: {
                            this.errorField.setText(Msg.msg("SCP.wrongCap"));
                            bl = true;
                            break;
                        }
                        case 4: {
                            this.errorField.setText(Msg.msg("SCP.duplicatedWords"));
                            break;
                        }
                        case 5: {
                            this.errorField.setText(Msg.msg("SCP.badPunctuation"));
                        }
                    }
                    this.replaceAllButton.setEnabled(bl);
                    this.ignoreAllButton.setEnabled(bl);
                    this.learnButton.setEnabled(bl);
                    if (bl) {
                        String[] stringArray = this.spellChecker.getSuggestions().toArray();
                        this.suggestionList.setListData(stringArray);
                        if (stringArray.length > 0) {
                            this.replacementField.setText(stringArray[0]);
                        } else {
                            this.replacementField.setText(string);
                            this.replacementField.selectAll();
                        }
                    } else {
                        this.suggestionList.setListData(NO_SUGGESTIONS);
                        this.replacementField.setText("");
                    }
                    this.suggestionList.ensureIndexIsVisible(0);
                    this.replacementField.requestFocus();
                    return;
                }
                case 0: {
                    ShowStatus.showStatus(Msg.msg("SCP.spellCheckingCompleted"));
                    this.setDone(true);
                    return;
                }
            }
            this.checkResult = this.spellChecker.checkNext();
        }
    }

    protected void selectShowText(TextOffset textOffset, TextOffset textOffset2) {
        this.selectionMark = textOffset.copy();
        this.selectionDot = textOffset2.copy();
        this.docView.selectShowText(this.selectionMark.text, this.selectionMark.offset, this.selectionDot.text, this.selectionDot.offset);
    }

    protected String replaceBadWord(String string) {
        String string2 = this.spellChecker.getWord();
        if (string2.equals(string)) {
            return null;
        }
        int n = this.spellChecker.getPosition();
        TextOffset textOffset = this.charInput.getTextOffset(n);
        TextOffset textOffset2 = this.charInput.getTextOffset(n + string2.length());
        TextEditor textEditor = this.docView.getTextEditor();
        if (!textEditor.canEdit(textOffset.text, textOffset.offset, textOffset2.text, textOffset2.offset)) {
            return string2;
        }
        MarkManager markManager = this.docView.getMarkManager();
        markManager.beginBatchMarking();
        Document document = this.docView.getDocument();
        document.beginBatchEditing();
        textEditor.cutChars(textOffset.text, textOffset.offset, textOffset2.text, textOffset2.offset);
        if (string.length() > 0) {
            textOffset.text.insertText(textOffset.offset, string);
        }
        document.endBatchEditing();
        this.docView.describeUndo(Msg.msg("SCP.fixSpelling"));
        this.selectionMark = textOffset.copy();
        textOffset.offset += string.length();
        this.selectionDot = textOffset.copy();
        this.docView.selectShowText(this.selectionMark.text, this.selectionMark.offset, this.selectionDot.text, this.selectionDot.offset);
        markManager.endBatchMarking();
        this.charInput = new CheckableCharSequence(null, textOffset, null, null, 1, null);
        this.spellChecker.setInput((CharSequence)this.charInput);
        return string2;
    }

    protected void stop() {
        this.cancel();
    }

    protected void replace() {
        if (this.done) {
            return;
        }
        String string = this.replacementField.getText();
        try {
            String string2 = this.replaceBadWord(string);
            if (string2 != null && (this.checkResult == 2 || this.checkResult == 3)) {
                this.learnSuggestion(string2, string);
            }
            this.checkResult = this.spellChecker.checkNext();
            this.showResult();
        }
        catch (SpellException spellException) {
            this.spellCheckerError((Exception)((Object)spellException));
        }
    }

    protected void learnSuggestion(String string, String string2) throws SpellException {
        if (string2.trim().length() == 0) {
            return;
        }
        ListModel listModel = this.suggestionList.getModel();
        int n = Math.min(3, listModel.getSize());
        boolean bl = true;
        int n2 = 0;
        while (n2 < n) {
            if (string2.equals((String)listModel.getElementAt(n2))) {
                bl = false;
                break;
            }
            ++n2;
        }
        if (bl) {
            this.spellChecker.learnSuggestion(string, string2, "<temporary>");
        }
    }

    protected void replaceAll() {
        if (this.done) {
            return;
        }
        String string = this.replacementField.getText();
        try {
            String string2 = this.replaceBadWord(string);
            if (string2 != null) {
                this.replacedWords.put(string2, string);
                this.learnSuggestion(string2, string);
            }
            this.checkResult = this.spellChecker.checkNext();
            this.showResult();
        }
        catch (SpellException spellException) {
            this.spellCheckerError((Exception)((Object)spellException));
        }
    }

    protected void ignore() {
        if (this.done) {
            return;
        }
        try {
            this.checkResult = this.spellChecker.checkNext();
            this.showResult();
        }
        catch (SpellException spellException) {
            this.spellCheckerError((Exception)((Object)spellException));
        }
    }

    protected void ignoreAll() {
        if (this.done) {
            return;
        }
        try {
            String string = this.spellChecker.getWord();
            this.ignoredWords.put(string, string);
            this.checkResult = this.spellChecker.checkNext();
            this.showResult();
        }
        catch (SpellException spellException) {
            this.spellCheckerError((Exception)((Object)spellException));
        }
    }

    protected void skipElement() {
        if (this.done) {
            return;
        }
        int n = this.spellChecker.getPosition();
        TextOffset textOffset = new TextOffset();
        this.charInput.getTextOffset(n, textOffset);
        TextNode textNode = textOffset.text;
        Tree tree = textNode.getParent();
        int n2 = this.charInput.length();
        ++n;
        while (n < n2) {
            this.charInput.getTextOffset(n, textOffset);
            TextNode textNode2 = textOffset.text;
            if (textNode2 != textNode) {
                Tree tree2 = textNode2.getParent();
                if (!tree2.isDescendantOf(tree)) break;
                textNode = textNode2;
            }
            ++n;
        }
        if (n >= n2) {
            ShowStatus.showStatus(Msg.msg("SCP.spellCheckingCompleted"));
            this.setDone(true);
            return;
        }
        try {
            this.charInput = new CheckableCharSequence(null, textOffset, null, null, 1, null);
            this.spellChecker.setInput((CharSequence)this.charInput);
            this.checkResult = this.spellChecker.checkNext();
            this.showResult();
        }
        catch (SpellException spellException) {
            this.spellCheckerError((Exception)((Object)spellException));
        }
    }

    protected void learn() {
        if (this.done) {
            return;
        }
        try {
            String string = this.spellChecker.getWord();
            if (SpellCheckerFactory.getPersonalDictionaryPath() != null) {
                this.spellChecker.learnWord(string, "<personal>");
                this.mustSavePersonalDictionaries = true;
            } else {
                this.spellChecker.learnWord(string, "<temporary>");
            }
            this.checkResult = this.spellChecker.checkNext();
            this.showResult();
        }
        catch (SpellException spellException) {
            this.spellCheckerError((Exception)((Object)spellException));
        }
    }

    protected void selectLanguage() {
        int n = this.languageCombo.getSelectedIndex();
        try {
            SpellCheckerFactory.setSelectedLanguage(this.languages[n]);
            if (!this.done) {
                this.spellChecker.setSelectedLanguage(this.languages[n]);
                int n2 = this.spellChecker.getPosition();
                TextOffset textOffset = this.charInput.getTextOffset(n2);
                this.charInput = new CheckableCharSequence(null, textOffset, null, null, 1, null);
                this.spellChecker.setInput((CharSequence)this.charInput);
                this.checkResult = this.spellChecker.checkNext();
                this.showResult();
            }
        }
        catch (Exception exception) {
            this.spellCheckerError(exception);
        }
    }
}

