/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.spell;

import com.xmlmind.spellcheck.engine.DictionaryManager;
import com.xmlmind.spellcheck.engine.DictionaryManagerItem;
import com.xmlmind.spellcheck.engine.SpellChecker;
import com.xmlmind.spellcheck.engine.SpellException;
import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmledit.util.StringUtil;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;

public class SpellCheckerFactory {
    private static HashMap definedDictionaries = new HashMap();
    private static DictionaryManager dictionaryManager = null;
    private static String personalDictionaryPath = null;
    private static boolean ignoreCase = false;
    private static boolean ignoreMixedCase = false;
    private static boolean ignoreDigits = true;
    private static boolean ignoreURL = true;
    private static boolean ignoreDuplicates = false;
    private static boolean checkPunctuation = false;
    private static boolean allowCompound = true;
    private static boolean allowPrefixes = true;
    private static boolean allowFileExtensions = true;
    private static boolean maxSuggestionForce = false;
    private static String selectedLanguage = null;
    private static SpellChecker spellChecker = null;
    private static String[] availableLanguages = null;
    private static String[] availableLanguagesLocalized = null;

    public static void defineDictionary(String string, URL uRL) {
        definedDictionaries.put(string, new DefinedDictionary(string, uRL));
        dictionaryManager = null;
        SpellCheckerFactory.discardSpellChecker();
    }

    private static void discardSpellChecker() {
        spellChecker = null;
        availableLanguages = null;
        availableLanguagesLocalized = null;
    }

    public DefinedDictionary[] getDefinedDictionaries() {
        DefinedDictionary[] definedDictionaryArray = new DefinedDictionary[definedDictionaries.size()];
        definedDictionaries.values().toArray(definedDictionaryArray);
        return definedDictionaryArray;
    }

    public static void setPersonalDictionaryPath(String string) {
        if (!MiscUtil.eq(string, personalDictionaryPath)) {
            personalDictionaryPath = string;
            SpellCheckerFactory.discardSpellChecker();
        }
    }

    public static String getPersonalDictionaryPath() {
        return personalDictionaryPath;
    }

    public static void setIgnoreCase(boolean bl) {
        if (bl != ignoreCase) {
            ignoreCase = bl;
            SpellCheckerFactory.discardSpellChecker();
        }
    }

    public static boolean getIgnoreCase() {
        return ignoreCase;
    }

    public static void setIgnoreMixedCase(boolean bl) {
        if (bl != ignoreMixedCase) {
            ignoreMixedCase = bl;
            SpellCheckerFactory.discardSpellChecker();
        }
    }

    public static boolean getIgnoreMixedCase() {
        return ignoreMixedCase;
    }

    public static void setIgnoreDigits(boolean bl) {
        if (bl != ignoreDigits) {
            ignoreDigits = bl;
            SpellCheckerFactory.discardSpellChecker();
        }
    }

    public static boolean getIgnoreDigits() {
        return ignoreDigits;
    }

    public static void setIgnoreURL(boolean bl) {
        if (bl != ignoreURL) {
            ignoreURL = bl;
            SpellCheckerFactory.discardSpellChecker();
        }
    }

    public static boolean getIgnoreURL() {
        return ignoreURL;
    }

    public static void setIgnoreDuplicates(boolean bl) {
        if (bl != ignoreDuplicates) {
            ignoreDuplicates = bl;
            SpellCheckerFactory.discardSpellChecker();
        }
    }

    public static boolean getIgnoreDuplicates() {
        return ignoreDuplicates;
    }

    public static void setCheckPunctuation(boolean bl) {
        if (bl != checkPunctuation) {
            checkPunctuation = bl;
            SpellCheckerFactory.discardSpellChecker();
        }
    }

    public static boolean getCheckPunctuation() {
        return checkPunctuation;
    }

    public static void setAllowCompound(boolean bl) {
        if (bl != allowCompound) {
            allowCompound = bl;
            SpellCheckerFactory.discardSpellChecker();
        }
    }

    public static boolean getAllowCompound() {
        return allowCompound;
    }

    public static void setAllowPrefixes(boolean bl) {
        if (bl != allowPrefixes) {
            allowPrefixes = bl;
            SpellCheckerFactory.discardSpellChecker();
        }
    }

    public static boolean getAllowPrefixes() {
        return allowPrefixes;
    }

    public static void setAllowFileExtensions(boolean bl) {
        if (bl != allowFileExtensions) {
            allowFileExtensions = bl;
            SpellCheckerFactory.discardSpellChecker();
        }
    }

    public static boolean getAllowFileExtensions() {
        return allowFileExtensions;
    }

    public static void setMaxSuggestionForce(boolean bl) {
        if (bl != maxSuggestionForce) {
            maxSuggestionForce = bl;
            SpellCheckerFactory.discardSpellChecker();
        }
    }

    public static boolean getMaxSuggestionForce() {
        return maxSuggestionForce;
    }

    public static void setSelectedLanguage(String string) {
        if (!MiscUtil.eq(string, selectedLanguage)) {
            selectedLanguage = string;
            SpellCheckerFactory.discardSpellChecker();
        }
    }

    public static String getSelectedLanguage() {
        return selectedLanguage;
    }

    public static SpellChecker getSpellChecker() {
        block3: {
            if (spellChecker != null) break block3;
            String[][] stringArray = new String[2][];
            try {
                spellChecker = SpellCheckerFactory.createSpellChecker(stringArray);
                availableLanguages = stringArray[0];
                availableLanguagesLocalized = stringArray[1];
            }
            catch (IOException iOException) {
            }
            catch (SpellException spellException) {}
        }
        return spellChecker;
    }

    private static SpellChecker createSpellChecker(String[][] stringArray) throws IOException, SpellException {
        String string;
        DictionaryManagerItem[] dictionaryManagerItemArray;
        Object object;
        if (dictionaryManager == null) {
            dictionaryManager = new DictionaryManager();
            if (definedDictionaries.size() > 0) {
                object = definedDictionaries.values().iterator();
                while (object.hasNext()) {
                    dictionaryManagerItemArray = (DictionaryManagerItem[])object.next();
                    dictionaryManager.defineDictionary(dictionaryManagerItemArray.name, dictionaryManagerItemArray.location);
                }
            }
        }
        object = new SpellChecker(dictionaryManager);
        if (personalDictionaryPath != null) {
            object.setPersonalDictionaryPath(personalDictionaryPath);
        }
        object.setIgnoreCase(ignoreCase);
        object.setIgnoreMixedCase(ignoreMixedCase);
        object.setIgnoreDigits(ignoreDigits);
        object.setIgnoreURL(ignoreURL);
        object.setIgnoreDuplicates(ignoreDuplicates);
        object.setCheckPunctuation(checkPunctuation);
        object.setAllowCompound(allowCompound);
        object.setAllowPrefixes(allowPrefixes);
        object.setAllowFileExtensions(allowFileExtensions);
        object.setSuggestionForce(maxSuggestionForce ? 5 : 3);
        dictionaryManagerItemArray = object.listLanguages();
        if (dictionaryManagerItemArray.length == 0) {
            throw new SpellException("no dictionaries");
        }
        String[] stringArray2 = new String[dictionaryManagerItemArray.length];
        String[] stringArray3 = new String[dictionaryManagerItemArray.length];
        int n = 0;
        while (n < dictionaryManagerItemArray.length) {
            DictionaryManagerItem dictionaryManagerItem = dictionaryManagerItemArray[n];
            string = dictionaryManagerItem.name;
            if (string.endsWith("/default")) {
                dictionaryManagerItem.name = string = string.substring(0, string.length() - 8);
            }
            stringArray2[n] = string;
            stringArray3[n] = dictionaryManagerItem.local;
            ++n;
        }
        string = null;
        if (selectedLanguage != null && StringUtil.contains(stringArray2, selectedLanguage)) {
            string = selectedLanguage;
        }
        if (string == null) {
            string = StringUtil.contains(stringArray2, "en") ? "en" : stringArray2[0];
        }
        object.setSelectedLanguage(string);
        if (stringArray != null) {
            stringArray[0] = stringArray2;
            stringArray[1] = stringArray3;
        }
        return object;
    }

    public static String[] getAvailableLanguages(boolean bl) {
        if (bl) {
            return availableLanguagesLocalized;
        }
        return availableLanguages;
    }

    public static final class DefinedDictionary {
        public String name;
        public URL location;

        public DefinedDictionary(String string, URL uRL) {
            this.name = string;
            this.location = uRL;
        }
    }
}

