/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.styledgadget;

import com.xmlmind.xmledit.imagetoolkit.ImageRendererConstants;
import com.xmlmind.xmledit.styledgadget.Box;
import com.xmlmind.xmledit.styledgadget.Icon;
import com.xmlmind.xmledit.styledgadget.Style;
import java.awt.Graphics;
import java.awt.Image;

public abstract class AbstractImageViewport
extends Box
implements ImageRendererConstants {
    public static final int HALIGN_LEFT = 1;
    public static final int HALIGN_CENTER = 2;
    public static final int HALIGN_RIGHT = 4;
    public static final int VALIGN_BOTTOM = 16;
    public static final int VALIGN_MIDDLE = 32;
    public static final int VALIGN_TOP = 64;
    protected static final int HALIGN = 15;
    protected static final int VALIGN = 240;
    protected static final int FLAG_PRESERVE_ASPECT_RATIO = 1;
    protected static final int FLAG_SMOOTH = 2;
    protected static final int FLAG_FALLBACK = 4;
    protected double viewportWidth = 0.0;
    protected double viewportHeight = 0.0;
    protected double contentWidth = 0.0;
    protected double contentHeight = 0.0;
    protected byte viewportWidthType = (byte)-1;
    protected byte viewportHeightType = (byte)-1;
    protected byte contentWidthType = (byte)-1;
    protected byte contentHeightType = (byte)-1;
    protected byte align = (byte)34;
    protected byte flags = 1;
    protected Image renderedImage = null;
    protected double renderedImageWidthSpec = -1.0;
    protected double renderedImageHeightSpec = -1.0;

    protected AbstractImageViewport(Style style) {
        super(style);
    }

    public void setViewportWidth(double d, int n) {
        if (d <= 0.0 || n <= -1 || n > 1) {
            d = 0.0;
            n = -1;
        }
        this.viewportWidth = d;
        this.viewportWidthType = (byte)n;
        this.discardRenderedImage();
    }

    protected void discardRenderedImage() {
        this.renderedImage = null;
        this.renderedImageHeightSpec = -1.0;
        this.renderedImageWidthSpec = -1.0;
    }

    public double getViewportWidth() {
        return this.viewportWidth;
    }

    public int getViewportWidthType() {
        return this.viewportWidthType;
    }

    public void setViewportHeight(double d, int n) {
        if (d <= 0.0 || n <= -1 || n > 1) {
            d = 0.0;
            n = -1;
        }
        this.viewportHeight = d;
        this.viewportHeightType = (byte)n;
        this.discardRenderedImage();
    }

    public double getViewportHeight() {
        return this.viewportHeight;
    }

    public int getViewportHeightType() {
        return this.viewportHeightType;
    }

    public void setContentWidth(double d, int n) {
        if (n == 2) {
            d = 0.0;
        } else if (d <= 0.0 || n <= -1 || n > 3) {
            d = 0.0;
            n = -1;
        }
        this.contentWidth = d;
        this.contentWidthType = (byte)n;
        this.discardRenderedImage();
    }

    public double getContentWidth() {
        return this.contentWidth;
    }

    public int getContentWidthType() {
        return this.contentWidthType;
    }

    public void setContentHeight(double d, int n) {
        if (n == 2) {
            d = 0.0;
        } else if (d <= 0.0 || n <= -1 || n > 3) {
            d = 0.0;
            n = -1;
        }
        this.contentHeight = d;
        this.contentHeightType = (byte)n;
        this.discardRenderedImage();
    }

    public double getContentHeight() {
        return this.contentHeight;
    }

    public int getContentHeightType() {
        return this.contentHeightType;
    }

    public void setHAlign(int n) {
        int n2 = this.align & 0xFFFFFFF0;
        switch (n) {
            case 1: 
            case 4: {
                n2 |= n;
                break;
            }
            default: {
                n2 |= 2;
            }
        }
        this.align = (byte)n2;
    }

    public int getHAlign() {
        return this.align & 0xF;
    }

    public void setVAlign(int n) {
        int n2 = this.align & 0xFFFFFF0F;
        switch (n) {
            case 16: 
            case 64: {
                n2 |= n;
                break;
            }
            default: {
                n2 |= 0x20;
            }
        }
        this.align = (byte)n2;
    }

    public int getVAlign() {
        return this.align & 0xF0;
    }

    public void setPreserveAspectRatio(boolean bl) {
        this.flags = bl ? (byte)(this.flags | 1) : (byte)(this.flags & 0xFFFFFFFE);
        this.discardRenderedImage();
    }

    public boolean isPreserveAspectRatio() {
        return (this.flags & 1) != 0;
    }

    public void setSmooth(boolean bl) {
        this.flags = bl ? (byte)(this.flags | 2) : (byte)(this.flags & 0xFFFFFFFD);
        this.discardRenderedImage();
    }

    public boolean isSmooth() {
        return (this.flags & 2) != 0;
    }

    public Image getImage() {
        return this.renderedImage;
    }

    public boolean isShowingFallbackImage() {
        return (this.flags & 4) != 0;
    }

    protected void markAsFallbackImage(boolean bl) {
        this.flags = bl ? (byte)(this.flags | 4) : (byte)(this.flags & 0xFFFFFFFB);
    }

    protected void layoutContent(int n, int n2, boolean bl) {
        boolean bl2 = this.isInline();
        double d = this.viewportWidthType == 1 ? (n > 0 && !bl2 ? (double)n * this.viewportWidth / 100.0 : 0.0) : this.viewportWidth;
        double d2 = this.viewportHeightType == 1 ? (n2 > 0 && !bl2 ? (double)n2 * this.viewportHeight / 100.0 : 0.0) : this.viewportHeight;
        double d3 = this.contentWidthType == 2 ? d : this.contentWidth;
        double d4 = this.contentHeightType == 2 ? d2 : this.contentHeight;
        if (this.renderedImage != null && (d3 != this.renderedImageWidthSpec || d4 != this.renderedImageHeightSpec)) {
            this.discardRenderedImage();
        }
        if (this.renderedImage == null) {
            try {
                this.renderedImage = this.renderImage(d3, this.contentWidthType, d4, this.contentHeightType, this.isPreserveAspectRatio(), this.isSmooth());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.renderedImage != null) {
            this.markAsFallbackImage(false);
        } else {
            this.renderedImage = this.fallbackImage();
            this.markAsFallbackImage(true);
        }
        this.renderedImageWidthSpec = d3;
        this.renderedImageHeightSpec = d4;
        if (d <= 0.0) {
            d = n > 0 && !bl2 ? (double)n : (double)this.renderedImage.getWidth(null);
        }
        if (d2 <= 0.0) {
            d2 = this.renderedImage.getHeight(null);
        }
        this.width = (int)Math.rint(d);
        if (this.width <= 0) {
            this.width = 1;
        }
        this.height = (int)Math.rint(d2);
        if (this.height <= 0) {
            this.height = 1;
        }
    }

    protected abstract boolean isInline();

    protected abstract Image renderImage(double var1, int var3, double var4, int var6, boolean var7, boolean var8) throws Exception;

    protected Image fallbackImage() {
        return Icon.get("image");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintContent(Graphics graphics) {
        int n;
        int n2;
        int n3 = 2 * this.style.borderWidth + this.style.paddingLeft + this.style.paddingRight;
        int n4 = 2 * this.style.borderWidth + this.style.paddingTop + this.style.paddingBottom;
        int n5 = this.width - n3;
        int n6 = this.height - n4;
        Image image = this.renderedImage == null ? Icon.get("no-image") : this.renderedImage;
        int n7 = image.getWidth(null);
        int n8 = image.getHeight(null);
        switch (this.getHAlign()) {
            case 2: {
                n2 = (n5 - n7) / 2;
                break;
            }
            case 4: {
                n2 = n5 - n7;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        switch (this.getVAlign()) {
            case 32: {
                n = (n6 - n8) / 2;
                break;
            }
            case 16: {
                n = n6 - n8;
                break;
            }
            default: {
                n = 0;
            }
        }
        if (n7 <= n5 && n8 <= n6) {
            try {
                graphics.drawImage(image, n2, n, null);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        } else {
            Graphics graphics2 = graphics.create(0, 0, n5, n6);
            if (graphics2 != null) {
                try {
                    try {
                        graphics2.drawImage(image, n2, n, null);
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        Object var14_14 = null;
                        graphics2.dispose();
                    }
                    Object var14_13 = null;
                    graphics2.dispose();
                }
                catch (Throwable throwable) {
                    Object var14_15 = null;
                    graphics2.dispose();
                    throw throwable;
                }
            }
        }
    }
}

