/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.styledgadget;

import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.styledgadget.Icon;
import com.xmlmind.xmledit.styledgadget.Style;
import com.xmlmind.xmledit.styledgadget.Styleable;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;

public abstract class Box
extends Gadget
implements Styleable {
    public static final Style DEFAULT_STYLE = new Style();
    protected Style style;
    private static final float[] DOT_PATTERN = new float[]{1.0f, 2.0f};
    private static final float[] DASH_PATTERN = new float[]{4.0f, 4.0f};
    private static BasicStroke[] DOTS = new BasicStroke[3];
    private static BasicStroke[] DASHES = new BasicStroke[3];

    protected Box() {
        this(DEFAULT_STYLE);
    }

    protected Box(Style style) {
        this.style = style;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public Style getStyle() {
        return this.style;
    }

    public void layout(int n, int n2, boolean bl) {
        int n3 = 2 * this.style.borderWidth + this.style.paddingLeft + this.style.paddingRight;
        int n4 = 2 * this.style.borderWidth + this.style.paddingTop + this.style.paddingBottom;
        if (n > 0 && (n -= n3) <= 0) {
            n = 1;
        }
        if (n2 > 0 && (n2 -= n4) <= 0) {
            n2 = 1;
        }
        this.layoutContent(n, n2, bl);
        this.width += n3;
        this.height += n4;
    }

    protected abstract void layoutContent(int var1, int var2, boolean var3);

    public void paint(Graphics graphics) {
        Box.drawBox(graphics, this.style, this.width, this.height);
        graphics.translate(this.style.borderWidth + this.style.paddingLeft, this.style.borderWidth + this.style.paddingTop);
        this.paintContent(graphics);
    }

    protected abstract void paintContent(Graphics var1);

    public static void drawBox(Graphics graphics, Style style, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        boolean bl;
        Rectangle rectangle = null;
        if (style.backgroundColor != null) {
            graphics.setColor(style.backgroundColor);
            rectangle = graphics.getClipBounds();
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        if (style.borderStyle == 0 || style.borderWidth <= 0) {
            return;
        }
        boolean bl2 = style.borderTopColor != null;
        boolean bl3 = style.borderRightColor != null;
        boolean bl4 = style.borderBottomColor != null;
        boolean bl5 = bl = style.borderLeftColor != null;
        if (!(bl2 || bl3 || bl4 || bl)) {
            return;
        }
        if (rectangle == null) {
            rectangle = graphics.getClipBounds();
        }
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        Color color = null;
        Color color2 = null;
        Color color3 = null;
        Color color4 = null;
        Color color5 = null;
        Color color6 = null;
        Color color7 = null;
        Color color8 = null;
        switch (style.borderStyle) {
            case 4: {
                n9 = n10 = style.borderWidth / 3;
                n11 = style.borderWidth - 2 * n9;
                if (bl2) {
                    color = color2 = style.borderTopColor;
                }
                if (bl3) {
                    color3 = color4 = style.borderRightColor;
                }
                if (bl4) {
                    color5 = color6 = style.borderBottomColor;
                }
                if (!bl) break;
                color7 = color8 = style.borderLeftColor;
                break;
            }
            case 8: {
                n9 = style.borderWidth;
                if (bl2) {
                    color = style.borderTopColor.brighter();
                }
                if (bl) {
                    color7 = style.borderLeftColor.brighter();
                }
                if (bl3) {
                    color3 = style.borderRightColor.darker();
                }
                if (!bl4) break;
                color5 = style.borderBottomColor.darker();
                break;
            }
            case 7: {
                n9 = style.borderWidth;
                if (bl2) {
                    color = style.borderTopColor.darker();
                }
                if (bl) {
                    color7 = style.borderLeftColor.darker();
                }
                if (bl3) {
                    color3 = style.borderRightColor.brighter();
                }
                if (!bl4) break;
                color5 = style.borderBottomColor.brighter();
                break;
            }
            case 5: {
                n9 = style.borderWidth / 2;
                n10 = 0;
                n11 = style.borderWidth - n9;
                if (bl2) {
                    color = style.borderTopColor.darker();
                    color2 = style.borderTopColor.brighter();
                }
                if (bl) {
                    color7 = style.borderLeftColor.darker();
                    color8 = style.borderLeftColor.brighter();
                }
                if (bl3) {
                    color3 = style.borderRightColor.brighter();
                    color4 = style.borderRightColor.darker();
                }
                if (!bl4) break;
                color5 = style.borderBottomColor.brighter();
                color6 = style.borderBottomColor.darker();
                break;
            }
            case 6: {
                n9 = style.borderWidth / 2;
                n10 = 0;
                n11 = style.borderWidth - n9;
                if (bl2) {
                    color = style.borderTopColor.brighter();
                    color2 = style.borderTopColor.darker();
                }
                if (bl) {
                    color7 = style.borderLeftColor.brighter();
                    color8 = style.borderLeftColor.darker();
                }
                if (bl3) {
                    color3 = style.borderRightColor.darker();
                    color4 = style.borderRightColor.brighter();
                }
                if (!bl4) break;
                color5 = style.borderBottomColor.darker();
                color6 = style.borderBottomColor.brighter();
                break;
            }
            default: {
                n9 = style.borderWidth;
                if (bl2) {
                    color = style.borderTopColor;
                }
                if (bl3) {
                    color3 = style.borderRightColor;
                }
                if (bl4) {
                    color5 = style.borderBottomColor;
                }
                if (bl) {
                    color7 = style.borderLeftColor;
                }
                switch (style.borderStyle) {
                    case 1: {
                        ((Graphics2D)graphics).setStroke(Box.getDotStroke(n9));
                        Box.drawNonSolidBox(graphics, style, n, n2, rectangle, bl2, bl3, bl4, bl, color, color3, color5, color7);
                        return;
                    }
                    case 2: {
                        ((Graphics2D)graphics).setStroke(Box.getDashStroke(n9));
                        Box.drawNonSolidBox(graphics, style, n, n2, rectangle, bl2, bl3, bl4, bl, color, color3, color5, color7);
                        return;
                    }
                }
            }
        }
        int n12 = rectangle.y;
        int n13 = n12 + rectangle.height - 1;
        if (bl2 && n12 < style.borderWidth) {
            n8 = 0;
            n7 = 0;
            n6 = 0;
            n5 = n - 1;
            graphics.setColor(color);
            n4 = 0;
            while (n4 < n9) {
                graphics.drawLine(n8, n7, n5, n6);
                if (bl) {
                    ++n8;
                }
                ++n7;
                if (bl3) {
                    --n5;
                }
                n6 = n7;
                ++n4;
            }
            if (n11 > 0) {
                if (bl) {
                    n8 += n10;
                }
                n7 += n10;
                if (bl3) {
                    n5 -= n10;
                }
                n6 = n7;
                graphics.setColor(color2);
                n3 = 0;
                while (n3 < n11) {
                    graphics.drawLine(n8, n7, n5, n6);
                    if (bl) {
                        ++n8;
                    }
                    ++n7;
                    if (bl3) {
                        --n5;
                    }
                    n6 = n7;
                    ++n3;
                }
            }
        }
        if (bl3 && rectangle.x + rectangle.width > n - style.borderWidth) {
            n5 = n8 = n - 1;
            n7 = 0;
            n6 = n2 - 1;
            graphics.setColor(color3);
            n4 = 0;
            while (n4 < n9) {
                graphics.drawLine(n8, n7 < n12 ? n12 : n7, n5, n6 > n13 ? n13 : n6);
                --n8;
                if (bl2) {
                    ++n7;
                }
                n5 = n8;
                if (bl4) {
                    --n6;
                }
                ++n4;
            }
            if (n11 > 0) {
                n8 -= n10;
                if (bl2) {
                    n7 += n10;
                }
                n5 = n8;
                if (bl4) {
                    n6 -= n10;
                }
                graphics.setColor(color4);
                n3 = 0;
                while (n3 < n11) {
                    graphics.drawLine(n8, n7 < n12 ? n12 : n7, n5, n6 > n13 ? n13 : n6);
                    --n8;
                    if (bl2) {
                        ++n7;
                    }
                    n5 = n8;
                    if (bl4) {
                        --n6;
                    }
                    ++n3;
                }
            }
        }
        if (bl4 && n12 + rectangle.height > n2 - style.borderWidth) {
            n8 = 0;
            n6 = n7 = n2 - 1;
            n5 = n - 1;
            graphics.setColor(color5);
            n4 = 0;
            while (n4 < n9) {
                graphics.drawLine(n8, n7, n5, n6);
                if (bl) {
                    ++n8;
                }
                --n7;
                if (bl3) {
                    --n5;
                }
                n6 = n7;
                ++n4;
            }
            if (n11 > 0) {
                if (bl) {
                    n8 += n10;
                }
                n7 -= n10;
                if (bl3) {
                    n5 -= n10;
                }
                n6 = n7;
                graphics.setColor(color6);
                n3 = 0;
                while (n3 < n11) {
                    graphics.drawLine(n8, n7, n5, n6);
                    if (bl) {
                        ++n8;
                    }
                    --n7;
                    if (bl3) {
                        --n5;
                    }
                    n6 = n7;
                    ++n3;
                }
            }
        }
        if (bl && rectangle.x < style.borderWidth) {
            n8 = 0;
            n5 = 0;
            n7 = 0;
            n6 = n2 - 1;
            graphics.setColor(color7);
            n4 = 0;
            while (n4 < n9) {
                graphics.drawLine(n8, n7 < n12 ? n12 : n7, n5, n6 > n13 ? n13 : n6);
                ++n8;
                if (bl2) {
                    ++n7;
                }
                n5 = n8;
                if (bl4) {
                    --n6;
                }
                ++n4;
            }
            if (n11 > 0) {
                n8 += n10;
                if (bl2) {
                    n7 += n10;
                }
                n5 = n8;
                if (bl4) {
                    n6 -= n10;
                }
                graphics.setColor(color8);
                n3 = 0;
                while (n3 < n11) {
                    graphics.drawLine(n8, n7 < n12 ? n12 : n7, n5, n6 > n13 ? n13 : n6);
                    ++n8;
                    if (bl2) {
                        ++n7;
                    }
                    n5 = n8;
                    if (bl4) {
                        --n6;
                    }
                    ++n3;
                }
            }
        }
    }

    private static final void drawNonSolidBox(Graphics graphics, Style style, int n, int n2, Rectangle rectangle, boolean bl, boolean bl2, boolean bl3, boolean bl4, Color color, Color color2, Color color3, Color color4) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = rectangle.y;
        int n8 = n7 + rectangle.height - 1;
        if (bl && n7 < style.borderWidth) {
            n6 = 0;
            n5 = 0;
            n4 = 0;
            n3 = n - 1;
            graphics.setColor(color);
            graphics.drawLine(n6, n5, n3, n4);
        }
        if (bl2 && rectangle.x + rectangle.width > n - style.borderWidth) {
            n3 = n6 = n - 1;
            n5 = 0;
            n4 = n2 - 1;
            graphics.setColor(color2);
            graphics.drawLine(n6, n5 < n7 ? n7 : n5, n3, n4 > n8 ? n8 : n4);
        }
        if (bl3 && n7 + rectangle.height > n2 - style.borderWidth) {
            n6 = 0;
            n4 = n5 = n2 - 1;
            n3 = n - 1;
            graphics.setColor(color3);
            graphics.drawLine(n6, n5, n3, n4);
        }
        if (bl4 && rectangle.x < style.borderWidth) {
            n6 = 0;
            n3 = 0;
            n5 = 0;
            n4 = n2 - 1;
            graphics.setColor(color4);
            graphics.drawLine(n6, n5 < n7 ? n7 : n5, n3, n4 > n8 ? n8 : n4);
        }
    }

    public static void getContentSizeConstraints(Gadget gadget, Style style, Dimension dimension) {
        if (gadget.parent == null) {
            dimension.height = -1;
            dimension.width = -1;
            return;
        }
        gadget.parent.getSizeConstraints(gadget, dimension);
        if (dimension.width > 0) {
            dimension.width -= 2 * style.borderWidth + style.paddingLeft + style.paddingRight;
            if (dimension.width <= 0) {
                dimension.width = 1;
            }
        }
        if (dimension.height > 0) {
            dimension.height -= 2 * style.borderWidth + style.paddingTop + style.paddingBottom;
            if (dimension.height <= 0) {
                dimension.height = 1;
            }
        }
    }

    public static void drawEmptyContent(Graphics graphics, Style style, int n, int n2) {
        Box.drawPattern(graphics, style, 40, n, n2);
    }

    private static void drawPattern(Graphics graphics, Style style, int n, int n2, int n3) {
        Icon.Info info = Icon.list[n];
        Image image = Icon.get(info.icon, style.color, null);
        int n4 = info.width;
        int n5 = info.height;
        int n6 = 0;
        while (n6 < n3) {
            int n7 = Math.min(n5, n3 - n6);
            int n8 = 0;
            while (n8 < n2) {
                int n9 = Math.min(n4, n2 - n8);
                graphics.drawImage(image, n8, n6, n8 + n9, n6 + n7, 0, 0, n9, n7, null);
                n8 += n4;
            }
            n6 += n5;
        }
    }

    public static void drawEmptyTextContent(Graphics graphics, Style style, int n, int n2) {
        Box.drawPattern(graphics, style, 41, n, n2);
    }

    public static void drawEmptyTextContent2(Graphics graphics, Style style, int n, int n2) {
        FontMetrics fontMetrics = graphics.getFontMetrics(style.font);
        int n3 = fontMetrics.getAscent();
        int n4 = fontMetrics.getDescent();
        int n5 = (int)(0.5 + (double)fontMetrics.getHeight() * style.lineHeight);
        int n6 = (n5 + n3 - n4) / 2;
        graphics.setColor(style.color);
        int n7 = 0;
        int n8 = n6;
        int n9 = 0;
        int n10 = n6 + n4 - 1;
        graphics.drawLine(n7, n8, n9, n10);
        n7 = n - 1;
        n8 = n10;
        graphics.drawLine(n9, n10, n7, n8);
        n9 = n7;
        n10 = n6;
        graphics.drawLine(n7, n8, n9, n10);
    }

    public static Dimension getEmptyContentSize(Gadget gadget, Style style) {
        Dimension dimension = new Dimension();
        Box.getEmptyContentSize(gadget, style, dimension);
        return dimension;
    }

    public static void getEmptyContentSize(Gadget gadget, Style style, Dimension dimension) {
        FontMetrics fontMetrics = gadget.getFontMetrics(style.font);
        dimension.width = fontMetrics.charWidth('M');
        dimension.height = (int)(0.5 + (double)fontMetrics.getHeight() * style.lineHeight);
        if (dimension.width < 4) {
            dimension.width = 4;
        }
        if (dimension.height < 4) {
            dimension.height = 4;
        }
    }

    private static final BasicStroke getDotStroke(int n) {
        if (n <= DOTS.length) {
            return DOTS[n - 1];
        }
        return new BasicStroke(n, 0, 0, 10.0f, DOT_PATTERN, 0.0f);
    }

    private static final BasicStroke getDashStroke(int n) {
        if (n <= DASHES.length) {
            return DASHES[n - 1];
        }
        return new BasicStroke(n, 0, 0, 10.0f, DASH_PATTERN, 0.0f);
    }

    static {
        int n = 0;
        while (n < DOTS.length) {
            float f = n + 1;
            Box.DOTS[n] = new BasicStroke(f, 0, 0, 10.0f, DOT_PATTERN, 0.0f);
            Box.DASHES[n] = new BasicStroke(f, 0, 0, 10.0f, DASH_PATTERN, 0.0f);
            ++n;
        }
    }
}

