/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.styledgadget;

import com.xmlmind.xmledit.gadget.PaintUtil;
import com.xmlmind.xmledit.styledgadget.Box;
import com.xmlmind.xmledit.styledgadget.Style;
import com.xmlmind.xmledit.styledgadget.StyledGadgetUtil;
import com.xmlmind.xmledit.styledgadget.TextLabel;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;

public class ButtonBase
extends TextLabel {
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int TOP = 2;
    public static final int BOTTOM = 3;
    protected Image icon = null;
    protected byte state = 0;
    private static final int GAP_MASK = 15;
    private static final int POSITION_MASK = 48;
    private static final int PRESSED_MASK = 64;
    private static final int DISABLED_MASK = 128;
    private static final int PADDING = 1;

    public ButtonBase() {
        this(Box.DEFAULT_STYLE);
    }

    public ButtonBase(Style style) {
        super(style, "");
        this.setIconGap(4);
        this.setIconPosition(0);
    }

    public void setIcon(Image image) {
        this.icon = image;
    }

    public Image getIcon() {
        return this.icon;
    }

    public boolean hasIcon() {
        return this.icon != null;
    }

    public boolean hasText() {
        return this.textChars.length > 0;
    }

    public void setIconGap(int n) {
        if (n < 0) {
            n = 0;
        } else if (n > 15) {
            n = 15;
        }
        this.state = (byte)(this.state & 0xFFFFFFF0 | n);
    }

    public int getIconGap() {
        return this.state & 0xF;
    }

    public void setIconPosition(int n) {
        if (n < 0 || n > 3) {
            n = 0;
        }
        this.state = (byte)(this.state & 0xFFFFFFCF | n << 4);
    }

    public int getIconPosition() {
        return (this.state & 0x30) >>> 4;
    }

    public void setEnabled(boolean bl) {
        this.state = bl ? (byte)(this.state & 0xFFFFFF7F) : (byte)(this.state | 0x80);
    }

    public boolean isEnabled() {
        return (this.state & 0x80) == 0;
    }

    public void setPressed(boolean bl) {
        this.state = bl ? (byte)(this.state | 0x40) : (byte)(this.state & 0xFFFFFFBF);
    }

    public boolean isPressed() {
        return (this.state & 0x40) != 0;
    }

    protected void layoutContent(int n, int n2, boolean bl) {
        boolean bl2;
        boolean bl3 = this.textChars.length > 0;
        boolean bl4 = bl2 = this.icon != null;
        if (bl3) {
            FontMetrics fontMetrics = this.getFontMetrics(this.style.font);
            this.doLayoutContent(fontMetrics);
            if (bl2) {
                switch (this.getIconPosition()) {
                    case 0: 
                    case 1: {
                        this.width += this.getIconGap() + this.icon.getWidth(null);
                        int n3 = (int)(0.5 + (double)fontMetrics.getHeight() * this.style.lineHeight);
                        int n4 = n3 / 2;
                        int n5 = this.height - n4;
                        int n6 = this.icon.getHeight(null) / 2;
                        this.height = Math.max(n6, n4) + Math.max(n6, n5);
                        break;
                    }
                    default: {
                        this.width = Math.max(this.width, this.icon.getWidth(null));
                        this.height += this.getIconGap() + this.icon.getHeight(null);
                        break;
                    }
                }
            }
        } else if (bl2) {
            this.width = this.icon.getWidth(null);
            this.height = this.icon.getHeight(null);
        } else {
            this.height = 1;
            this.width = 1;
        }
        this.width += 2;
        this.height += 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintContent(Graphics graphics) {
        int n;
        int n2;
        int n3;
        PaintUtil.configureTextRendering(graphics);
        graphics.translate(1, 1);
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        boolean bl = this.textChars.length > 0;
        boolean bl2 = this.icon != null;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        if (bl && bl2) {
            n3 = 2 * this.style.borderWidth + this.style.paddingLeft + this.style.paddingRight;
            n2 = 2 * this.style.borderWidth + this.style.paddingTop + this.style.paddingBottom;
            int n12 = this.width - 2 - n3;
            n = this.height - 2 - n2;
            n8 = this.icon.getWidth(null);
            n9 = this.icon.getHeight(null);
            n10 = this.getIconGap();
            n11 = this.getIconPosition();
            FontMetrics fontMetrics = graphics.getFontMetrics(this.style.font);
            switch (n11) {
                case 0: 
                case 1: {
                    if (n11 == 0) {
                        n6 = n8 + n10;
                    } else {
                        n4 = n12 - n8;
                    }
                    int n13 = (int)(0.5 + (double)fontMetrics.getHeight() * this.style.lineHeight);
                    int n14 = n13 / 2;
                    int n15 = n9 / 2;
                    if (n15 > n14) {
                        n7 = n15 - n14;
                        break;
                    }
                    n5 = n14 - n15;
                    break;
                }
                default: {
                    if (n8 < n12) {
                        n4 = (n12 - n8) / 2;
                    } else {
                        int n16 = 0;
                        int n17 = this.width;
                        int n18 = this.height;
                        try {
                            this.doLayoutContent(fontMetrics);
                            n16 = this.width;
                            Object var21_25 = null;
                            this.width = n17;
                            this.height = n18;
                        }
                        catch (Throwable throwable) {
                            Object var21_26 = null;
                            this.width = n17;
                            this.height = n18;
                            throw throwable;
                        }
                        n6 = (n12 - n16) / 2;
                    }
                    if (n11 == 2) {
                        n7 = n9 + n10;
                        break;
                    }
                    n5 = n - n9;
                }
            }
        }
        n3 = this.isPressed();
        n2 = !this.isEnabled() ? 1 : 0;
        Color color = n3 != 0 || n2 != 0 ? StyledGadgetUtil.getDimmedColor(this.style) : null;
        if (bl2) {
            if (n3 != 0) {
                StyledGadgetUtil.drawDimmedIcon(graphics, this.icon, n4, n5, color);
                ++n4;
                ++n5;
            }
            if (n2 != 0) {
                StyledGadgetUtil.drawDimmedIcon(graphics, this.icon, n4, n5, color);
            } else {
                graphics.drawImage(this.icon, n4, n5, null);
            }
        }
        if (bl) {
            graphics.setFont(this.style.font);
            n = 2 * this.style.borderWidth + this.style.paddingLeft + this.style.paddingRight;
            int n19 = this.width - 2 - n;
            if (bl2) {
                switch (n11) {
                    case 0: 
                    case 1: {
                        n19 -= n8 + n10;
                        break;
                    }
                    default: {
                        n19 -= 2 * n6;
                    }
                }
            }
            if (n3 != 0) {
                graphics.translate(n6, n7);
                graphics.setColor(color);
                this.doPaintContent(graphics, n19);
                n6 = 1;
                n7 = 1;
            }
            graphics.translate(n6, n7);
            graphics.setColor(n2 != 0 ? color : this.style.color);
            this.doPaintContent(graphics, n19);
        }
    }

    public int getFirstBaseLine() {
        boolean bl;
        boolean bl2 = this.textChars.length > 0;
        boolean bl3 = bl = this.icon != null;
        if (bl2) {
            int n = super.getFirstBaseLine();
            if (bl) {
                n += this.getTextOffset();
            }
            return n + 1;
        }
        return -1;
    }

    public int getLastBaseLine() {
        boolean bl;
        boolean bl2 = this.textChars.length > 0;
        boolean bl3 = bl = this.icon != null;
        if (bl2) {
            int n = super.getLastBaseLine();
            if (bl) {
                n += this.getTextOffset();
            }
            return n + 1;
        }
        return -1;
    }

    private int getTextOffset() {
        switch (this.getIconPosition()) {
            case 0: 
            case 1: {
                FontMetrics fontMetrics = this.getFontMetrics(this.style.font);
                int n = (int)(0.5 + (double)fontMetrics.getHeight() * this.style.lineHeight);
                int n2 = n / 2;
                int n3 = this.icon.getHeight(null) / 2;
                if (n3 > n2) {
                    return n3 - n2;
                }
                return 0;
            }
            case 2: {
                return this.icon.getHeight(null) + this.getIconGap();
            }
        }
        return 0;
    }

    public boolean grabsMouseButton(MouseEvent mouseEvent) {
        return this.isEnabled() && mouseEvent.getModifiers() == 16;
    }

    public void handleMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getModifiers() == 16) {
            int n = mouseEvent.getID();
            if (n == 501) {
                this.setPressed(true);
                this.repaint();
            } else if (n == 502) {
                this.setPressed(false);
                this.repaint();
                int n2 = mouseEvent.getX();
                int n3 = mouseEvent.getY();
                if (n2 >= 0 && n2 < this.width && n3 >= 0 && n3 < this.height) {
                    this.doAction();
                }
            }
        }
    }

    protected void doAction() {
        System.err.println(">>> " + this + " clicked");
    }
}

