/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.styledgadget;

import com.xmlmind.xmledit.gadget.CollapsibleGadget;
import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.styledgadget.Box;
import com.xmlmind.xmledit.styledgadget.Division;
import com.xmlmind.xmledit.styledgadget.Icon;
import com.xmlmind.xmledit.styledgadget.Style;
import com.xmlmind.xmledit.styledgadget.Styled;
import com.xmlmind.xmledit.styledgadget.TextLines;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;

public class CollapsibleDivision
extends Division
implements CollapsibleGadget {
    private boolean collapsed;
    private byte notCollapsibleHead;
    private byte notCollapsibleFoot;
    private byte collapsedImageAlign;
    private Image collapsedImage = Icon.get("expand-down");
    private int collapsedImageX;
    private int collapsedImageY;
    private static final int OUT_OF_SIGHT = -1000000;

    public CollapsibleDivision() {
        this(Box.DEFAULT_STYLE);
    }

    public CollapsibleDivision(Style style) {
        super(style);
        this.collapsedImageAlign = (byte)-1;
    }

    public void setNotCollapsibleHead(int n) {
        if (n < 0) {
            n = 0;
        } else if (n > 127) {
            n = 127;
        }
        this.notCollapsibleHead = (byte)n;
    }

    public int getNotCollapsibleHead() {
        return this.notCollapsibleHead;
    }

    public void setNotCollapsibleFoot(int n) {
        if (n < 0) {
            n = 0;
        } else if (n > 127) {
            n = 127;
        }
        this.notCollapsibleFoot = (byte)n;
    }

    public int getNotCollapsibleFoot() {
        return this.notCollapsibleFoot;
    }

    public void setCollapsedImage(Image image) {
        this.collapsedImage = image;
    }

    public Image getCollapsedImage() {
        return this.collapsedImage;
    }

    public void setCollapsedImageAlign(int n) {
        this.collapsedImageAlign = (byte)n;
    }

    public int getCollapsedImageAlign() {
        return this.collapsedImageAlign;
    }

    public void setCollapsed(boolean bl) {
        this.collapsed = bl;
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    public boolean isCollapsible() {
        return this.notCollapsibleHead + this.notCollapsibleFoot < this.children.length;
    }

    protected void layoutContent(int n, int n2, boolean bl) {
        int n3;
        Object object;
        Object object2;
        boolean bl2 = true;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        this.width = 0;
        int n7 = 0;
        while (n7 < this.children.length) {
            object2 = this.children[n7];
            object = ((Styled)object2).getStyle();
            if (bl) {
                if (n > 0) {
                    n3 = n;
                    if (((Style)object).marginLeft > 0) {
                        n3 -= ((Style)object).marginLeft;
                    }
                    if (((Style)object).marginRight > 0) {
                        n3 -= ((Style)object).marginRight;
                    }
                } else {
                    n3 = -1;
                }
                ((Gadget)object2).layout(n3, -1, true);
            }
            if (this.collapsed && n7 >= this.notCollapsibleHead && n7 < this.children.length - this.notCollapsibleFoot) {
                ((Gadget)object2).y = -1000000;
                if (bl2) {
                    bl2 = false;
                    if (this.collapsedImage != null) {
                        n3 = n4 = this.collapsedImage.getWidth(null);
                        if (this.collapsedImageAlign < 0) {
                            if (((Style)object).marginLeft > 0) {
                                n3 += ((Style)object).marginLeft;
                            }
                            if (((Style)object).marginRight > 0) {
                                n3 += ((Style)object).marginRight;
                            }
                        }
                        if (n3 > this.width) {
                            this.width = n3;
                        }
                        this.collapsedImageY = n5 + (n6 > ((Style)object).marginTop ? n6 : ((Style)object).marginTop);
                        n5 = this.collapsedImageY + this.collapsedImage.getHeight(null);
                        n6 = ((Style)object).marginBottom;
                    }
                }
            } else {
                n3 = ((Gadget)object2).width;
                if (((Style)object).marginLeft > 0) {
                    n3 += ((Style)object).marginLeft;
                }
                if (((Style)object).marginRight > 0) {
                    n3 += ((Style)object).marginRight;
                }
                if (n3 > this.width) {
                    this.width = n3;
                }
                ((Gadget)object2).y = n5 + (n6 > ((Style)object).marginTop ? n6 : ((Style)object).marginTop);
                n5 = ((Gadget)object2).y + ((Gadget)object2).height;
                n6 = ((Style)object).marginBottom;
            }
            ++n7;
        }
        if (n > 0 && this.width < n) {
            this.width = n;
        }
        this.height = n5 + n6;
        if (this.width < 1) {
            this.width = 1;
        }
        if (this.height < 1) {
            this.height = 1;
        }
        if (this.children.length > 0) {
            Object object3;
            bl2 = true;
            object2 = null;
            object = null;
            n3 = 0;
            while (n3 < this.children.length) {
                object3 = this.children[n3];
                Style style = ((Styled)object3).getStyle();
                if (this.collapsed && n3 >= this.notCollapsibleHead && n3 < this.children.length - this.notCollapsibleFoot) {
                    ((Gadget)object3).x = -1000000;
                    if (bl2) {
                        bl2 = false;
                        if (this.collapsedImage != null) {
                            switch (this.collapsedImageAlign) {
                                case 0: {
                                    this.collapsedImageX = 0;
                                    break;
                                }
                                case 1: {
                                    this.collapsedImageX = this.width - n4;
                                    break;
                                }
                                case 2: {
                                    this.collapsedImageX = (this.width - n4) / 2;
                                    break;
                                }
                                default: {
                                    if (style.marginLeft >= 0) {
                                        this.collapsedImageX = style.marginLeft;
                                        break;
                                    }
                                    if (style.marginRight >= 0) {
                                        this.collapsedImageX = this.width - style.marginRight - n4;
                                        break;
                                    }
                                    this.collapsedImageX = (this.width - n4) / 2;
                                    break;
                                }
                            }
                        }
                    }
                } else {
                    if (object2 == null) {
                        object2 = object3;
                    }
                    object = object3;
                    ((Gadget)object3).x = style.marginLeft >= 0 ? style.marginLeft : (style.marginRight >= 0 ? this.width - style.marginRight - ((Gadget)object3).width : (this.width - ((Gadget)object3).width) / 2);
                }
                ++n3;
            }
            this.firstBaseLine = -1;
            this.lastBaseLine = -1;
            object3 = object2;
            if (object3 != null && object3 instanceof TextLines) {
                this.firstBaseLine = ((TextLines)object3).getFirstBaseLine();
                if (this.firstBaseLine >= 0) {
                    this.firstBaseLine += ((Gadget)object3).y;
                }
            }
            if ((object3 = object) != null && object3 instanceof TextLines) {
                this.lastBaseLine = ((TextLines)object3).getLastBaseLine();
                if (this.lastBaseLine >= 0) {
                    this.lastBaseLine += ((Gadget)object3).y;
                }
            }
        }
    }

    public void paintRelayout(Gadget gadget, int n, int n2, int n3, int n4) {
        if (!this.collapsed || !this.isCollapsible()) {
            super.paintRelayout(gadget, n, n2, n3, n4);
        } else {
            this.doPaintRelayout(gadget, n, n2, n3, n4);
        }
    }

    protected void paintContent(Graphics graphics) {
        super.paintContent(graphics);
        this.drawCollapsedImage(graphics);
    }

    protected void printContent(Graphics graphics) {
        super.printContent(graphics);
        this.drawCollapsedImage(graphics);
    }

    private void drawCollapsedImage(Graphics graphics) {
        if (this.collapsed && this.isCollapsible() && this.collapsedImage != null) {
            graphics.drawImage(this.collapsedImage, this.collapsedImageX, this.collapsedImageY, null);
        }
    }

    public boolean grabsMouseButton(MouseEvent mouseEvent) {
        if (mouseEvent.getModifiers() != 16) {
            return false;
        }
        if (!this.collapsed || !this.isCollapsible() || this.collapsedImage == null) {
            return false;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = this.collapsedImage.getWidth(null);
        int n4 = this.collapsedImage.getHeight(null);
        int n5 = this.collapsedImageX;
        int n6 = this.collapsedImageY;
        return n >= n5 && n < n5 + n3 && n2 >= n6 && n2 < n6 + n4;
    }

    public void handleMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getModifiers() == 16 && mouseEvent.getID() == 500) {
            this.collapsed = false;
            this.refresh();
        }
    }
}

