/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.styledgadget;

import com.xmlmind.xmledit.gadget.ComponentWrapper;
import com.xmlmind.xmledit.styledgadget.Box;
import com.xmlmind.xmledit.styledgadget.Style;
import com.xmlmind.xmledit.styledgadget.Styleable;
import com.xmlmind.xmledit.styledgadget.TextLines;
import java.awt.Component;
import java.awt.Graphics;

public class ComponentBox
extends ComponentWrapper
implements Styleable,
TextLines {
    public static final Style DEFAULT_STYLE = new Style();
    protected Style style;

    public ComponentBox(Component component) {
        this(Box.DEFAULT_STYLE, component);
    }

    public ComponentBox(Style style, Component component) {
        this.style = style;
        this.initialize(component);
        this.relayout();
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public Style getStyle() {
        return this.style;
    }

    public void refresh() {
        int n = this.width;
        int n2 = this.height;
        int n3 = this.getFirstBaseLine();
        int n4 = this.getLastBaseLine();
        this.relayout(true);
        if (this.width == n && this.height == n2 && this.getFirstBaseLine() == n3 && this.getLastBaseLine() == n4) {
            this.repaint(0, 0, this.width, this.height);
        } else if (this.parent != null) {
            this.parent.paintRelayout(this, n, n2, 0, -1);
        }
    }

    public int getFirstBaseLine() {
        if (this.component instanceof TextLines) {
            int n = ((TextLines)((Object)this.component)).getFirstBaseLine();
            return n < 0 ? -1 : this.style.borderWidth + this.style.paddingTop + n;
        }
        return -1;
    }

    public int getLastBaseLine() {
        if (this.component instanceof TextLines) {
            int n = ((TextLines)((Object)this.component)).getLastBaseLine();
            return n < 0 ? -1 : this.style.borderWidth + this.style.paddingTop + n;
        }
        return -1;
    }

    protected int getTopMargin() {
        return this.style.borderWidth + this.style.paddingTop;
    }

    protected int getRightMargin() {
        return this.style.borderWidth + this.style.paddingRight;
    }

    protected int getBottomMargin() {
        return this.style.borderWidth + this.style.paddingBottom;
    }

    protected int getLeftMargin() {
        return this.style.borderWidth + this.style.paddingLeft;
    }

    protected void paintBackground(Graphics graphics) {
        Box.drawBox(graphics, this.style, this.width, this.height);
    }
}

