/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.styledgadget;

import com.xmlmind.xmledit.gadget.ComponentImage;
import com.xmlmind.xmledit.styledgadget.Box;
import com.xmlmind.xmledit.styledgadget.ComponentImageBoxRenderer;
import com.xmlmind.xmledit.styledgadget.Style;
import com.xmlmind.xmledit.styledgadget.Styleable;
import com.xmlmind.xmledit.styledgadget.TextLines;
import java.awt.Graphics;

public abstract class ComponentImageBox
extends ComponentImage
implements Styleable,
TextLines {
    public static final Style DEFAULT_STYLE = new Style();
    protected Style style;

    public ComponentImageBox(ComponentImageBoxRenderer componentImageBoxRenderer) {
        this(Box.DEFAULT_STYLE, componentImageBoxRenderer);
    }

    public ComponentImageBox(Style style, ComponentImageBoxRenderer componentImageBoxRenderer) {
        this.initialize(style, componentImageBoxRenderer);
        this.relayout();
    }

    protected ComponentImageBox() {
    }

    protected void initialize(Style style, ComponentImageBoxRenderer componentImageBoxRenderer) {
        this.style = style;
        super.initialize(componentImageBoxRenderer);
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public Style getStyle() {
        return this.style;
    }

    public void refresh() {
        int n = this.width;
        int n2 = this.height;
        int n3 = this.getFirstBaseLine();
        int n4 = this.getLastBaseLine();
        this.relayout(true);
        if (this.width == n && this.height == n2 && this.getFirstBaseLine() == n3 && this.getLastBaseLine() == n4) {
            this.repaint(0, 0, this.width, this.height);
        } else if (this.parent != null) {
            this.parent.paintRelayout(this, n, n2, 0, -1);
        }
    }

    public int getFirstBaseLine() {
        return ((ComponentImageBoxRenderer)this.renderer).getFirstBaseLine(this);
    }

    public int getLastBaseLine() {
        return ((ComponentImageBoxRenderer)this.renderer).getLastBaseLine(this);
    }

    protected int getTopMargin() {
        return this.style.borderWidth + this.style.paddingTop;
    }

    protected int getRightMargin() {
        return this.style.borderWidth + this.style.paddingRight;
    }

    protected int getBottomMargin() {
        return this.style.borderWidth + this.style.paddingBottom;
    }

    protected int getLeftMargin() {
        return this.style.borderWidth + this.style.paddingLeft;
    }

    protected void paintBackground(Graphics graphics) {
        Box.drawBox(graphics, this.style, this.width, this.height);
    }
}

