/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.styledgadget;

import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.gadget.GadgetContainer;
import com.xmlmind.xmledit.styledgadget.Box;
import com.xmlmind.xmledit.styledgadget.Style;
import com.xmlmind.xmledit.styledgadget.Styleable;
import java.awt.Dimension;
import java.awt.Graphics;

public abstract class ContainerBox
extends GadgetContainer
implements Styleable {
    protected Style style;

    protected ContainerBox() {
        this(Box.DEFAULT_STYLE);
    }

    protected ContainerBox(Style style) {
        this.style = style;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public Style getStyle() {
        return this.style;
    }

    public void layout(int n, int n2, boolean bl) {
        int n3 = this.style.borderWidth + this.style.paddingLeft;
        int n4 = this.style.borderWidth + this.style.paddingTop;
        int n5 = n3 + this.style.borderWidth + this.style.paddingRight;
        int n6 = n4 + this.style.borderWidth + this.style.paddingBottom;
        if (n > 0 && (n -= n5) <= 0) {
            n = 1;
        }
        if (n2 > 0 && (n2 -= n6) <= 0) {
            n2 = 1;
        }
        if (this.children.length == 0) {
            this.layoutEmptyContent(n, n2);
        } else {
            this.layoutContent(n, n2, bl);
            int n7 = 0;
            while (n7 < this.children.length) {
                Gadget gadget = this.children[n7];
                gadget.x += n3;
                gadget.y += n4;
                ++n7;
            }
        }
        this.width += n5;
        this.height += n6;
    }

    protected void layoutEmptyContent(int n, int n2) {
        Dimension dimension = Box.getEmptyContentSize(this, this.style);
        this.width = dimension.width;
        this.height = dimension.height;
        if (n > 0 && this.width < n) {
            this.width = n;
        }
    }

    protected abstract void layoutContent(int var1, int var2, boolean var3);

    public void paint(Graphics graphics) {
        Box.drawBox(graphics, this.style, this.width, this.height);
        if (this.children.length == 0) {
            this.paintEmptyContent(graphics);
        } else {
            this.paintContent(graphics);
        }
    }

    protected void paintEmptyContent(Graphics graphics) {
        int n = this.style.borderWidth + this.style.paddingLeft;
        int n2 = this.style.borderWidth + this.style.paddingTop;
        int n3 = this.width - (n + this.style.borderWidth + this.style.paddingRight);
        int n4 = this.height - (n2 + this.style.borderWidth + this.style.paddingBottom);
        graphics.translate(n, n2);
        Box.drawEmptyContent(graphics, this.style, n3, n4);
    }

    protected void paintContent(Graphics graphics) {
        super.paint(graphics);
    }

    public void print(Graphics graphics) {
        Box.drawBox(graphics, this.style, this.width, this.height);
        if (this.children.length == 0) {
            this.printEmptyContent(graphics);
        } else {
            this.printContent(graphics);
        }
    }

    protected void printEmptyContent(Graphics graphics) {
        this.paintEmptyContent(graphics);
    }

    protected void printContent(Graphics graphics) {
        super.print(graphics);
    }
}

