/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.styledgadget;

import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.gadget.GadgetContainer;
import com.xmlmind.xmledit.styledgadget.Box;
import com.xmlmind.xmledit.styledgadget.Style;
import com.xmlmind.xmledit.styledgadget.Styleable;
import com.xmlmind.xmledit.styledgadget.Styled;
import com.xmlmind.xmledit.styledgadget.TextLines;
import java.awt.Dimension;
import java.awt.Graphics;

public class LabeledItem
extends GadgetContainer
implements Styleable,
TextLines {
    public static final int FILL = Integer.MAX_VALUE;
    protected Style style;
    protected int startLabelOffset = -1;
    protected int endLabelOffset = -1;

    public LabeledItem() {
        this(Box.DEFAULT_STYLE);
    }

    public LabeledItem(Style style) {
        this.style = style;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStartLabel(Gadget gadget, int n) {
        if (this.startLabelOffset >= 0) {
            this.removeChild(0);
        }
        if (gadget != null) {
            this.insertChild(0, gadget);
            if (n < 0) {
                n = 0;
            }
            this.startLabelOffset = n;
        }
    }

    public Gadget getStartLabel() {
        return this.startLabelOffset < 0 ? null : this.children[0];
    }

    public int getStartLabelOffset() {
        return this.startLabelOffset;
    }

    public void setItem(Gadget gadget) {
        Gadget gadget2 = this.getItem();
        if (gadget2 != null) {
            this.removeChild(gadget2);
        }
        if (gadget != null) {
            this.insertChild(this.startLabelOffset < 0 ? 0 : 1, gadget);
        }
    }

    public Gadget getItem() {
        if (this.startLabelOffset < 0) {
            if (this.endLabelOffset < 0) {
                return this.children.length > 0 ? this.children[0] : null;
            }
            return this.children.length > 1 ? this.children[0] : null;
        }
        if (this.endLabelOffset < 0) {
            return this.children.length > 1 ? this.children[1] : null;
        }
        return this.children.length > 2 ? this.children[1] : null;
    }

    public void setEndLabel(Gadget gadget, int n) {
        if (this.endLabelOffset >= 0) {
            this.removeChild(this.children.length - 1);
        }
        if (gadget != null) {
            this.addChild(gadget);
            if (n < 0) {
                n = 0;
            }
            this.endLabelOffset = n;
        }
    }

    public Gadget getEndLabel() {
        return this.endLabelOffset < 0 ? null : this.children[this.children.length - 1];
    }

    public int getEndLabelOffset() {
        return this.endLabelOffset;
    }

    public void removeChild(int n) {
        if (n == 0 && this.startLabelOffset >= 0) {
            this.startLabelOffset = -1;
        } else if (n == this.children.length - 1 && this.endLabelOffset >= 0) {
            this.endLabelOffset = -1;
        }
        super.removeChild(n);
    }

    public void refresh() {
        int n = this.width;
        int n2 = this.height;
        int n3 = this.getFirstBaseLine();
        int n4 = this.getLastBaseLine();
        this.relayout(true);
        if (this.width == n && this.height == n2 && this.getFirstBaseLine() == n3 && this.getLastBaseLine() == n4) {
            this.repaint(0, 0, this.width, this.height);
        } else if (this.parent != null) {
            this.parent.paintRelayout(this, n, n2, 0, -1);
        }
    }

    public void layout(int n, int n2, boolean bl) {
        int n3;
        Object object;
        Gadget gadget = this.getStartLabel();
        Gadget gadget2 = this.getItem();
        Gadget gadget3 = this.getEndLabel();
        int n4 = 0;
        while (n4 < this.children.length) {
            object = this.children[n4];
            if (bl) {
                if (object == gadget2) {
                    Style style = ((Styled)object).getStyle();
                    if (n > 0) {
                        n3 = n;
                        if (style.marginLeft > 0) {
                            n3 -= style.marginLeft;
                        }
                        if (style.marginRight > 0) {
                            n3 -= style.marginRight;
                        }
                        if (n3 <= 0) {
                            n3 = 1;
                        }
                    } else {
                        n3 = -1;
                    }
                    ((Gadget)object).layout(n3, -1, true);
                } else {
                    ((Gadget)object).layout(-1, -1, true);
                }
            }
            ((Gadget)object).y = 0;
            ((Gadget)object).x = 0;
            ++n4;
        }
        if (gadget2 == null) {
            gadget2 = new Box(){

                protected void layoutContent(int n, int n2, boolean bl) {
                    this.height = 1;
                    this.width = 1;
                }

                protected void paintContent(Graphics graphics) {
                }
            };
            object = new Style();
            ((Style)object).marginRight = -1;
            ((Style)object).marginLeft = -1;
            ((Box)gadget2).setStyle((Style)object);
            gadget2.layout(-1, -1, false);
        }
        object = ((Styled)((Object)gadget2)).getStyle();
        this.width = gadget2.width;
        if (((Style)object).marginLeft > 0) {
            this.width += ((Style)object).marginLeft;
        }
        if (((Style)object).marginRight > 0) {
            this.width += ((Style)object).marginRight;
        }
        if (n > 0 && this.width < n) {
            this.width = n;
        }
        if (this.width == 0) {
            this.width = 1;
        }
        gadget2.x = ((Style)object).marginLeft >= 0 ? ((Style)object).marginLeft : (((Style)object).marginRight >= 0 ? this.width - (gadget2.width + ((Style)object).marginRight) : (this.width - gadget2.width) / 2);
        if (gadget != null) {
            gadget.x = this.startLabelOffset == Integer.MAX_VALUE ? gadget2.x - Math.max(((Style)object).marginLeft, gadget.width) : gadget2.x - (gadget.width + this.startLabelOffset);
            if (gadget2 instanceof TextLines && gadget instanceof TextLines) {
                int n5 = ((TextLines)((Object)gadget2)).getFirstBaseLine();
                n3 = ((TextLines)((Object)gadget)).getFirstBaseLine();
                if (n5 >= 0 && n3 >= 0) {
                    if (n5 > n3) {
                        gadget.y = n5 - n3;
                    } else {
                        gadget2.y = n3 - n5;
                    }
                }
            }
        }
        if (gadget3 != null) {
            boolean bl2;
            gadget3.x = this.endLabelOffset == Integer.MAX_VALUE ? gadget2.x + gadget2.width + Math.max(((Style)object).marginRight, gadget3.width) - gadget3.width : gadget2.x + gadget2.width + this.endLabelOffset;
            if (gadget2 instanceof TextLines && gadget3 instanceof TextLines) {
                n3 = gadget2.y + ((TextLines)((Object)gadget2)).getLastBaseLine();
                int n6 = ((TextLines)((Object)gadget3)).getFirstBaseLine();
                if (n3 >= 0 && n6 >= 0) {
                    if (n3 > n6) {
                        gadget3.y = n3 - n6;
                    } else {
                        gadget2.y += n6 - n3;
                        if (gadget != null) {
                            gadget.y += n6 - n3;
                        }
                    }
                    bl2 = false;
                } else {
                    bl2 = true;
                }
            } else {
                bl2 = true;
            }
            if (bl2) {
                n3 = gadget2.y + gadget2.height;
                if (n3 > gadget3.height) {
                    gadget3.y = n3 - gadget3.height;
                } else {
                    gadget2.y += gadget3.height - n3;
                    if (gadget != null) {
                        gadget.y += gadget3.height - n3;
                    }
                }
            }
        }
        this.height = gadget2.y + gadget2.height;
        if (gadget != null && gadget.y + gadget.height > this.height) {
            this.height = gadget.y + gadget.height;
        }
        if (gadget3 != null && gadget3.y + gadget3.height > this.height) {
            this.height = gadget3.y + gadget3.height;
        }
        if (this.height == 0) {
            this.height = 1;
        }
    }

    public void getSizeConstraints(Gadget gadget, Dimension dimension) {
        if (gadget == this.getItem() && this.parent != null) {
            this.parent.getSizeConstraints(this, dimension);
            dimension.height = -1;
            if (dimension.width > 0) {
                Style style = ((Styled)((Object)gadget)).getStyle();
                if (style.marginLeft > 0) {
                    dimension.width -= style.marginLeft;
                }
                if (style.marginRight > 0) {
                    dimension.width -= style.marginRight;
                }
                if (dimension.width <= 0) {
                    dimension.width = 1;
                }
            }
        } else {
            dimension.width = -1;
            dimension.height = -1;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void paintRelayout(Gadget gadget, int n, int n2, int n3, int n4) {
        if (n3 == 2 && gadget == this.getItem()) {
            Style style = ((Styled)((Object)gadget)).getStyle();
            if (style.marginLeft >= 0 && this.getEndLabel() == null) {
                Gadget gadget2 = this.getStartLabel();
                int n5 = this.height;
                this.height = gadget.y + gadget.height;
                if (gadget2 != null && gadget2.y + gadget2.height > this.height) {
                    this.height = gadget2.y + gadget2.height;
                }
                if (this.height == 0) {
                    this.height = 1;
                }
                int n6 = gadget.y + gadget.height - n4;
                if (this.parent == null) return;
                this.parent.paintRelayout(this, this.width, n5, 2, this.height - n6);
                return;
            }
        }
        super.paintRelayout(gadget, n, n2, n3, n4);
    }

    public int getFirstBaseLine() {
        Gadget gadget = this.getItem();
        if (gadget == null || !(gadget instanceof TextLines)) {
            return -1;
        }
        int n = ((TextLines)((Object)gadget)).getFirstBaseLine();
        if (n < 0) {
            return -1;
        }
        return gadget.y + n;
    }

    public int getLastBaseLine() {
        Gadget gadget = this.getItem();
        if (gadget == null || !(gadget instanceof TextLines)) {
            return -1;
        }
        int n = ((TextLines)((Object)gadget)).getLastBaseLine();
        if (n < 0) {
            return -1;
        }
        return gadget.y + n;
    }
}

