/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.styledgadget;

import com.xmlmind.xmledit.doc.TextAccess;
import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.gadget.PaintUtil;
import com.xmlmind.xmledit.styledgadget.Box;
import com.xmlmind.xmledit.styledgadget.Icon;
import com.xmlmind.xmledit.styledgadget.Style;
import com.xmlmind.xmledit.styledgadget.Styleable;
import com.xmlmind.xmledit.styledgadget.TextLines;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class ParagraphText
extends Gadget
implements Styleable,
TextLines,
Cloneable {
    protected Style style;
    protected TextAccess text;
    protected int rangeOffset;
    protected int rangeLength;

    public ParagraphText copy() {
        ParagraphText paragraphText;
        try {
            paragraphText = (ParagraphText)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            paragraphText = null;
        }
        return paragraphText;
    }

    public ParagraphText(String string) {
        this(Box.DEFAULT_STYLE, string);
    }

    public ParagraphText(Style style, String string) {
        this(style, new Access(string));
    }

    public ParagraphText(Style style, TextAccess textAccess) {
        this.setStyle(style);
        this.setTextAccess(textAccess);
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public void setTextAccess(TextAccess textAccess) {
        this.text = textAccess;
        this.rangeOffset = 0;
        this.rangeLength = textAccess.getTextLength();
    }

    public Style getStyle() {
        return this.style;
    }

    public TextAccess getTextAccess() {
        return this.text;
    }

    public int getRangeOffset() {
        return this.rangeOffset;
    }

    public int getRangeLength() {
        return this.rangeLength;
    }

    public void setRange(int n, int n2) {
        if (n < 0 || n2 < 0 || n + n2 > this.text.getTextLength()) {
            throw new IllegalArgumentException("invalid range");
        }
        this.rangeOffset = n;
        this.rangeLength = n2;
    }

    public boolean containsChar(int n) {
        int n2 = this.rangeOffset + this.rangeLength;
        return n >= this.rangeOffset && n < n2 || n == n2 && n2 >= this.text.getTextLength();
    }

    public void refresh() {
        int n = this.width;
        int n2 = this.height;
        this.relayout(true);
        if (this.parent != null) {
            this.parent.paintRelayout(this, n, n2, 0, -1);
        }
    }

    public void layout(int n, int n2, boolean bl) {
        char[] cArray = this.text.getTextChars();
        int n3 = this.rangeOffset;
        int n4 = this.rangeLength;
        int n5 = this.text.getTextLength();
        if (n3 + n4 > n5) {
            n4 = n5 - n3;
        }
        if (n4 <= 0) {
            Dimension dimension = Box.getEmptyContentSize(this, this.style);
            this.width = dimension.width;
            this.height = dimension.height;
        } else {
            FontMetrics fontMetrics = this.getFontMetrics(this.style.font);
            this.height = (int)(0.5 + (double)fontMetrics.getHeight() * this.style.lineHeight);
            int n6 = n3 + n4 - 1;
            switch (cArray[n6]) {
                case '\n': {
                    this.width = PaintUtil.charsWidth(fontMetrics, cArray, n3, n4 - 1);
                    if (n6 == n5 - 1) {
                        this.width += Icon.list[0].width;
                        break;
                    }
                    if (this.width != 0) break;
                    this.width = 1;
                    break;
                }
                case '\t': 
                case '\r': 
                case ' ': {
                    if (n6 != n5 - 1) {
                        this.width = PaintUtil.charsWidth(fontMetrics, cArray, n3, n4 - 1);
                        if (this.width != 0) break;
                        this.width = 1;
                        break;
                    }
                }
                default: {
                    this.width = PaintUtil.charsWidth(fontMetrics, cArray, n3, n4);
                }
            }
        }
    }

    public void paint(Graphics graphics) {
        if (this.style.backgroundColor != null) {
            graphics.setColor(this.style.backgroundColor);
            graphics.fillRect(0, 0, this.width, this.height);
        }
        this.paintText(graphics);
    }

    public void paintText(Graphics graphics) {
        char[] cArray = this.text.getTextChars();
        int n = this.rangeOffset;
        int n2 = this.rangeLength;
        int n3 = this.text.getTextLength();
        if (n + n2 > n3) {
            n2 = n3 - n;
        }
        if (n2 <= 0) {
            Box.drawEmptyTextContent(graphics, this.style, this.width, this.height);
            return;
        }
        PaintUtil.configureTextRendering(graphics);
        FontMetrics fontMetrics = graphics.getFontMetrics(this.style.font);
        int n4 = fontMetrics.getAscent();
        int n5 = fontMetrics.getDescent();
        int n6 = (int)(0.5 + (double)fontMetrics.getHeight() * this.style.lineHeight);
        int n7 = (n6 + n4 - n5) / 2;
        graphics.setColor(this.style.color);
        graphics.setFont(this.style.font);
        int n8 = n + n2 - 1;
        switch (cArray[n8]) {
            case '\n': {
                PaintUtil.drawChars(graphics, fontMetrics, cArray, n, --n2, 0, n7);
                if (n8 != n3 - 1) break;
                graphics.drawImage(Icon.get(0, this.style.color, null), this.width - Icon.list[0].width, (n6 - Icon.list[0].height) / 2, null);
                break;
            }
            case '\t': 
            case '\r': 
            case ' ': {
                if (n8 != n3 - 1) {
                    --n2;
                }
            }
            default: {
                PaintUtil.drawChars(graphics, fontMetrics, cArray, n, n2, 0, n7);
            }
        }
        switch (this.style.textDecoration) {
            case 1: {
                int n9 = n7 + n5 - 1;
                int n10 = PaintUtil.charsWidth(fontMetrics, cArray, n, n2);
                graphics.drawLine(0, n9, n10 - 1, n9);
                break;
            }
            case 2: {
                int n11 = n7 - n4 + 1;
                int n12 = PaintUtil.charsWidth(fontMetrics, cArray, n, n2);
                graphics.drawLine(0, n11, n12 - 1, n11);
                break;
            }
            case 3: {
                int n13 = n7 + (n5 - n4) / 2;
                int n14 = PaintUtil.charsWidth(fontMetrics, cArray, n, n2);
                graphics.drawLine(0, n13, n14 - 1, n13);
            }
        }
    }

    public int getFirstBaseLine() {
        FontMetrics fontMetrics = this.getFontMetrics(this.style.font);
        int n = (int)(0.5 + (double)fontMetrics.getHeight() * this.style.lineHeight);
        int n2 = (n + fontMetrics.getAscent() - fontMetrics.getDescent()) / 2;
        return n2;
    }

    public int getLastBaseLine() {
        return this.getFirstBaseLine();
    }

    public static final class Access
    implements TextAccess {
        private char[] chars;

        public Access(String string) {
            this(string.toCharArray());
        }

        public Access(char[] cArray) {
            this.chars = cArray;
        }

        public String getText() {
            return new String(this.chars);
        }

        public int getTextLength() {
            return this.chars.length;
        }

        public char[] getTextChars() {
            return this.chars;
        }

        public char getTextChar(int n) {
            return this.chars[n];
        }
    }
}

