/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.styledgadget;

import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.styledgadget.Box;
import com.xmlmind.xmledit.styledgadget.ContainerBox;
import com.xmlmind.xmledit.styledgadget.Style;
import com.xmlmind.xmledit.styledgadget.TextLines;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;

public class TableBody
extends ContainerBox
implements TextLines {
    private static final int LABEL_MARGIN_WIDTH = 2;
    private static final int LABEL_MARGIN_HEIGHT = 2;
    private static final Cell[] noCells = new Cell[0];
    private int horizontalSpacing = 0;
    private int verticalSpacing = 0;
    private boolean addColRowLabels = false;
    protected CellImpl[][] rows = new CellImpl[0][];
    private int[] columnConstrainedWidth = new int[0];
    private ColRowLabelInfo colRowLabelInfo = null;
    private CellImpl cachedCell = null;
    private int cachedCellRowIndex = -1;
    private int cachedCellConstrainedWidth = -1;
    private CellInfo cellInfo = new CellInfo();

    public TableBody() {
    }

    public TableBody(Style style) {
        super(style);
    }

    public void setHorizontalCellSpacing(int n) {
        this.horizontalSpacing = n;
    }

    public int getHorizontalCellSpacing() {
        return this.horizontalSpacing;
    }

    public void setVerticalCellSpacing(int n) {
        this.verticalSpacing = n;
    }

    public int getVerticalCellSpacing() {
        return this.verticalSpacing;
    }

    public void setAddingColumnRowLabels(boolean bl) {
        this.addColRowLabels = bl;
        this.colRowLabelInfo = bl ? new ColRowLabelInfo() : null;
    }

    public boolean isAddingColumnRowLabels() {
        return this.addColRowLabels;
    }

    public void addRow() {
        this.insertRow(this.rows.length, noCells);
    }

    public void addRow(Cell[] cellArray) {
        this.insertRow(this.rows.length, cellArray);
    }

    public void insertRow(int n) {
        this.insertRow(n, noCells);
    }

    public void insertRow(int n, Cell[] cellArray) {
        int n2;
        CellImpl[][] cellImplArrayArray = new CellImpl[this.rows.length + 1][];
        if (n > 0) {
            System.arraycopy(this.rows, 0, cellImplArrayArray, 0, n);
        }
        if ((n2 = this.rows.length - n) > 0) {
            System.arraycopy(this.rows, n, cellImplArrayArray, n + 1, n2);
        }
        CellImpl[] cellImplArray = new CellImpl[cellArray.length];
        int n3 = 0;
        while (n3 < cellArray.length) {
            cellImplArray[n3] = new CellImpl(cellArray[n3]);
            ++n3;
        }
        cellImplArrayArray[n] = cellImplArray;
        this.rows = cellImplArrayArray;
        int n4 = this.rowToChildIndex(n);
        int n5 = 0;
        while (n5 < cellArray.length) {
            super.insertChild(n4 + n5, cellArray[n5].gadget);
            ++n5;
        }
    }

    private int rowToChildIndex(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            n2 += this.rows[n3].length;
            ++n3;
        }
        return n2;
    }

    public void removeRow(int n) {
        int n2;
        int n3;
        CellImpl[] cellImplArray = this.rows[n];
        int n4 = this.rowToChildIndex(n);
        CellImpl[][] cellImplArrayArray = new CellImpl[this.rows.length - 1][];
        if (n > 0) {
            System.arraycopy(this.rows, 0, cellImplArrayArray, 0, n);
        }
        if ((n3 = this.rows.length - (n2 = n + 1)) > 0) {
            System.arraycopy(this.rows, n2, cellImplArrayArray, n, n3);
        }
        this.rows = cellImplArrayArray;
        int n5 = cellImplArray.length - 1;
        while (n5 >= 0) {
            super.removeChild(n4 + n5);
            --n5;
        }
        this.clearCachedCell();
    }

    private void clearCachedCell() {
        this.cachedCell = null;
        this.cachedCellRowIndex = -1;
        this.cachedCellConstrainedWidth = -1;
    }

    public Cell[] getRow(int n) {
        return this.rows[n];
    }

    public int getRowCount() {
        return this.rows.length;
    }

    public int getCellCount(int n) {
        return this.rows[n].length;
    }

    public void insertChild(int n, Gadget gadget) {
        Cell cell = new Cell();
        cell.gadget = gadget;
        this.insertCell(n, cell);
    }

    public void insertCell(int n, Cell cell) {
        if (n >= this.children.length) {
            if (this.rows.length == 0) {
                this.insertRow(0, new Cell[]{cell});
            } else {
                int n2 = this.rows.length - 1;
                this.insertCell(n2, this.rows[n2].length, cell);
            }
        } else {
            this.cellInfo.gadget = this.children[n];
            this.findCell(this.cellInfo);
            this.insertCell(this.cellInfo.rowIndex, this.cellInfo.cellIndex, cell);
        }
    }

    public void insertCell(int n, int n2, Cell cell) {
        int n3;
        CellImpl[] cellImplArray = this.rows[n];
        CellImpl[] cellImplArray2 = new CellImpl[cellImplArray.length + 1];
        if (n2 > 0) {
            System.arraycopy(cellImplArray, 0, cellImplArray2, 0, n2);
        }
        if ((n3 = cellImplArray.length - n2) > 0) {
            System.arraycopy(cellImplArray, n2, cellImplArray2, n2 + 1, n3);
        }
        cellImplArray2[n2] = new CellImpl(cell);
        this.rows[n] = cellImplArray2;
        super.insertChild(this.cellToChildIndex(n, n2), cell.gadget);
    }

    private int cellToChildIndex(int n, int n2) {
        return this.rowToChildIndex(n) + n2;
    }

    public void removeChild(Gadget gadget) {
        this.cellInfo.gadget = gadget;
        if (this.findCell(this.cellInfo)) {
            this.removeCell(this.cellInfo.rowIndex, this.cellInfo.cellIndex);
        }
    }

    public void removeChild(int n) {
        this.cellInfo.gadget = this.children[n];
        this.findCell(this.cellInfo);
        this.removeCell(this.cellInfo.rowIndex, this.cellInfo.cellIndex);
    }

    public void removeCell(int n, int n2) {
        int n3;
        int n4;
        CellImpl[] cellImplArray = this.rows[n];
        CellImpl[] cellImplArray2 = new CellImpl[cellImplArray.length - 1];
        if (n2 > 0) {
            System.arraycopy(cellImplArray, 0, cellImplArray2, 0, n2);
        }
        if ((n4 = cellImplArray.length - (n3 = n2 + 1)) > 0) {
            System.arraycopy(cellImplArray, n3, cellImplArray2, n2, n4);
        }
        this.rows[n] = cellImplArray2;
        super.removeChild(this.cellToChildIndex(n, n2));
        this.clearCachedCell();
    }

    public void replaceChild(Gadget gadget, Gadget gadget2) {
        this.cellInfo.gadget = gadget;
        this.findCell(this.cellInfo);
        this.cellInfo.gadget = gadget2;
        this.replaceCell(this.cellInfo.rowIndex, this.cellInfo.cellIndex, this.cellInfo);
    }

    public void replaceChild(int n, Gadget gadget) {
        this.cellInfo.gadget = this.children[n];
        this.findCell(this.cellInfo);
        this.cellInfo.gadget = gadget;
        this.replaceCell(this.cellInfo.rowIndex, this.cellInfo.cellIndex, this.cellInfo);
    }

    public void replaceCell(int n, int n2, Cell cell) {
        CellImpl cellImpl = this.rows[n][n2];
        this.rows[n][n2] = new CellImpl(cell);
        super.replaceChild(this.cellToChildIndex(n, n2), cell.gadget);
        this.clearCachedCell();
    }

    public CellInfo getCell(int n, int n2) {
        CellInfo cellInfo = new CellInfo();
        cellInfo.rowIndex = n;
        cellInfo.cellIndex = n2;
        this.getCell(cellInfo);
        return cellInfo;
    }

    public void getCell(CellInfo cellInfo) {
        CellImpl cellImpl = this.rows[cellInfo.rowIndex][cellInfo.cellIndex];
        cellInfo.gadget = cellImpl.gadget;
        cellInfo.rowSpan = cellImpl.rowSpan;
        cellInfo.columnSpan = cellImpl.columnSpan;
        cellInfo.startColumn = cellImpl.column;
        cellInfo.style = cellImpl.style;
        cellInfo.widthSpec1 = cellImpl.widthSpec1;
        cellInfo.widthSpec1IsPercent = cellImpl.widthSpec1IsPercent;
        cellInfo.widthSpec2 = cellImpl.widthSpec2;
    }

    public CellInfo findCell(Gadget gadget) {
        CellInfo cellInfo = new CellInfo();
        cellInfo.gadget = gadget;
        return this.findCell(cellInfo) ? cellInfo : null;
    }

    public boolean findCell(CellInfo cellInfo) {
        Gadget gadget = cellInfo.gadget;
        int n = 0;
        while (n < this.rows.length) {
            CellImpl[] cellImplArray = this.rows[n];
            int n2 = 0;
            while (n2 < cellImplArray.length) {
                CellImpl cellImpl = cellImplArray[n2];
                if (cellImpl.gadget == gadget) {
                    cellInfo.rowIndex = n;
                    cellInfo.cellIndex = n2;
                    cellInfo.rowSpan = cellImpl.rowSpan;
                    cellInfo.columnSpan = cellImpl.columnSpan;
                    cellInfo.startColumn = cellImpl.column;
                    cellInfo.style = cellImpl.style;
                    cellInfo.widthSpec1 = cellImpl.widthSpec1;
                    cellInfo.widthSpec1IsPercent = cellImpl.widthSpec1IsPercent;
                    cellInfo.widthSpec2 = cellImpl.widthSpec2;
                    return true;
                }
                ++n2;
            }
            ++n;
        }
        return false;
    }

    protected void layoutContent(int n, int n2, boolean bl) {
        if (this.addColRowLabels) {
            this.colRowLabelInfo.labelFont = new Font("SansSerif", 1, Math.max(10, this.style.font.getSize() - 2));
            FontMetrics fontMetrics = this.getFontMetrics(this.colRowLabelInfo.labelFont);
            this.colRowLabelInfo.labelHeight = fontMetrics.getAscent() + fontMetrics.getDescent() + 4;
            int n3 = 100 * ((this.rows.length + 99) / 100);
            this.colRowLabelInfo.labelWidth = fontMetrics.stringWidth(Integer.toString(n3)) + 4;
            if (n > 0 && (n -= this.colRowLabelInfo.labelWidth) <= 0) {
                n = 1;
            }
        }
        int n4 = this.estimateColumnCount();
        GridItem[][] gridItemArray = new GridItem[this.rows.length][n4];
        n4 = this.placeCells(gridItemArray);
        if (bl) {
            this.clearCachedCell();
            this.computeColumnConstrainedWidth(n, gridItemArray, n4);
            this.relayoutChildren();
        }
        this.horizontalLayout(gridItemArray, n4);
        this.verticalLayout(gridItemArray, n4);
        if (this.addColRowLabels) {
            int n5 = this.colRowLabelInfo.labelWidth;
            int n6 = this.colRowLabelInfo.labelHeight;
            int n7 = 0;
            while (n7 < this.children.length) {
                Gadget gadget = this.children[n7];
                gadget.x += n5;
                gadget.y += n6;
                ++n7;
            }
            this.width += n5;
            this.height += n6;
        }
    }

    private int estimateColumnCount() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.rows.length) {
            CellImpl[] cellImplArray = this.rows[n3];
            int n4 = 0;
            int n5 = 0;
            while (n5 < cellImplArray.length) {
                CellImpl cellImpl = cellImplArray[n5];
                if (cellImpl.startColumn > n4) {
                    n4 = cellImpl.startColumn;
                }
                n4 += cellImpl.columnSpan;
                if (cellImpl.rowSpan > 1) {
                    n2 += cellImpl.columnSpan;
                }
                ++n5;
            }
            if (n4 > n) {
                n = n4;
            }
            ++n3;
        }
        return n + n2;
    }

    private int placeCells(GridItem[][] gridItemArray) {
        int n;
        GridItem[] gridItemArray2;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.rows.length) {
            CellImpl[] cellImplArray = this.rows[n3];
            gridItemArray2 = gridItemArray[n3];
            n = 0;
            int n4 = 0;
            while (n4 < cellImplArray.length) {
                int n5;
                CellImpl cellImpl = cellImplArray[n4];
                while (gridItemArray2[n] != null) {
                    ++n;
                }
                if (cellImpl.rowSpan > 1) {
                    n5 = Math.min(this.rows.length, n3 + cellImpl.rowSpan);
                    int n6 = n3 + 1;
                    while (n6 < n5) {
                        GridItem[] gridItemArray3 = gridItemArray[n6];
                        int n7 = 0;
                        while (n7 < cellImpl.columnSpan) {
                            gridItemArray3[n + n7] = new GridItem();
                            ++n7;
                        }
                        ++n6;
                    }
                }
                while (n < cellImpl.startColumn) {
                    gridItemArray2[n++] = new GridItem();
                }
                cellImpl.column = n;
                gridItemArray2[n++] = new GridItem(cellImpl);
                n5 = 1;
                while (n5 < cellImpl.columnSpan) {
                    gridItemArray2[n++] = new GridItem();
                    ++n5;
                }
                ++n4;
            }
            if (n > n2) {
                n2 = n;
            }
            ++n3;
        }
        int n8 = 0;
        while (n8 < this.rows.length) {
            gridItemArray2 = gridItemArray[n8];
            n = 0;
            while (n < n2) {
                if (gridItemArray2[n] == null) {
                    gridItemArray2[n] = new GridItem();
                }
                ++n;
            }
            ++n8;
        }
        return n2;
    }

    private void computeColumnConstrainedWidth(int n, GridItem[][] gridItemArray, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        int n8 = 0;
        while (n8 < n2) {
            n7 = -1;
            n6 = -1;
            n5 = 0;
            while (n5 < this.rows.length) {
                GridItem gridItem = gridItemArray[n5][n8];
                if (gridItem.cell != null) {
                    CellImpl cellImpl = gridItem.cell;
                    cellImpl.minWidth = cellImpl.widthSpec1 > 0 ? (cellImpl.widthSpec1IsPercent ? (n <= 0 ? -1 : Math.max(1, cellImpl.widthSpec1 * n / 100)) : cellImpl.widthSpec1) : -1;
                    if (cellImpl.minWidth > 0) {
                        Style style = cellImpl.style;
                        n4 = cellImpl.minWidth + 2 * style.borderWidth + style.paddingLeft + style.paddingRight;
                        gridItem.width = this.computeWidthPerColumn(n4, cellImpl.columnSpan);
                    } else {
                        gridItem.width = -1;
                    }
                    gridItem.height = cellImpl.widthSpec2 > 0 ? Math.max(1, cellImpl.widthSpec2 / cellImpl.columnSpan) : (cellImpl.widthSpec2 == 0 && cellImpl.widthSpec1 <= 0 ? 0 : -1);
                    n3 = 1;
                    while (n3 < cellImpl.columnSpan) {
                        GridItem gridItem2 = gridItemArray[n5][n8 + n3];
                        gridItem2.width = gridItem.width;
                        gridItem2.height = gridItem.height;
                        ++n3;
                    }
                }
                if (gridItem.width > n7) {
                    n7 = gridItem.width;
                }
                gridItem.width = 0;
                if (gridItem.height > n6) {
                    n6 = gridItem.height;
                }
                gridItem.height = 0;
                ++n5;
            }
            nArray[n8] = n7;
            nArray2[n8] = n6;
            ++n8;
        }
        if (n > 0) {
            n7 = 0;
            n6 = 0;
            n5 = 0;
            while (n5 < n2) {
                if (nArray[n5] > 0) {
                    n7 += this.horizontalSpacing + nArray[n5];
                    if (nArray2[n5] > 0) {
                        n6 += nArray2[n5];
                    }
                } else {
                    n6 = nArray2[n5] > 0 ? (n6 += nArray2[n5]) : ++n6;
                }
                ++n5;
            }
            int n9 = -1;
            int n10 = -1;
            if (n > n7 && n6 > 0) {
                n3 = n - n7;
                n9 = (n3 -= (n6 - 1) * this.horizontalSpacing) / n6;
                n10 = n3 - n9 * (n6 - 1);
            }
            if (n9 <= 0) {
                n9 = 1;
            }
            if (n10 <= 0) {
                n10 = 1;
            }
            n3 = n2 - 1;
            while (n3 >= 0) {
                if (nArray2[n3] > 0) {
                    n4 = nArray[n3];
                    if (n10 > 0) {
                        nArray[n3] = nArray2[n3] > 1 ? (nArray2[n3] - 1) * n9 + n10 : n10;
                        n10 = -1;
                    } else {
                        nArray[n3] = nArray2[n3] * n9;
                    }
                    if (n4 > 0) {
                        int n11 = n3;
                        nArray[n11] = nArray[n11] + n4;
                    }
                } else if (nArray2[n3] == 0) {
                    nArray[n3] = 1;
                } else if (nArray[n3] <= 0) {
                    if (n10 > 0) {
                        nArray[n3] = n10;
                        n10 = -1;
                    } else {
                        nArray[n3] = n9;
                    }
                }
                --n3;
            }
        }
        this.columnConstrainedWidth = nArray;
    }

    private int computeWidthPerColumn(int n, int n2) {
        int n3 = n;
        if (n2 > 1) {
            n3 -= (n2 - 1) * this.horizontalSpacing;
            n3 /= n2;
        }
        if (n3 <= 0) {
            n3 = 1;
        }
        return n3;
    }

    private void relayoutChildren() {
        int n = 0;
        while (n < this.rows.length) {
            CellImpl[] cellImplArray = this.rows[n];
            int n2 = 0;
            while (n2 < cellImplArray.length) {
                CellImpl cellImpl = cellImplArray[n2];
                cellImpl.gadget.layout(this.computeChildConstrainedWidth(cellImpl), -1, true);
                ++n2;
            }
            ++n;
        }
    }

    private int computeChildConstrainedWidth(CellImpl cellImpl) {
        int n = cellImpl.column;
        int n2 = this.columnConstrainedWidth[n];
        if (n2 <= 0) {
            return -1;
        }
        int n3 = 1;
        while (n3 < cellImpl.columnSpan) {
            int n4 = this.columnConstrainedWidth[n + n3];
            if (n4 <= 0) {
                return -1;
            }
            n2 += this.horizontalSpacing + n4;
            ++n3;
        }
        Style style = cellImpl.style;
        if ((n2 -= 2 * style.borderWidth + style.paddingLeft + style.paddingRight) <= 0) {
            n2 = 1;
        }
        return n2;
    }

    private void horizontalLayout(GridItem[][] gridItemArray, int n) {
        int n2;
        Object object;
        Object object2;
        int n3;
        int n4;
        int[] nArray = new int[n];
        if (this.addColRowLabels) {
            this.colRowLabelInfo.columnWidth = nArray;
        }
        int n5 = 0;
        while (n5 < n) {
            n4 = 0;
            n3 = 0;
            while (n3 < this.rows.length) {
                GridItem gridItem = gridItemArray[n3][n5];
                if (gridItem.cell != null) {
                    object2 = gridItem.cell;
                    object = ((CellImpl)object2).style;
                    n2 = ((CellImpl)object2).gadget.width;
                    if (((CellImpl)object2).minWidth > 0) {
                        n2 = Math.max(n2, ((CellImpl)object2).minWidth);
                    }
                    int n6 = n2 + 2 * ((Style)object).borderWidth + ((Style)object).paddingLeft + ((Style)object).paddingRight;
                    if (((CellImpl)object2).columnSpan == 1) {
                        gridItem.width = n6;
                    } else {
                        int n7;
                        boolean bl = false;
                        int n8 = 0;
                        int n9 = 0;
                        while (n9 < ((CellImpl)object2).columnSpan) {
                            if (this.columnConstrainedWidth[n5 + n9] <= 0) {
                                bl = true;
                                break;
                            }
                            n8 += this.columnConstrainedWidth[n5 + n9];
                            ++n9;
                        }
                        if (bl) {
                            gridItem.width = this.computeWidthPerColumn(n6, ((CellImpl)object2).columnSpan);
                            n7 = 1;
                            while (n7 < ((CellImpl)object2).columnSpan) {
                                gridItemArray[n3][n5 + n7].width = gridItem.width;
                                ++n7;
                            }
                        } else {
                            if ((n6 -= (((CellImpl)object2).columnSpan - 1) * this.horizontalSpacing) < 1 * ((CellImpl)object2).columnSpan) {
                                n6 = 1 * ((CellImpl)object2).columnSpan;
                            }
                            n7 = 0;
                            int n10 = 0;
                            while (n10 < ((CellImpl)object2).columnSpan) {
                                if (n10 == ((CellImpl)object2).columnSpan - 1) {
                                    gridItemArray[n3][n5 + n10].width = n6 - n7;
                                } else {
                                    int n11 = n6 * this.columnConstrainedWidth[n5 + n10] / n8;
                                    if (n11 <= 0) {
                                        n11 = 1;
                                    }
                                    gridItemArray[n3][n5 + n10].width = n11;
                                    n7 += n11;
                                }
                                ++n10;
                            }
                        }
                    }
                }
                if (gridItem.width > n4) {
                    n4 = gridItem.width;
                }
                ++n3;
            }
            nArray[n5] = n4;
            ++n5;
        }
        n4 = 0;
        n3 = 0;
        while (n3 < n) {
            if (n3 > 0) {
                n4 += this.horizontalSpacing;
            }
            int n12 = 0;
            while (n12 < this.rows.length) {
                object2 = gridItemArray[n12][n3];
                if (((GridItem)object2).cell != null) {
                    object = ((GridItem)object2).cell;
                    ((CellImpl)object).x = n4;
                    ((CellImpl)object).width = nArray[n3];
                    n2 = 1;
                    while (n2 < ((CellImpl)object).columnSpan) {
                        ((CellImpl)object).width += this.horizontalSpacing + nArray[n3 + n2];
                        ++n2;
                    }
                    Style style = ((CellImpl)object).style;
                    switch (style.textAlign) {
                        case 1: {
                            ((CellImpl)object).gadget.x = ((CellImpl)object).x + ((CellImpl)object).width - style.borderWidth - style.paddingRight - ((CellImpl)object).gadget.width;
                            break;
                        }
                        case 2: {
                            ((CellImpl)object).gadget.x = ((CellImpl)object).x + style.borderWidth + style.paddingLeft + (((CellImpl)object).width - 2 * style.borderWidth - style.paddingLeft - style.paddingRight - ((CellImpl)object).gadget.width) / 2;
                            break;
                        }
                        default: {
                            ((CellImpl)object).gadget.x = ((CellImpl)object).x + style.borderWidth + style.paddingLeft;
                        }
                    }
                }
                ++n12;
            }
            n4 += nArray[n3];
            ++n3;
        }
        this.width = n4;
        if (this.width < 1) {
            this.width = 1;
        }
    }

    private void verticalLayout(GridItem[][] gridItemArray, int n) {
        int n2;
        int n3;
        int n4;
        Object object;
        int n5;
        int[] nArray = new int[this.rows.length];
        if (this.addColRowLabels) {
            this.colRowLabelInfo.rowHeight = nArray;
        }
        int n6 = 0;
        while (n6 < this.rows.length) {
            GridItem[] gridItemArray2 = gridItemArray[n6];
            n5 = 0;
            int n7 = 0;
            while (n7 < n) {
                GridItem gridItem = gridItemArray2[n7];
                if (gridItem.cell != null) {
                    CellImpl cellImpl = gridItem.cell;
                    object = cellImpl.style;
                    n4 = cellImpl.gadget.height + 2 * ((Style)object).borderWidth + ((Style)object).paddingTop + ((Style)object).paddingBottom;
                    gridItem.height = this.computeHeightPerRow(n4, cellImpl.rowSpan);
                    n3 = Math.min(this.rows.length, n6 + cellImpl.rowSpan);
                    int n8 = n6 + 1;
                    while (n8 < n3) {
                        gridItemArray[n8][n7].height = gridItem.height;
                        ++n8;
                    }
                    switch (((Style)object).verticalAlign) {
                        case 3: 
                        case 5: 
                        case 6: {
                            break;
                        }
                        default: {
                            cellImpl.gadgetBaseLine = cellImpl.gadget instanceof TextLines ? ((TextLines)((Object)cellImpl.gadget)).getFirstBaseLine() : -1;
                            if (cellImpl.gadgetBaseLine < 0) {
                                cellImpl.gadgetBaseLine = cellImpl.gadget.height;
                            }
                            cellImpl.rowBaseLine = ((Style)object).borderWidth + ((Style)object).paddingTop + cellImpl.gadgetBaseLine;
                            if (cellImpl.rowBaseLine <= n5) break;
                            n5 = cellImpl.rowBaseLine;
                        }
                    }
                }
                ++n7;
            }
            n2 = 0;
            int n9 = 0;
            while (n9 < n) {
                object = gridItemArray2[n9];
                CellImpl cellImpl = ((GridItem)object).cell;
                if (cellImpl != null && cellImpl.rowBaseLine > 0) {
                    ((GridItem)object).height += n5 - cellImpl.rowBaseLine;
                    cellImpl.rowBaseLine = n5;
                }
                if (((GridItem)object).height > n2) {
                    n2 = ((GridItem)object).height;
                }
                ++n9;
            }
            nArray[n6] = n2;
            ++n6;
        }
        int n10 = 0;
        n5 = 0;
        while (n5 < this.rows.length) {
            GridItem[] gridItemArray3 = gridItemArray[n5];
            if (n5 > 0) {
                n10 += this.verticalSpacing;
            }
            n2 = 0;
            while (n2 < n) {
                GridItem gridItem = gridItemArray3[n2];
                if (gridItem.cell != null) {
                    object = gridItem.cell;
                    ((CellImpl)object).y = n10;
                    ((CellImpl)object).height = nArray[n5];
                    n4 = Math.min(this.rows.length, n5 + ((CellImpl)object).rowSpan);
                    n3 = n5 + 1;
                    while (n3 < n4) {
                        ((CellImpl)object).height += this.verticalSpacing + nArray[n3];
                        ++n3;
                    }
                    Style style = ((CellImpl)object).style;
                    switch (style.verticalAlign) {
                        case 3: {
                            ((CellImpl)object).gadget.y = ((CellImpl)object).y + style.borderWidth + style.paddingTop;
                            break;
                        }
                        case 6: {
                            ((CellImpl)object).gadget.y = ((CellImpl)object).y + ((CellImpl)object).height - style.borderWidth - style.paddingBottom - ((CellImpl)object).gadget.height;
                            break;
                        }
                        case 5: {
                            ((CellImpl)object).gadget.y = ((CellImpl)object).y + style.borderWidth + style.paddingTop + (((CellImpl)object).height - 2 * style.borderWidth - style.paddingTop - style.paddingBottom - ((CellImpl)object).gadget.height) / 2;
                            break;
                        }
                        default: {
                            ((CellImpl)object).gadget.y = ((CellImpl)object).y + ((CellImpl)object).rowBaseLine - ((CellImpl)object).gadgetBaseLine;
                        }
                    }
                }
                ++n2;
            }
            n10 += nArray[n5];
            ++n5;
        }
        this.height = n10;
        if (this.height < 1) {
            this.height = 1;
        }
    }

    private int computeHeightPerRow(int n, int n2) {
        int n3 = n;
        if (n2 > 1) {
            n3 -= (n2 - 1) * this.verticalSpacing;
            n3 /= n2;
        }
        if (n3 <= 0) {
            n3 = 1;
        }
        return n3;
    }

    public void getSizeConstraints(Gadget gadget, Dimension dimension) {
        dimension.height = -1;
        dimension.width = -1;
        CellImpl cellImpl = this.fetchCell(gadget);
        if (cellImpl == null) {
            return;
        }
        if (this.cachedCellConstrainedWidth > 0) {
            dimension.width = this.cachedCellConstrainedWidth;
        } else if (cellImpl.column >= 0) {
            dimension.width = this.cachedCellConstrainedWidth = this.computeChildConstrainedWidth(cellImpl);
        }
    }

    private CellImpl fetchCell(Gadget gadget) {
        if (this.cachedCell != null && this.cachedCell.gadget == gadget) {
            return this.cachedCell;
        }
        int n = 0;
        while (n < this.rows.length) {
            CellImpl[] cellImplArray = this.rows[n];
            int n2 = 0;
            while (n2 < cellImplArray.length) {
                CellImpl cellImpl = cellImplArray[n2];
                if (cellImpl.gadget == gadget) {
                    this.cachedCell = cellImpl;
                    this.cachedCellRowIndex = n;
                    this.cachedCellConstrainedWidth = -1;
                    return cellImpl;
                }
                ++n2;
            }
            ++n;
        }
        return null;
    }

    public void paintRelayout(Gadget gadget, int n, int n2, int n3, int n4) {
        CellImpl cellImpl = this.fetchCell(gadget);
        if (cellImpl == null) {
            return;
        }
        if (cellImpl.column < 0) {
            super.paintRelayout(gadget, n, n2, n3, n4);
            return;
        }
        int n5 = this.style.borderWidth + this.style.paddingLeft;
        int n6 = this.style.borderWidth + this.style.paddingTop;
        if (this.addColRowLabels) {
            n5 += this.colRowLabelInfo.labelWidth;
            n6 += this.colRowLabelInfo.labelHeight;
        }
        boolean bl = gadget.width == n;
        Style style = cellImpl.style;
        int n7 = style.borderWidth + style.paddingLeft;
        int n8 = cellImpl.width - n7 - style.borderWidth - style.paddingRight;
        if (bl || n < n8 && gadget.width <= n8) {
            if (!bl) {
                switch (style.textAlign) {
                    case 1: {
                        gadget.x = n5 + cellImpl.x + cellImpl.width - style.borderWidth - style.paddingRight - gadget.width;
                        break;
                    }
                    case 2: {
                        gadget.x = n5 + cellImpl.x + n7 + (n8 - gadget.width) / 2;
                    }
                }
            }
            int n9 = style.borderWidth + style.paddingTop;
            int n10 = cellImpl.height - n9 - style.borderWidth - style.paddingBottom;
            int n11 = cellImpl.gadgetBaseLine;
            switch (style.verticalAlign) {
                case 3: 
                case 5: 
                case 6: {
                    break;
                }
                default: {
                    cellImpl.gadgetBaseLine = gadget instanceof TextLines ? ((TextLines)((Object)gadget)).getFirstBaseLine() : -1;
                    if (cellImpl.gadgetBaseLine >= 0) break;
                    cellImpl.gadgetBaseLine = gadget.height;
                }
            }
            if (cellImpl.gadgetBaseLine >= 0 && cellImpl.gadgetBaseLine == n11 && cellImpl.rowBaseLine >= 0 && n2 - n11 < n10 - cellImpl.rowBaseLine && gadget.height - cellImpl.gadgetBaseLine <= n10 - cellImpl.rowBaseLine || cellImpl.gadgetBaseLine < 0 && n2 < n10 && gadget.height <= n10) {
                switch (style.verticalAlign) {
                    case 6: {
                        gadget.y = n6 + cellImpl.y + cellImpl.height - style.borderWidth - style.paddingBottom - gadget.height;
                        break;
                    }
                    case 5: {
                        gadget.y = n6 + cellImpl.y + n9 + (n10 - gadget.height) / 2;
                    }
                }
                this.repaint(n5 + cellImpl.x + n7, n6 + cellImpl.y + n9, n8, n10);
                return;
            }
            if (this.verticalRelayoutFromRow(this.cachedCellRowIndex, cellImpl.y, cellImpl.height)) {
                return;
            }
        }
        super.paintRelayout(gadget, n, n2, n3, n4);
    }

    private boolean verticalRelayoutFromRow(int n, int n2, int n3) {
        int n4;
        Object[] objectArray;
        int n5;
        CellImpl[] cellImplArray;
        int n6 = 0;
        while (n6 < n) {
            cellImplArray = this.rows[n6];
            n5 = 0;
            while (n5 < cellImplArray.length) {
                CellImpl cellImpl = cellImplArray[n5];
                if (n6 + cellImpl.rowSpan > n) {
                    return false;
                }
                ++n5;
            }
            ++n6;
        }
        cellImplArray = this.rows[n];
        n5 = 0;
        int n7 = 0;
        while (n7 < cellImplArray.length) {
            CellImpl cellImpl = cellImplArray[n7];
            if (cellImpl.rowSpan > 1) {
                return false;
            }
            Style style = cellImpl.style;
            cellImpl.height = cellImpl.gadget.height + 2 * style.borderWidth + style.paddingTop + style.paddingBottom;
            switch (style.verticalAlign) {
                case 3: 
                case 5: 
                case 6: {
                    break;
                }
                default: {
                    cellImpl.rowBaseLine = style.borderWidth + style.paddingTop + cellImpl.gadgetBaseLine;
                    if (cellImpl.rowBaseLine <= n5) break;
                    n5 = cellImpl.rowBaseLine;
                }
            }
            ++n7;
        }
        int n8 = n3;
        n3 = 0;
        int n9 = 0;
        while (n9 < cellImplArray.length) {
            CellImpl cellImpl = cellImplArray[n9];
            if (cellImpl.rowBaseLine > 0) {
                cellImpl.height += n5 - cellImpl.rowBaseLine;
                cellImpl.rowBaseLine = n5;
            }
            if (cellImpl.height > n3) {
                n3 = cellImpl.height;
            }
            ++n9;
        }
        int n10 = this.style.borderWidth + this.style.paddingTop;
        if (this.addColRowLabels) {
            n10 += this.colRowLabelInfo.labelHeight;
        }
        int n11 = 0;
        while (n11 < cellImplArray.length) {
            CellImpl cellImpl = cellImplArray[n11];
            cellImpl.height = n3;
            Style style = cellImpl.style;
            switch (style.verticalAlign) {
                case 3: {
                    cellImpl.gadget.y = n10 + cellImpl.y + style.borderWidth + style.paddingTop;
                    break;
                }
                case 6: {
                    cellImpl.gadget.y = n10 + cellImpl.y + cellImpl.height - style.borderWidth - style.paddingBottom - cellImpl.gadget.height;
                    break;
                }
                case 5: {
                    cellImpl.gadget.y = n10 + cellImpl.y + style.borderWidth + style.paddingTop + (cellImpl.height - 2 * style.borderWidth - style.paddingTop - style.paddingBottom - cellImpl.gadget.height) / 2;
                    break;
                }
                default: {
                    cellImpl.gadget.y = n10 + cellImpl.y + cellImpl.rowBaseLine - cellImpl.gadgetBaseLine;
                }
            }
            ++n11;
        }
        int n12 = n3 - n8;
        int n13 = n + 1;
        while (n13 < this.rows.length) {
            objectArray = this.rows[n13];
            n4 = 0;
            while (n4 < objectArray.length) {
                CellImpl cellImpl = objectArray[n4];
                cellImpl.y += n12;
                cellImpl.gadget.y += n12;
                ++n4;
            }
            ++n13;
        }
        if (this.addColRowLabels) {
            objectArray = this.colRowLabelInfo.rowHeight;
            n4 = n;
            while (n4 < this.rows.length) {
                int n14 = n4++;
                objectArray[n14] = objectArray[n14] + n12;
            }
        }
        this.height += n12;
        this.parent.paintRelayout(this, this.width, this.height - n12, 2, this.height - (n10 + n2));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintContent(Graphics graphics) {
        Object object;
        int n;
        Rectangle rectangle = graphics.getClipBounds();
        int n2 = this.style.borderWidth + this.style.paddingTop;
        int n3 = this.style.borderWidth + this.style.paddingLeft;
        if (this.addColRowLabels) {
            n = this.colRowLabelInfo.labelWidth;
            int n4 = this.colRowLabelInfo.labelHeight;
            int[] nArray = this.colRowLabelInfo.columnWidth;
            int n5 = n3 + n;
            graphics.setFont(this.colRowLabelInfo.labelFont);
            object = graphics.getFontMetrics();
            int n6 = ((FontMetrics)object).getAscent();
            int n7 = ((FontMetrics)object).getDescent();
            int n8 = 0;
            while (n8 < nArray.length) {
                this.drawColumnRowLabel(graphics, n8, true, n5, n2, nArray[n8], n4, (FontMetrics)object, n6, n7);
                n5 += nArray[n8] + this.horizontalSpacing;
                ++n8;
            }
            int[] nArray2 = this.colRowLabelInfo.rowHeight;
            int n9 = n2 + n4;
            int n10 = 0;
            while (n10 < nArray2.length) {
                this.drawColumnRowLabel(graphics, n10, false, n3, n9, n, nArray2[n10], (FontMetrics)object, n6, n7);
                n9 += nArray2[n10] + this.verticalSpacing;
                ++n10;
            }
            n3 += n;
            n2 += n4;
        }
        n = 0;
        while (n < this.rows.length) {
            CellImpl[] cellImplArray = this.rows[n];
            int n11 = 0;
            while (n11 < cellImplArray.length) {
                CellImpl cellImpl = cellImplArray[n11];
                if (cellImpl.column >= 0 && (rectangle == null || n3 + cellImpl.x < rectangle.x + rectangle.width && n2 + cellImpl.y < rectangle.y + rectangle.height && n3 + cellImpl.x + cellImpl.width > rectangle.x && n2 + cellImpl.y + cellImpl.height > rectangle.y)) {
                    Object var17_19;
                    object = graphics.create(n3 + cellImpl.x, n2 + cellImpl.y, cellImpl.width, cellImpl.height);
                    try {
                        Box.drawBox((Graphics)object, cellImpl.style, cellImpl.width, cellImpl.height);
                        var17_19 = null;
                        ((Graphics)object).dispose();
                    }
                    catch (Throwable throwable) {
                        var17_19 = null;
                        ((Graphics)object).dispose();
                        throw throwable;
                    }
                }
                ++n11;
            }
            ++n;
        }
        super.paintContent(graphics);
    }

    private void drawColumnRowLabel(Graphics graphics, int n, boolean bl, int n2, int n3, int n4, int n5, FontMetrics fontMetrics, int n6, int n7) {
        Rectangle rectangle;
        boolean bl2;
        graphics.setColor(Color.lightGray);
        graphics.fill3DRect(++n2, ++n3, n4 -= 2, n5 -= 2, true);
        graphics.setColor(Color.black);
        graphics.drawRect(n2 - 1, n3 - 1, n4 + 1, n5 + 1);
        String string = bl ? TableBody.numberToLabel(1 + n) : Integer.toString(1 + n);
        int n8 = fontMetrics.stringWidth(string);
        int n9 = n2 + (n4 - n8) / 2;
        int n10 = n3 + n5 / 2 + (n6 - n7) / 2;
        boolean bl3 = bl2 = n8 + 1 > n4 || n6 + n7 + 1 > n5;
        if (bl2) {
            rectangle = graphics.getClipBounds();
            graphics.setClip(n2, n3, n4, n5);
        } else {
            rectangle = null;
        }
        graphics.setColor(Color.white);
        graphics.drawString(string, n9 + 1, n10 + 1);
        graphics.setColor(Color.black);
        graphics.drawString(string, n9, n10);
        if (bl2) {
            graphics.setClip(rectangle);
        }
    }

    private static final String numberToLabel(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        while (n > 0) {
            int n2 = --n % 26;
            stringBuffer.insert(0, (char)(65 + n2));
            n /= 26;
        }
        return stringBuffer.toString();
    }

    protected void printContent(Graphics graphics) {
        this.paintContent(graphics);
    }

    public int getFirstBaseLine() {
        if (this.rows.length == 0) {
            return -1;
        }
        CellImpl[] cellImplArray = this.rows[0];
        if (cellImplArray.length == 0) {
            return -1;
        }
        CellImpl cellImpl = cellImplArray[0];
        return cellImpl.y + cellImpl.rowBaseLine;
    }

    public int getLastBaseLine() {
        if (this.rows.length == 0) {
            return -1;
        }
        CellImpl[] cellImplArray = this.rows[this.rows.length - 1];
        if (cellImplArray.length == 0) {
            return -1;
        }
        CellImpl cellImpl = cellImplArray[0];
        return cellImpl.y + cellImpl.rowBaseLine;
    }

    private static final class ColRowLabelInfo {
        public int labelWidth;
        public int labelHeight;
        public int[] columnWidth;
        public int[] rowHeight;
        public Font labelFont;

        private ColRowLabelInfo() {
        }
    }

    private static class GridItem {
        public CellImpl cell;
        public int width;
        public int height;

        public GridItem() {
            this(null);
        }

        public GridItem(CellImpl cellImpl) {
            this.cell = cellImpl;
            this.width = -1;
            this.height = -1;
        }
    }

    protected static class CellImpl
    extends Cell {
        public int column = -1;
        public int x = -1;
        public int y = -1;
        public int width = -1;
        public int height = -1;
        public int gadgetBaseLine = -1;
        public int rowBaseLine = -1;
        public int minWidth = -1;

        public CellImpl(Cell cell) {
            this.gadget = cell.gadget;
            this.rowSpan = cell.rowSpan;
            this.columnSpan = cell.columnSpan;
            this.startColumn = cell.startColumn;
            this.style = cell.style;
            this.widthSpec1 = cell.widthSpec1;
            this.widthSpec1IsPercent = cell.widthSpec1IsPercent;
            this.widthSpec2 = cell.widthSpec2;
        }
    }

    public static class CellInfo
    extends Cell {
        public int rowIndex = -1;
        public int cellIndex = -1;
    }

    public static class Cell {
        public Gadget gadget = null;
        public int rowSpan = 1;
        public int columnSpan = 1;
        public int startColumn = -1;
        public Style style = Box.DEFAULT_STYLE;
        public int widthSpec1 = -1;
        public boolean widthSpec1IsPercent = false;
        public int widthSpec2 = -1;
    }
}

