/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.styledgadget;

import com.xmlmind.xmledit.gadget.PaintUtil;
import com.xmlmind.xmledit.styledgadget.Box;
import com.xmlmind.xmledit.styledgadget.Style;
import com.xmlmind.xmledit.styledgadget.TextLineBox;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class TextLabel
extends TextLineBox {
    protected char[] textChars;
    private static final char[] NO_CHARS = new char[0];

    public TextLabel() {
        this(Box.DEFAULT_STYLE, "");
    }

    public TextLabel(Style style) {
        this(style, "");
    }

    public TextLabel(String string) {
        this(Box.DEFAULT_STYLE, string);
    }

    public TextLabel(Style style, String string) {
        super(style);
        this.setText(string);
    }

    public void setText(String string) {
        this.textChars = string.length() == 0 ? NO_CHARS : string.toCharArray();
    }

    public String getText() {
        return new String(this.textChars, 0, this.textChars.length);
    }

    protected void layoutContent(int n, int n2, boolean bl) {
        FontMetrics fontMetrics = this.getFontMetrics(this.style.font);
        this.doLayoutContent(fontMetrics);
    }

    protected final void doLayoutContent(FontMetrics fontMetrics) {
        int n;
        boolean bl = true;
        int n2 = 0;
        int n3 = 0;
        int n4 = 1;
        int n5 = this.textChars.length;
        int n6 = 0;
        while (n6 < n5) {
            char c = this.textChars[n6];
            if (c == '\n') {
                if (n6 > n2) {
                    n = fontMetrics.charsWidth(this.textChars, n2, n6 - n2);
                    if (this.style.textAlign == 0) {
                        if (this.style.textIndent > 0) {
                            n += bl ? this.style.textIndent : 0;
                        } else if (this.style.textIndent < 0) {
                            n += bl ? 0 : -this.style.textIndent;
                        }
                    }
                    if (n > n3) {
                        n3 = n;
                    }
                }
                bl = false;
                n2 = n6 + 1;
                ++n4;
            }
            ++n6;
        }
        if (n5 > n2) {
            n = fontMetrics.charsWidth(this.textChars, n2, n5 - n2);
            if (this.style.textAlign == 0) {
                if (this.style.textIndent > 0) {
                    n += bl ? this.style.textIndent : 0;
                } else if (this.style.textIndent < 0) {
                    n += bl ? 0 : -this.style.textIndent;
                }
            }
            if (n > n3) {
                n3 = n;
            }
        }
        this.width = n3;
        this.height = n4 * (int)(0.5 + (double)fontMetrics.getHeight() * this.style.lineHeight);
    }

    protected void paintContent(Graphics graphics) {
        PaintUtil.configureTextRendering(graphics);
        graphics.setFont(this.style.font);
        graphics.setColor(this.style.color);
        int n = this.width - (2 * this.style.borderWidth + this.style.paddingLeft + this.style.paddingRight);
        this.doPaintContent(graphics, n);
    }

    protected final void doPaintContent(Graphics graphics, int n) {
        int n2;
        int n3;
        int n4;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n5 = fontMetrics.getAscent();
        int n6 = fontMetrics.getDescent();
        boolean bl = true;
        int n7 = 0;
        int n8 = (int)(0.5 + (double)fontMetrics.getHeight() * this.style.lineHeight);
        int n9 = (n8 + n5 - n6) / 2;
        int n10 = this.textChars.length;
        int n11 = 0;
        while (n11 < n10) {
            n4 = this.textChars[n11];
            if (n4 == 10) {
                if (n11 > n7) {
                    switch (this.style.textAlign) {
                        case 1: {
                            n3 = n - fontMetrics.charsWidth(this.textChars, n7, n11 - n7);
                            break;
                        }
                        case 2: {
                            n3 = (n - fontMetrics.charsWidth(this.textChars, n7, n11 - n7)) / 2;
                            break;
                        }
                        default: {
                            n3 = this.style.textIndent > 0 ? (bl ? this.style.textIndent : 0) : (this.style.textIndent < 0 ? (bl ? 0 : -this.style.textIndent) : 0);
                        }
                    }
                    graphics.drawChars(this.textChars, n7, n11 - n7, n3, n9);
                    switch (this.style.textDecoration) {
                        case 1: {
                            n2 = n9 + n6 - 1;
                            int n12 = fontMetrics.charsWidth(this.textChars, n7, n11 - n7);
                            graphics.drawLine(n3, n2, n3 + n12 - 1, n2);
                            break;
                        }
                        case 2: {
                            n2 = n9 - n5 + 1;
                            int n12 = fontMetrics.charsWidth(this.textChars, n7, n11 - n7);
                            graphics.drawLine(n3, n2, n3 + n12 - 1, n2);
                            break;
                        }
                        case 3: {
                            n2 = n9 + (n6 - n5) / 2;
                            int n12 = fontMetrics.charsWidth(this.textChars, n7, n11 - n7);
                            graphics.drawLine(n3, n2, n3 + n12 - 1, n2);
                        }
                    }
                }
                bl = false;
                n7 = n11 + 1;
                n9 += n8;
            }
            ++n11;
        }
        if (n10 > n7) {
            switch (this.style.textAlign) {
                case 1: {
                    n3 = n - fontMetrics.charsWidth(this.textChars, n7, n10 - n7);
                    break;
                }
                case 2: {
                    n3 = (n - fontMetrics.charsWidth(this.textChars, n7, n10 - n7)) / 2;
                    break;
                }
                default: {
                    n3 = this.style.textIndent > 0 ? (bl ? this.style.textIndent : 0) : (this.style.textIndent < 0 ? (bl ? 0 : -this.style.textIndent) : 0);
                }
            }
            graphics.drawChars(this.textChars, n7, n10 - n7, n3, n9);
            switch (this.style.textDecoration) {
                case 1: {
                    n4 = n9 + n6 - 1;
                    n2 = fontMetrics.charsWidth(this.textChars, n7, n10 - n7);
                    graphics.drawLine(n3, n4, n3 + n2 - 1, n4);
                    break;
                }
                case 2: {
                    n4 = n9 - n5 + 1;
                    n2 = fontMetrics.charsWidth(this.textChars, n7, n10 - n7);
                    graphics.drawLine(n3, n4, n3 + n2 - 1, n4);
                    break;
                }
                case 3: {
                    n4 = n9 + (n6 - n5) / 2;
                    n2 = fontMetrics.charsWidth(this.textChars, n7, n10 - n7);
                    graphics.drawLine(n3, n4, n3 + n2 - 1, n4);
                }
            }
        }
    }

    public int getFirstBaseLine() {
        FontMetrics fontMetrics = this.getFontMetrics(this.style.font);
        int n = (int)(0.5 + (double)fontMetrics.getHeight() * this.style.lineHeight);
        int n2 = (n + fontMetrics.getAscent() - fontMetrics.getDescent()) / 2;
        return this.style.borderWidth + this.style.paddingTop + n2;
    }

    public int getLastBaseLine() {
        int n = 1;
        int n2 = this.textChars.length;
        int n3 = 0;
        while (n3 < n2) {
            if (this.textChars[n3] == '\n') {
                ++n;
            }
            ++n3;
        }
        FontMetrics fontMetrics = this.getFontMetrics(this.style.font);
        int n4 = (int)(0.5 + (double)fontMetrics.getHeight() * this.style.lineHeight);
        int n5 = (n4 + fontMetrics.getAscent() - fontMetrics.getDescent()) / 2;
        return this.style.borderWidth + this.style.paddingTop + (n5 + (n - 1) * n4);
    }
}

