/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.styledgadget;

import com.xmlmind.xmledit.gadget.CollapsibleGadget;
import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.gadget.GadgetContainer;
import com.xmlmind.xmledit.gadget.MenuItemSpec;
import com.xmlmind.xmledit.gadget.MenuSpec;
import com.xmlmind.xmledit.styledgadget.Box;
import com.xmlmind.xmledit.styledgadget.CollapsibleDivision;
import com.xmlmind.xmledit.styledgadget.Icon;
import com.xmlmind.xmledit.styledgadget.Msg;
import com.xmlmind.xmledit.styledgadget.Style;
import com.xmlmind.xmledit.styledgadget.StyledGadgetUtil;
import com.xmlmind.xmledit.util.PlatformUtil;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;

public class ToggleCollapsed
extends Box {
    private Image collapsedImage = Icon.get("collapsed-right");
    private Image expandedImage = Icon.get("expanded-down");
    private byte state = 0;
    private static final int COLLAPSIBLE = 1;
    private static final int COLLAPSED = 2;
    private static MenuSpec menuSpec = new MenuSpec(null, new MenuItemSpec[]{new MenuItemSpec(Msg.msg("TC.collapseAll"), null, null, "collapseAll"), new MenuItemSpec(Msg.msg("TC.expandAll"), null, null, "expandAll")});

    public ToggleCollapsed() {
        this(Box.DEFAULT_STYLE);
    }

    public ToggleCollapsed(Style style) {
        super(style);
    }

    public void setCollapsedImage(Image image) {
        this.collapsedImage = image;
    }

    public Image getCollapsedImage() {
        return this.collapsedImage;
    }

    public void setExpandedImage(Image image) {
        this.expandedImage = image;
    }

    public Image getExpandedImage() {
        return this.expandedImage;
    }

    public void layoutContent(int n, int n2, boolean bl) {
        this.width = this.collapsedImage.getWidth(null);
        this.height = this.collapsedImage.getHeight(null);
        this.updateState(this.findCollapsibleDivision());
    }

    public CollapsibleDivision findCollapsibleDivision() {
        Gadget gadget = this;
        while (gadget != null) {
            if (gadget instanceof CollapsibleDivision) {
                return (CollapsibleDivision)gadget;
            }
            gadget = gadget.parent;
        }
        return null;
    }

    public void updateState(CollapsibleDivision collapsibleDivision) {
        this.state = 0;
        if (collapsibleDivision != null && collapsibleDivision.isCollapsible()) {
            this.state = (byte)(this.state | 1);
            if (collapsibleDivision.isCollapsed()) {
                this.state = (byte)(this.state | 2);
            }
        }
    }

    protected void paintContent(Graphics graphics) {
        if ((this.state & 1) != 0) {
            Image image = (this.state & 2) != 0 ? this.collapsedImage : this.expandedImage;
            graphics.drawImage(image, 0, 0, null);
        } else {
            StyledGadgetUtil.drawDimmedIcon(graphics, this.expandedImage, 0, 0, StyledGadgetUtil.getDimmedColor(this.style));
        }
    }

    public boolean grabsMouseButton(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiers();
        return n == 16 || n == 4 || PlatformUtil.IS_MAC_OS && n == 18;
    }

    public void handleMouseEvent(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiers();
        if (n == 16 && mouseEvent.getID() == 500) {
            CollapsibleDivision collapsibleDivision = this.findCollapsibleDivision();
            if (collapsibleDivision != null && collapsibleDivision.isCollapsible()) {
                collapsibleDivision.setCollapsed(!collapsibleDivision.isCollapsed());
                collapsibleDivision.refresh();
            }
        } else if ((n == 4 || PlatformUtil.IS_MAC_OS && n == 18) && mouseEvent.getID() == 501) {
            this.showMenu(menuSpec, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public Object executeCommand(Gadget gadget, String string, int n, int n2) {
        CollapsibleDivision collapsibleDivision;
        if (string.equals("collapseAll")) {
            CollapsibleDivision collapsibleDivision2 = this.findCollapsibleDivision();
            if (collapsibleDivision2 != null) {
                ToggleCollapsed.collapseAll(collapsibleDivision2, true);
                collapsibleDivision2.refresh();
            }
        } else if (string.equals("expandAll") && (collapsibleDivision = this.findCollapsibleDivision()) != null) {
            ToggleCollapsed.collapseAll(collapsibleDivision, false);
            collapsibleDivision.refresh();
        }
        return null;
    }

    private static final void collapseAll(GadgetContainer gadgetContainer, boolean bl) {
        CollapsibleGadget collapsibleGadget;
        Gadget[] gadgetArray = gadgetContainer.getChildren();
        int n = 0;
        while (n < gadgetArray.length) {
            if (gadgetArray[n] instanceof GadgetContainer) {
                ToggleCollapsed.collapseAll((GadgetContainer)gadgetArray[n], bl);
            }
            ++n;
        }
        if (gadgetContainer instanceof CollapsibleGadget && (collapsibleGadget = (CollapsibleGadget)((Object)gadgetContainer)).isCollapsible()) {
            collapsibleGadget.setCollapsed(bl);
        }
    }
}

