/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.styledview;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.styledgadget.Style;
import com.xmlmind.xmledit.styledgadget.TextLabel;
import com.xmlmind.xmledit.styledview.CustomViewManager;
import com.xmlmind.xmledit.styledview.StyledElementView;
import com.xmlmind.xmledit.styledview.StyledElementViewPart;
import com.xmlmind.xmledit.styledview.StyledViewFactory;
import com.xmlmind.xmledit.view.DocumentView;
import com.xmlmind.xmledit.view.ElementView;
import com.xmlmind.xmledit.view.NodeView;
import com.xmlmind.xmledit.xmlutil.Name;

public final class CounterVP
extends TextLabel
implements StyledElementViewPart,
CustomViewManager.Counter {
    private StyledElementView view;
    private byte role;
    private int[] counterValues;
    private int[] nextCounterValues;
    private boolean[] counterMasks;
    private int counterStyle;
    private String countersSeparator;
    private static final int[] ROMAN_SPECIAL_NUMBERS = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
    private static final String[] ROMAN_UPPER_CASE_LETTERS = new String[]{"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};
    private static final String[] ROMAN_LOWER_CASE_LETTERS = new String[]{"m", "cm", "d", "cd", "c", "xc", "l", "xl", "x", "ix", "v", "iv", "i"};

    public CounterVP(Style style, String string, int n, String string2, StyledElementView styledElementView, int n2) {
        super(style);
        this.view = styledElementView;
        this.role = (byte)n2;
        int n3 = string.length();
        this.counterValues = new int[n3];
        this.nextCounterValues = new int[n3];
        this.counterMasks = new boolean[n3];
        int n4 = n3 - 1;
        while (n4 >= 0) {
            this.counterMasks[n4] = string.charAt(n4) != '-';
            this.counterValues[n4] = -1;
            this.nextCounterValues[n4] = 0;
            --n4;
        }
        this.counterStyle = n;
        if (string2 == null) {
            string2 = ".";
        }
        this.countersSeparator = string2;
    }

    public boolean isHierarchical() {
        return this.counterValues.length > 1;
    }

    public NodeView getView() {
        return this.view;
    }

    public ElementView getElementView() {
        return this.view;
    }

    public StyledElementView getStyledElementView() {
        return this.view;
    }

    public int getRole() {
        return this.role;
    }

    public void detachingViewFromModel(Document document, int n) {
        DocumentView documentView = (DocumentView)document.getDocumentListener(n, true);
        StyledViewFactory styledViewFactory = (StyledViewFactory)documentView.getViewFactory();
        styledViewFactory.getCustomViewManager().remove(this, this.view.getElement());
    }

    public void counterChanged() {
        CounterVP.getCounters(this.view.getElement(), this.nextCounterValues);
        boolean bl = false;
        int n = this.counterValues.length - 1;
        while (n >= 0) {
            if (this.nextCounterValues[n] != this.counterValues[n]) {
                bl = true;
                break;
            }
            --n;
        }
        if (!bl) {
            return;
        }
        int[] nArray = this.counterValues;
        this.counterValues = this.nextCounterValues;
        this.nextCounterValues = nArray;
        this.setText(this.getLabel());
        this.refresh();
    }

    private static final void getCounters(Element element, int[] nArray) {
        int n = nArray.length - 1;
        Element element2 = element.getParentElement();
        while (n >= 0) {
            if (element2 == null) {
                nArray[n] = 1;
            } else {
                nArray[n] = CounterVP.indexOfElement(element, element2);
                element = element2;
                element2 = element.getParentElement();
            }
            --n;
        }
    }

    private static final int indexOfElement(Element element, Element element2) {
        int n = 1;
        Name name = element.getName();
        Node node = element2.getFirstChild();
        while (node != null) {
            if (node instanceof Element) {
                if (node == element) break;
                if (((Element)node).getName() == name) {
                    ++n;
                }
            }
            node = node.getNextSibling();
        }
        return n;
    }

    private String getLabel() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.counterValues.length) {
            int n2;
            if (this.counterMasks[n] && (n2 = this.counterValues[n]) > 0) {
                if (n > 0) {
                    stringBuffer.append(this.countersSeparator);
                }
                switch (this.counterStyle) {
                    case 99: {
                        CounterVP.toAlpha(n2, true, stringBuffer);
                        break;
                    }
                    case 100: {
                        CounterVP.toAlpha(n2, false, stringBuffer);
                        break;
                    }
                    case 101: {
                        CounterVP.toRoman(n2, true, stringBuffer);
                        break;
                    }
                    case 102: {
                        CounterVP.toRoman(n2, false, stringBuffer);
                        break;
                    }
                    default: {
                        stringBuffer.append(Integer.toString(n2));
                    }
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public void customViewAdded() {
        this.counterChanged();
    }

    public void customViewRemoved() {
    }

    private static final void toAlpha(int n, boolean bl, StringBuffer stringBuffer) {
        while (n > 0) {
            int n2 = --n % 26;
            char c = (char)(65 + n2);
            if (bl) {
                c = Character.toLowerCase(c);
            }
            stringBuffer.insert(0, c);
            n /= 26;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static final void toRoman(int var0, boolean var1_1, StringBuffer var2_2) {
        var3_3 = var1_1 != false ? CounterVP.ROMAN_LOWER_CASE_LETTERS : CounterVP.ROMAN_UPPER_CASE_LETTERS;
        var4_4 = 0;
        ** GOTO lbl10
        {
            var2_2.append(var3_3[var4_4]);
            var0 -= CounterVP.ROMAN_SPECIAL_NUMBERS[var4_4];
            do {
                if (var0 >= CounterVP.ROMAN_SPECIAL_NUMBERS[var4_4]) continue block0;
                ++var4_4;
lbl10:
                // 2 sources

            } while (var4_4 < CounterVP.ROMAN_SPECIAL_NUMBERS.length);
        }
    }
}

