/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.styledview;

import com.xmlmind.xmledit.doc.BatchEditingEvent;
import com.xmlmind.xmledit.doc.Comment;
import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.DocumentEvent;
import com.xmlmind.xmledit.doc.DocumentListener;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.ElementAttributeEvent;
import com.xmlmind.xmledit.doc.ElementStructureEvent;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.ProcessingInstruction;
import com.xmlmind.xmledit.doc.ProcessingInstructionEvent;
import com.xmlmind.xmledit.doc.Text;
import com.xmlmind.xmledit.doc.TextEvent;
import com.xmlmind.xmledit.doc.TextNode;
import com.xmlmind.xmledit.doc.Traversal;
import com.xmlmind.xmledit.edit.ContextChangeEvent;
import com.xmlmind.xmledit.edit.ContextChangeListener;
import com.xmlmind.xmledit.edit.MarkManager;
import com.xmlmind.xmledit.edit.SimpleDocumentCache;
import com.xmlmind.xmledit.styledview.StyledViewFactory;
import com.xmlmind.xmledit.view.DocumentView;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.Namespace;
import com.xmlmind.xmledit.xpath.ExprContext;
import com.xmlmind.xmledit.xpath.SimpleExprContext;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;

public final class CustomViewManager
implements DocumentListener,
Traversal.Handler {
    private static final int COUNTER = 0;
    private static final int BASIC_ELEMENT_EDITOR = 1;
    private static final int SIMPLE_ELEMENT_EDITOR = 2;
    private static final int ELEMENT_EDITOR = 3;
    private static final int BASIC_ELEMENT_OBSERVER = 4;
    private static final int ATTRIBUTE_VALUE_EDITOR = 5;
    private static final int ELEMENT_VALUE_EDITOR = 6;
    private static final int XPATH_LABEL = 7;
    private static final int TYPE_COUNT = 8;
    private StyledViewFactory styledViewFactory;
    private Document doc = null;
    private boolean isDocListener = false;
    private CounterInfo[] counters = new CounterInfo[0];
    private boolean hasCounters = false;
    private BasicElementEditorInfo[] basicElementEditors = new BasicElementEditorInfo[0];
    private boolean hasBasicElementEditors = false;
    private SimpleElementEditorInfo[] simpleElementEditors = new SimpleElementEditorInfo[0];
    private boolean hasSimpleElementEditors = false;
    private ElementEditorInfo[] elementEditors = new ElementEditorInfo[0];
    private boolean hasElementEditors = false;
    private BasicElementObserverInfo[] basicElementObservers = new BasicElementObserverInfo[0];
    private boolean hasBasicElementObservers = false;
    private AttributeValueEditorInfo[] attributeValueEditors = new AttributeValueEditorInfo[0];
    private boolean hasAttributeValueEditors = false;
    private ElementValueEditorInfo[] elementValueEditors = new ElementValueEditorInfo[0];
    private boolean hasElementValueEditors = false;
    private XPathLabelInfo[] xpathLabels = new XPathLabelInfo[0];
    private XPathLabelManager xpathLabelManager = null;
    private boolean noTextListeners = true;
    private IdentityHashMap elementDependents = new IdentityHashMap();
    private boolean batchEditing = false;
    private boolean[] mustSweep = new boolean[8];
    private ArrayList pendingAdd = new ArrayList();
    private IdentityHashMap pendingNotify = new IdentityHashMap();
    private static final Info[] NO_INFO = new Info[0];
    private static final DocumentEvent[] NO_EVENTS = new DocumentEvent[0];
    private DocumentEvent[] events1 = new DocumentEvent[1];

    public CustomViewManager(StyledViewFactory styledViewFactory) {
        this.styledViewFactory = styledViewFactory;
    }

    public StyledViewFactory getStyledViewFactory() {
        return this.styledViewFactory;
    }

    public void add(Counter counter, boolean bl, Element element) {
        CounterInfo counterInfo = new CounterInfo(counter, bl, element);
        if (this.batchEditing) {
            this.pendingAdd.add(counterInfo);
        } else {
            this.counters = (CounterInfo[])this.doAdd(this.counters, counterInfo);
            this.hasCounters = true;
        }
    }

    public void add(BasicElementEditor basicElementEditor, Element element) {
        BasicElementEditorInfo basicElementEditorInfo = new BasicElementEditorInfo(basicElementEditor, element);
        if (this.batchEditing) {
            this.pendingAdd.add(basicElementEditorInfo);
        } else {
            this.basicElementEditors = (BasicElementEditorInfo[])this.doAdd(this.basicElementEditors, basicElementEditorInfo);
            this.hasBasicElementEditors = true;
        }
    }

    public void add(SimpleElementEditor simpleElementEditor, Element element) {
        SimpleElementEditorInfo simpleElementEditorInfo = new SimpleElementEditorInfo(simpleElementEditor, element);
        if (this.batchEditing) {
            this.pendingAdd.add(simpleElementEditorInfo);
        } else {
            this.simpleElementEditors = (SimpleElementEditorInfo[])this.doAdd(this.simpleElementEditors, simpleElementEditorInfo);
            this.hasSimpleElementEditors = true;
            this.noTextListeners = false;
        }
    }

    public void add(ElementEditor elementEditor, Element element) {
        ElementEditorInfo elementEditorInfo = new ElementEditorInfo(elementEditor, element);
        if (this.batchEditing) {
            this.pendingAdd.add(elementEditorInfo);
        } else {
            this.elementEditors = (ElementEditorInfo[])this.doAdd(this.elementEditors, elementEditorInfo);
            this.hasElementEditors = true;
            this.noTextListeners = false;
        }
    }

    public void add(BasicElementObserver basicElementObserver, NamePattern namePattern) {
        this.add(basicElementObserver, new NamePattern[]{namePattern});
    }

    public void add(BasicElementObserver basicElementObserver, NamePattern[] namePatternArray) {
        BasicElementObserverInfo basicElementObserverInfo = new BasicElementObserverInfo(basicElementObserver, namePatternArray);
        if (this.batchEditing) {
            this.pendingAdd.add(basicElementObserverInfo);
        } else {
            this.basicElementObservers = (BasicElementObserverInfo[])this.doAdd(this.basicElementObservers, basicElementObserverInfo);
            this.hasBasicElementObservers = true;
        }
    }

    public void add(AttributeValueEditor attributeValueEditor, Element element, Name name) {
        AttributeValueEditorInfo attributeValueEditorInfo = new AttributeValueEditorInfo(attributeValueEditor, element, name);
        if (this.batchEditing) {
            this.pendingAdd.add(attributeValueEditorInfo);
        } else {
            this.attributeValueEditors = (AttributeValueEditorInfo[])this.doAdd(this.attributeValueEditors, attributeValueEditorInfo);
            this.hasAttributeValueEditors = true;
        }
    }

    public void add(ElementValueEditor elementValueEditor, Element element) {
        ElementValueEditorInfo elementValueEditorInfo = new ElementValueEditorInfo(elementValueEditor, element);
        if (this.batchEditing) {
            this.pendingAdd.add(elementValueEditorInfo);
        } else {
            this.elementValueEditors = (ElementValueEditorInfo[])this.doAdd(this.elementValueEditors, elementValueEditorInfo);
            this.hasElementValueEditors = true;
            this.noTextListeners = false;
        }
    }

    public void add(XPathLabel xPathLabel, Element element) {
        XPathLabelInfo xPathLabelInfo = new XPathLabelInfo(xPathLabel, element);
        if (this.batchEditing) {
            this.pendingAdd.add(xPathLabelInfo);
        } else {
            this.xpathLabels = (XPathLabelInfo[])this.doAdd(this.xpathLabels, xPathLabelInfo);
            if (this.xpathLabelManager == null) {
                this.xpathLabelManager = new XPathLabelManager();
                this.noTextListeners = false;
            }
            this.xpathLabelManager.xpathLabelAdded(xPathLabel);
        }
    }

    private Info[] doAdd(Info[] infoArray, Info info) {
        int n = infoArray.length;
        Info[] infoArray2 = (Info[])Array.newInstance(infoArray.getClass().getComponentType(), n + 1);
        System.arraycopy(infoArray, 0, infoArray2, 0, n);
        infoArray2[n] = info;
        Element element = info.getModel();
        if (element != null) {
            Info[] infoArray3 = (Info[])this.elementDependents.get(element);
            if (infoArray3 == null) {
                infoArray3 = new Info[]{info};
            } else {
                Info[] infoArray4 = new Info[infoArray3.length + 1];
                System.arraycopy(infoArray3, 0, infoArray4, 0, infoArray3.length);
                infoArray4[infoArray3.length] = info;
                infoArray3 = infoArray4;
            }
            this.elementDependents.put(element, infoArray3);
        }
        info.getCustomView().customViewAdded();
        if (!this.isDocListener && this.doc != null) {
            this.doc.addDocumentListener(this, false);
            this.isDocListener = true;
        }
        return infoArray2;
    }

    public void remove(CustomView customView, Element element) {
        Info[] infoArray = (Info[])this.elementDependents.get(element);
        if (infoArray == null) {
            return;
        }
        if (!this.batchEditing) {
            this.initRemove();
        }
        ArrayList<Info> arrayList = new ArrayList<Info>();
        int n = 0;
        while (n < infoArray.length) {
            Info info = infoArray[n];
            if (info.getCustomView() == customView) {
                info.removed = true;
                this.mustSweep[info.type] = true;
            } else {
                arrayList.add(info);
            }
            ++n;
        }
        if (arrayList.size() > 0) {
            this.elementDependents.put(element, arrayList.toArray(NO_INFO));
        } else {
            this.elementDependents.remove(element);
        }
        if (!this.batchEditing) {
            this.finishRemove();
        }
    }

    public void remove(CustomView customView) {
        if (!this.batchEditing) {
            this.initRemove();
        }
        if (this.hasBasicElementObservers) {
            int n = 0;
            while (n < this.basicElementObservers.length) {
                BasicElementObserverInfo basicElementObserverInfo = this.basicElementObservers[n];
                if (basicElementObserverInfo.observer == customView) {
                    basicElementObserverInfo.removed = true;
                    this.mustSweep[basicElementObserverInfo.type] = true;
                }
                ++n;
            }
        }
        if (!this.batchEditing) {
            this.finishRemove();
        }
    }

    private void initRemove() {
        int n = 0;
        while (n < 8) {
            this.mustSweep[n] = false;
            ++n;
        }
    }

    private void finishRemove() {
        if (this.mustSweep[0]) {
            this.mustSweep[0] = false;
            this.counters = (CounterInfo[])CustomViewManager.sweep(this.counters);
            boolean bl = this.hasCounters = this.counters.length > 0;
        }
        if (this.mustSweep[1]) {
            this.mustSweep[1] = false;
            this.basicElementEditors = (BasicElementEditorInfo[])CustomViewManager.sweep(this.basicElementEditors);
            boolean bl = this.hasBasicElementEditors = this.basicElementEditors.length > 0;
        }
        if (this.mustSweep[2]) {
            this.mustSweep[2] = false;
            this.simpleElementEditors = (SimpleElementEditorInfo[])CustomViewManager.sweep(this.simpleElementEditors);
            boolean bl = this.hasSimpleElementEditors = this.simpleElementEditors.length > 0;
        }
        if (this.mustSweep[3]) {
            this.mustSweep[3] = false;
            this.elementEditors = (ElementEditorInfo[])CustomViewManager.sweep(this.elementEditors);
            boolean bl = this.hasElementEditors = this.elementEditors.length > 0;
        }
        if (this.mustSweep[4]) {
            this.mustSweep[4] = false;
            this.basicElementObservers = (BasicElementObserverInfo[])CustomViewManager.sweep(this.basicElementObservers);
            boolean bl = this.hasBasicElementObservers = this.basicElementObservers.length > 0;
        }
        if (this.mustSweep[5]) {
            this.mustSweep[5] = false;
            this.attributeValueEditors = (AttributeValueEditorInfo[])CustomViewManager.sweep(this.attributeValueEditors);
            boolean bl = this.hasAttributeValueEditors = this.attributeValueEditors.length > 0;
        }
        if (this.mustSweep[6]) {
            this.mustSweep[6] = false;
            this.elementValueEditors = (ElementValueEditorInfo[])CustomViewManager.sweep(this.elementValueEditors);
            boolean bl = this.hasElementValueEditors = this.elementValueEditors.length > 0;
        }
        if (this.mustSweep[7]) {
            this.mustSweep[7] = false;
            this.xpathLabels = (XPathLabelInfo[])CustomViewManager.sweep(this.xpathLabels);
            if (this.xpathLabels.length == 0) {
                this.xpathLabelManager.dispose();
                this.xpathLabelManager = null;
            }
        }
        this.noTextListeners = !this.hasSimpleElementEditors && !this.hasElementEditors && !this.hasElementValueEditors && this.xpathLabelManager == null;
    }

    private static final Info[] sweep(Info[] infoArray) {
        Info[] infoArray2;
        int n = 0;
        int n2 = 0;
        while (n2 < infoArray.length) {
            infoArray2 = infoArray[n2];
            if (!infoArray2.removed) {
                ++n;
            }
            ++n2;
        }
        infoArray2 = (Info[])Array.newInstance(infoArray.getClass().getComponentType(), n);
        n = 0;
        int n3 = 0;
        while (n3 < infoArray.length) {
            Info info = infoArray[n3];
            if (info.removed) {
                info.getCustomView().customViewRemoved();
            } else {
                infoArray2[n++] = info;
            }
            ++n3;
        }
        return infoArray2;
    }

    public void reset() {
        Document document = this.doc;
        this.setDocument(document);
    }

    public void setDocument(Document document) {
        if (this.doc != null) {
            Info info;
            int n;
            this.elementDependents.clear();
            if (this.hasCounters) {
                n = 0;
                while (n < this.counters.length) {
                    info = this.counters[n];
                    info.getCustomView().customViewRemoved();
                    ++n;
                }
                this.counters = new CounterInfo[0];
                this.hasCounters = false;
            }
            if (this.hasBasicElementEditors) {
                n = 0;
                while (n < this.basicElementEditors.length) {
                    info = this.basicElementEditors[n];
                    info.getCustomView().customViewRemoved();
                    ++n;
                }
                this.basicElementEditors = new BasicElementEditorInfo[0];
                this.hasBasicElementEditors = false;
            }
            if (this.hasSimpleElementEditors) {
                n = 0;
                while (n < this.simpleElementEditors.length) {
                    info = this.simpleElementEditors[n];
                    info.getCustomView().customViewRemoved();
                    ++n;
                }
                this.simpleElementEditors = new SimpleElementEditorInfo[0];
                this.hasSimpleElementEditors = false;
            }
            if (this.hasElementEditors) {
                n = 0;
                while (n < this.elementEditors.length) {
                    info = this.elementEditors[n];
                    info.getCustomView().customViewRemoved();
                    ++n;
                }
                this.elementEditors = new ElementEditorInfo[0];
                this.hasElementEditors = false;
            }
            if (this.hasBasicElementObservers) {
                n = 0;
                while (n < this.basicElementObservers.length) {
                    info = this.basicElementObservers[n];
                    info.getCustomView().customViewRemoved();
                    ++n;
                }
                this.basicElementObservers = new BasicElementObserverInfo[0];
                this.hasBasicElementObservers = false;
            }
            if (this.hasAttributeValueEditors) {
                n = 0;
                while (n < this.attributeValueEditors.length) {
                    info = this.attributeValueEditors[n];
                    info.getCustomView().customViewRemoved();
                    ++n;
                }
                this.attributeValueEditors = new AttributeValueEditorInfo[0];
                this.hasAttributeValueEditors = false;
            }
            if (this.hasElementValueEditors) {
                n = 0;
                while (n < this.elementValueEditors.length) {
                    info = this.elementValueEditors[n];
                    info.getCustomView().customViewRemoved();
                    ++n;
                }
                this.elementValueEditors = new ElementValueEditorInfo[0];
                this.hasElementValueEditors = false;
            }
            if (this.xpathLabelManager != null) {
                n = 0;
                while (n < this.xpathLabels.length) {
                    info = this.xpathLabels[n];
                    info.getCustomView().customViewRemoved();
                    ++n;
                }
                this.xpathLabelManager.dispose();
                this.xpathLabelManager = null;
            }
            this.noTextListeners = true;
            this.batchEditing = false;
            this.pendingAdd.clear();
            this.pendingNotify.clear();
            this.initRemove();
            this.doc.removeDocumentListener(this);
            this.doc = null;
            this.isDocListener = false;
        }
        if (document != null) {
            this.doc = document;
            if (this.hasBasicElementObservers) {
                this.doc.addDocumentListener(this, false);
                this.isDocListener = true;
            }
        }
    }

    public Document getDocument() {
        return this.doc;
    }

    public void batchEditingStarted(BatchEditingEvent batchEditingEvent, int n) {
        this.batchEditing = true;
        this.pendingAdd.clear();
        this.pendingNotify.clear();
        this.initRemove();
        if (this.hasElementEditors) {
            int n2 = 0;
            while (n2 < this.elementEditors.length) {
                this.elementEditors[n2].editor.batchEditingStarted(batchEditingEvent, n);
                ++n2;
            }
        }
    }

    public void batchEditingCompleted(BatchEditingEvent batchEditingEvent, int n) {
        Info info;
        this.batchEditing = false;
        if (this.pendingNotify.size() > 0) {
            Iterator iterator = this.pendingNotify.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                info = (Info)entry.getKey();
                if (info.removed) continue;
                switch (info.type) {
                    case 0: {
                        ((CounterInfo)info).counter.counterChanged();
                        break;
                    }
                    case 1: 
                    case 2: {
                        ((BasicElementEditorInfo)info).editor.elementChanged(((ArrayList)entry.getValue()).toArray(NO_EVENTS));
                        break;
                    }
                    case 4: {
                        ((BasicElementObserverInfo)info).observer.elementChanged(((ArrayList)entry.getValue()).toArray(NO_EVENTS));
                        break;
                    }
                    case 5: {
                        ((AttributeValueEditorInfo)info).editor.attributeValueChanged(((ArrayList)entry.getValue()).toArray(NO_EVENTS));
                        break;
                    }
                    case 6: {
                        ((ElementValueEditorInfo)info).editor.elementValueChanged();
                    }
                }
            }
            this.pendingNotify.clear();
        }
        if (this.hasElementEditors) {
            int n2 = 0;
            while (n2 < this.elementEditors.length) {
                this.elementEditors[n2].editor.batchEditingCompleted(batchEditingEvent, n);
                ++n2;
            }
        }
        if (this.xpathLabelManager != null) {
            this.xpathLabelManager.checkMustNotify();
        }
        this.finishRemove();
        int n3 = this.pendingAdd.size();
        if (n3 > 0) {
            int n4 = 0;
            while (n4 < n3) {
                info = (Info)this.pendingAdd.get(n4);
                switch (info.type) {
                    case 0: {
                        this.counters = (CounterInfo[])this.doAdd(this.counters, info);
                        this.hasCounters = true;
                        break;
                    }
                    case 1: {
                        this.basicElementEditors = (BasicElementEditorInfo[])this.doAdd(this.basicElementEditors, info);
                        this.hasBasicElementEditors = true;
                        break;
                    }
                    case 2: {
                        this.simpleElementEditors = (SimpleElementEditorInfo[])this.doAdd(this.simpleElementEditors, info);
                        this.hasSimpleElementEditors = true;
                        break;
                    }
                    case 3: {
                        this.elementEditors = (ElementEditorInfo[])this.doAdd(this.elementEditors, info);
                        this.hasElementEditors = true;
                        break;
                    }
                    case 4: {
                        this.basicElementObservers = (BasicElementObserverInfo[])this.doAdd(this.basicElementObservers, info);
                        this.hasBasicElementObservers = true;
                        break;
                    }
                    case 5: {
                        this.attributeValueEditors = (AttributeValueEditorInfo[])this.doAdd(this.attributeValueEditors, info);
                        this.hasAttributeValueEditors = true;
                        break;
                    }
                    case 6: {
                        this.elementValueEditors = (ElementValueEditorInfo[])this.doAdd(this.elementValueEditors, info);
                        this.hasElementValueEditors = true;
                        break;
                    }
                    case 7: {
                        this.xpathLabels = (XPathLabelInfo[])this.doAdd(this.xpathLabels, info);
                        if (this.xpathLabelManager == null) {
                            this.xpathLabelManager = new XPathLabelManager();
                        }
                        this.xpathLabelManager.xpathLabelAdded(((XPathLabelInfo)info).xpathLabel);
                    }
                }
                ++n4;
            }
            this.pendingAdd.clear();
            this.noTextListeners = !this.hasSimpleElementEditors && !this.hasElementEditors && !this.hasElementValueEditors && this.xpathLabelManager == null;
        }
    }

    public void elementStructureChanged(ElementStructureEvent elementStructureEvent, int n) {
        Object object;
        Object object2;
        int n2;
        boolean bl;
        int n3;
        Node node = elementStructureEvent.getOldChild();
        int n4 = n3 = node == null ? -1 : node.getNodeType();
        if (n3 == 4) {
            this.elementRemoved((Element)node);
        }
        Element element = elementStructureEvent.getElementSource();
        Node node2 = elementStructureEvent.getNewChild();
        int n5 = node2 == null ? -1 : node2.getNodeType();
        boolean bl2 = n3 == 4 || n5 == 4;
        boolean bl3 = bl = n3 == 0 || n5 == 0;
        if (this.hasElementValueEditors && (bl2 || bl)) {
            n2 = 0;
            while (n2 < this.elementValueEditors.length) {
                object2 = this.elementValueEditors[n2];
                if (((ElementValueEditorInfo)object2).element == element) {
                    if (this.batchEditing) {
                        this.pendingNotify.put(object2, object2);
                    } else {
                        ((ElementValueEditorInfo)object2).editor.elementValueChanged();
                    }
                }
                ++n2;
            }
        }
        if (this.hasCounters && bl2) {
            n2 = 0;
            while (n2 < this.counters.length) {
                object2 = this.counters[n2];
                object = ((CounterInfo)object2).element.getParent();
                if (element == object || ((CounterInfo)object2).hierarchical && element.isAncestorOf((Node)object)) {
                    if (this.batchEditing) {
                        this.pendingNotify.put(object2, object2);
                    } else {
                        ((CounterInfo)object2).counter.counterChanged();
                    }
                }
                ++n2;
            }
        }
        if (this.hasBasicElementEditors && bl2) {
            n2 = 0;
            while (n2 < this.basicElementEditors.length) {
                object2 = this.basicElementEditors[n2];
                if (((BasicElementEditorInfo)object2).element.isAncestorOf(element)) {
                    if (this.batchEditing) {
                        this.pendingNotifyAdd((Info)object2, elementStructureEvent);
                    } else {
                        this.events1[0] = elementStructureEvent;
                        ((BasicElementEditorInfo)object2).editor.elementChanged(this.events1);
                    }
                }
                ++n2;
            }
        }
        if (this.hasSimpleElementEditors && (bl2 || bl)) {
            n2 = 0;
            while (n2 < this.simpleElementEditors.length) {
                object2 = this.simpleElementEditors[n2];
                if (((SimpleElementEditorInfo)object2).element.isAncestorOf(element)) {
                    if (this.batchEditing) {
                        this.pendingNotifyAdd((Info)object2, elementStructureEvent);
                    } else {
                        this.events1[0] = elementStructureEvent;
                        ((SimpleElementEditorInfo)object2).editor.elementChanged(this.events1);
                    }
                }
                ++n2;
            }
        }
        if (this.hasElementEditors) {
            n2 = 0;
            while (n2 < this.elementEditors.length) {
                object2 = this.elementEditors[n2];
                if (((ElementEditorInfo)object2).element.isAncestorOf(element)) {
                    ((ElementEditorInfo)object2).editor.elementStructureChanged(elementStructureEvent, n);
                }
                ++n2;
            }
        }
        if (this.hasBasicElementObservers && bl2) {
            Name name = element.getName();
            object2 = name.getNamespace();
            object = name.getLocalPart();
            int n6 = 0;
            while (n6 < this.basicElementObservers.length) {
                BasicElementObserverInfo basicElementObserverInfo = this.basicElementObservers[n6];
                if (CustomViewManager.match((Namespace)object2, (String)object, basicElementObserverInfo.patterns)) {
                    if (this.batchEditing) {
                        this.pendingNotifyAdd(basicElementObserverInfo, elementStructureEvent);
                    } else {
                        this.events1[0] = elementStructureEvent;
                        basicElementObserverInfo.observer.elementChanged(this.events1);
                    }
                }
                ++n6;
            }
        }
        if (this.xpathLabelManager != null) {
            this.xpathLabelManager.setMustNotify();
        }
    }

    private void elementRemoved(Element element) {
        if (!this.batchEditing) {
            this.initRemove();
        }
        Traversal.traverse(element, this);
        if (!this.batchEditing) {
            this.finishRemove();
        }
    }

    public Object enterElement(Element element) {
        Info[] infoArray = (Info[])this.elementDependents.remove(element);
        if (infoArray != null) {
            int n = 0;
            while (n < infoArray.length) {
                Info info = infoArray[n];
                info.removed = true;
                this.mustSweep[info.type] = true;
                ++n;
            }
        }
        return null;
    }

    public Object leaveElement(Element element) {
        return null;
    }

    public Object processText(Text text) {
        return null;
    }

    public Object processPI(ProcessingInstruction processingInstruction) {
        return null;
    }

    public Object processComment(Comment comment) {
        return null;
    }

    private void pendingNotifyAdd(Info info, DocumentEvent documentEvent) {
        ArrayList<DocumentEvent> arrayList = (ArrayList<DocumentEvent>)this.pendingNotify.get(info);
        if (arrayList == null) {
            arrayList = new ArrayList<DocumentEvent>();
        }
        arrayList.add(documentEvent.copy());
        this.pendingNotify.put(info, arrayList);
    }

    private static final boolean match(Namespace namespace, String string, NamePattern[] namePatternArray) {
        int n = 0;
        while (n < namePatternArray.length) {
            NamePattern namePattern = namePatternArray[n];
            if (!(namePattern.namespace != null && namePattern.namespace != namespace || namePattern.localPart != null && !namePattern.localPart.equals(string))) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void elementAttributeChanged(ElementAttributeEvent elementAttributeEvent, int n) {
        Object object;
        Name name;
        Element element = elementAttributeEvent.getElementSource();
        if (this.hasAttributeValueEditors) {
            name = elementAttributeEvent.getName();
            int n2 = 0;
            while (n2 < this.attributeValueEditors.length) {
                object = this.attributeValueEditors[n2];
                if (((AttributeValueEditorInfo)object).element == element && (((AttributeValueEditorInfo)object).attributeName == null || ((AttributeValueEditorInfo)object).attributeName == name)) {
                    if (this.batchEditing) {
                        this.pendingNotifyAdd((Info)object, elementAttributeEvent);
                    } else {
                        this.events1[0] = elementAttributeEvent;
                        ((AttributeValueEditorInfo)object).editor.attributeValueChanged(this.events1);
                    }
                }
                ++n2;
            }
        }
        if (this.hasBasicElementEditors) {
            int n3 = 0;
            while (n3 < this.basicElementEditors.length) {
                BasicElementEditorInfo basicElementEditorInfo = this.basicElementEditors[n3];
                if (basicElementEditorInfo.element.isAncestorOf(element)) {
                    if (this.batchEditing) {
                        this.pendingNotifyAdd(basicElementEditorInfo, elementAttributeEvent);
                    } else {
                        this.events1[0] = elementAttributeEvent;
                        basicElementEditorInfo.editor.elementChanged(this.events1);
                    }
                }
                ++n3;
            }
        }
        if (this.hasSimpleElementEditors) {
            int n4 = 0;
            while (n4 < this.simpleElementEditors.length) {
                SimpleElementEditorInfo simpleElementEditorInfo = this.simpleElementEditors[n4];
                if (simpleElementEditorInfo.element.isAncestorOf(element)) {
                    if (this.batchEditing) {
                        this.pendingNotifyAdd(simpleElementEditorInfo, elementAttributeEvent);
                    } else {
                        this.events1[0] = elementAttributeEvent;
                        simpleElementEditorInfo.editor.elementChanged(this.events1);
                    }
                }
                ++n4;
            }
        }
        if (this.hasElementEditors) {
            int n5 = 0;
            while (n5 < this.elementEditors.length) {
                ElementEditorInfo elementEditorInfo = this.elementEditors[n5];
                if (elementEditorInfo.element.isAncestorOf(element)) {
                    elementEditorInfo.editor.elementAttributeChanged(elementAttributeEvent, n);
                }
                ++n5;
            }
        }
        if (this.hasBasicElementObservers) {
            name = element.getName();
            Namespace namespace = name.getNamespace();
            object = name.getLocalPart();
            int n6 = 0;
            while (n6 < this.basicElementObservers.length) {
                BasicElementObserverInfo basicElementObserverInfo = this.basicElementObservers[n6];
                if (CustomViewManager.match(namespace, (String)object, basicElementObserverInfo.patterns)) {
                    if (this.batchEditing) {
                        this.pendingNotifyAdd(basicElementObserverInfo, elementAttributeEvent);
                    } else {
                        this.events1[0] = elementAttributeEvent;
                        basicElementObserverInfo.observer.elementChanged(this.events1);
                    }
                }
                ++n6;
            }
        }
        if (this.xpathLabelManager != null) {
            this.xpathLabelManager.setMustNotify();
        }
    }

    public void textChanged(TextEvent textEvent, int n) {
        Info info;
        int n2;
        Element element;
        TextNode textNode;
        if (this.noTextListeners) {
            return;
        }
        if (this.xpathLabelManager != null) {
            this.xpathLabelManager.mustNotify = true;
        }
        if (this.hasElementValueEditors) {
            textNode = textEvent.getTextSource();
            element = textNode.getParentElement();
            if (textNode instanceof Text) {
                n2 = 0;
                while (n2 < this.elementValueEditors.length) {
                    info = this.elementValueEditors[n2];
                    if (info.element == element) {
                        if (this.batchEditing) {
                            this.pendingNotify.put(info, info);
                        } else {
                            info.editor.elementValueChanged();
                        }
                    }
                    ++n2;
                }
            }
        }
        if (this.hasSimpleElementEditors) {
            textNode = textEvent.getTextSource();
            element = textNode.getParentElement();
            if (textNode instanceof Text) {
                n2 = 0;
                while (n2 < this.simpleElementEditors.length) {
                    info = this.simpleElementEditors[n2];
                    if (((SimpleElementEditorInfo)info).element.isAncestorOf(element)) {
                        if (this.batchEditing) {
                            this.pendingNotifyAdd(info, textEvent);
                        } else {
                            this.events1[0] = textEvent;
                            ((SimpleElementEditorInfo)info).editor.elementChanged(this.events1);
                        }
                    }
                    ++n2;
                }
            }
        }
        if (this.hasElementEditors) {
            textNode = textEvent.getTextSource();
            element = textNode.getParentElement();
            n2 = 0;
            while (n2 < this.elementEditors.length) {
                info = this.elementEditors[n2];
                if (((ElementEditorInfo)info).element.isAncestorOf(element)) {
                    ((ElementEditorInfo)info).editor.textChanged(textEvent, n);
                }
                ++n2;
            }
        }
    }

    public void processingInstructionChanged(ProcessingInstructionEvent processingInstructionEvent, int n) {
        if (this.hasElementEditors) {
            Element element = processingInstructionEvent.getProcessingInstructionSource().getParentElement();
            int n2 = 0;
            while (n2 < this.elementEditors.length) {
                ElementEditorInfo elementEditorInfo = this.elementEditors[n2];
                if (elementEditorInfo.element.isAncestorOf(element)) {
                    elementEditorInfo.editor.processingInstructionChanged(processingInstructionEvent, n);
                }
                ++n2;
            }
        }
        if (this.xpathLabelManager != null) {
            this.xpathLabelManager.setMustNotify();
        }
    }

    public void customEventHappened(DocumentEvent documentEvent, int n) {
        int n2;
        if (documentEvent.getId() == 102) {
            Info info;
            if (this.hasAttributeValueEditors) {
                n2 = 0;
                while (n2 < this.attributeValueEditors.length) {
                    info = this.attributeValueEditors[n2];
                    info.editor.commitChanges();
                    ++n2;
                }
            }
            if (this.hasElementValueEditors) {
                n2 = 0;
                while (n2 < this.elementValueEditors.length) {
                    info = this.elementValueEditors[n2];
                    ((ElementValueEditorInfo)info).editor.commitChanges();
                    ++n2;
                }
            }
            if (this.hasBasicElementEditors) {
                n2 = 0;
                while (n2 < this.basicElementEditors.length) {
                    info = this.basicElementEditors[n2];
                    ((BasicElementEditorInfo)info).editor.commitChanges();
                    ++n2;
                }
            }
            if (this.hasSimpleElementEditors) {
                n2 = 0;
                while (n2 < this.simpleElementEditors.length) {
                    info = this.simpleElementEditors[n2];
                    ((SimpleElementEditorInfo)info).editor.commitChanges();
                    ++n2;
                }
            }
            if (this.xpathLabelManager != null) {
                this.xpathLabelManager.setMustNotify();
            }
        }
        if (this.hasElementEditors) {
            n2 = 0;
            while (n2 < this.elementEditors.length) {
                this.elementEditors[n2].editor.customEventHappened(documentEvent, n);
                ++n2;
            }
        }
    }

    private final class XPathLabelManager
    implements ContextChangeListener {
        private SimpleExprContext exprContext;
        private MarkManager markManager;
        public boolean mustNotify = false;

        public XPathLabelManager() {
            SimpleDocumentCache.installDefaultDocumentManager();
            this.exprContext = new SimpleExprContext();
        }

        public void dispose() {
            if (this.markManager != null) {
                this.markManager.removeContextChangeListener(this);
            }
        }

        public void xpathLabelAdded(XPathLabel xPathLabel) {
            if (this.markManager == null) {
                DocumentView documentView = CustomViewManager.this.styledViewFactory.getDocumentView();
                this.markManager = documentView.getMarkManager();
                if (this.markManager != null) {
                    this.markManager.addContextChangeListener(this);
                }
            }
            this.exprContext.reset();
            xPathLabel.documentChanged(this.exprContext);
        }

        public void checkMustNotify() {
            if (this.mustNotify) {
                this.notifyXPathLabels();
                this.mustNotify = false;
            }
        }

        private void notifyXPathLabels() {
            this.exprContext.reset();
            XPathLabelInfo[] xPathLabelInfoArray = CustomViewManager.this.xpathLabels;
            int n = 0;
            while (n < xPathLabelInfoArray.length) {
                XPathLabelInfo xPathLabelInfo = xPathLabelInfoArray[n];
                if (!xPathLabelInfo.removed) {
                    xPathLabelInfo.xpathLabel.documentChanged(this.exprContext);
                }
                ++n;
            }
        }

        public void setMustNotify() {
            this.mustNotify = true;
            if (!CustomViewManager.this.batchEditing) {
                this.notifyXPathLabels();
                this.mustNotify = false;
            }
        }

        public void contextChanged(ContextChangeEvent contextChangeEvent) {
            if (!CustomViewManager.this.batchEditing) {
                this.checkMustNotify();
            }
        }
    }

    private static class XPathLabelInfo
    extends Info {
        public XPathLabel xpathLabel;
        public Element element;

        public XPathLabelInfo(XPathLabel xPathLabel, Element element) {
            super(7);
            this.xpathLabel = xPathLabel;
            this.element = element;
        }

        public CustomView getCustomView() {
            return this.xpathLabel;
        }

        public Element getModel() {
            return this.element;
        }
    }

    private static class ElementValueEditorInfo
    extends Info {
        public ElementValueEditor editor;
        public Element element;

        public ElementValueEditorInfo(ElementValueEditor elementValueEditor, Element element) {
            super(6);
            this.editor = elementValueEditor;
            this.element = element;
        }

        public CustomView getCustomView() {
            return this.editor;
        }

        public Element getModel() {
            return this.element;
        }
    }

    private static class AttributeValueEditorInfo
    extends Info {
        public AttributeValueEditor editor;
        public Element element;
        public Name attributeName;

        public AttributeValueEditorInfo(AttributeValueEditor attributeValueEditor, Element element, Name name) {
            super(5);
            this.editor = attributeValueEditor;
            this.element = element;
            this.attributeName = name;
        }

        public CustomView getCustomView() {
            return this.editor;
        }

        public Element getModel() {
            return this.element;
        }
    }

    private static class BasicElementObserverInfo
    extends Info {
        public BasicElementObserver observer;
        public NamePattern[] patterns;

        public BasicElementObserverInfo(BasicElementObserver basicElementObserver, NamePattern[] namePatternArray) {
            super(4);
            this.observer = basicElementObserver;
            this.patterns = namePatternArray;
        }

        public CustomView getCustomView() {
            return this.observer;
        }

        public Element getModel() {
            return null;
        }
    }

    private static final class ElementEditorInfo
    extends Info {
        public ElementEditor editor;
        public Element element;

        public ElementEditorInfo(ElementEditor elementEditor, Element element) {
            super(3);
            this.editor = elementEditor;
            this.element = element;
        }

        public CustomView getCustomView() {
            return this.editor;
        }

        public Element getModel() {
            return this.element;
        }
    }

    private static final class SimpleElementEditorInfo
    extends BasicElementEditorInfo {
        public SimpleElementEditorInfo(SimpleElementEditor simpleElementEditor, Element element) {
            super(simpleElementEditor, element);
            this.type = (byte)2;
        }
    }

    private static class BasicElementEditorInfo
    extends Info {
        public BasicElementEditor editor;
        public Element element;

        public BasicElementEditorInfo(BasicElementEditor basicElementEditor, Element element) {
            super(1);
            this.editor = basicElementEditor;
            this.element = element;
        }

        public CustomView getCustomView() {
            return this.editor;
        }

        public Element getModel() {
            return this.element;
        }
    }

    private static final class CounterInfo
    extends Info {
        public Counter counter;
        public boolean hierarchical;
        public Element element;

        public CounterInfo(Counter counter, boolean bl, Element element) {
            super(0);
            this.counter = counter;
            this.hierarchical = bl;
            this.element = element;
        }

        public CustomView getCustomView() {
            return this.counter;
        }

        public Element getModel() {
            return this.element;
        }
    }

    private static abstract class Info {
        public byte type;
        public boolean removed = false;

        protected Info(int n) {
            this.type = (byte)n;
        }

        public abstract CustomView getCustomView();

        public abstract Element getModel();
    }

    public static interface XPathLabel
    extends CustomView {
        public void documentChanged(ExprContext var1);
    }

    public static interface ElementValueEditor
    extends CustomEditor {
        public void elementValueChanged();
    }

    public static interface AttributeValueEditor
    extends CustomEditor {
        public void attributeValueChanged(DocumentEvent[] var1);
    }

    public static final class NamePattern {
        private Namespace namespace;
        private String localPart;

        public NamePattern(Namespace namespace, String string) {
            this.namespace = namespace;
            this.localPart = string;
        }

        public Namespace getNamespace() {
            return this.namespace;
        }

        public String getLocalPart() {
            return this.localPart;
        }
    }

    public static interface BasicElementObserver
    extends CustomView {
        public void elementChanged(DocumentEvent[] var1);
    }

    public static interface ElementEditor
    extends CustomView,
    DocumentListener {
    }

    public static interface SimpleElementEditor
    extends BasicElementEditor {
    }

    public static interface BasicElementEditor
    extends CustomEditor {
        public void elementChanged(DocumentEvent[] var1);
    }

    public static interface Counter
    extends CustomView {
        public void counterChanged();
    }

    public static interface CustomEditor
    extends CustomView {
        public void commitChanges();
    }

    public static interface CustomView {
        public void customViewAdded();

        public void customViewRemoved();
    }
}

