/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.styledview;

import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.TextAccess;
import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.styledgadget.Paragraph;
import com.xmlmind.xmledit.styledgadget.ParagraphText;
import com.xmlmind.xmledit.styledgadget.Style;
import com.xmlmind.xmledit.styledview.GroupView;
import com.xmlmind.xmledit.styledview.ParagraphTextVP;
import com.xmlmind.xmledit.styledview.StyledElementView;
import com.xmlmind.xmledit.styledview.StyledElementViewPart;
import com.xmlmind.xmledit.styledview.StyledViewFactory;
import com.xmlmind.xmledit.styledview.TextLabelVP;
import com.xmlmind.xmledit.styledview.ViewParameters;
import com.xmlmind.xmledit.view.GadgetList;

public class InlineGroupView
extends GroupView {
    private Gadget[] startLabelGadgets = null;
    private Gadget[] customViewGadgets = null;
    private Gadget[] endLabelGadgets = null;

    public InlineGroupView(Element element, Style style) {
        super(element, style);
    }

    public void initView(ViewParameters viewParameters, ViewParameters viewParameters2, Style style, ViewParameters viewParameters3, Style style2, StyledViewFactory styledViewFactory) {
        if (viewParameters2 != null && viewParameters2.content != null) {
            this.startLabelGadgets = this.convertTextLabels(viewParameters2.content, 2);
        }
        if (viewParameters.content != null) {
            this.customViewGadgets = this.convertTextLabels(viewParameters.content, 3);
        }
        if (viewParameters3 != null && viewParameters3.content != null) {
            this.endLabelGadgets = this.convertTextLabels(viewParameters3.content, 4);
        }
    }

    private Gadget[] convertTextLabels(StyledElementViewPart[] styledElementViewPartArray, int n) {
        Gadget[] gadgetArray = new Gadget[styledElementViewPartArray.length];
        int n2 = 0;
        while (n2 < styledElementViewPartArray.length) {
            StyledElementViewPart styledElementViewPart = styledElementViewPartArray[n2];
            if (styledElementViewPart instanceof TextLabelVP) {
                TextLabelVP textLabelVP = (TextLabelVP)styledElementViewPart;
                styledElementViewPart = new ParagraphTextVP(textLabelVP.getStyle(), textLabelVP.getText(), (StyledElementView)this, n);
            }
            gadgetArray[n2] = (Gadget)((Object)styledElementViewPart);
            ++n2;
        }
        return gadgetArray;
    }

    public boolean isCustomView() {
        return this.customViewGadgets != null;
    }

    public boolean isInlineView() {
        return true;
    }

    public Gadget[] getStartLabelGadgets() {
        return this.startLabelGadgets;
    }

    public Gadget[] getCustomViewGadgets() {
        return this.customViewGadgets;
    }

    public Gadget[] getEndLabelGadgets() {
        return this.endLabelGadgets;
    }

    public void getStartLabelGadgets(GadgetList gadgetList) {
        if (this.startLabelGadgets != null) {
            InlineGroupView.appendGadgets(this.startLabelGadgets, gadgetList);
        }
    }

    public void getCustomViewGadgets(GadgetList gadgetList) {
        if (this.customViewGadgets != null) {
            InlineGroupView.appendGadgets(this.customViewGadgets, gadgetList);
        }
    }

    public void getEndLabelGadgets(GadgetList gadgetList) {
        if (this.endLabelGadgets != null) {
            InlineGroupView.appendGadgets(this.endLabelGadgets, gadgetList);
        }
    }

    private static final void appendGadgets(Gadget[] gadgetArray, GadgetList gadgetList) {
        int n = 0;
        while (n < gadgetArray.length) {
            Gadget gadget = gadgetArray[n];
            if (gadget instanceof ParagraphText && gadget.parent != null) {
                TextAccess textAccess = ((ParagraphText)gadget).getTextAccess();
                ((Paragraph)gadget.parent).getParagraphTexts(textAccess, gadgetList);
            } else {
                gadgetList.appendGadget(gadget);
            }
            ++n;
        }
    }
}

