/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.styledview;

import com.xmlmind.xmledit.doc.Comment;
import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.ProcessingInstruction;
import com.xmlmind.xmledit.doc.Text;
import com.xmlmind.xmledit.doc.TextNode;
import com.xmlmind.xmledit.edit.MarkManager;
import com.xmlmind.xmledit.edit.TextLocation;
import com.xmlmind.xmledit.gadget.ComponentImage;
import com.xmlmind.xmledit.gadget.ComponentWrapper;
import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.gadget.GadgetContainer;
import com.xmlmind.xmledit.styledview.StyledDocumentPane;
import com.xmlmind.xmledit.styledview.StyledDocumentView;
import com.xmlmind.xmledit.styledview.StyledElementViewPart;
import com.xmlmind.xmledit.styledview.StyledTraversal;
import com.xmlmind.xmledit.view.DocumentFocusTraversalPolicy;
import com.xmlmind.xmledit.view.DocumentView;
import com.xmlmind.xmledit.view.ElementView;
import com.xmlmind.xmledit.view.GadgetListImpl;
import com.xmlmind.xmledit.view.TextNodeView;
import com.xmlmind.xmledit.view.TextNodeViewText;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.LayoutFocusTraversalPolicy;

public class StyledDocFocusTraversalPolicy
extends LayoutFocusTraversalPolicy
implements StyledTraversal.Handler,
Comparator {
    public static final StyledDocFocusTraversalPolicy INSTANCE = new StyledDocFocusTraversalPolicy();
    private boolean backwards = false;
    private boolean skipGeneratedContent = false;
    private StyledDocumentPane docPane = null;
    private StyledDocumentView docView = null;
    private int viewIndex = -1;
    private StyledDocumentPane docPane2 = null;
    private Comparator comparator = null;
    private ComponentImage lastComponentImage = null;
    private Focusable focused = new Focusable();
    private Focusable focusable = new Focusable();
    private Focusable[] focusables1 = new Focusable[1];
    private GadgetListImpl gadgetList = new GadgetListImpl();
    private Point point = new Point();
    private ArrayList list = new ArrayList();

    public Component getComponentAfter(Container container, Component component) {
        if (container instanceof StyledDocumentPane) {
            return this.doGetComponentAfter((StyledDocumentPane)container, component);
        }
        return super.getComponentAfter(container, component);
    }

    public Component getComponentBefore(Container container, Component component) {
        if (container instanceof StyledDocumentPane) {
            return this.doGetComponentBefore((StyledDocumentPane)container, component);
        }
        return super.getComponentBefore(container, component);
    }

    public Component getFirstComponent(Container container) {
        if (container instanceof StyledDocumentPane) {
            return this.doGetFirstComponent((StyledDocumentPane)container);
        }
        return super.getFirstComponent(container);
    }

    public Component getLastComponent(Container container) {
        if (container instanceof StyledDocumentPane) {
            return this.doGetLastComponent((StyledDocumentPane)container);
        }
        return super.getLastComponent(container);
    }

    public Component getDefaultComponent(Container container) {
        if (container instanceof StyledDocumentPane) {
            return this.doGetDefaultComponent((StyledDocumentPane)container);
        }
        return super.getDefaultComponent(container);
    }

    private Component doGetComponentAfter(StyledDocumentPane styledDocumentPane, Component component) {
        if (!this.getFocused(styledDocumentPane, component, this.focused)) {
            return null;
        }
        Focusable[] focusableArray = null;
        switch (this.focused.role) {
            case 2: {
                focusableArray = this.getFocusables(styledDocumentPane, (Element)this.focused.node, 2);
                if (focusableArray != null) {
                    focusableArray = this.getFocusableAfter(styledDocumentPane, focusableArray, component);
                }
                if (focusableArray != null) break;
                focusableArray = this.traverseFrom(styledDocumentPane, this.focused.node);
                break;
            }
            case 1: 
            case 3: {
                focusableArray = this.getFocusables(styledDocumentPane, (Element)this.focused.node, 3);
                if (focusableArray != null) {
                    focusableArray = this.getFocusableAfter(styledDocumentPane, focusableArray, component);
                }
                if (focusableArray == null) {
                    focusableArray = this.getFocusables(styledDocumentPane, (Element)this.focused.node, 4);
                }
                if (focusableArray != null) break;
                focusableArray = this.traverseAfter(styledDocumentPane, this.focused.node);
                break;
            }
            case 4: {
                focusableArray = this.getFocusables(styledDocumentPane, (Element)this.focused.node, 4);
                if (focusableArray != null) {
                    focusableArray = this.getFocusableAfter(styledDocumentPane, focusableArray, component);
                }
                if (focusableArray != null) break;
                focusableArray = this.traverseAfter(styledDocumentPane, this.focused.node);
                break;
            }
            default: {
                Element element;
                if (this.focused.node.getNextSibling() == null && (element = this.focused.node.getParentElement()) != null) {
                    focusableArray = this.getFocusables(styledDocumentPane, element, 4);
                }
                if (focusableArray != null) break;
                focusableArray = this.traverseAfter(styledDocumentPane, this.focused.node);
            }
        }
        if (focusableArray == null) {
            return component;
        }
        if (focusableArray.length > 1) {
            this.sortFocusables(styledDocumentPane, focusableArray);
        }
        return this.focusComponent(styledDocumentPane, focusableArray[0], false, component);
    }

    private boolean getFocused(StyledDocumentPane styledDocumentPane, Component component, Focusable focusable) {
        Object object;
        focusable.node = null;
        focusable.componentImage = null;
        focusable.componentWrapper = null;
        focusable.role = -1;
        focusable.component = null;
        if (component == styledDocumentPane) {
            MarkManager markManager = styledDocumentPane.getDocumentView().getMarkManager();
            if (markManager == null) {
                return false;
            }
            TextLocation textLocation = markManager.getDot();
            if (textLocation == null) {
                return false;
            }
            focusable.node = textLocation.getNode();
            return true;
        }
        Component component2 = styledDocumentPane.getActiveComponent();
        if (component2 != null && (component2 == component || component2 instanceof Container && ((Container)component2).isAncestorOf(component))) {
            ComponentImage componentImage = styledDocumentPane.getActiveComponentImage();
            if (!(componentImage instanceof StyledElementViewPart)) {
                return false;
            }
            StyledElementViewPart styledElementViewPart = (StyledElementViewPart)((Object)componentImage);
            focusable.node = styledElementViewPart.getView().getModel();
            focusable.componentImage = componentImage;
            focusable.role = styledElementViewPart.getRole();
            focusable.component = component;
            return true;
        }
        ComponentWrapper componentWrapper = null;
        ComponentWrapper[] componentWrapperArray = styledDocumentPane.getComponentWrappers();
        int n = 0;
        while (n < componentWrapperArray.length) {
            object = componentWrapperArray[n].getComponent();
            if (component == object || object instanceof Container && ((Container)object).isAncestorOf(component)) {
                componentWrapper = componentWrapperArray[n];
                break;
            }
            ++n;
        }
        if (componentWrapper == null || !(componentWrapper instanceof StyledElementViewPart)) {
            return false;
        }
        object = (StyledElementViewPart)((Object)componentWrapper);
        focusable.node = object.getView().getModel();
        focusable.componentWrapper = componentWrapper;
        focusable.role = object.getRole();
        focusable.component = component;
        return true;
    }

    private Focusable[] getFocusables(StyledDocumentPane styledDocumentPane, Element element, int n) {
        DocumentView documentView = styledDocumentPane.getDocumentView();
        int n2 = documentView.getDocument().documentListenerIndex(documentView);
        return this.getFocusables(styledDocumentPane, documentView, n2, element, n);
    }

    private Focusable[] getFocusables(StyledDocumentPane styledDocumentPane, DocumentView documentView, int n, Element element, int n2) {
        this.list.clear();
        ElementView elementView = (ElementView)element.getDocumentListenerData(n);
        if (elementView == null) {
            return null;
        }
        this.gadgetList.removeAll();
        elementView.getGadgets(this.gadgetList, n);
        int n3 = 0;
        while (n3 < this.gadgetList.size) {
            this.doGetFocusables(styledDocumentPane, documentView, n, element, n2, this.gadgetList.list[n3], this.list);
            ++n3;
        }
        this.gadgetList.removeAll();
        int n4 = this.list.size();
        if (n4 == 0) {
            return null;
        }
        Focusable[] focusableArray = new Focusable[n4];
        this.list.toArray(focusableArray);
        this.list.clear();
        return focusableArray;
    }

    private void doGetFocusables(StyledDocumentPane styledDocumentPane, DocumentView documentView, int n, Element element, int n2, Gadget gadget, ArrayList arrayList) {
        if (!(gadget instanceof StyledElementViewPart) || ((StyledElementViewPart)((Object)gadget)).getView().getModel() != element) {
            return;
        }
        this.point.y = 0;
        this.point.x = 0;
        gadget.gadgetToRoot(this.point);
        if (this.point.x >= documentView.width || this.point.y >= documentView.height || this.point.x + gadget.width <= 0 || this.point.y + gadget.height <= 0) {
            return;
        }
        if (gadget instanceof ComponentImage && ((StyledElementViewPart)((Object)gadget)).getRole() == n2) {
            ComponentImage componentImage = (ComponentImage)gadget;
            Focusable focusable = new Focusable();
            focusable.node = element;
            focusable.componentImage = componentImage;
            focusable.role = n2;
            focusable.partX = this.point.x;
            focusable.partY = this.point.y;
            Component component = styledDocumentPane.getActiveComponentImage() == componentImage ? styledDocumentPane.getActiveComponent() : componentImage.getTemplate();
            this.addComponent(component, focusable, arrayList);
        } else if (gadget instanceof ComponentWrapper && ((StyledElementViewPart)((Object)gadget)).getRole() == n2) {
            ComponentWrapper componentWrapper = (ComponentWrapper)gadget;
            Focusable focusable = new Focusable();
            focusable.node = element;
            focusable.componentWrapper = componentWrapper;
            focusable.role = n2;
            focusable.partX = this.point.x;
            focusable.partY = this.point.y;
            this.addComponent(componentWrapper.getComponent(), focusable, arrayList);
        } else if (gadget instanceof GadgetContainer) {
            Gadget[] gadgetArray = ((GadgetContainer)gadget).getChildren();
            int n3 = 0;
            while (n3 < gadgetArray.length) {
                this.doGetFocusables(styledDocumentPane, documentView, n, element, n2, gadgetArray[n3], arrayList);
                ++n3;
            }
        }
    }

    private void addComponent(Component component, Focusable focusable, ArrayList arrayList) {
        Object object;
        if (this.accept(component)) {
            object = focusable.copy();
            ((Focusable)object).component = component;
            arrayList.add(object);
        }
        if (component instanceof Container && !((Container)(object = (Container)component)).isFocusCycleRoot()) {
            int n = ((Container)object).getComponentCount();
            int n2 = 0;
            while (n2 < n) {
                this.addComponent(((Container)object).getComponent(n2), focusable, arrayList);
                ++n2;
            }
        }
    }

    private Focusable[] getFocusableAfter(StyledDocumentPane styledDocumentPane, Focusable[] focusableArray, Component component) {
        if (focusableArray.length > 1) {
            this.sortFocusables(styledDocumentPane, focusableArray);
        }
        int n = 0;
        while (n < focusableArray.length) {
            Focusable focusable = focusableArray[n];
            if (component == focusable.component) {
                if (n + 1 < focusableArray.length) {
                    this.focusables1[0] = focusableArray[n + 1];
                    return this.focusables1;
                }
                return null;
            }
            ++n;
        }
        return null;
    }

    private Component focusComponent(StyledDocumentPane styledDocumentPane, Focusable focusable, boolean bl, Component component) {
        if (focusable.node instanceof TextNode) {
            DocumentFocusTraversalPolicy.moveCaret(styledDocumentPane, (TextNode)focusable.node, bl);
            return styledDocumentPane;
        }
        if (focusable.componentImage != null) {
            ComponentImage componentImage = styledDocumentPane.getActiveComponentImage();
            if (componentImage != null && componentImage != focusable.componentImage) {
                if (!componentImage.commit(true)) {
                    return component;
                }
                componentImage.passivate();
                componentImage = null;
            }
            if (componentImage != focusable.componentImage) {
                if (focusable.componentImage.getRoot() == null) {
                    return null;
                }
                Component component2 = focusable.componentImage.getTemplate();
                int[] nArray = StyledDocFocusTraversalPolicy.descendantToLocation(component2, focusable.component);
                if (nArray == null) {
                    return null;
                }
                focusable.componentImage.activate();
                Component component3 = styledDocumentPane.getActiveComponent();
                if (component3 == null) {
                    return null;
                }
                return StyledDocFocusTraversalPolicy.locationToDescendant(component3, nArray, 0);
            }
            return focusable.component;
        }
        return focusable.component;
    }

    private static final int[] descendantToLocation(Component component, Component component2) {
        boolean bl = false;
        int n = 0;
        Component component3 = component2;
        while (component3 != null) {
            if (component3 == component) {
                bl = true;
                break;
            }
            ++n;
            component3 = component3.getParent();
        }
        if (!bl) {
            return null;
        }
        int[] nArray = new int[n];
        component3 = component2;
        while (component3 != component) {
            Container container = component3.getParent();
            int n2 = container.getComponentCount();
            int n3 = 0;
            while (n3 < n2) {
                if (container.getComponent(n3) == component3) {
                    nArray[n - 1] = n3;
                    --n;
                    break;
                }
                ++n3;
            }
            component3 = container;
        }
        return nArray;
    }

    private static final Component locationToDescendant(Component component, int[] nArray, int n) {
        if (n == nArray.length) {
            return component;
        }
        component = ((Container)component).getComponent(nArray[n]);
        return StyledDocFocusTraversalPolicy.locationToDescendant(component, nArray, ++n);
    }

    private Component doGetComponentBefore(StyledDocumentPane styledDocumentPane, Component component) {
        if (!this.getFocused(styledDocumentPane, component, this.focused)) {
            return null;
        }
        Focusable[] focusableArray = null;
        switch (this.focused.role) {
            case 2: {
                focusableArray = this.getFocusables(styledDocumentPane, (Element)this.focused.node, 2);
                if (focusableArray != null) {
                    focusableArray = this.getFocusableBefore(styledDocumentPane, focusableArray, component);
                }
                if (focusableArray != null) break;
                focusableArray = this.traverseBefore(styledDocumentPane, this.focused.node);
                break;
            }
            case 1: 
            case 3: {
                focusableArray = this.getFocusables(styledDocumentPane, (Element)this.focused.node, 3);
                if (focusableArray != null) {
                    focusableArray = this.getFocusableBefore(styledDocumentPane, focusableArray, component);
                }
                if (focusableArray == null) {
                    focusableArray = this.getFocusables(styledDocumentPane, (Element)this.focused.node, 2);
                }
                if (focusableArray != null) break;
                focusableArray = this.traverseBefore(styledDocumentPane, this.focused.node);
                break;
            }
            case 4: {
                focusableArray = this.getFocusables(styledDocumentPane, (Element)this.focused.node, 4);
                if (focusableArray != null) {
                    focusableArray = this.getFocusableBefore(styledDocumentPane, focusableArray, component);
                }
                if (focusableArray != null) break;
                focusableArray = this.traverseBackwardsFrom(styledDocumentPane, this.focused.node);
                break;
            }
            default: {
                Element element;
                if (this.focused.node.getPreviousSibling() == null && (element = this.focused.node.getParentElement()) != null) {
                    focusableArray = this.getFocusables(styledDocumentPane, element, 2);
                }
                if (focusableArray != null) break;
                focusableArray = this.traverseBefore(styledDocumentPane, this.focused.node);
            }
        }
        if (focusableArray == null) {
            return component;
        }
        if (focusableArray.length > 1) {
            this.sortFocusables(styledDocumentPane, focusableArray);
        }
        return this.focusComponent(styledDocumentPane, focusableArray[focusableArray.length - 1], true, component);
    }

    private Focusable[] getFocusableBefore(StyledDocumentPane styledDocumentPane, Focusable[] focusableArray, Component component) {
        if (focusableArray.length > 1) {
            this.sortFocusables(styledDocumentPane, focusableArray);
        }
        int n = 0;
        while (n < focusableArray.length) {
            Focusable focusable = focusableArray[n];
            if (component == focusable.component) {
                if (n - 1 >= 0) {
                    this.focusables1[0] = focusableArray[n - 1];
                    return this.focusables1;
                }
                return null;
            }
            ++n;
        }
        return null;
    }

    private Component doGetFirstComponent(StyledDocumentPane styledDocumentPane) {
        Document document = styledDocumentPane.getDocumentView().getDocument();
        if (document == null) {
            return null;
        }
        Focusable[] focusableArray = this.traverse(styledDocumentPane, document.getRootElement());
        if (focusableArray == null) {
            return null;
        }
        if (focusableArray.length > 1) {
            this.sortFocusables(styledDocumentPane, focusableArray);
        }
        return this.focusComponent(styledDocumentPane, focusableArray[0], false, null);
    }

    private Component doGetLastComponent(StyledDocumentPane styledDocumentPane) {
        Document document = styledDocumentPane.getDocumentView().getDocument();
        if (document == null) {
            return null;
        }
        Focusable[] focusableArray = this.traverseBackwards(styledDocumentPane, document.getRootElement());
        if (focusableArray == null) {
            return null;
        }
        if (focusableArray.length > 1) {
            this.sortFocusables(styledDocumentPane, focusableArray);
        }
        return this.focusComponent(styledDocumentPane, focusableArray[focusableArray.length - 1], true, null);
    }

    private Component doGetDefaultComponent(StyledDocumentPane styledDocumentPane) {
        return styledDocumentPane;
    }

    private Focusable[] traverseFrom(StyledDocumentPane styledDocumentPane, Node node) {
        this.initTraversal(styledDocumentPane, false, true);
        Focusable[] focusableArray = (Focusable[])StyledTraversal.traverseFrom(node, this);
        this.finishTraversal();
        return focusableArray;
    }

    private Focusable[] traverseBackwardsFrom(StyledDocumentPane styledDocumentPane, Node node) {
        this.initTraversal(styledDocumentPane, true, true);
        Focusable[] focusableArray = (Focusable[])StyledTraversal.traverseBackwardsFrom(node, this);
        this.finishTraversal();
        return focusableArray;
    }

    private Focusable[] traverseAfter(StyledDocumentPane styledDocumentPane, Node node) {
        this.initTraversal(styledDocumentPane, false, false);
        Focusable[] focusableArray = (Focusable[])StyledTraversal.traverseAfter(node, this);
        this.finishTraversal();
        return focusableArray;
    }

    private Focusable[] traverseBefore(StyledDocumentPane styledDocumentPane, Node node) {
        this.initTraversal(styledDocumentPane, true, false);
        Focusable[] focusableArray = (Focusable[])StyledTraversal.traverseBefore(node, this);
        this.finishTraversal();
        return focusableArray;
    }

    private Focusable[] traverse(StyledDocumentPane styledDocumentPane, Node node) {
        this.initTraversal(styledDocumentPane, false, false);
        Focusable[] focusableArray = (Focusable[])StyledTraversal.traverse(node, this);
        this.finishTraversal();
        return focusableArray;
    }

    private Focusable[] traverseBackwards(StyledDocumentPane styledDocumentPane, Node node) {
        this.initTraversal(styledDocumentPane, true, false);
        Focusable[] focusableArray = (Focusable[])StyledTraversal.traverseBackwards(node, this);
        this.finishTraversal();
        return focusableArray;
    }

    private void initTraversal(StyledDocumentPane styledDocumentPane, boolean bl, boolean bl2) {
        this.backwards = bl;
        this.skipGeneratedContent = bl2;
        this.docPane = styledDocumentPane;
        this.docView = styledDocumentPane.getStyledDocumentView();
        this.viewIndex = this.docView.getDocument().documentListenerIndex(this.docView);
    }

    private void finishTraversal() {
        this.docPane = null;
        this.docView = null;
        this.viewIndex = -1;
        this.gadgetList.removeAll();
    }

    public Object processText(Text text) {
        return this.processTextNode(text);
    }

    public Object processPI(ProcessingInstruction processingInstruction) {
        return this.processTextNode(processingInstruction);
    }

    public Object processComment(Comment comment) {
        return this.processTextNode(comment);
    }

    private Object processTextNode(TextNode textNode) {
        if (this.isFocusable(textNode)) {
            this.focusable.node = textNode;
            this.focusables1[0] = this.focusable;
            return this.focusables1;
        }
        return null;
    }

    private boolean isFocusable(TextNode textNode) {
        TextNodeView textNodeView = (TextNodeView)textNode.getDocumentListenerData(this.viewIndex);
        boolean bl = false;
        if (textNodeView != null) {
            this.gadgetList.removeAll();
            textNodeView.getTextGadgets(this.gadgetList, this.viewIndex);
            int n = 0;
            while (n < this.gadgetList.size) {
                Gadget gadget = this.gadgetList.list[n];
                if (gadget instanceof TextNodeViewText) {
                    this.point.y = 0;
                    this.point.x = 0;
                    gadget.gadgetToRoot(this.point);
                    if (this.point.x < this.docView.width && this.point.y < this.docView.height && this.point.x + gadget.width > 0 && this.point.y + gadget.height > 0) {
                        bl = true;
                        break;
                    }
                }
                ++n;
            }
        }
        return bl;
    }

    public Object processContentBefore(Element element) {
        Focusable[] focusableArray = null;
        if (this.skipGeneratedContent) {
            this.skipGeneratedContent = false;
        } else {
            focusableArray = this.getFocusables(this.docPane, this.docView, this.viewIndex, element, 2);
        }
        if (focusableArray == null && !this.backwards) {
            focusableArray = this.getFocusables(this.docPane, this.docView, this.viewIndex, element, 3);
        }
        if (focusableArray != null) {
            return focusableArray;
        }
        return null;
    }

    public Object processContentAfter(Element element) {
        Focusable[] focusableArray = null;
        if (this.skipGeneratedContent) {
            this.skipGeneratedContent = false;
        } else {
            focusableArray = this.getFocusables(this.docPane, this.docView, this.viewIndex, element, 4);
        }
        if (focusableArray == null && this.backwards) {
            focusableArray = this.getFocusables(this.docPane, this.docView, this.viewIndex, element, 3);
        }
        if (focusableArray != null) {
            return focusableArray;
        }
        return null;
    }

    public Object enterElement(Element element) {
        return null;
    }

    public Object leaveElement(Element element) {
        return null;
    }

    private void sortFocusables(StyledDocumentPane styledDocumentPane, Focusable[] focusableArray) {
        this.docPane2 = styledDocumentPane;
        this.comparator = this.getComparator();
        this.lastComponentImage = null;
        Arrays.sort(focusableArray, this);
        this.docPane2 = null;
        this.comparator = null;
        this.lastComponentImage = null;
    }

    public int compare(Object object, Object object2) {
        Focusable focusable = (Focusable)object;
        Focusable focusable2 = (Focusable)object2;
        if (focusable.componentImage != null && focusable.componentImage == focusable2.componentImage) {
            if (focusable.componentImage != this.docPane2.getActiveComponentImage() && focusable.componentImage != this.lastComponentImage) {
                this.lastComponentImage = focusable.componentImage;
                this.lastComponentImage.getTemplate();
            }
            return this.comparator.compare(focusable.component, focusable2.component);
        }
        if (focusable.componentWrapper != null && focusable.componentWrapper == focusable2.componentWrapper) {
            return this.comparator.compare(focusable.component, focusable2.component);
        }
        if (Math.abs(focusable.partY - focusable2.partY) < 10) {
            return focusable.partX < focusable2.partX ? -1 : 1;
        }
        return focusable.partY < focusable2.partY ? -1 : 1;
    }

    private static final class Focusable
    implements Cloneable {
        public Node node;
        public ComponentImage componentImage;
        public ComponentWrapper componentWrapper;
        public int role;
        public int partX;
        public int partY;
        public Component component;

        private Focusable() {
        }

        public Focusable copy() {
            Focusable focusable = null;
            try {
                focusable = (Focusable)this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {}
            return focusable;
        }
    }
}

