/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.styledview;

import com.xmlmind.xmledit.doc.Comment;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.ProcessingInstruction;
import com.xmlmind.xmledit.doc.Text;

class StyledTraversal {
    public static final Object LEAVE_ELEMENT = new Object();

    StyledTraversal() {
    }

    public static final Object traverse(Node node, Handler handler) {
        switch (node.getNodeType()) {
            case 0: {
                return handler.processText((Text)node);
            }
            case 2: {
                return handler.processPI((ProcessingInstruction)node);
            }
            case 1: {
                return handler.processComment((Comment)node);
            }
            case 4: {
                Element element = (Element)node;
                Object object = handler.enterElement(element);
                if (object != null) {
                    return object == LEAVE_ELEMENT ? null : object;
                }
                object = handler.processContentBefore(element);
                if (object != null) {
                    return object;
                }
                Node node2 = element.getFirstChild();
                while (node2 != null) {
                    object = StyledTraversal.traverse(node2, handler);
                    if (object != null) {
                        return object;
                    }
                    node2 = node2.getNextSibling();
                }
                object = handler.processContentAfter(element);
                if (object != null) {
                    return object;
                }
                object = handler.leaveElement(element);
                if (object != null) {
                    return object;
                }
                return null;
            }
        }
        return null;
    }

    public static final Object traverseBackwards(Node node, Handler handler) {
        switch (node.getNodeType()) {
            case 0: {
                return handler.processText((Text)node);
            }
            case 2: {
                return handler.processPI((ProcessingInstruction)node);
            }
            case 1: {
                return handler.processComment((Comment)node);
            }
            case 4: {
                Element element = (Element)node;
                Object object = handler.enterElement(element);
                if (object != null) {
                    return object == LEAVE_ELEMENT ? null : object;
                }
                object = handler.processContentAfter(element);
                if (object != null) {
                    return object;
                }
                Node node2 = element.getLastChild();
                while (node2 != null) {
                    object = StyledTraversal.traverseBackwards(node2, handler);
                    if (object != null) {
                        return object;
                    }
                    node2 = node2.getPreviousSibling();
                }
                object = handler.processContentBefore(element);
                if (object != null) {
                    return object;
                }
                object = handler.leaveElement(element);
                if (object != null) {
                    return object;
                }
                return null;
            }
        }
        return null;
    }

    public static final Object traverseFrom(Node node, Handler handler) {
        Object object = StyledTraversal.traverse(node, handler);
        if (object != null) {
            return object;
        }
        return StyledTraversal.traverseAfter(node, handler);
    }

    public static final Object traverseAfter(Node node, Handler handler) {
        Object object;
        Element element = node.getParentElement();
        if (element == null) {
            return null;
        }
        Node node2 = node.getNextSibling();
        while (node2 != null) {
            object = StyledTraversal.traverse(node2, handler);
            if (object != null) {
                return object;
            }
            node2 = node2.getNextSibling();
        }
        object = handler.processContentAfter(element);
        if (object != null) {
            return object;
        }
        Element element2;
        while ((element2 = element.getParentElement()) != null) {
            Node node3 = element.getNextSibling();
            if (node3 != null) {
                return StyledTraversal.traverseFrom(node3, handler);
            }
            object = handler.processContentAfter(element2);
            if (object != null) {
                return object;
            }
            element = element2;
        }
        return null;
    }

    public static final Object traverseBackwardsFrom(Node node, Handler handler) {
        Object object = StyledTraversal.traverseBackwards(node, handler);
        if (object != null) {
            return object;
        }
        return StyledTraversal.traverseBefore(node, handler);
    }

    public static final Object traverseBefore(Node node, Handler handler) {
        Object object;
        Element element = node.getParentElement();
        if (element == null) {
            return null;
        }
        Node node2 = node.getPreviousSibling();
        while (node2 != null) {
            object = StyledTraversal.traverseBackwards(node2, handler);
            if (object != null) {
                return object;
            }
            node2 = node2.getPreviousSibling();
        }
        object = handler.processContentBefore(element);
        if (object != null) {
            return object;
        }
        Element element2;
        while ((element2 = element.getParentElement()) != null) {
            Node node3 = element.getPreviousSibling();
            if (node3 != null) {
                return StyledTraversal.traverseBackwardsFrom(node3, handler);
            }
            object = handler.processContentBefore(element2);
            if (object != null) {
                return object;
            }
            element = element2;
        }
        return null;
    }

    public static interface Handler {
        public Object processText(Text var1);

        public Object processPI(ProcessingInstruction var1);

        public Object processComment(Comment var1);

        public Object enterElement(Element var1);

        public Object leaveElement(Element var1);

        public Object processContentBefore(Element var1);

        public Object processContentAfter(Element var1);
    }
}

