/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.styledview;

import com.xmlmind.xmledit.doc.Comment;
import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.ElementAttributeEvent;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.ProcessingInstruction;
import com.xmlmind.xmledit.doc.Text;
import com.xmlmind.xmledit.doc.TextNode;
import com.xmlmind.xmledit.doc.XNode;
import com.xmlmind.xmledit.doctype.DocumentTypeUtil;
import com.xmlmind.xmledit.edit.SimpleDocumentCache;
import com.xmlmind.xmledit.gadget.ComponentImageRenderer;
import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.gadget.GadgetContainer;
import com.xmlmind.xmledit.styledgadget.Icon;
import com.xmlmind.xmledit.styledgadget.Style;
import com.xmlmind.xmledit.styledgadget.TableBody;
import com.xmlmind.xmledit.styledview.CaptionView;
import com.xmlmind.xmledit.styledview.CellView;
import com.xmlmind.xmledit.styledview.CollapsibleParagraphView;
import com.xmlmind.xmledit.styledview.CollapsibleTableView;
import com.xmlmind.xmledit.styledview.ColumnGroupView;
import com.xmlmind.xmledit.styledview.ColumnView;
import com.xmlmind.xmledit.styledview.ComponentBoxVP;
import com.xmlmind.xmledit.styledview.ComponentFactory;
import com.xmlmind.xmledit.styledview.CounterVP;
import com.xmlmind.xmledit.styledview.CustomViewManager;
import com.xmlmind.xmledit.styledview.DivisionVP;
import com.xmlmind.xmledit.styledview.GadgetFactory;
import com.xmlmind.xmledit.styledview.GadgetFactory2;
import com.xmlmind.xmledit.styledview.ImageLabelTVP;
import com.xmlmind.xmledit.styledview.ImageLabelVP;
import com.xmlmind.xmledit.styledview.InlineGroupView;
import com.xmlmind.xmledit.styledview.ParagraphTextTVP;
import com.xmlmind.xmledit.styledview.ParagraphTextVP;
import com.xmlmind.xmledit.styledview.ParagraphTextView;
import com.xmlmind.xmledit.styledview.ParagraphVP;
import com.xmlmind.xmledit.styledview.ParagraphView;
import com.xmlmind.xmledit.styledview.PseudoElementCustomView;
import com.xmlmind.xmledit.styledview.PseudoElementView;
import com.xmlmind.xmledit.styledview.RowGroupView;
import com.xmlmind.xmledit.styledview.RowView;
import com.xmlmind.xmledit.styledview.StyledElementView;
import com.xmlmind.xmledit.styledview.StyledElementViewPart;
import com.xmlmind.xmledit.styledview.StyledTreeView;
import com.xmlmind.xmledit.styledview.StyledViewFactoryUtil;
import com.xmlmind.xmledit.styledview.SubtableView;
import com.xmlmind.xmledit.styledview.TableBodyVP;
import com.xmlmind.xmledit.styledview.TableView;
import com.xmlmind.xmledit.styledview.TextLabelVP;
import com.xmlmind.xmledit.styledview.ViewParameters;
import com.xmlmind.xmledit.stylesheet.Rule;
import com.xmlmind.xmledit.stylesheet.Selector;
import com.xmlmind.xmledit.stylesheet.StyleSheet;
import com.xmlmind.xmledit.stylesheet.StyleSpec;
import com.xmlmind.xmledit.stylesheet.StyleSpecs;
import com.xmlmind.xmledit.stylesheet.StyleValue;
import com.xmlmind.xmledit.stylesheet.StyleValueParser;
import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmledit.util.StringUtil;
import com.xmlmind.xmledit.view.DocumentView;
import com.xmlmind.xmledit.view.ElementView;
import com.xmlmind.xmledit.view.TextNodeView;
import com.xmlmind.xmledit.view.TextNodeViewPart;
import com.xmlmind.xmledit.view.TreeView;
import com.xmlmind.xmledit.view.TreeViewFactory;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.Namespace;
import com.xmlmind.xmledit.xmlutil.XMLUtil;
import com.xmlmind.xmledit.xpath.EvalException;
import com.xmlmind.xmledit.xpath.SimpleExprContext;
import com.xmlmind.xmledit.xpath.StringExpr;
import com.xmlmind.xmledit.xpath.StringVariant;
import com.xmlmind.xmledit.xpath.Variant;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;

public class StyledViewFactory
extends TreeViewFactory {
    public static final String FACTORY_PACKAGE_NAMES_PROPERTY = "XXE_FACTORY_PACKAGE_NAMES";
    private static String[] factoryPackageNames;
    private static HashMap factoryNameToClass;
    public static final int MIN_FONT_SIZE = 6;
    public static final int MAX_FONT_SIZE = 72;
    private Style defaultStyle = new Style();
    private String serifFamily = "Serif";
    private String sansSerifFamily = "SansSerif";
    private String monospaceFamily = "Monospaced";
    private double screenResolution;
    private StyleSheet styleSheet = null;
    private CustomViewManager customViewManager;
    private HashMap sharedRenderers = new HashMap();
    private HashMap sharedStyles = new HashMap();
    private HashMap dependencies = new HashMap();
    private StyleValueParser styleValueParser = null;
    private Class[] extensionClasses = null;
    private Object[] extensions = null;
    private HashMap extensionMethods = null;
    private StyleSpecs[] stylers = null;
    private HashMap fontCache = new HashMap();
    private StyleSpec spec0 = new StyleSpec();
    private StyleSpec[] specs = new StyleSpec[]{this.spec0, new StyleSpec(), new StyleSpec()};
    private FontInfo fontProbe = new FontInfo(null, 0, 0);
    private Dependency dependencyProbe = new Dependency(null, null, null, null);
    private Object[] invokeParams = new Object[3];
    private static final StyleValue noValue;
    private static final Class[] invokeParamTypes;
    static /* synthetic */ Class array$Lcom$xmlmind$xmledit$stylesheet$StyleValue;
    static /* synthetic */ Class class$com$xmlmind$xmledit$doc$Node;
    static /* synthetic */ Class class$com$xmlmind$xmledit$styledview$StyledViewFactory;
    static /* synthetic */ Class array$Ljava$lang$String;

    public StyledViewFactory(DocumentView documentView) {
        super(documentView);
        this.customViewManager = new CustomViewManager(this);
        this.defaultStyle.paddingLeft = 5;
        this.defaultStyle.paddingBottom = 5;
        this.defaultStyle.paddingRight = 5;
        this.defaultStyle.paddingTop = 5;
        this.defaultStyle.font = new Font(this.sansSerifFamily, 0, 12);
        this.defaultStyle.backgroundColor = Color.white;
        this.defaultStyle.color = Color.black;
        this.setScreenResolution(-1.0);
    }

    public void setStyleSheet(StyleSheet styleSheet) {
        this.styleSheet = styleSheet;
        this.customViewManager.reset();
        this.sharedRenderers.clear();
        this.sharedStyles.clear();
        this.dependencies.clear();
        this.styleValueParser = null;
        this.extensionClasses = null;
        this.extensions = null;
        this.extensionMethods = null;
        this.stylers = null;
        if (styleSheet != null) {
            this.setDependencies();
            this.styleValueParser = new StyleValueParser(styleSheet);
            this.initExtensions();
        }
        if (this.doc != null) {
            this.docView.rebuildView(this.doc.getRootElement());
        }
    }

    private void initExtensions() {
        StyleSheet.ExtensionInfo[] extensionInfoArray = this.styleSheet.getAllExtensionInfo();
        if (extensionInfoArray != null) {
            int n = 0;
            while (n < extensionInfoArray.length) {
                Object obj;
                Constructor<?> constructor;
                Class<?> clazz;
                StyleSheet.ExtensionInfo extensionInfo = extensionInfoArray[n];
                try {
                    clazz = Class.forName(extensionInfo.className);
                }
                catch (Exception exception) {
                    this.reportExtensionError("cannot load @extension class " + extensionInfo.className, exception);
                    break;
                }
                try {
                    constructor = clazz.getConstructor(array$Ljava$lang$String == null ? StyledViewFactory.class$("[Ljava.lang.String;") : array$Ljava$lang$String, class$com$xmlmind$xmledit$styledview$StyledViewFactory == null ? StyledViewFactory.class$("com.xmlmind.xmledit.styledview.StyledViewFactory") : class$com$xmlmind$xmledit$styledview$StyledViewFactory);
                }
                catch (Exception exception) {
                    this.reportExtensionError("constructor " + extensionInfo.className + "(String[], StyleViewFactory)" + " not found", exception);
                    break;
                }
                try {
                    obj = constructor.newInstance(extensionInfo.parameters, this);
                }
                catch (Exception exception) {
                    this.reportExtensionError("cannot invoke constructor " + extensionInfo.className + "(String[], StyleViewFactory)", exception);
                    break;
                }
                if (this.extensionClasses == null) {
                    this.extensionClasses = new Class[]{clazz};
                    this.extensions = new Object[]{obj};
                } else {
                    int n2 = this.extensionClasses.length + 1;
                    Class[] classArray = new Class[n2 + 1];
                    System.arraycopy(this.extensionClasses, 0, classArray, 0, n2);
                    classArray[n2] = clazz;
                    this.extensionClasses = classArray;
                    Object[] objectArray = new Object[n2 + 1];
                    System.arraycopy(this.extensions, 0, objectArray, 0, n2);
                    objectArray[n2] = obj;
                    this.extensions = objectArray;
                }
                ++n;
            }
            if (this.extensionClasses != null) {
                this.extensionMethods = new HashMap();
            }
        }
    }

    private void reportExtensionError(String string, Exception exception) {
        System.err.print("style sheet '" + this.styleSheet.getURL() + "': " + string);
        if (exception == null) {
            System.err.println();
            return;
        }
        Throwable throwable = null;
        if (exception instanceof InvocationTargetException) {
            throwable = ((InvocationTargetException)exception).getCause();
        }
        if (throwable == null) {
            throwable = exception;
        }
        System.err.println(": " + MiscUtil.reason(throwable));
        System.err.println("----------------------------------------");
        exception.printStackTrace();
        System.err.println("----------------------------------------");
    }

    public StyleSheet getStyleSheet() {
        return this.styleSheet;
    }

    public void setDefaultStyle(Style style) {
        this.defaultStyle = style;
    }

    public Style getDefaultStyle() {
        return this.defaultStyle;
    }

    public void setSerifFontFamily(String string) {
        if (string == null || !StringUtil.contains(StyledViewFactoryUtil.getFontFamilies(), string)) {
            string = "Serif";
        }
        this.serifFamily = string;
    }

    public String getSerifFontFamily() {
        return this.serifFamily;
    }

    public void setSansSerifFontFamily(String string) {
        if (string == null || !StringUtil.contains(StyledViewFactoryUtil.getFontFamilies(), string)) {
            string = "SansSerif";
        }
        this.sansSerifFamily = string;
    }

    public String getSansSerifFontFamily() {
        return this.sansSerifFamily;
    }

    public void setMonospaceFontFamily(String string) {
        if (string == null || !StringUtil.contains(StyledViewFactoryUtil.getFontFamilies(), string)) {
            string = "Monospaced";
        }
        this.monospaceFamily = string;
    }

    public String getMonospaceFontFamily() {
        return this.monospaceFamily;
    }

    public void setScreenResolution(double d) {
        if (d <= 0.0) {
            d = this.docView.getPanel().getToolkit().getScreenResolution();
        }
        this.screenResolution = d;
    }

    public double getScreenResolution() {
        return this.screenResolution;
    }

    public void applyStyleDefaults() {
        if (this.doc != null) {
            this.docView.rebuildView(this.doc.getRootElement());
        }
    }

    public void addDependency(Namespace namespace, String string, Namespace namespace2, String string2) {
        Dependency dependency = new Dependency(namespace, string, namespace2, string2);
        this.dependencies.put(dependency, dependency);
    }

    private void setDependencies() {
        Rule[] ruleArray = this.styleSheet.getRules();
        int n = 0;
        while (n < ruleArray.length) {
            Object object;
            Object object2;
            int n2;
            Dependency dependency;
            Object object3;
            Rule rule = ruleArray[n];
            Selector.Matcher[] matcherArray = rule.getSelector().getMatchers();
            int n3 = 0;
            while (n3 < matcherArray.length) {
                object3 = matcherArray[n3];
                Selector.Test[] testArray = ((Selector.Matcher)object3).tests;
                dependency = StyledViewFactory.getDependent(testArray);
                n2 = 0;
                while (n2 < testArray.length) {
                    object2 = testArray[n2];
                    switch (((Selector.Test)object2).type) {
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 14: 
                        case 15: 
                        case 16: {
                            object = ((Selector.Test)object2).name.getNamespace();
                            if (object == Selector.ANY_NAMESPACE) {
                                object = null;
                            }
                            this.addDependency(dependency.elementNS, dependency.elementLP, (Namespace)object, ((Selector.Test)object2).name.getLocalPart());
                            break;
                        }
                        case 7: {
                            this.addDependency(dependency.elementNS, dependency.elementLP, Namespace.XML, "lang");
                        }
                    }
                    ++n2;
                }
                ++n3;
            }
            dependency = matcherArray.length > 0 ? StyledViewFactory.getDependent(matcherArray[0].tests) : new Dependency(null, null, null, null);
            object3 = rule.getStyleSpec();
            boolean bl = ((StyleSpec)object3).display != null && ((StyleSpec)object3).display.type == 28;
            if (bl) {
                this.addDependency(dependency.elementNS, dependency.elementLP, null, null);
            } else {
                n2 = 0;
                while (n2 < StyledViewFactoryUtil.STYLE_SPEC_FIELD_COUNT) {
                    object2 = StyledViewFactoryUtil.STYLE_SPEC_FIELDS[n2];
                    try {
                        object = (StyleValue)((Field)object2).get(object3);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        object = null;
                        illegalAccessException.printStackTrace();
                    }
                    if (object != null) {
                        StyledViewFactory.addDependencies((StyleValue)object, dependency, this.dependencies);
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    private static final Dependency getDependent(Selector.Test[] testArray) {
        if (testArray.length > 0) {
            Selector.Test test = testArray[0];
            switch (test.type) {
                case 0: {
                    Namespace namespace = test.name.getNamespace();
                    if (namespace == Selector.ANY_NAMESPACE) {
                        namespace = null;
                    }
                    return new Dependency(namespace, test.name.getLocalPart(), null, null);
                }
                case 1: {
                    return new Dependency(test.name.getNamespace(), null, null, null);
                }
            }
            return new Dependency(null, null, null, null);
        }
        return new Dependency(null, null, null, null);
    }

    private static final void addDependencies(StyleValue styleValue, Dependency dependency, HashMap hashMap) {
        switch (styleValue.type) {
            case 23: {
                Namespace namespace = styleValue.name.getNamespace();
                if (namespace == Selector.ANY_NAMESPACE) {
                    namespace = null;
                }
                Dependency dependency2 = new Dependency(dependency.elementNS, dependency.elementLP, namespace, styleValue.name.getLocalPart());
                hashMap.put(dependency2, dependency2);
                break;
            }
            case 24: {
                Dependency dependency3 = new Dependency(dependency.elementNS, dependency.elementLP, null, null);
                hashMap.put(dependency3, dependency3);
                break;
            }
            case 4: 
            case 25: 
            case 26: 
            case 28: {
                StyleValue[] styleValueArray = styleValue.list;
                int n = 0;
                while (n < styleValueArray.length) {
                    StyledViewFactory.addDependencies(styleValueArray[n], dependency, hashMap);
                    ++n;
                }
                break;
            }
        }
    }

    public boolean hasDependency(Name name, Name name2) {
        Namespace namespace = name.getNamespace();
        String string = name.getLocalPart();
        Namespace namespace2 = name2.getNamespace();
        String string2 = name2.getLocalPart();
        this.dependencyProbe.attributeNS = namespace2;
        this.dependencyProbe.attributeLP = string2;
        this.dependencyProbe.elementNS = namespace;
        this.dependencyProbe.elementLP = string;
        if (this.dependencies.containsKey(this.dependencyProbe)) {
            return true;
        }
        this.dependencyProbe.elementNS = null;
        this.dependencyProbe.elementLP = string;
        if (this.dependencies.containsKey(this.dependencyProbe)) {
            return true;
        }
        this.dependencyProbe.elementNS = namespace;
        this.dependencyProbe.elementLP = null;
        if (this.dependencies.containsKey(this.dependencyProbe)) {
            return true;
        }
        this.dependencyProbe.elementNS = null;
        this.dependencyProbe.elementLP = null;
        if (this.dependencies.containsKey(this.dependencyProbe)) {
            return true;
        }
        this.dependencyProbe.attributeNS = null;
        this.dependencyProbe.attributeLP = string2;
        this.dependencyProbe.elementNS = namespace;
        this.dependencyProbe.elementLP = string;
        if (this.dependencies.containsKey(this.dependencyProbe)) {
            return true;
        }
        this.dependencyProbe.elementNS = null;
        this.dependencyProbe.elementLP = string;
        if (this.dependencies.containsKey(this.dependencyProbe)) {
            return true;
        }
        this.dependencyProbe.elementNS = namespace;
        this.dependencyProbe.elementLP = null;
        if (this.dependencies.containsKey(this.dependencyProbe)) {
            return true;
        }
        this.dependencyProbe.elementNS = null;
        this.dependencyProbe.elementLP = null;
        if (this.dependencies.containsKey(this.dependencyProbe)) {
            return true;
        }
        this.dependencyProbe.attributeNS = null;
        this.dependencyProbe.attributeLP = null;
        this.dependencyProbe.elementNS = namespace;
        this.dependencyProbe.elementLP = string;
        if (this.dependencies.containsKey(this.dependencyProbe)) {
            return true;
        }
        this.dependencyProbe.elementNS = null;
        this.dependencyProbe.elementLP = string;
        if (this.dependencies.containsKey(this.dependencyProbe)) {
            return true;
        }
        this.dependencyProbe.elementNS = namespace;
        this.dependencyProbe.elementLP = null;
        if (this.dependencies.containsKey(this.dependencyProbe)) {
            return true;
        }
        this.dependencyProbe.elementNS = null;
        this.dependencyProbe.elementLP = null;
        return this.dependencies.containsKey(this.dependencyProbe);
    }

    public CustomViewManager getCustomViewManager() {
        return this.customViewManager;
    }

    public void addIntrinsicStyleSpecs(StyleSpecs styleSpecs) {
        if (this.stylers == null) {
            this.stylers = new StyleSpecs[]{styleSpecs};
        } else {
            StyleSpecs[] styleSpecsArray = new StyleSpecs[this.stylers.length + 1];
            System.arraycopy(this.stylers, 0, styleSpecsArray, 0, this.stylers.length);
            styleSpecsArray[this.stylers.length] = styleSpecs;
            this.stylers = styleSpecsArray;
        }
    }

    public StyleSpecs[] getAllIntrinsicStyleSpecs() {
        return this.stylers;
    }

    public ComponentImageRenderer shareRenderer(ComponentImageRenderer componentImageRenderer) {
        ComponentImageRenderer componentImageRenderer2 = (ComponentImageRenderer)this.sharedRenderers.get(componentImageRenderer);
        if (componentImageRenderer2 == null) {
            componentImageRenderer2 = componentImageRenderer;
            this.sharedRenderers.put(componentImageRenderer, componentImageRenderer);
        }
        return componentImageRenderer2;
    }

    public Style shareStyle(Style style) {
        Style style2 = (Style)this.sharedStyles.get(style);
        if (style2 == null) {
            this.sharedStyles.put(style, style);
            style2 = style;
        }
        return style2;
    }

    public void setDocument(Document document) {
        super.setDocument(document);
        this.customViewManager.setDocument(document);
    }

    public int elementAttributeChanged(ElementAttributeEvent elementAttributeEvent, int n) {
        boolean bl;
        if (this.styleSheet == null) {
            return super.elementAttributeChanged(elementAttributeEvent, n);
        }
        Element element = elementAttributeEvent.getElementSource();
        ElementView elementView = (ElementView)element.getDocumentListenerData(n);
        if (elementView != null && elementView instanceof TreeView) {
            bl = true;
        } else {
            ElementView elementView2;
            Name name = elementAttributeEvent.getName();
            Name name2 = element.getName();
            Element element2 = element.getParentElement();
            bl = element2 == null ? this.hasDependency(name2, name) : ((elementView2 = (ElementView)element2.getDocumentListenerData(n)) == null ? false : this.hasDependency(name2, name) || elementView2 instanceof TreeView);
        }
        return bl ? 2 : 0;
    }

    public TextNodeView createTextView(Text text, ElementView elementView) {
        if (this.styleSheet == null) {
            return super.createTextView(text, elementView);
        }
        if (elementView == null) {
            return null;
        }
        if (elementView instanceof TreeView) {
            return super.createTextView(text, elementView);
        }
        StyledElementView styledElementView = (StyledElementView)elementView;
        if (styledElementView.isCustomView()) {
            return null;
        }
        Style style = styledElementView.getStyle();
        if (style.verticalAlign != 0 && !(elementView instanceof InlineGroupView)) {
            style = style.copy();
            style.verticalAlign = 0;
            style = this.shareStyle(style);
        }
        return new ParagraphTextView(style, text);
    }

    public TextNodeView createCommentView(Comment comment, ElementView elementView) {
        if (this.styleSheet == null) {
            return super.createCommentView(comment, elementView);
        }
        if (elementView == null) {
            return null;
        }
        if (elementView instanceof TreeView) {
            return super.createCommentView(comment, elementView);
        }
        return this.createTextNodeView(comment, elementView);
    }

    public TextNodeView createProcessingInstructionView(ProcessingInstruction processingInstruction, ElementView elementView) {
        if (this.styleSheet == null) {
            return super.createProcessingInstructionView(processingInstruction, elementView);
        }
        if (elementView == null) {
            return null;
        }
        if (elementView instanceof TreeView) {
            return super.createProcessingInstructionView(processingInstruction, elementView);
        }
        return this.createTextNodeView(processingInstruction, elementView);
    }

    private TextNodeView createTextNodeView(TextNode textNode, ElementView elementView) {
        TextNodeViewPart[] textNodeViewPartArray;
        boolean bl;
        int n;
        StyledElementView styledElementView = (StyledElementView)elementView;
        if (styledElementView.isCustomView()) {
            return null;
        }
        Style style = styledElementView.getStyle();
        StyleSpec styleSpec = this.spec0;
        styleSpec.clear();
        if (textNode instanceof Comment) {
            if (this.stylers != null) {
                n = 0;
                while (n < this.stylers.length) {
                    this.stylers[n].findStyleSpec((Comment)textNode, styleSpec);
                    n += 1;
                }
            }
            this.styleSheet.findStyleSpec((Comment)textNode, styleSpec);
        } else {
            if (this.stylers != null) {
                n = 0;
                while (n < this.stylers.length) {
                    this.stylers[n].findStyleSpec((ProcessingInstruction)textNode, styleSpec);
                    n += 1;
                }
            }
            this.styleSheet.findStyleSpec((ProcessingInstruction)textNode, styleSpec);
        }
        ViewParameters viewParameters = new ViewParameters();
        Style style2 = this.specToStyle(styleSpec, style, textNode.getParentElement(), viewParameters);
        switch (viewParameters.display) {
            case 32: {
                return null;
            }
            case 76: 
            case 88: {
                n = viewParameters.display == 88 ? 1 : 0;
                bl = true;
                break;
            }
            default: {
                n = 1;
                bl = false;
            }
        }
        style2 = this.shareStyle(style2);
        Gadget gadget = styleSpec.content == null ? (bl ? new PseudoElementView(style2, textNode, n != 0) : new ParagraphTextView(style2, textNode)) : new PseudoElementCustomView(style2, textNode, n != 0);
        if (styleSpec.content != null && (textNodeViewPartArray = this.contentToTextNodeViewParts(styleSpec.content, style2, (TextNodeView)((Object)gadget))) != null) {
            ((PseudoElementCustomView)gadget).initView(textNodeViewPartArray);
        }
        return gadget;
    }

    public ElementView createElementView(Element element, ElementView elementView) {
        StyledElementView styledElementView;
        Style style;
        StyledElementView styledElementView2;
        if (this.styleSheet == null) {
            return super.createElementView(element, elementView);
        }
        Element element2 = element.getParentElement();
        if (element2 == null) {
            styledElementView2 = null;
            style = null;
        } else {
            if (elementView == null) {
                return null;
            }
            if (elementView instanceof TreeView) {
                return super.createElementView(element, elementView);
            }
            styledElementView2 = (StyledElementView)elementView;
            if (styledElementView2.isCustomView()) {
                return null;
            }
            style = styledElementView2.getStyle();
        }
        StyleSpec styleSpec = null;
        Style style2 = null;
        ViewParameters viewParameters = null;
        StyleSpec styleSpec2 = null;
        Style style3 = null;
        ViewParameters viewParameters2 = null;
        int n = 0;
        while (n < 3) {
            this.specs[n].clear();
            ++n;
        }
        int n2 = 0;
        if (this.stylers != null) {
            int n3 = 0;
            while (n3 < this.stylers.length) {
                n2 |= this.stylers[n3].findStyleSpec(element, this.specs);
                ++n3;
            }
        }
        StyleSpec styleSpec3 = this.specs[0];
        ViewParameters viewParameters3 = new ViewParameters();
        Style style4 = this.specToStyle(styleSpec3, style, element, viewParameters3);
        style4 = this.shareStyle(style4);
        if (((n2 |= this.styleSheet.findStyleSpec(element, this.specs)) & 2) != 0) {
            styleSpec = this.specs[1];
            viewParameters = new ViewParameters();
            style2 = this.specToStyle(styleSpec, style4, element, viewParameters);
            style2 = this.shareStyle(style2);
        }
        if ((n2 & 4) != 0) {
            styleSpec2 = this.specs[2];
            viewParameters2 = new ViewParameters();
            style3 = this.specToStyle(styleSpec2, style4, element, viewParameters2);
            style3 = this.shareStyle(style3);
        }
        if (element2 == null) {
            switch (viewParameters3.display) {
                case 32: 
                case 80: 
                case 81: 
                case 89: {
                    viewParameters3.display = 89;
                    break;
                }
                case 78: 
                case 79: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 90: {
                    viewParameters3.display = 78;
                    break;
                }
                default: {
                    viewParameters3.display = 76;
                }
            }
        }
        switch (viewParameters3.display) {
            case 32: {
                return null;
            }
            case 89: {
                styledElementView = new StyledTreeView(element, style4);
                break;
            }
            case 78: {
                if (viewParameters3.collapsible) {
                    styledElementView = new CollapsibleTableView(element, style4);
                    break;
                }
            }
            case 79: {
                styledElementView = new TableView(element, style4);
                break;
            }
            case 80: {
                styledElementView = new ColumnGroupView(element, style4);
                break;
            }
            case 81: {
                styledElementView = new ColumnView(element, style4);
                break;
            }
            case 82: 
            case 83: 
            case 84: {
                styledElementView = new RowGroupView(element, style4);
                break;
            }
            case 85: {
                styledElementView = new RowView(element, style4);
                break;
            }
            case 86: {
                styledElementView = new CellView(element, style4);
                break;
            }
            case 90: {
                styledElementView = new SubtableView(element, style4);
                break;
            }
            case 87: {
                styledElementView = new CaptionView(element, style4);
                break;
            }
            case 76: {
                if (viewParameters3.collapsible) {
                    styledElementView = new CollapsibleParagraphView(element, style4);
                    break;
                }
            }
            case 88: {
                styledElementView = new ParagraphView(element, style4);
                break;
            }
            case 77: {
                viewParameters3.display = 75;
            }
            default: {
                styledElementView = new InlineGroupView(element, style4);
            }
        }
        if (styledElementView instanceof TreeView) {
            styledElementView.initView(viewParameters3, null, null, null, null, this);
            return styledElementView;
        }
        if (styleSpec3.collapsedContent != null) {
            viewParameters3.collapsedContent = this.contentToViewParts(styleSpec3.collapsedContent, style4, styledElementView, 1);
        }
        if (styleSpec3.content != null) {
            viewParameters3.content = this.contentToViewParts(styleSpec3.content, style4, styledElementView, 3);
        }
        if (styleSpec != null) {
            if (styleSpec.content != null && viewParameters.display != 32) {
                viewParameters.content = this.contentToViewParts(styleSpec.content, style2, styledElementView, 2);
            }
            if (viewParameters.content == null) {
                viewParameters = null;
                style2 = null;
            }
        }
        if (styleSpec2 != null) {
            if (styleSpec2.content != null && viewParameters2.display != 32) {
                viewParameters2.content = this.contentToViewParts(styleSpec2.content, style3, styledElementView, 4);
            }
            if (viewParameters2.content == null) {
                viewParameters2 = null;
                style3 = null;
            }
        }
        styledElementView.initView(viewParameters3, viewParameters, style2, viewParameters2, style3, this);
        return styledElementView;
    }

    public final Style specToStyle(StyleSpec styleSpec, Style style, Element element, ViewParameters viewParameters) {
        Style style2;
        if (style == null) {
            style = this.defaultStyle;
            style2 = this.defaultStyle.copy();
        } else {
            style2 = style.copy();
            style2.resetNonInherited();
        }
        this.specToStyle(styleSpec, style, element, style2, viewParameters);
        return style2;
    }

    public final void specToStyle(StyleSpec styleSpec, Style style, Element element, Style style2, ViewParameters viewParameters) {
        Color color;
        StyleValue styleValue;
        Font font = style.font;
        String string = font.getFamily();
        int n = font.getStyle();
        int n2 = font.getSize();
        FontMetrics fontMetrics = null;
        if (styleSpec.fontFamily != null) {
            styleValue = this.eval(styleSpec.fontFamily, element);
            switch (styleValue.type) {
                case 45: {
                    string = this.serifFamily;
                    break;
                }
                case 46: {
                    string = this.sansSerifFamily;
                    break;
                }
                case 47: {
                    string = this.monospaceFamily;
                }
            }
        }
        if (styleSpec.fontStyle != null) {
            styleValue = this.eval(styleSpec.fontStyle, element);
            switch (styleValue.type) {
                case 31: {
                    n &= 0xFFFFFFFD;
                    break;
                }
                case 48: 
                case 49: {
                    n |= 2;
                }
            }
        }
        if (styleSpec.fontWeight != null) {
            styleValue = this.eval(styleSpec.fontWeight, element);
            switch (styleValue.type) {
                case 31: {
                    n &= 0xFFFFFFFE;
                    break;
                }
                case 50: {
                    n |= 1;
                }
            }
        }
        if (styleSpec.fontSize != null) {
            styleValue = this.eval(styleSpec.fontSize, element);
            switch (styleValue.type) {
                case 42: {
                    n2 = this.defaultStyle.font.getSize();
                    break;
                }
                case 51: {
                    n2 = this.defaultStyle.font.getSize() - 2;
                    break;
                }
                case 52: {
                    n2 = this.defaultStyle.font.getSize() + 4;
                    break;
                }
                case 53: {
                    n2 = this.defaultStyle.font.getSize() - 4;
                    break;
                }
                case 54: {
                    n2 = this.defaultStyle.font.getSize() + 8;
                    break;
                }
                case 55: {
                    n2 = this.defaultStyle.font.getSize() - 6;
                    break;
                }
                case 56: {
                    n2 = this.defaultStyle.font.getSize() + 12;
                    break;
                }
                case 57: {
                    n2 += 2;
                    break;
                }
                case 58: {
                    n2 -= 2;
                    break;
                }
                case 20: {
                    n2 = (int)Math.rint((double)n2 * styleValue.number / 100.0);
                    break;
                }
                case 6: {
                    n2 = (int)Math.rint(styleValue.number * 72.0);
                    break;
                }
                case 7: {
                    n2 = (int)Math.rint(styleValue.number / 2.54 * 72.0);
                    break;
                }
                case 8: {
                    n2 = (int)Math.rint(styleValue.number / 25.4 * 72.0);
                    break;
                }
                case 9: {
                    n2 = (int)Math.rint(styleValue.number);
                    break;
                }
                case 10: {
                    n2 = (int)Math.rint(styleValue.number * 12.0);
                    break;
                }
                case 11: {
                    n2 = (int)Math.rint(styleValue.number * (double)n2);
                    break;
                }
                case 12: {
                    fontMetrics = this.docView.getFontMetrics(font);
                    n2 = (int)Math.rint(styleValue.number * (double)fontMetrics.getAscent() / 2.0 / this.screenResolution * 72.0);
                    break;
                }
                case 0: 
                case 5: {
                    n2 = (int)Math.rint(styleValue.number / this.screenResolution * 72.0);
                }
            }
        }
        if (n2 < 6) {
            n2 = 6;
        } else if (n2 > 72) {
            n2 = 72;
        }
        if (n2 != font.getSize() || n != font.getStyle() || !string.toLowerCase().equals(font.getFamily().toLowerCase())) {
            style2.font = this.getFont(string, n, n2);
        }
        fontMetrics = this.docView.getFontMetrics(style2.font);
        if (styleSpec.marginTop != null) {
            styleValue = this.eval(styleSpec.marginTop, element);
            switch (styleValue.type) {
                case 29: {
                    style2.marginTop = style.marginTop;
                    break;
                }
                case 30: {
                    style2.marginTop = -1;
                    break;
                }
                default: {
                    if ((styleValue.type < 5 || styleValue.type > 12) && styleValue.type != 0 || !(styleValue.number >= 0.0)) break;
                    style2.marginTop = StyledViewFactoryUtil.lengthToPixels(styleValue.type, styleValue.number, fontMetrics, this.screenResolution);
                }
            }
        }
        if (styleSpec.marginRight != null) {
            styleValue = this.eval(styleSpec.marginRight, element);
            switch (styleValue.type) {
                case 29: {
                    style2.marginRight = style.marginRight;
                    break;
                }
                case 30: {
                    style2.marginRight = -1;
                    break;
                }
                default: {
                    if ((styleValue.type < 5 || styleValue.type > 12) && styleValue.type != 0 || !(styleValue.number >= 0.0)) break;
                    style2.marginRight = StyledViewFactoryUtil.lengthToPixels(styleValue.type, styleValue.number, fontMetrics, this.screenResolution);
                }
            }
        }
        if (styleSpec.marginBottom != null) {
            styleValue = this.eval(styleSpec.marginBottom, element);
            switch (styleValue.type) {
                case 29: {
                    style2.marginBottom = style.marginBottom;
                    break;
                }
                case 30: {
                    style2.marginBottom = -1;
                    break;
                }
                default: {
                    if ((styleValue.type < 5 || styleValue.type > 12) && styleValue.type != 0 || !(styleValue.number >= 0.0)) break;
                    style2.marginBottom = StyledViewFactoryUtil.lengthToPixels(styleValue.type, styleValue.number, fontMetrics, this.screenResolution);
                }
            }
        }
        if (styleSpec.marginLeft != null) {
            styleValue = this.eval(styleSpec.marginLeft, element);
            switch (styleValue.type) {
                case 29: {
                    style2.marginLeft = style.marginLeft;
                    break;
                }
                case 30: {
                    style2.marginLeft = -1;
                    break;
                }
                default: {
                    if ((styleValue.type < 5 || styleValue.type > 12) && styleValue.type != 0 || !(styleValue.number >= 0.0)) break;
                    style2.marginLeft = StyledViewFactoryUtil.lengthToPixels(styleValue.type, styleValue.number, fontMetrics, this.screenResolution);
                }
            }
        }
        if (styleSpec.paddingTop != null) {
            styleValue = this.eval(styleSpec.paddingTop, element);
            if (styleValue.type == 29) {
                style2.paddingTop = style.paddingTop;
            } else if ((styleValue.type >= 5 && styleValue.type <= 12 || styleValue.type == 0) && styleValue.number >= 0.0) {
                style2.paddingTop = StyledViewFactoryUtil.lengthToPixels(styleValue.type, styleValue.number, fontMetrics, this.screenResolution);
            }
        }
        if (styleSpec.paddingRight != null) {
            styleValue = this.eval(styleSpec.paddingRight, element);
            if (styleValue.type == 29) {
                style2.paddingRight = style.paddingRight;
            } else if ((styleValue.type >= 5 && styleValue.type <= 12 || styleValue.type == 0) && styleValue.number >= 0.0) {
                style2.paddingRight = StyledViewFactoryUtil.lengthToPixels(styleValue.type, styleValue.number, fontMetrics, this.screenResolution);
            }
        }
        if (styleSpec.paddingBottom != null) {
            styleValue = this.eval(styleSpec.paddingBottom, element);
            if (styleValue.type == 29) {
                style2.paddingBottom = style.paddingBottom;
            } else if ((styleValue.type >= 5 && styleValue.type <= 12 || styleValue.type == 0) && styleValue.number >= 0.0) {
                style2.paddingBottom = StyledViewFactoryUtil.lengthToPixels(styleValue.type, styleValue.number, fontMetrics, this.screenResolution);
            }
        }
        if (styleSpec.paddingLeft != null) {
            styleValue = this.eval(styleSpec.paddingLeft, element);
            if (styleValue.type == 29) {
                style2.paddingLeft = style.paddingLeft;
            } else if ((styleValue.type >= 5 && styleValue.type <= 12 || styleValue.type == 0) && styleValue.number >= 0.0) {
                style2.paddingLeft = StyledViewFactoryUtil.lengthToPixels(styleValue.type, styleValue.number, fontMetrics, this.screenResolution);
            }
        }
        if (styleSpec.borderStyle != null) {
            styleValue = this.eval(styleSpec.borderStyle, element);
            switch (styleValue.type) {
                case 29: {
                    style2.borderStyle = style.borderStyle;
                    break;
                }
                case 32: {
                    style2.borderStyle = 0;
                    break;
                }
                case 33: {
                    style2.borderStyle = 1;
                    break;
                }
                case 34: {
                    style2.borderStyle = 2;
                    break;
                }
                case 35: {
                    style2.borderStyle = 3;
                    break;
                }
                case 36: {
                    style2.borderStyle = 4;
                    break;
                }
                case 37: {
                    style2.borderStyle = 5;
                    break;
                }
                case 38: {
                    style2.borderStyle = 6;
                    break;
                }
                case 39: {
                    style2.borderStyle = 7;
                    break;
                }
                case 40: {
                    style2.borderStyle = 8;
                }
            }
        }
        if (styleSpec.borderWidth != null) {
            styleValue = this.eval(styleSpec.borderWidth, element);
            switch (styleValue.type) {
                case 29: {
                    style2.borderWidth = style.borderWidth;
                    break;
                }
                case 41: {
                    style2.borderWidth = 1;
                    break;
                }
                case 42: {
                    style2.borderWidth = 2;
                    break;
                }
                case 43: {
                    style2.borderWidth = 4;
                    break;
                }
                default: {
                    if ((styleValue.type < 5 || styleValue.type > 12) && styleValue.type != 0 || !(styleValue.number >= 0.0)) break;
                    style2.borderWidth = StyledViewFactoryUtil.lengthToPixels(styleValue.type, styleValue.number, fontMetrics, this.screenResolution);
                }
            }
        }
        if (styleSpec.borderTopColor != null) {
            styleValue = this.eval(styleSpec.borderTopColor, element);
            switch (styleValue.type) {
                case 29: {
                    style2.borderTopColor = style.borderTopColor;
                    break;
                }
                case 44: {
                    style2.borderTopColor = null;
                    break;
                }
                case 27: {
                    style2.borderTopColor = styleValue.color;
                    break;
                }
                case 2: {
                    color = styleValue.colorValue();
                    if (color == null) break;
                    style2.borderTopColor = color;
                }
            }
        }
        if (styleSpec.borderRightColor != null) {
            styleValue = this.eval(styleSpec.borderRightColor, element);
            switch (styleValue.type) {
                case 29: {
                    style2.borderRightColor = style.borderRightColor;
                    break;
                }
                case 44: {
                    style2.borderRightColor = null;
                    break;
                }
                case 27: {
                    style2.borderRightColor = styleValue.color;
                    break;
                }
                case 2: {
                    color = styleValue.colorValue();
                    if (color == null) break;
                    style2.borderRightColor = color;
                }
            }
        }
        if (styleSpec.borderBottomColor != null) {
            styleValue = this.eval(styleSpec.borderBottomColor, element);
            switch (styleValue.type) {
                case 29: {
                    style2.borderBottomColor = style.borderBottomColor;
                    break;
                }
                case 44: {
                    style2.borderBottomColor = null;
                    break;
                }
                case 27: {
                    style2.borderBottomColor = styleValue.color;
                    break;
                }
                case 2: {
                    color = styleValue.colorValue();
                    if (color == null) break;
                    style2.borderBottomColor = color;
                }
            }
        }
        if (styleSpec.borderLeftColor != null) {
            styleValue = this.eval(styleSpec.borderLeftColor, element);
            switch (styleValue.type) {
                case 29: {
                    style2.borderLeftColor = style.borderLeftColor;
                    break;
                }
                case 44: {
                    style2.borderLeftColor = null;
                    break;
                }
                case 27: {
                    style2.borderLeftColor = styleValue.color;
                    break;
                }
                case 2: {
                    color = styleValue.colorValue();
                    if (color == null) break;
                    style2.borderLeftColor = color;
                }
            }
        }
        if (styleSpec.backgroundColor != null) {
            styleValue = this.eval(styleSpec.backgroundColor, element);
            switch (styleValue.type) {
                case 29: {
                    style2.backgroundColor = style.backgroundColor;
                    break;
                }
                case 44: {
                    style2.backgroundColor = null;
                    break;
                }
                case 27: {
                    style2.backgroundColor = styleValue.color;
                    break;
                }
                case 2: {
                    color = styleValue.colorValue();
                    if (color == null) break;
                    style2.backgroundColor = color;
                }
            }
        }
        if (styleSpec.color != null) {
            styleValue = this.eval(styleSpec.color, element);
            switch (styleValue.type) {
                case 27: {
                    style2.color = styleValue.color;
                    break;
                }
                case 2: {
                    color = styleValue.colorValue();
                    if (color == null) break;
                    style2.color = color;
                }
            }
        }
        if (styleSpec.textAlign != null) {
            styleValue = this.eval(styleSpec.textAlign, element);
            switch (styleValue.type) {
                case 62: {
                    style2.textAlign = 0;
                    break;
                }
                case 63: {
                    style2.textAlign = 1;
                    break;
                }
                case 64: {
                    style2.textAlign = 2;
                }
            }
        }
        if (styleSpec.textIndent != null) {
            styleValue = this.eval(styleSpec.textIndent, element);
            if (styleValue.type >= 5 && styleValue.type <= 12 || styleValue.type == 0) {
                style2.textIndent = StyledViewFactoryUtil.lengthToPixels(styleValue.type, styleValue.number, fontMetrics, this.screenResolution);
            }
        }
        if (styleSpec.verticalAlign != null) {
            styleValue = this.eval(styleSpec.verticalAlign, element);
            switch (styleValue.type) {
                case 29: {
                    style2.verticalAlign = style.verticalAlign;
                    break;
                }
                case 65: {
                    style2.verticalAlign = 0;
                    break;
                }
                case 69: {
                    style2.verticalAlign = 1;
                    break;
                }
                case 70: {
                    style2.verticalAlign = 2;
                    break;
                }
                case 66: {
                    style2.verticalAlign = 3;
                    break;
                }
                case 71: {
                    style2.verticalAlign = 4;
                    break;
                }
                case 67: {
                    style2.verticalAlign = 5;
                    break;
                }
                case 68: {
                    style2.verticalAlign = 6;
                    break;
                }
                case 72: {
                    style2.verticalAlign = 7;
                }
            }
        }
        if (styleSpec.lineHeight != null) {
            styleValue = this.eval(styleSpec.lineHeight, element);
            switch (styleValue.type) {
                case 31: {
                    style2.lineHeight = 1.0;
                    break;
                }
                case 0: {
                    if (!(styleValue.number > 0.0)) break;
                    style2.lineHeight = styleValue.number;
                }
            }
        }
        if (styleSpec.whiteSpace != null) {
            styleValue = this.eval(styleSpec.whiteSpace, element);
            switch (styleValue.type) {
                case 31: {
                    style2.whiteSpace = 0;
                    break;
                }
                case 73: {
                    style2.whiteSpace = 1;
                    break;
                }
                case 74: {
                    style2.whiteSpace = 2;
                }
            }
        }
        if (styleSpec.display != null) {
            styleValue = this.eval(styleSpec.display, element);
            switch (styleValue.type) {
                case 32: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: {
                    viewParameters.display = styleValue.type;
                }
            }
        }
        if (styleSpec.textDecoration != null) {
            styleValue = this.eval(styleSpec.textDecoration, element);
            switch (styleValue.type) {
                case 29: {
                    style2.textDecoration = style.textDecoration;
                    break;
                }
                case 32: {
                    style2.textDecoration = 0;
                    break;
                }
                case 59: {
                    style2.textDecoration = 1;
                    break;
                }
                case 60: {
                    style2.textDecoration = 2;
                    break;
                }
                case 61: {
                    style2.textDecoration = 3;
                }
            }
        } else if (viewParameters.display == 75) {
            style2.textDecoration = style.textDecoration;
        }
        if (styleSpec.markerOffset != null) {
            styleValue = this.eval(styleSpec.markerOffset, element);
            switch (styleValue.type) {
                case 30: {
                    viewParameters.markerOffset = 5;
                    break;
                }
                default: {
                    if ((styleValue.type < 5 || styleValue.type > 12) && styleValue.type != 0 || !(styleValue.number >= 0.0)) break;
                    viewParameters.markerOffset = StyledViewFactoryUtil.lengthToPixels(styleValue.type, styleValue.number, fontMetrics, this.screenResolution);
                }
            }
        }
        if (styleSpec.width != null) {
            styleValue = this.eval(styleSpec.width, element);
            switch (styleValue.type) {
                case 30: {
                    viewParameters.width = -1;
                    viewParameters.widthIsPercent = false;
                    viewParameters.proportionalWidth = -1;
                    break;
                }
                case 20: {
                    int n3 = (int)Math.rint(styleValue.number);
                    if (n3 <= 0) break;
                    viewParameters.width = n3;
                    viewParameters.widthIsPercent = true;
                    viewParameters.proportionalWidth = -1;
                    break;
                }
                case 21: {
                    int n4 = (int)Math.rint(styleValue.number);
                    if (!"*".equals(styleValue.string) || n4 < 0) break;
                    viewParameters.width = -1;
                    viewParameters.widthIsPercent = false;
                    viewParameters.proportionalWidth = n4;
                    break;
                }
                case 4: {
                    if (styleValue.list.length != 2) break;
                    viewParameters.width = -1;
                    viewParameters.widthIsPercent = false;
                    viewParameters.proportionalWidth = -1;
                    int n5 = 0;
                    while (n5 < 2) {
                        StyleValue styleValue2 = styleValue.list[n5];
                        switch (styleValue2.type) {
                            case 20: {
                                int n6 = (int)Math.rint(styleValue2.number);
                                if (n6 <= 0) break;
                                viewParameters.width = n6;
                                viewParameters.widthIsPercent = true;
                                break;
                            }
                            case 21: {
                                int n6 = (int)Math.rint(styleValue2.number);
                                if (!"*".equals(styleValue.string) || n6 < 0) break;
                                viewParameters.proportionalWidth = n6;
                                break;
                            }
                            default: {
                                if ((styleValue2.type < 5 || styleValue2.type > 12) && styleValue2.type != 0 || !(styleValue2.number > 0.0)) break;
                                viewParameters.width = StyledViewFactoryUtil.lengthToPixels(styleValue2.type, styleValue2.number, fontMetrics, this.screenResolution);
                                viewParameters.widthIsPercent = false;
                            }
                        }
                        ++n5;
                    }
                    if (viewParameters.proportionalWidth != 0 || viewParameters.width <= 0) break;
                    viewParameters.proportionalWidth = -1;
                    break;
                }
                default: {
                    if ((styleValue.type < 5 || styleValue.type > 12) && styleValue.type != 0 || !(styleValue.number > 0.0)) break;
                    viewParameters.width = StyledViewFactoryUtil.lengthToPixels(styleValue.type, styleValue.number, fontMetrics, this.screenResolution);
                    viewParameters.widthIsPercent = false;
                    viewParameters.proportionalWidth = -1;
                }
            }
        }
        if (styleSpec.height != null) {
            styleValue = this.eval(styleSpec.height, element);
            switch (styleValue.type) {
                case 30: {
                    viewParameters.height = -1;
                    break;
                }
                default: {
                    if ((styleValue.type < 5 || styleValue.type > 12) && styleValue.type != 0 || !(styleValue.number > 0.0)) break;
                    viewParameters.height = StyledViewFactoryUtil.lengthToPixels(styleValue.type, styleValue.number, fontMetrics, this.screenResolution);
                }
            }
        }
        if (styleSpec.captionSide != null) {
            styleValue = this.eval(styleSpec.captionSide, element);
            switch (styleValue.type) {
                case 66: 
                case 68: {
                    viewParameters.captionSide = styleValue.type;
                }
            }
        }
        if (styleSpec.borderHorizontalSpacing != null) {
            styleValue = this.eval(styleSpec.borderHorizontalSpacing, element);
            if ((styleValue.type >= 5 && styleValue.type <= 12 || styleValue.type == 0) && styleValue.number >= 0.0) {
                viewParameters.borderHorizontalSpacing = StyledViewFactoryUtil.lengthToPixels(styleValue.type, styleValue.number, fontMetrics, this.screenResolution);
            }
        }
        if (styleSpec.borderVerticalSpacing != null) {
            styleValue = this.eval(styleSpec.borderVerticalSpacing, element);
            if ((styleValue.type >= 5 && styleValue.type <= 12 || styleValue.type == 0) && styleValue.number >= 0.0) {
                viewParameters.borderVerticalSpacing = StyledViewFactoryUtil.lengthToPixels(styleValue.type, styleValue.number, fontMetrics, this.screenResolution);
            }
        }
        if (styleSpec.rowSpan != null) {
            styleValue = this.eval(styleSpec.rowSpan, element);
            if (styleValue.type == 0 && (int)styleValue.number > 0) {
                viewParameters.rowSpan = (int)styleValue.number;
            }
        }
        if (styleSpec.columnSpan != null) {
            styleValue = this.eval(styleSpec.columnSpan, element);
            if (styleValue.type == 0 && (int)styleValue.number > 0) {
                viewParameters.columnSpan = (int)styleValue.number;
            }
        }
        if (styleSpec.startColumn != null) {
            styleValue = this.eval(styleSpec.startColumn, element);
            if (styleValue.type == 0 && (int)styleValue.number >= 0) {
                viewParameters.startColumn = (int)styleValue.number;
            }
        }
        if (styleSpec.showRowColumnLabels != null) {
            styleValue = this.eval(styleSpec.showRowColumnLabels, element);
            switch (styleValue.type) {
                case 103: {
                    viewParameters.showRowColumnLabels = false;
                    break;
                }
                case 104: {
                    viewParameters.showRowColumnLabels = true;
                }
            }
        }
        if (styleSpec.collapsible != null) {
            styleValue = this.eval(styleSpec.collapsible, element);
            switch (styleValue.type) {
                case 103: {
                    viewParameters.collapsible = false;
                    break;
                }
                case 104: {
                    viewParameters.collapsible = true;
                }
            }
        }
        if (styleSpec.collapsed != null) {
            styleValue = this.eval(styleSpec.collapsed, element);
            switch (styleValue.type) {
                case 103: {
                    viewParameters.collapsed = false;
                    break;
                }
                case 104: {
                    viewParameters.collapsed = true;
                }
            }
        }
        if (styleSpec.notCollapsibleHead != null) {
            styleValue = this.eval(styleSpec.notCollapsibleHead, element);
            if (styleValue.type == 0 && (int)styleValue.number >= 0) {
                viewParameters.notCollapsibleHead = (int)styleValue.number;
            }
        }
        if (styleSpec.notCollapsibleFoot != null) {
            styleValue = this.eval(styleSpec.notCollapsibleFoot, element);
            if (styleValue.type == 0 && (int)styleValue.number >= 0) {
                viewParameters.notCollapsibleFoot = (int)styleValue.number;
            }
        }
        if (styleSpec.collapsedContentAlign != null) {
            styleValue = this.eval(styleSpec.collapsedContentAlign, element);
            switch (styleValue.type) {
                case 62: {
                    viewParameters.collapsedContentAlign = 0;
                    break;
                }
                case 63: {
                    viewParameters.collapsedContentAlign = 1;
                    break;
                }
                case 64: {
                    viewParameters.collapsedContentAlign = 2;
                    break;
                }
                case 30: {
                    viewParameters.collapsedContentAlign = -1;
                }
            }
        }
    }

    private Font getFont(String string, int n, int n2) {
        this.fontProbe.family = string;
        this.fontProbe.style = n;
        this.fontProbe.size = n2;
        Font font = (Font)this.fontCache.get(this.fontProbe);
        if (font == null) {
            font = new Font(string, n, n2);
            this.fontCache.put(new FontInfo(string, n, n2), font);
        }
        return font;
    }

    private StyleValue eval(StyleValue styleValue, Node node) {
        if (styleValue.type == 28) {
            if ("concatenate".equals(styleValue.string)) {
                String string = this.concatenate(styleValue.list, node);
                StyleValue styleValue2 = this.styleValueParser.parse(string, this.styleSheet.getURL());
                return styleValue2 == null ? noValue : styleValue2;
            }
            if ("invoke".equals(styleValue.string)) {
                StyleValue styleValue3 = this.invokeExtension(styleValue.list, node);
                return styleValue3 == null ? noValue : styleValue3;
            }
            return styleValue;
        }
        return styleValue;
    }

    private StyleValue invokeExtension(StyleValue[] styleValueArray, Node node) {
        Object object;
        String string;
        if (this.extensionClasses == null || styleValueArray.length == 0 || (string = styleValueArray[0].stringValue()) == null) {
            return null;
        }
        Method method = null;
        Object object2 = null;
        Class clazz = null;
        Object[] objectArray = (Object[])this.extensionMethods.get(string);
        if (objectArray == null) {
            int n = 0;
            while (n < this.extensionClasses.length) {
                clazz = this.extensionClasses[n];
                try {
                    method = clazz.getMethod(string, invokeParamTypes);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (method != null) {
                    object2 = this.extensions[n];
                    break;
                }
                ++n;
            }
            if (method == null) {
                this.reportExtensionError("method " + string + "(StyleValue[], Node, StyledViewFactory)" + " not found in any extension class", null);
                return null;
            }
            this.extensionMethods.put(string, new Object[]{method, object2});
        } else {
            method = (Method)objectArray[0];
            object2 = objectArray[1];
            clazz = object2.getClass();
        }
        try {
            StyleValue[] styleValueArray2 = new StyleValue[styleValueArray.length - 1];
            System.arraycopy(styleValueArray, 1, styleValueArray2, 0, styleValueArray2.length);
            this.invokeParams[0] = styleValueArray2;
            this.invokeParams[1] = node;
            this.invokeParams[2] = this;
            object = method.invoke(object2, this.invokeParams);
        }
        catch (Exception exception) {
            this.reportExtensionError("cannot invoke method " + clazz.getName() + "." + string + "(StyleValue[], Node, StyledViewFactory)", exception);
            return null;
        }
        try {
            return (StyleValue)object;
        }
        catch (ClassCastException classCastException) {
            this.reportExtensionError("method " + clazz.getName() + "." + string + "(StyleValue[], Node, StyledViewFactory)" + " does not return a StyleValue", classCastException);
            return null;
        }
    }

    private String concatenate(StyleValue[] styleValueArray, Node node) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < styleValueArray.length) {
            this.toString(styleValueArray[n], node, stringBuffer);
            ++n;
        }
        return stringBuffer.toString();
    }

    private void toString(StyleValue styleValue, Node node, StringBuffer stringBuffer) {
        switch (styleValue.type) {
            case 0: {
                stringBuffer.append(styleValue.number);
                break;
            }
            case 1: 
            case 2: {
                stringBuffer.append(styleValue.string);
                break;
            }
            case 3: {
                Name name = styleValue.name;
                Namespace namespace = name.getNamespace();
                if (namespace == Selector.ANY_NAMESPACE) {
                    stringBuffer.append("*|");
                } else if (namespace == Namespace.XML) {
                    stringBuffer.append("xml|");
                } else if (namespace != Namespace.NONE) {
                    String[] stringArray = this.styleSheet == null ? null : this.styleSheet.namespaceToPrefixes(namespace);
                    String string = null;
                    if (stringArray != null) {
                        int n = 0;
                        while (n < stringArray.length) {
                            String string2 = stringArray[n];
                            if (string2.length() > 0) {
                                string = string2;
                                break;
                            }
                            ++n;
                        }
                    }
                    if (string == null) {
                        stringBuffer.append("UNKNOWN|");
                    } else {
                        stringBuffer.append(string);
                        stringBuffer.append('|');
                    }
                }
                stringBuffer.append(name.getLocalPart());
                break;
            }
            case 4: {
                StyleValue[] styleValueArray = styleValue.list;
                int n = 0;
                while (n < styleValueArray.length) {
                    if (n > 0) {
                        stringBuffer.append(' ');
                    }
                    this.toString(styleValueArray[n], node, stringBuffer);
                    ++n;
                }
                break;
            }
            case 5: {
                stringBuffer.append(styleValue.number);
                stringBuffer.append("px");
                break;
            }
            case 6: {
                stringBuffer.append(styleValue.number);
                stringBuffer.append("in");
                break;
            }
            case 7: {
                stringBuffer.append(styleValue.number);
                stringBuffer.append("cm");
                break;
            }
            case 8: {
                stringBuffer.append(styleValue.number);
                stringBuffer.append("mm");
                break;
            }
            case 9: {
                stringBuffer.append(styleValue.number);
                stringBuffer.append("pt");
                break;
            }
            case 10: {
                stringBuffer.append(styleValue.number);
                stringBuffer.append("pc");
                break;
            }
            case 11: {
                stringBuffer.append(styleValue.number);
                stringBuffer.append("em");
                break;
            }
            case 12: {
                stringBuffer.append(styleValue.number);
                stringBuffer.append("ex");
                break;
            }
            case 13: {
                stringBuffer.append(styleValue.number);
                stringBuffer.append("deg");
                break;
            }
            case 14: {
                stringBuffer.append(styleValue.number);
                stringBuffer.append("grad");
                break;
            }
            case 15: {
                stringBuffer.append(styleValue.number);
                stringBuffer.append("rad");
                break;
            }
            case 16: {
                stringBuffer.append(styleValue.number);
                stringBuffer.append("ms");
                break;
            }
            case 17: {
                stringBuffer.append(styleValue.number);
                stringBuffer.append("s");
                break;
            }
            case 18: {
                stringBuffer.append(styleValue.number);
                stringBuffer.append("hz");
                break;
            }
            case 19: {
                stringBuffer.append(styleValue.number);
                stringBuffer.append("khz");
                break;
            }
            case 20: {
                stringBuffer.append(styleValue.number);
                stringBuffer.append("%");
                break;
            }
            case 21: {
                stringBuffer.append(styleValue.number);
                stringBuffer.append(styleValue.string);
                break;
            }
            case 22: {
                stringBuffer.append(styleValue.string);
                break;
            }
            case 23: {
                Element element = node instanceof Element ? (Element)node : node.getParentElement();
                String string = DocumentTypeUtil.getElementAttribute(element, styleValue.name, null);
                if (string == null) break;
                stringBuffer.append(string);
                break;
            }
            case 24: {
                String string = this.evalXPath(styleValue.xpath, node);
                if (string == null) break;
                stringBuffer.append(string);
                break;
            }
            case 27: {
                Color color = styleValue.color;
                stringBuffer.append("rgb(");
                stringBuffer.append(color.getRed());
                stringBuffer.append(',');
                stringBuffer.append(color.getGreen());
                stringBuffer.append(',');
                stringBuffer.append(color.getBlue());
                stringBuffer.append(')');
                break;
            }
            case 25: {
                stringBuffer.append("counter(");
                stringBuffer.append(styleValue.string);
                stringBuffer.append(',');
                this.toString(styleValue.list[0], node, stringBuffer);
                stringBuffer.append(')');
                break;
            }
            case 26: {
                stringBuffer.append("counters(");
                stringBuffer.append(styleValue.string);
                stringBuffer.append(',');
                this.toString(styleValue.list[0], node, stringBuffer);
                stringBuffer.append(',');
                this.toString(styleValue.list[1], node, stringBuffer);
                stringBuffer.append(')');
                break;
            }
            case 28: {
                if ("concatenate".equals(styleValue.string)) {
                    stringBuffer.append(this.concatenate(styleValue.list, node));
                    break;
                }
                if ("invoke".equals(styleValue.string)) {
                    StyleValue styleValue2 = this.invokeExtension(styleValue.list, node);
                    if (styleValue2 == null) break;
                    this.toString(styleValue2, node, stringBuffer);
                    break;
                }
                stringBuffer.append(styleValue.string);
                stringBuffer.append('(');
                StyleValue[] styleValueArray = styleValue.list;
                int n = 0;
                while (n < styleValueArray.length) {
                    if (n > 0) {
                        stringBuffer.append(',');
                    }
                    this.toString(styleValueArray[n], node, stringBuffer);
                    ++n;
                }
                stringBuffer.append(')');
                break;
            }
            default: {
                String string = StyleValue.getKeyword(styleValue.type);
                if (string == null) break;
                stringBuffer.append(string);
            }
        }
    }

    private String evalXPath(StringExpr stringExpr, XNode xNode) {
        SimpleDocumentCache.installDefaultDocumentManager();
        SimpleExprContext simpleExprContext = new SimpleExprContext(){

            public Variant getVariableValue(Name name, XNode xNode) throws EvalException {
                if (name == Name.get("styleSheetURL")) {
                    URL uRL = StyledViewFactory.this.styleSheet.getURL();
                    String string = uRL == null ? "" : uRL.toExternalForm();
                    return new StringVariant(string);
                }
                return null;
            }
        };
        String string = null;
        try {
            string = stringExpr.eval(xNode, simpleExprContext);
        }
        catch (EvalException evalException) {}
        return string;
    }

    private TextNodeViewPart[] contentToTextNodeViewParts(StyleValue styleValue, Style style, TextNodeView textNodeView) {
        Object object;
        TextNodeViewPart[] textNodeViewPartArray;
        StyleValue[] styleValueArray;
        Style style2 = style.copy();
        style2.resetBox();
        style2 = this.shareStyle(style2);
        TextNode textNode = textNodeView.getTextNode();
        switch (styleValue.type) {
            case 4: {
                styleValueArray = styleValue.list;
                break;
            }
            case 28: {
                if ("content".equals(styleValue.string)) {
                    styleValueArray = styleValue.list;
                    break;
                }
            }
            default: {
                styleValueArray = new StyleValue[]{styleValue};
            }
        }
        TextNodeViewPart[] textNodeViewPartArray2 = new TextNodeViewPart[styleValueArray.length];
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < styleValueArray.length) {
            textNodeViewPartArray = this.eval(styleValueArray[n2], textNode);
            switch (textNodeViewPartArray.type) {
                case 93: 
                case 94: {
                    break;
                }
                case 1: {
                    stringBuffer.append(textNodeViewPartArray.string);
                    break;
                }
                case 91: {
                    stringBuffer.append(StyledViewFactoryUtil.nativeQuote(textNode.getParentElement(), false));
                    break;
                }
                case 92: {
                    stringBuffer.append(StyledViewFactoryUtil.nativeQuote(textNode.getParentElement(), true));
                    break;
                }
                case 24: {
                    object = this.evalXPath(textNodeViewPartArray.xpath, textNode);
                    if (object == null) break;
                    stringBuffer.append((String)object);
                    break;
                }
                case 22: 
                case 95: 
                case 96: 
                case 97: {
                    Object object2;
                    object = null;
                    switch (textNodeViewPartArray.type) {
                        case 22: {
                            object2 = null;
                            try {
                                object2 = new URL(textNodeViewPartArray.string);
                            }
                            catch (MalformedURLException malformedURLException) {
                                // empty catch block
                            }
                            if (object2 != null) {
                                object = StyledViewFactoryUtil.fetchImage((URL)object2);
                            }
                            if (object != null) break;
                            object = Icon.get("image");
                            break;
                        }
                        case 95: {
                            object = Icon.get(1, style2.color, style2.backgroundColor);
                            break;
                        }
                        case 96: {
                            object = Icon.get(2, style2.color, style2.backgroundColor);
                            break;
                        }
                        case 97: {
                            object = Icon.get(3, style2.color, style2.backgroundColor);
                        }
                    }
                    if (object == null) break;
                    if (stringBuffer.length() > 0) {
                        textNodeViewPartArray2[n++] = new ParagraphTextTVP(style2, stringBuffer.toString(), textNodeView);
                        stringBuffer = new StringBuffer();
                    }
                    textNodeViewPartArray2[n++] = new ImageLabelTVP(style2, (Image)object, textNodeView);
                    break;
                }
                case 28: {
                    Object object2;
                    object = null;
                    if ("icon".equals(textNodeViewPartArray.string) && (object2 = this.iconContentToImage(textNodeViewPartArray.list, style2)) != null) {
                        object = new ImageLabelTVP(style2, (Image)object2, textNodeView);
                    }
                    if ("text".equals(textNodeViewPartArray.string)) {
                        stringBuffer.append(textNode.getText());
                    }
                    if ("processing-instruction-target".equals(textNodeViewPartArray.string)) {
                        if (textNode instanceof ProcessingInstruction) {
                            stringBuffer.append(((ProcessingInstruction)textNode).getTarget());
                        }
                    } else if ("gadget".equals(textNodeViewPartArray.string)) {
                        object = this.gadgetContentToTextNodeViewPart(null, textNodeViewPartArray.list, style2, textNodeView);
                    } else {
                        object2 = StyledViewFactory.functionNameToGadgetFactory2(textNodeViewPartArray.string);
                        if (object2 != null) {
                            object = this.gadgetContentToTextNodeViewPart((GadgetFactory2)object2, textNodeViewPartArray.list, style2, textNodeView);
                        }
                    }
                    if (object == null) break;
                    if (stringBuffer.length() > 0) {
                        textNodeViewPartArray2[n++] = new ParagraphTextTVP(style2, stringBuffer.toString(), textNodeView);
                        stringBuffer = new StringBuffer();
                    }
                    textNodeViewPartArray2[n++] = object;
                }
            }
            ++n2;
        }
        if (stringBuffer.length() > 0) {
            textNodeViewPartArray2[n++] = new ParagraphTextTVP(style2, stringBuffer.toString(), textNodeView);
        }
        if (n > 0) {
            if (n == textNodeViewPartArray2.length) {
                textNodeViewPartArray = textNodeViewPartArray2;
            } else {
                object = new TextNodeViewPart[n];
                System.arraycopy(textNodeViewPartArray2, 0, object, 0, n);
                textNodeViewPartArray = object;
            }
        } else {
            textNodeViewPartArray = null;
        }
        return textNodeViewPartArray;
    }

    private static final GadgetFactory2 functionNameToGadgetFactory2(String string) {
        GadgetFactory2 gadgetFactory2;
        block2: {
            gadgetFactory2 = null;
            Class clazz = StyledViewFactory.findFactoryClass(string);
            if (clazz == null) break block2;
            try {
                gadgetFactory2 = (GadgetFactory2)clazz.newInstance();
            }
            catch (Exception exception) {}
        }
        return gadgetFactory2;
    }

    private static final Class findFactoryClass(String string) {
        Class<?> clazz = (Class<?>)factoryNameToClass.get(string = StyledViewFactoryUtil.toJavaName(string, true));
        if (clazz == null) {
            String[] stringArray = StyledViewFactory.getFactoryPackageNames();
            int n = 0;
            while (n < stringArray.length) {
                String string2 = stringArray[n];
                StringBuffer stringBuffer = new StringBuffer();
                if (string2.length() > 0) {
                    stringBuffer.append(string2);
                    stringBuffer.append('.');
                }
                stringBuffer.append(string);
                try {
                    clazz = Class.forName(stringBuffer.toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (clazz != null) {
                    factoryNameToClass.put(string, clazz);
                    break;
                }
                ++n;
            }
        }
        return clazz;
    }

    public static final void addFactoryPackageName(String string) {
        if (!StringUtil.contains(factoryPackageNames, string)) {
            factoryPackageNames = StringUtil.prepend(factoryPackageNames, string);
            factoryNameToClass.clear();
        }
    }

    public static final String[] getFactoryPackageNames() {
        return factoryPackageNames;
    }

    private TextNodeViewPart gadgetContentToTextNodeViewPart(GadgetFactory2 gadgetFactory2, StyleValue[] styleValueArray, Style style, TextNodeView textNodeView) {
        Object object;
        StyleValue[] styleValueArray2;
        String string;
        if (gadgetFactory2 != null) {
            string = gadgetFactory2.getClass().getName();
            styleValueArray2 = styleValueArray;
        } else {
            if (styleValueArray.length < 1 || styleValueArray[0].type != 1) {
                return null;
            }
            string = styleValueArray[0].string;
            try {
                object = Class.forName(string);
            }
            catch (Exception exception) {
                this.reportExtensionError("cannot load GadgetFactory2 class " + string, exception);
                return null;
            }
            try {
                gadgetFactory2 = (GadgetFactory2)((Class)object).newInstance();
            }
            catch (Exception exception) {
                this.reportExtensionError("cannot create an instance of GadgetFactory2 class " + string, exception);
                return null;
            }
            styleValueArray2 = new StyleValue[styleValueArray.length - 1];
            if (styleValueArray2.length > 0) {
                System.arraycopy(styleValueArray, 1, styleValueArray2, 0, styleValueArray2.length);
            }
        }
        try {
            object = gadgetFactory2.createGadget(textNodeView, style, styleValueArray2, this);
        }
        catch (Exception exception) {
            this.reportExtensionError("cannot invoke createGadget(TextNodeView, int, Style, StyleValue[], StyledViewFactory) for instance of class " + string, exception);
            return null;
        }
        try {
            return (TextNodeViewPart)object;
        }
        catch (Exception exception) {
            this.reportExtensionError("gadget class " + object.getClass().getName() + " does not implement interface TextNodeViewPart", exception);
            return null;
        }
    }

    public final StyledElementViewPart[] contentToViewParts(StyleValue styleValue, Style style, StyledElementView styledElementView, int n) {
        Object object;
        StyledElementViewPart[] styledElementViewPartArray;
        StyleValue[] styleValueArray;
        Style style2 = style.copy();
        style2.resetBox();
        style2 = this.shareStyle(style2);
        Element element = styledElementView.getElement();
        switch (styleValue.type) {
            case 4: {
                styleValueArray = styleValue.list;
                break;
            }
            case 28: {
                if ("content".equals(styleValue.string)) {
                    styleValueArray = styleValue.list;
                    break;
                }
            }
            default: {
                styleValueArray = new StyleValue[]{styleValue};
            }
        }
        StyledElementViewPart[] styledElementViewPartArray2 = new StyledElementViewPart[styleValueArray.length];
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        while (n3 < styleValueArray.length) {
            styledElementViewPartArray = this.eval(styleValueArray[n3], element);
            switch (styledElementViewPartArray.type) {
                case 93: 
                case 94: {
                    break;
                }
                case 1: {
                    stringBuffer.append(styledElementViewPartArray.string);
                    break;
                }
                case 91: {
                    stringBuffer.append(StyledViewFactoryUtil.nativeQuote(element, false));
                    break;
                }
                case 92: {
                    stringBuffer.append(StyledViewFactoryUtil.nativeQuote(element, true));
                    break;
                }
                case 23: {
                    object = DocumentTypeUtil.getElementAttribute(element, styledElementViewPartArray.name, null);
                    if (object == null) break;
                    stringBuffer.append((String)object);
                    break;
                }
                case 24: {
                    object = this.evalXPath(styledElementViewPartArray.xpath, element);
                    if (object == null) break;
                    stringBuffer.append((String)object);
                    break;
                }
                case 22: 
                case 95: 
                case 96: 
                case 97: {
                    Object object2;
                    object = null;
                    switch (styledElementViewPartArray.type) {
                        case 22: {
                            object2 = null;
                            try {
                                object2 = new URL(styledElementViewPartArray.string);
                            }
                            catch (MalformedURLException malformedURLException) {
                                // empty catch block
                            }
                            if (object2 != null) {
                                object = StyledViewFactoryUtil.fetchImage((URL)object2);
                            }
                            if (object != null) break;
                            object = Icon.get("image");
                            break;
                        }
                        case 95: {
                            object = Icon.get(1, style2.color, style2.backgroundColor);
                            break;
                        }
                        case 96: {
                            object = Icon.get(2, style2.color, style2.backgroundColor);
                            break;
                        }
                        case 97: {
                            object = Icon.get(3, style2.color, style2.backgroundColor);
                        }
                    }
                    if (object == null) break;
                    if (stringBuffer.length() > 0) {
                        styledElementViewPartArray2[n2++] = new TextLabelVP(style2, stringBuffer.toString(), styledElementView, n);
                        stringBuffer = new StringBuffer();
                    }
                    styledElementViewPartArray2[n2++] = new ImageLabelVP(style2, (Image)object, styledElementView, n);
                    break;
                }
                case 25: 
                case 26: {
                    object = this.counterContentToViewPart((StyleValue)styledElementViewPartArray, style2, styledElementView, n);
                    if (object == null) break;
                    if (stringBuffer.length() > 0) {
                        styledElementViewPartArray2[n2++] = new TextLabelVP(style2, stringBuffer.toString(), styledElementView, n);
                        stringBuffer = new StringBuffer();
                    }
                    styledElementViewPartArray2[n2++] = object;
                    break;
                }
                case 28: {
                    Object object2;
                    object = null;
                    if ("icon".equals(styledElementViewPartArray.string)) {
                        object = this.iconContentToViewPart(styledElementViewPartArray.list, style2, styledElementView, n);
                    } else if ("component".equals(styledElementViewPartArray.string)) {
                        object = this.componentContentToViewPart(styledElementViewPartArray.list, style2, styledElementView, n);
                    } else if ("rows".equals(styledElementViewPartArray.string)) {
                        object = this.rowsContentToViewPart(styledElementViewPartArray.list, style2, styledElementView, n);
                    } else if ("row".equals(styledElementViewPartArray.string)) {
                        object = this.rowContentToViewPart(styledElementViewPartArray.list, style2, styledElementView, n);
                    } else if ("cell".equals(styledElementViewPartArray.string)) {
                        object = this.cellContentToViewPart(styledElementViewPartArray.list, style2, styledElementView, n);
                    } else if ("division".equals(styledElementViewPartArray.string)) {
                        object = this.divisionContentToViewPart(styledElementViewPartArray.list, style2, styledElementView, n);
                    } else if ("paragraph".equals(styledElementViewPartArray.string)) {
                        object = this.paragraphContentToViewPart(styledElementViewPartArray.list, style2, styledElementView, n);
                    } else if ("element-label".equals(styledElementViewPartArray.string)) {
                        stringBuffer.append(XMLUtil.nameToLabel(element.getLocalName()));
                    } else if ("element-local-name".equals(styledElementViewPartArray.string)) {
                        stringBuffer.append(element.getLocalName());
                    } else if ("element-name".equals(styledElementViewPartArray.string)) {
                        stringBuffer.append(element.getName().format(false, element));
                    } else if ("element-namespace-uri".equals(styledElementViewPartArray.string)) {
                        stringBuffer.append(element.getNamespace().getURI());
                    } else if ("property".equals(styledElementViewPartArray.string) && styledElementViewPartArray.list.length == 1) {
                        Object object3;
                        object2 = styledElementViewPartArray.list[0].stringValue();
                        if (object2 != null && (object3 = element.getProperty(object2)) != null) {
                            stringBuffer.append(object3.toString());
                        }
                    } else if ("gadget".equals(styledElementViewPartArray.string)) {
                        object = this.gadgetContentToViewPart(null, styledElementViewPartArray.list, style2, styledElementView, n);
                    } else {
                        object2 = StyledViewFactory.functionNameToGadgetFactory(styledElementViewPartArray.string);
                        if (object2 != null) {
                            object = this.gadgetContentToViewPart((GadgetFactory)object2, styledElementViewPartArray.list, style2, styledElementView, n);
                        }
                    }
                    if (object == null) break;
                    if (stringBuffer.length() > 0) {
                        styledElementViewPartArray2[n2++] = new TextLabelVP(style2, stringBuffer.toString(), styledElementView, n);
                        stringBuffer = new StringBuffer();
                    }
                    styledElementViewPartArray2[n2++] = object;
                }
            }
            ++n3;
        }
        if (stringBuffer.length() > 0) {
            styledElementViewPartArray2[n2++] = new TextLabelVP(style2, stringBuffer.toString(), styledElementView, n);
        }
        if (n2 > 0) {
            if (n2 == styledElementViewPartArray2.length) {
                styledElementViewPartArray = styledElementViewPartArray2;
            } else {
                object = new StyledElementViewPart[n2];
                System.arraycopy(styledElementViewPartArray2, 0, object, 0, n2);
                styledElementViewPartArray = object;
            }
        } else {
            styledElementViewPartArray = null;
        }
        return styledElementViewPartArray;
    }

    private static final GadgetFactory functionNameToGadgetFactory(String string) {
        GadgetFactory gadgetFactory;
        block2: {
            gadgetFactory = null;
            Class clazz = StyledViewFactory.findFactoryClass(string);
            if (clazz == null) break block2;
            try {
                gadgetFactory = (GadgetFactory)clazz.newInstance();
            }
            catch (Exception exception) {}
        }
        return gadgetFactory;
    }

    private StyledElementViewPart counterContentToViewPart(StyleValue styleValue, Style style, StyledElementView styledElementView, int n) {
        String string;
        int n2;
        String string2 = styleValue.string;
        if (styleValue.type == 25) {
            n2 = styleValue.list[0].type;
            string = ".";
        } else {
            string = styleValue.list[0].string;
            n2 = styleValue.list[1].type;
        }
        CounterVP counterVP = new CounterVP(style, string2, n2, string, styledElementView, n);
        this.customViewManager.add(counterVP, counterVP.isHierarchical(), styledElementView.getElement());
        return counterVP;
    }

    private StyledElementViewPart iconContentToViewPart(StyleValue[] styleValueArray, Style style, StyledElementView styledElementView, int n) {
        Image image = this.iconContentToImage(styleValueArray, style);
        return image == null ? null : new ImageLabelVP(style, image, styledElementView, n);
    }

    private Image iconContentToImage(StyleValue[] styleValueArray, Style style) {
        String string = null;
        if (styleValueArray.length != 1 || (string = styleValueArray[0].stringValue()) == null) {
            return null;
        }
        return Icon.get(string, style.color, style.backgroundColor);
    }

    private StyledElementViewPart componentContentToViewPart(StyleValue[] styleValueArray, Style style, StyledElementView styledElementView, int n) {
        Component component;
        ComponentFactory componentFactory;
        Class<?> clazz;
        if (styleValueArray.length < 1 || styleValueArray[0].type != 1) {
            return null;
        }
        String string = styleValueArray[0].string;
        boolean[] blArray = new boolean[]{false, false};
        StyleValue[] styleValueArray2 = new StyleValue[styleValueArray.length - 1];
        if (styleValueArray2.length > 0) {
            System.arraycopy(styleValueArray, 1, styleValueArray2, 0, styleValueArray2.length);
        }
        try {
            clazz = Class.forName(string);
        }
        catch (Exception exception) {
            this.reportExtensionError("cannot load ComponentFactory class " + string, exception);
            return null;
        }
        try {
            componentFactory = (ComponentFactory)clazz.newInstance();
        }
        catch (Exception exception) {
            this.reportExtensionError("cannot create an instance of ComponentFactory class " + string, exception);
            return null;
        }
        try {
            component = componentFactory.createComponent(styledElementView.getElement(), style, styleValueArray2, this, blArray);
        }
        catch (Exception exception) {
            this.reportExtensionError("cannot invoke createComponent(Element, Style, StyleValue[], StyledViewFactory, boolean[]) for instance of " + string, exception);
            return null;
        }
        ComponentBoxVP componentBoxVP = new ComponentBoxVP(style, component, styledElementView, n);
        componentBoxVP.setXStretchable(blArray[0]);
        componentBoxVP.setYStretchable(blArray[1]);
        return componentBoxVP;
    }

    private StyledElementViewPart gadgetContentToViewPart(GadgetFactory gadgetFactory, StyleValue[] styleValueArray, Style style, StyledElementView styledElementView, int n) {
        Object object;
        StyleValue[] styleValueArray2;
        String string;
        if (gadgetFactory != null) {
            string = gadgetFactory.getClass().getName();
            styleValueArray2 = styleValueArray;
        } else {
            if (styleValueArray.length < 1 || styleValueArray[0].type != 1) {
                return null;
            }
            string = styleValueArray[0].string;
            try {
                object = Class.forName(string);
            }
            catch (Exception exception) {
                this.reportExtensionError("cannot load GadgetFactory class " + string, exception);
                return null;
            }
            try {
                gadgetFactory = (GadgetFactory)((Class)object).newInstance();
            }
            catch (Exception exception) {
                this.reportExtensionError("cannot create an instance of GadgetFactory class " + string, exception);
                return null;
            }
            styleValueArray2 = new StyleValue[styleValueArray.length - 1];
            if (styleValueArray2.length > 0) {
                System.arraycopy(styleValueArray, 1, styleValueArray2, 0, styleValueArray2.length);
            }
        }
        try {
            object = gadgetFactory.createGadget(styledElementView, n, style, styleValueArray2, this);
        }
        catch (Exception exception) {
            this.reportExtensionError("cannot invoke createGadget(StyledElementView, int, Style, StyleValue[], StyledViewFactory) for instance of class " + string, exception);
            return null;
        }
        try {
            return (StyledElementViewPart)object;
        }
        catch (Exception exception) {
            this.reportExtensionError("gadget class " + object.getClass().getName() + " does not implement interface StyledElementViewPart", exception);
            return null;
        }
    }

    private StyledElementViewPart rowsContentToViewPart(StyleValue[] styleValueArray, Style style, StyledElementView styledElementView, int n) {
        Object object;
        int n2 = 0;
        int n3 = 0;
        while (n3 < styleValueArray.length) {
            object = styleValueArray[n3];
            if (((StyleValue)object).type != 28 || !"row".equals(((StyleValue)object).string)) break;
            ++n2;
            ++n3;
        }
        if (n2 == 0) {
            return null;
        }
        object = null;
        if (n2 < styleValueArray.length) {
            object = StyledViewFactoryUtil.valueListToStyleSpec(styleValueArray, n2);
        }
        TableBodyVP tableBodyVP = new TableBodyVP(style, styledElementView, n);
        int n4 = 0;
        while (n4 < n2) {
            TableBody.Cell[] cellArray = this.contentToRow(styleValueArray[n4].list, (StyleSpec)object, style, styledElementView, n);
            if (cellArray == null) {
                return null;
            }
            tableBodyVP.addRow(cellArray);
            ++n4;
        }
        return tableBodyVP;
    }

    private StyledElementViewPart rowContentToViewPart(StyleValue[] styleValueArray, Style style, StyledElementView styledElementView, int n) {
        TableBody.Cell[] cellArray = this.contentToRow(styleValueArray, null, style, styledElementView, n);
        if (cellArray == null) {
            return null;
        }
        TableBodyVP tableBodyVP = new TableBodyVP(style, styledElementView, n);
        tableBodyVP.addRow(cellArray);
        return tableBodyVP;
    }

    private TableBody.Cell[] contentToRow(StyleValue[] styleValueArray, StyleSpec object, Style style, StyledElementView styledElementView, int n) {
        Object object2;
        int n2 = 0;
        int n3 = 0;
        while (n3 < styleValueArray.length) {
            object2 = styleValueArray[n3];
            if (((StyleValue)object2).type != 28 || !"cell".equals(((StyleValue)object2).string)) break;
            ++n2;
            ++n3;
        }
        if (n2 == 0) {
            return null;
        }
        object2 = null;
        if (n2 < styleValueArray.length) {
            object2 = StyledViewFactoryUtil.valueListToStyleSpec(styleValueArray, n2);
        }
        if (object2 != null) {
            if (object == null) {
                object = object2;
            } else {
                object = ((StyleSpec)object).copy();
                ((StyleSpec)object).put((StyleSpec)object2);
            }
        }
        TableBody.Cell[] cellArray = new TableBody.Cell[n2];
        int n4 = 0;
        while (n4 < n2) {
            cellArray[n4] = this.contentToCell(styleValueArray[n4].list, (StyleSpec)object, style, styledElementView, n);
            if (cellArray[n4] == null) {
                return null;
            }
            ++n4;
        }
        return cellArray;
    }

    private StyledElementViewPart cellContentToViewPart(StyleValue[] styleValueArray, Style style, StyledElementView styledElementView, int n) {
        TableBody.Cell cell = this.contentToCell(styleValueArray, null, style, styledElementView, n);
        if (cell == null) {
            return null;
        }
        TableBodyVP tableBodyVP = new TableBodyVP(style, styledElementView, n);
        tableBodyVP.addRow(new TableBody.Cell[]{cell});
        return tableBodyVP;
    }

    private TableBody.Cell contentToCell(StyleValue[] styleValueArray, StyleSpec styleSpec, Style style, StyledElementView styledElementView, int n) {
        StyledElementViewPart styledElementViewPart;
        StyledElementViewPart[] styledElementViewPartArray;
        if (styleValueArray.length < 1) {
            return null;
        }
        StyleSpec styleSpec2 = null;
        if (styleValueArray.length > 1) {
            styleSpec2 = StyledViewFactoryUtil.valueListToStyleSpec(styleValueArray, 1);
        }
        if (styleSpec2 != null) {
            if (styleSpec == null) {
                styleSpec = styleSpec2;
            } else {
                styleSpec = styleSpec.copy();
                styleSpec.put(styleSpec2);
            }
        }
        Element element = styledElementView.getElement();
        ViewParameters viewParameters = new ViewParameters();
        Style style2 = style;
        if (styleSpec != null) {
            style2 = this.specToStyle(styleSpec, style, element, viewParameters);
        }
        if ((styledElementViewPartArray = this.contentToViewParts(styleValueArray[0], style2 = this.shareStyle(style2), styledElementView, n)) == null) {
            return null;
        }
        Style style3 = style2.copy();
        style3.resetBox();
        style3 = this.shareStyle(style3);
        if (styledElementViewPartArray.length > 1) {
            styledElementViewPart = this.contentToParagraph(styledElementViewPartArray, style3, styledElementView, n);
        } else {
            styledElementViewPart = styledElementViewPartArray[0];
            styledElementViewPart.setStyle(style3);
        }
        TableBody.Cell cell = new TableBody.Cell();
        cell.gadget = (Gadget)((Object)styledElementViewPart);
        cell.style = style2;
        cell.columnSpan = viewParameters.columnSpan;
        cell.rowSpan = viewParameters.rowSpan;
        cell.widthSpec1 = viewParameters.width;
        cell.widthSpec1IsPercent = viewParameters.widthIsPercent;
        cell.widthSpec2 = viewParameters.proportionalWidth;
        cell.startColumn = viewParameters.startColumn;
        return cell;
    }

    private StyledElementViewPart divisionContentToViewPart(StyleValue[] styleValueArray, Style style, StyledElementView styledElementView, int n) {
        Object object;
        StyledElementViewPart[] styledElementViewPartArray;
        if (styleValueArray.length < 1) {
            return null;
        }
        Style style2 = style;
        if (styleValueArray.length > 1 && (styledElementViewPartArray = StyledViewFactoryUtil.valueListToStyleSpec(styleValueArray, 1)) != null) {
            object = styledElementView.getElement();
            ViewParameters viewParameters = new ViewParameters();
            style2 = this.specToStyle((StyleSpec)styledElementViewPartArray, style, (Element)object, viewParameters);
        }
        if ((styledElementViewPartArray = this.contentToViewParts(styleValueArray[0], style2 = this.shareStyle(style2), styledElementView, n)) == null) {
            return null;
        }
        object = new DivisionVP(style2, styledElementView, n);
        int n2 = 0;
        while (n2 < styledElementViewPartArray.length) {
            ((GadgetContainer)object).addChild((Gadget)((Object)styledElementViewPartArray[n2]));
            ++n2;
        }
        return object;
    }

    private StyledElementViewPart paragraphContentToViewPart(StyleValue[] styleValueArray, Style style, StyledElementView styledElementView, int n) {
        StyledElementViewPart[] styledElementViewPartArray;
        if (styleValueArray.length < 1) {
            return null;
        }
        Style style2 = style;
        if (styleValueArray.length > 1 && (styledElementViewPartArray = StyledViewFactoryUtil.valueListToStyleSpec(styleValueArray, 1)) != null) {
            Element element = styledElementView.getElement();
            ViewParameters viewParameters = new ViewParameters();
            style2 = this.specToStyle((StyleSpec)styledElementViewPartArray, style, element, viewParameters);
        }
        if ((styledElementViewPartArray = this.contentToViewParts(styleValueArray[0], style2 = this.shareStyle(style2), styledElementView, n)) == null) {
            return null;
        }
        return this.contentToParagraph(styledElementViewPartArray, style2, styledElementView, n);
    }

    private ParagraphVP contentToParagraph(StyledElementViewPart[] styledElementViewPartArray, Style style, StyledElementView styledElementView, int n) {
        ParagraphVP paragraphVP = new ParagraphVP(style, styledElementView, n);
        int n2 = 0;
        while (n2 < styledElementViewPartArray.length) {
            Gadget gadget;
            if (styledElementViewPartArray[n2] instanceof TextLabelVP) {
                TextLabelVP textLabelVP = (TextLabelVP)styledElementViewPartArray[n2];
                gadget = new ParagraphTextVP(textLabelVP.getStyle(), textLabelVP.getText(), styledElementView, n);
            } else {
                gadget = (Gadget)((Object)styledElementViewPartArray[n2]);
            }
            paragraphVP.addChild(gadget);
            ++n2;
        }
        return paragraphVP;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        String string = System.getProperty(FACTORY_PACKAGE_NAMES_PROPERTY);
        if (string == null) {
            factoryPackageNames = new String[]{"com.xmlmind.xmledit.form"};
        } else {
            factoryPackageNames = StringUtil.split(string, ';');
            if (!StringUtil.contains(factoryPackageNames, "com.xmlmind.xmledit.form")) {
                factoryPackageNames = StringUtil.append(factoryPackageNames, "com.xmlmind.xmledit.form");
            }
        }
        factoryNameToClass = new HashMap();
        noValue = new StyleValue();
        invokeParamTypes = new Class[]{array$Lcom$xmlmind$xmledit$stylesheet$StyleValue == null ? (array$Lcom$xmlmind$xmledit$stylesheet$StyleValue = StyledViewFactory.class$("[Lcom.xmlmind.xmledit.stylesheet.StyleValue;")) : array$Lcom$xmlmind$xmledit$stylesheet$StyleValue, class$com$xmlmind$xmledit$doc$Node == null ? (class$com$xmlmind$xmledit$doc$Node = StyledViewFactory.class$("com.xmlmind.xmledit.doc.Node")) : class$com$xmlmind$xmledit$doc$Node, class$com$xmlmind$xmledit$styledview$StyledViewFactory == null ? (class$com$xmlmind$xmledit$styledview$StyledViewFactory = StyledViewFactory.class$("com.xmlmind.xmledit.styledview.StyledViewFactory")) : class$com$xmlmind$xmledit$styledview$StyledViewFactory};
    }

    private static final class FontInfo {
        public String family;
        public int style;
        public int size;

        public FontInfo(String string, int n, int n2) {
            this.family = string;
            this.style = n;
            this.size = n2;
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof FontInfo)) {
                return false;
            }
            FontInfo fontInfo = (FontInfo)object;
            return this.family.equals(fontInfo.family) && this.style == fontInfo.style && this.size == fontInfo.size;
        }

        public int hashCode() {
            return this.family.hashCode() ^ this.style ^ this.size;
        }
    }

    private static final class Dependency {
        public Namespace elementNS;
        public String elementLP;
        public Namespace attributeNS;
        public String attributeLP;

        public Dependency(Namespace namespace, String string, Namespace namespace2, String string2) {
            this.elementNS = namespace;
            this.elementLP = string;
            this.attributeNS = namespace2;
            this.attributeLP = string2;
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof Dependency)) {
                return false;
            }
            Dependency dependency = (Dependency)object;
            return this.elementNS == dependency.elementNS && this.attributeNS == dependency.attributeNS && (this.elementLP == null && dependency.elementLP == null || this.elementLP != null && this.elementLP.equals(dependency.elementLP)) && (this.attributeLP == null && dependency.attributeLP == null || this.attributeLP != null && this.attributeLP.equals(dependency.attributeLP));
        }

        public int hashCode() {
            int n = System.identityHashCode(this.elementNS);
            n = this.elementLP == null ? (n ^= 0) : (n ^= this.elementLP.hashCode());
            n ^= System.identityHashCode(this.attributeNS);
            n = this.attributeLP == null ? (n ^= 0) : (n ^= this.attributeLP.hashCode());
            return n;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.elementNS == null) {
                stringBuffer.append("{*}");
            } else {
                stringBuffer.append('{');
                stringBuffer.append(this.elementNS.getURI());
                stringBuffer.append('}');
            }
            if (this.elementLP == null) {
                stringBuffer.append('*');
            } else {
                stringBuffer.append(this.elementLP);
            }
            stringBuffer.append(' ');
            if (this.attributeNS == null) {
                stringBuffer.append("{*}");
            } else {
                stringBuffer.append('{');
                stringBuffer.append(this.attributeNS.getURI());
                stringBuffer.append('}');
            }
            if (this.attributeLP == null) {
                stringBuffer.append('*');
            } else {
                stringBuffer.append(this.attributeLP);
            }
            return stringBuffer.toString();
        }
    }
}

