/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.styledview;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.gadget.GadgetContainer;
import com.xmlmind.xmledit.styledgadget.Paragraph;
import com.xmlmind.xmledit.styledgadget.Style;
import com.xmlmind.xmledit.styledview.ParagraphTextVP;
import com.xmlmind.xmledit.styledview.ParagraphVP;
import com.xmlmind.xmledit.styledview.StyledElementView;
import com.xmlmind.xmledit.styledview.StyledElementViewPart;
import com.xmlmind.xmledit.styledview.StyledViewFactory;
import com.xmlmind.xmledit.styledview.TextLabelVP;
import com.xmlmind.xmledit.view.DocumentView;
import com.xmlmind.xmledit.view.GadgetListImpl;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;

public abstract class ViewBase
implements StyledElementView {
    protected Element element;
    protected Style style;

    protected ViewBase(Element element, Style style) {
        this.element = element;
        this.style = style;
    }

    public Style getStyle() {
        return this.style;
    }

    public Node getModel() {
        return this.element;
    }

    public void detachingFromModel(Document document, int n) {
        GadgetListImpl gadgetListImpl = new GadgetListImpl();
        this.getGadgets(gadgetListImpl, n);
        int n2 = 0;
        while (n2 < gadgetListImpl.size) {
            ViewBase.detachingViewFromModel(this, gadgetListImpl.list[n2], document, n);
            ++n2;
        }
    }

    private static final void detachingViewFromModel(StyledElementView styledElementView, Gadget gadget, Document document, int n) {
        Gadget[] gadgetArray;
        if (gadget instanceof StyledElementViewPart && (gadgetArray = (Gadget[])gadget).getStyledElementView() == styledElementView) {
            gadgetArray.detachingViewFromModel(document, n);
        }
        if (gadget instanceof GadgetContainer) {
            gadgetArray = ((GadgetContainer)gadget).getChildren();
            int n2 = 0;
            while (n2 < gadgetArray.length) {
                ViewBase.detachingViewFromModel(styledElementView, gadgetArray[n2], document, n);
                ++n2;
            }
        }
    }

    public Element getElement() {
        return this.element;
    }

    protected Gadget contentToGadget(StyledElementViewPart[] styledElementViewPartArray, Style style, int n, boolean bl, StyledViewFactory styledViewFactory) {
        Object object;
        if (styledElementViewPartArray.length == 1) {
            object = styledElementViewPartArray[0];
            if (bl || !(object instanceof TextLabelVP)) {
                if (style.hasBox()) {
                    Style style2 = object.getStyle().copy();
                    style2.putBox(style);
                    style2 = styledViewFactory.shareStyle(style2);
                    object.setStyle(style2);
                }
                return (Gadget)object;
            }
        }
        if (bl) {
            if (style.whiteSpace == 2) {
                object = style;
            } else {
                object = style.copy();
                ((Style)object).whiteSpace = 2;
                object = styledViewFactory.shareStyle((Style)object);
            }
        } else {
            object = style;
        }
        ParagraphVP paragraphVP = new ParagraphVP((Style)object, this, n);
        int n2 = 0;
        while (n2 < styledElementViewPartArray.length) {
            Gadget gadget;
            if (styledElementViewPartArray[n2] instanceof TextLabelVP) {
                TextLabelVP textLabelVP = (TextLabelVP)styledElementViewPartArray[n2];
                gadget = new ParagraphTextVP(textLabelVP.getStyle(), textLabelVP.getText(), (StyledElementView)this, n);
            } else {
                gadget = (Gadget)((Object)styledElementViewPartArray[n2]);
            }
            paragraphVP.addChild(gadget);
            ++n2;
        }
        return paragraphVP;
    }

    protected StyledViewFactory getViewFactory(int n) {
        DocumentView documentView = (DocumentView)this.element.getDocument().getDocumentListener(n, true);
        return (StyledViewFactory)documentView.getViewFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Image contentToImage(StyledElementViewPart[] styledElementViewPartArray) {
        if (styledElementViewPartArray == null || styledElementViewPartArray.length == 0) {
            return null;
        }
        Paragraph paragraph = new Paragraph();
        int n = 0;
        while (n < styledElementViewPartArray.length) {
            paragraph.addChild((Gadget)((Object)styledElementViewPartArray[n]));
            ++n;
        }
        paragraph.layout(-1, -1, true);
        if (paragraph.width <= 0 || paragraph.height <= 0) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(paragraph.width, paragraph.height, 2);
        Graphics graphics = bufferedImage.getGraphics();
        try {
            graphics.setColor(new Color(255, 255, 255, 0));
            graphics.fillRect(0, 0, paragraph.width, paragraph.height);
            paragraph.paint(graphics);
            Object var6_5 = null;
            graphics.dispose();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            graphics.dispose();
            throw throwable;
        }
        return bufferedImage;
    }
}

