/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.stylesheet;

import com.xmlmind.xmledit.doc.Attribute;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.ProcessingInstruction;
import com.xmlmind.xmledit.util.StringUtil;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.Namespace;
import java.util.Arrays;
import java.util.Comparator;
import java.util.StringTokenizer;

public final class Selector {
    public static final int SUBJECT_CURRENT = 0;
    public static final int SUBJECT_PARENT = 1;
    public static final int SUBJECT_PREDECESSOR = 2;
    public static final int SUBJECT_ANCESTOR = 3;
    public static final int TEST_ELEMENT_NAME_IS = 0;
    public static final int TEST_ELEMENT_NAMESPACE_IS = 1;
    public static final int TEST_IS_FIRST_CHILD = 2;
    public static final int TEST_HAS_ATTRIBUTE = 3;
    public static final int TEST_ATTRIBUTE_EQUALS = 4;
    public static final int TEST_ATTRIBUTE_CONTAINS = 5;
    public static final int TEST_ATTRIBUTE_DASH_MATCH = 6;
    public static final int TEST_LANGUAGE_IS = 7;
    public static final int TEST_IS_LAST_CHILD = 8;
    public static final int TEST_IS_FIRST_OF_TYPE = 9;
    public static final int TEST_IS_LAST_OF_TYPE = 10;
    public static final int TEST_HAS_PROPERTY = 11;
    public static final int TEST_PROPERTY_EQUALS = 12;
    public static final int TEST_IS_READ_ONLY = 13;
    public static final int TEST_ATTRIBUTE_STARTS_WITH = 14;
    public static final int TEST_ATTRIBUTE_ENDS_WITH = 15;
    public static final int TEST_ATTRIBUTE_HAS_SUBSTRING = 16;
    public static final int TEST_CONTAINS_PI = 17;
    public static final int TEST_CONTAINS_ELEMENT = 18;
    public static final int PSEUDO_ELEMENT_NONE = 0;
    public static final int PSEUDO_ELEMENT_BEFORE = 1;
    public static final int PSEUDO_ELEMENT_AFTER = 2;
    public static final int PSEUDO_ELEMENT_COMMENT = 3;
    public static final int PSEUDO_ELEMENT_PI = 4;
    public static final int PSEUDO_ELEMENT_ATTRIBUTE = 5;
    public static final Namespace ANY_NAMESPACE = Namespace.get("*");
    public static final Name CLASS = Name.get("class");
    public static final Name ID = Name.get("id");
    public static TestCompare testCompare = new TestCompare();
    private Matcher[] matchers;
    private int pseudoElement;
    private Object pseudoElementParameter;
    private int specificity = -1;

    public Selector(Matcher[] matcherArray, int n, Object object) {
        this.matchers = matcherArray;
        this.pseudoElement = n;
        this.pseudoElementParameter = object;
        this.sortTests();
        this.computeSpecificity();
    }

    private void sortTests() {
        int n = 0;
        while (n < this.matchers.length) {
            Matcher matcher = this.matchers[n];
            Arrays.sort(matcher.tests, testCompare);
            ++n;
        }
    }

    private void computeSpecificity() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.matchers.length) {
            Matcher matcher = this.matchers[n4];
            int n5 = matcher.tests.length;
            int n6 = 0;
            while (n6 < n5) {
                Test test = matcher.tests[n6];
                switch (test.type) {
                    case 0: {
                        ++n3;
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: {
                        ++n2;
                        break;
                    }
                    case 4: {
                        if (test.name == ID) {
                            ++n;
                            break;
                        }
                        ++n2;
                    }
                }
                ++n6;
            }
            ++n4;
        }
        this.specificity = n * 512 * 512 + n2 * 512 + n3;
    }

    public Matcher[] getMatchers() {
        return this.matchers;
    }

    public int getPseudoElement() {
        return this.pseudoElement;
    }

    public Object getPseudoElementParameter() {
        return this.pseudoElementParameter;
    }

    public int getSpecificity() {
        return this.specificity;
    }

    public boolean match(Element element) {
        Element element2 = element;
        int n = 0;
        while (n < this.matchers.length) {
            Matcher matcher = this.matchers[n];
            switch (matcher.subject) {
                case 0: {
                    if (Selector.test(element2, matcher.tests)) break;
                    return false;
                }
                case 1: {
                    element2 = element2.getParentElement();
                    if (element2 != null && Selector.test(element2, matcher.tests)) break;
                    return false;
                }
                case 2: {
                    element2 = element2.getPreviousElement();
                    if (element2 != null && Selector.test(element2, matcher.tests)) break;
                    return false;
                }
                case 3: {
                    do {
                        if ((element2 = element2.getParentElement()) != null) continue;
                        return false;
                    } while (!Selector.test(element2, matcher.tests));
                    break;
                }
            }
            ++n;
        }
        return true;
    }

    private static final boolean test(Element element, Test[] testArray) {
        int n = testArray.length;
        int n2 = 0;
        while (n2 < n) {
            Test test = testArray[n2];
            switch (test.type) {
                case 0: {
                    Namespace namespace;
                    Name name = element.getName();
                    if (name == test.name || (namespace = test.name.getNamespace()) == ANY_NAMESPACE && name.getLocalPart().equals(test.name.getLocalPart())) break;
                    return false;
                }
                case 1: {
                    if (element.getName().getNamespace() == test.name.getNamespace()) break;
                    return false;
                }
                case 2: {
                    if (element.getPreviousElement() == null) break;
                    return false;
                }
                case 8: {
                    if (element.getNextElement() == null) break;
                    return false;
                }
                case 9: {
                    Name name = element.getName();
                    Node node = element.getPreviousSibling();
                    while (node != null) {
                        if (node instanceof Element && ((Element)node).getName() == name) {
                            return false;
                        }
                        node = node.getPreviousSibling();
                    }
                    break;
                }
                case 10: {
                    Name name = element.getName();
                    Node node = element.getNextSibling();
                    while (node != null) {
                        if (node instanceof Element && ((Element)node).getName() == name) {
                            return false;
                        }
                        node = node.getNextSibling();
                    }
                    break;
                }
                case 3: {
                    Object object;
                    Object object2;
                    boolean bl2;
                    String string;
                    String string2 = element.getAttribute(test.name);
                    if (string2 != null) break;
                    Namespace namespace = test.name.getNamespace();
                    if (namespace == ANY_NAMESPACE) {
                        string = test.name.getLocalPart();
                        bl2 = false;
                        object2 = element.getAttributes();
                        while (object2.hasMoreElements()) {
                            object = (Attribute)object2.nextElement();
                            if (!((Attribute)object).name.getLocalPart().equals(string)) continue;
                            bl2 = true;
                            break;
                        }
                        if (bl2) break;
                    }
                    return false;
                }
                case 4: {
                    Object object;
                    Object object2;
                    boolean bl2;
                    String string;
                    String string3 = element.getAttribute(test.name);
                    if (string3 != null) {
                        if (string3.equals(test.value)) break;
                        return false;
                    }
                    Namespace namespace = test.name.getNamespace();
                    if (namespace == ANY_NAMESPACE) {
                        string = test.name.getLocalPart();
                        bl2 = false;
                        object2 = element.getAttributes();
                        while (object2.hasMoreElements()) {
                            object = (Attribute)object2.nextElement();
                            if (!((Attribute)object).name.getLocalPart().equals(string) || !((Attribute)object).value.equals(test.value)) continue;
                            bl2 = true;
                            break;
                        }
                        if (bl2) break;
                    }
                    return false;
                }
                case 5: {
                    Object object;
                    Object object2;
                    boolean bl2;
                    String string;
                    String string4 = element.getAttribute(test.name);
                    if (string4 != null) {
                        if (Selector.containsWord(string4, test.value)) break;
                        return false;
                    }
                    Namespace namespace = test.name.getNamespace();
                    if (namespace == ANY_NAMESPACE) {
                        string = test.name.getLocalPart();
                        bl2 = false;
                        object2 = element.getAttributes();
                        while (object2.hasMoreElements()) {
                            object = (Attribute)object2.nextElement();
                            if (!((Attribute)object).name.getLocalPart().equals(string) || !Selector.containsWord(((Attribute)object).value, test.value)) continue;
                            bl2 = true;
                            break;
                        }
                        if (bl2) break;
                    }
                    return false;
                }
                case 6: {
                    Object object;
                    Object object2;
                    boolean bl2;
                    String string;
                    String string5 = element.getAttribute(test.name);
                    if (string5 != null) {
                        if (Selector.containsField(string5, test.value)) break;
                        return false;
                    }
                    Namespace namespace = test.name.getNamespace();
                    if (namespace == ANY_NAMESPACE) {
                        string = test.name.getLocalPart();
                        bl2 = false;
                        object2 = element.getAttributes();
                        while (object2.hasMoreElements()) {
                            object = (Attribute)object2.nextElement();
                            if (!((Attribute)object).name.getLocalPart().equals(string) || !Selector.containsField(((Attribute)object).value, test.value)) continue;
                            bl2 = true;
                            break;
                        }
                        if (bl2) break;
                    }
                    return false;
                }
                case 14: {
                    Object object;
                    Object object2;
                    boolean bl2;
                    String string;
                    String string6 = element.getAttribute(test.name);
                    if (string6 != null) {
                        if (string6.startsWith(test.value)) break;
                        return false;
                    }
                    Namespace namespace = test.name.getNamespace();
                    if (namespace == ANY_NAMESPACE) {
                        string = test.name.getLocalPart();
                        bl2 = false;
                        object2 = element.getAttributes();
                        while (object2.hasMoreElements()) {
                            object = (Attribute)object2.nextElement();
                            if (!((Attribute)object).name.getLocalPart().equals(string) || !((Attribute)object).value.startsWith(test.value)) continue;
                            bl2 = true;
                            break;
                        }
                        if (bl2) break;
                    }
                    return false;
                }
                case 15: {
                    Object object;
                    Object object2;
                    boolean bl2;
                    String string;
                    String string7 = element.getAttribute(test.name);
                    if (string7 != null) {
                        if (string7.endsWith(test.value)) break;
                        return false;
                    }
                    Namespace namespace = test.name.getNamespace();
                    if (namespace == ANY_NAMESPACE) {
                        string = test.name.getLocalPart();
                        bl2 = false;
                        object2 = element.getAttributes();
                        while (object2.hasMoreElements()) {
                            object = (Attribute)object2.nextElement();
                            if (!((Attribute)object).name.getLocalPart().equals(string) || !((Attribute)object).value.endsWith(test.value)) continue;
                            bl2 = true;
                            break;
                        }
                        if (bl2) break;
                    }
                    return false;
                }
                case 16: {
                    Object object;
                    Object object2;
                    boolean bl2;
                    String string;
                    String string8 = element.getAttribute(test.name);
                    if (string8 != null) {
                        if (string8.indexOf(test.value) >= 0) break;
                        return false;
                    }
                    Namespace namespace = test.name.getNamespace();
                    if (namespace == ANY_NAMESPACE) {
                        string = test.name.getLocalPart();
                        bl2 = false;
                        object2 = element.getAttributes();
                        while (object2.hasMoreElements()) {
                            object = (Attribute)object2.nextElement();
                            if (!((Attribute)object).name.getLocalPart().equals(string) || ((Attribute)object).value.indexOf(test.value) < 0) continue;
                            bl2 = true;
                            break;
                        }
                        if (bl2) break;
                    }
                    return false;
                }
                case 7: {
                    String string = element.lookupAttribute(Name.XML_LANG, null);
                    if (string != null && string.trim().equals(test.value)) break;
                    return false;
                }
                case 11: {
                    if (element.hasProperty(test.key)) break;
                    return false;
                }
                case 12: {
                    Object object = element.getProperty(test.key);
                    if (object != null && test.value.equals(object.toString())) break;
                    return false;
                }
                case 13: {
                    if (element.isReadOnly()) break;
                    return false;
                }
                case 17: {
                    boolean bl = false;
                    Node node = element.getFirstChild();
                    while (node != null) {
                        if (node instanceof ProcessingInstruction && ((ProcessingInstruction)node).getTarget().equals(test.value)) {
                            bl = true;
                            break;
                        }
                        node = node.getNextSibling();
                    }
                    if (bl) break;
                    return false;
                }
                case 18: {
                    Object object;
                    Name name = test.name;
                    boolean bl = name.getNamespace() == ANY_NAMESPACE;
                    String string = name.getLocalPart();
                    boolean bl2 = false;
                    Object object2 = element.getFirstChild();
                    while (object2 != null) {
                        if (object2 instanceof Element && ((object = ((Element)object2).getName()) == name || bl && string.equals(((Name)object).getLocalPart()))) {
                            bl2 = true;
                            break;
                        }
                        object2 = ((Node)object2).getNextSibling();
                    }
                    if (bl2) break;
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    private static final boolean containsWord(String string, String string2) {
        if (string.indexOf(string2) < 0) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \n\r\t");
        while (stringTokenizer.hasMoreTokens()) {
            if (!stringTokenizer.nextToken().equals(string2)) continue;
            return true;
        }
        return false;
    }

    private static final boolean containsField(String string, String string2) {
        if (string.indexOf(string2) < 0) {
            return false;
        }
        String[] stringArray = StringUtil.split(string, '-');
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string2)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Selector)) {
            return false;
        }
        Selector selector = (Selector)object;
        if (selector.matchers.length != this.matchers.length || selector.pseudoElement != this.pseudoElement) {
            return false;
        }
        if (this.pseudoElementParameter == null && selector.pseudoElementParameter != null || this.pseudoElementParameter != null && !this.pseudoElementParameter.equals(selector.pseudoElementParameter)) {
            return false;
        }
        int n = 0;
        while (n < this.matchers.length) {
            int n2;
            Matcher matcher = this.matchers[n];
            Matcher matcher2 = selector.matchers[n];
            if (matcher2.subject != matcher.subject || matcher2.tests.length != (n2 = matcher.tests.length)) {
                return false;
            }
            int n3 = 0;
            while (n3 < n2) {
                Test test = matcher.tests[n3];
                Test test2 = matcher2.tests[n3];
                if (test.type != test2.type || test.name != test2.name || test.key == null && test2.key != null || test.key != null && !test.key.equals(test2.key) || test.value == null && test2.value != null || test.value != null && !test.value.equals(test2.value)) {
                    return false;
                }
                ++n3;
            }
            ++n;
        }
        return true;
    }

    public int hashCode() {
        return this.pseudoElement * 512 * 512 * 512 + this.specificity;
    }

    public static class TestCompare
    implements Comparator {
        public int compare(Object object, Object object2) {
            Test test = (Test)object;
            Test test2 = (Test)object2;
            if (test.type == test2.type) {
                switch (test.type) {
                    case 0: 
                    case 1: 
                    case 3: 
                    case 18: {
                        return test.name.compareTo(test2.name);
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 14: 
                    case 15: 
                    case 16: {
                        int n = test.name.compareTo(test2.name);
                        if (n == 0) {
                            return test.value.compareTo(test2.value);
                        }
                        return n;
                    }
                    case 7: {
                        return test.value.compareTo(test2.value);
                    }
                    case 11: {
                        return test.key.compareTo(test2.key);
                    }
                    case 12: {
                        int n = test.key.compareTo(test2.key);
                        if (n == 0) {
                            return test.value.compareTo(test2.value);
                        }
                        return n;
                    }
                    case 17: {
                        return test.value.compareTo(test2.value);
                    }
                }
                return 0;
            }
            return test.type - test2.type;
        }
    }

    public static class Matcher {
        public int subject;
        public Test[] tests;
    }

    public static class Test {
        public int type;
        public Name name;
        public String key;
        public String value;
    }
}

