/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.stylesheet;

import com.xmlmind.xmledit.doc.Comment;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.ProcessingInstruction;
import com.xmlmind.xmledit.stylesheet.Rule;
import com.xmlmind.xmledit.stylesheet.Selector;
import com.xmlmind.xmledit.stylesheet.StyleSpec;
import com.xmlmind.xmledit.stylesheet.StyleSpecs;
import com.xmlmind.xmledit.util.StringUtil;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.Namespace;
import com.xmlmind.xmledit.xmlutil.NamespacePrefixMap;
import com.xmlmind.xmledit.xmlutil.NamespaceToPrefixes;
import com.xmlmind.xmledit.xmlutil.PrefixEntry;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;

public final class StyleSheet
implements StyleSpecs,
NamespacePrefixMap {
    public static final int COMMENT = 3;
    public static final int PI = 4;
    public static final int ATTRIBUTE = 5;
    public static final int COMMENT_MASK = 8;
    public static final int PI_MASK = 16;
    public static final int ATTRIBUTE_MASK = 32;
    private URL url = null;
    private String[] defaultMedia = null;
    private String[] otherMedia = null;
    private HashMap prefixToNS = new HashMap();
    private HashMap nsToPrefixes = null;
    private ExtensionInfo[] extensionInfos = null;
    private int nextRuleId = 0;
    private HashMap ruleSet = new HashMap();
    private Rule[] rules = null;
    private HashMap nameToRules = null;
    private HashMap localPartToRules = null;
    private HashMap namespaceToRules = null;
    private Rule[][] fallbackRules = null;
    private HashMap elementNameToRules = null;
    public static RuleCompare ruleCompare = new RuleCompare();
    private static final Rule[] NO_RULES = new Rule[0];

    public void setURL(URL uRL) {
        this.url = uRL;
    }

    public URL getURL() {
        return this.url;
    }

    public void setDefaultMedia(String[] stringArray) {
        this.defaultMedia = stringArray;
    }

    public String[] getDefaultMedia() {
        return this.defaultMedia;
    }

    public void addOtherMedia(String[] stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                if (this.otherMedia == null) {
                    this.otherMedia = new String[]{string};
                } else if (!StringUtil.contains(this.otherMedia, string)) {
                    this.otherMedia = StringUtil.append(this.otherMedia, string);
                }
                ++n;
            }
        }
    }

    public String[] getOtherMedia() {
        return this.otherMedia;
    }

    public void addNamespacePrefix(String string, String string2) {
        this.addNamespacePrefix(string, Namespace.get(string2));
    }

    public void addNamespacePrefix(String string, Namespace namespace) {
        this.prefixToNS.put(string, namespace);
        this.nsToPrefixes = null;
    }

    public PrefixEntry[] getAllNamespacePrefixes() {
        PrefixEntry[] prefixEntryArray = new PrefixEntry[this.prefixToNS.size()];
        int n = 0;
        Iterator iterator = this.prefixToNS.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Namespace namespace = (Namespace)this.prefixToNS.get(string);
            prefixEntryArray[n++] = new PrefixEntry(string, namespace);
        }
        return prefixEntryArray;
    }

    public Namespace prefixToNamespace(String string) {
        Namespace namespace = (Namespace)this.prefixToNS.get(string);
        if (namespace == null && "xml".equals(string)) {
            namespace = Namespace.XML;
        }
        return namespace;
    }

    public String[] namespaceToPrefixes(Namespace namespace) {
        String[] stringArray;
        if (this.nsToPrefixes == null) {
            this.nsToPrefixes = StyleSheet.createInverseMap(this.prefixToNS);
        }
        if ((stringArray = (String[])this.nsToPrefixes.get(namespace)) == null && namespace == Namespace.XML) {
            stringArray = NamespaceToPrefixes.XML_PREFIXES;
        }
        return stringArray;
    }

    private static final HashMap createInverseMap(HashMap hashMap) {
        HashMap<Namespace, String[]> hashMap2 = new HashMap<Namespace, String[]>();
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Namespace namespace = (Namespace)hashMap.get(string);
            String[] stringArray = (String[])hashMap2.get(namespace);
            stringArray = stringArray == null ? new String[]{string} : StringUtil.append(stringArray, string);
            hashMap2.put(namespace, stringArray);
        }
        return hashMap2;
    }

    public void putExtensionInfo(ExtensionInfo extensionInfo) {
        if (this.extensionInfos == null) {
            this.extensionInfos = new ExtensionInfo[]{extensionInfo};
        } else {
            int n = this.extensionInfos.length;
            int n2 = 0;
            while (n2 < n) {
                if (this.extensionInfos[n2].className.equals(extensionInfo.className)) {
                    this.extensionInfos[n2] = extensionInfo;
                    return;
                }
                ++n2;
            }
            ExtensionInfo[] extensionInfoArray = new ExtensionInfo[n + 1];
            System.arraycopy(this.extensionInfos, 0, extensionInfoArray, 0, n);
            extensionInfoArray[n] = extensionInfo;
            this.extensionInfos = extensionInfoArray;
        }
    }

    public ExtensionInfo[] getAllExtensionInfo() {
        return this.extensionInfos;
    }

    public void addRules(StyleSheet styleSheet) {
        if (this.ruleSet == null) {
            this.addRules();
        }
        Rule[] ruleArray = styleSheet.getRules();
        int n = 0;
        while (n < ruleArray.length) {
            Rule rule = ruleArray[n];
            this.doAddRule(rule.getSelector(), rule.getStyleSpec().copy());
            ++n;
        }
    }

    public void addRule(Selector selector, StyleSpec styleSpec) {
        if (this.ruleSet == null) {
            this.addRules();
        }
        this.doAddRule(selector, styleSpec);
    }

    public void doAddRule(Selector selector, StyleSpec styleSpec) {
        Rule rule = (Rule)this.ruleSet.get(selector);
        if (rule == null) {
            rule = new Rule(this.nextRuleId++, selector, styleSpec);
            this.ruleSet.put(selector, rule);
        } else {
            rule.getStyleSpec().put(styleSpec);
            rule.setId(this.nextRuleId++);
        }
    }

    private void addRules() {
        int n = 0;
        while (n < this.rules.length) {
            Rule rule = this.rules[n];
            this.ruleSet.put(rule.getSelector(), rule);
            ++n;
        }
        this.rules = null;
        this.nameToRules = null;
        this.localPartToRules = null;
        this.namespaceToRules = null;
        this.fallbackRules = null;
        this.elementNameToRules = null;
    }

    public Rule[] getRules() {
        if (this.rules == null) {
            this.sortRules();
        }
        return this.rules;
    }

    private void sortRules() {
        Rule[] ruleArray;
        Rule[][] ruleArrayArray;
        Object[] objectArray;
        Object object;
        this.rules = new Rule[this.ruleSet.size()];
        Iterator<Object> iterator = this.ruleSet.values().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            this.rules[n++] = (Rule)iterator.next();
        }
        Arrays.sort(this.rules, ruleCompare);
        this.ruleSet = null;
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        HashMap<Rule[], ArrayList[]> hashMap3 = new HashMap<Rule[], ArrayList[]>();
        boolean bl = false;
        ArrayList[] arrayListArray = new ArrayList[6];
        int n2 = 0;
        while (n2 < 6) {
            arrayListArray[n2] = new ArrayList();
            ++n2;
        }
        n = 0;
        while (n < this.rules.length) {
            Object object2;
            object = this.rules[n];
            objectArray = ((Rule)object).getSelector();
            ruleArrayArray = objectArray.getMatchers()[0];
            HashMap<Rule[], ArrayList[]> hashMap4 = null;
            ruleArray = null;
            if (ruleArrayArray.tests.length > 0) {
                object2 = ruleArrayArray.tests[0];
                switch (object2.type) {
                    case 0: {
                        if (object2.name.getNamespace() == Selector.ANY_NAMESPACE) {
                            hashMap4 = hashMap2;
                            ruleArray = object2.name.getLocalPart();
                            break;
                        }
                        hashMap4 = hashMap;
                        ruleArray = object2.name;
                        break;
                    }
                    case 1: {
                        hashMap4 = hashMap3;
                        ruleArray = object2.name.getNamespace();
                    }
                }
            }
            if (hashMap4 == null) {
                object2 = arrayListArray;
                bl = true;
            } else {
                object2 = (ArrayList[])hashMap4.get(ruleArray);
                if (object2 == null) {
                    object2 = new ArrayList[6];
                    int n3 = 0;
                    while (n3 < 6) {
                        object2[n3] = new ArrayList();
                        ++n3;
                    }
                    hashMap4.put(ruleArray, (ArrayList[])object2);
                }
            }
            switch (objectArray.getPseudoElement()) {
                case 0: {
                    object2[0].add(object);
                    break;
                }
                case 1: {
                    object2[1].add(object);
                    break;
                }
                case 2: {
                    object2[2].add(object);
                    break;
                }
                case 3: {
                    object2[3].add(object);
                    break;
                }
                case 4: {
                    object2[4].add(object);
                    break;
                }
                case 5: {
                    object2[5].add(object);
                }
            }
            ++n;
        }
        this.nameToRules = new HashMap();
        this.localPartToRules = new HashMap();
        this.namespaceToRules = new HashMap();
        this.fallbackRules = null;
        this.elementNameToRules = new HashMap();
        iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            object = (Name)iterator.next();
            objectArray = (ArrayList[])hashMap.get(object);
            ruleArrayArray = new Rule[6][];
            int n4 = 0;
            while (n4 < 6) {
                ruleArray = objectArray[n4].toArray(NO_RULES);
                ruleArrayArray[n4] = ruleArray;
                ++n4;
            }
            this.nameToRules.put(object, ruleArrayArray);
        }
        iterator = hashMap2.keySet().iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            objectArray = (ArrayList[])hashMap2.get(object);
            ruleArrayArray = new Rule[6][];
            int n5 = 0;
            while (n5 < 6) {
                ruleArray = objectArray[n5].toArray(NO_RULES);
                ruleArrayArray[n5] = ruleArray;
                ++n5;
            }
            this.localPartToRules.put(object, ruleArrayArray);
        }
        iterator = hashMap3.keySet().iterator();
        while (iterator.hasNext()) {
            object = (Namespace)iterator.next();
            objectArray = (ArrayList[])hashMap3.get(object);
            ruleArrayArray = new Rule[6][];
            int n6 = 0;
            while (n6 < 6) {
                ruleArray = ((ArrayList)objectArray[n6]).toArray(NO_RULES);
                ruleArrayArray[n6] = ruleArray;
                ++n6;
            }
            this.namespaceToRules.put(object, ruleArrayArray);
        }
        if (bl) {
            this.fallbackRules = new Rule[6][];
            int n7 = 0;
            while (n7 < 6) {
                objectArray = arrayListArray[n7].toArray(NO_RULES);
                this.fallbackRules[n7] = objectArray;
                ++n7;
            }
        }
    }

    public Rule[][] findRules(Name name) {
        Rule[][] ruleArray;
        if (this.rules == null) {
            this.sortRules();
        }
        if ((ruleArray = (Rule[][])this.elementNameToRules.get(name)) == null) {
            Rule[][] ruleArray2 = (Rule[][])this.nameToRules.get(name);
            Rule[][] ruleArray3 = (Rule[][])this.localPartToRules.get(name.getLocalPart());
            Rule[][] ruleArray4 = (Rule[][])this.namespaceToRules.get(name.getNamespace());
            ruleArray = new Rule[6][];
            int n = 0;
            while (n < 6) {
                int n2;
                int n3 = 0;
                Rule[] ruleArray5 = null;
                int n4 = 0;
                if (ruleArray2 != null && (n2 = ruleArray2[n].length) > 0) {
                    n4 += n2;
                    ++n3;
                    ruleArray5 = ruleArray2[n];
                }
                if (ruleArray3 != null && (n2 = ruleArray3[n].length) > 0) {
                    n4 += n2;
                    ++n3;
                    ruleArray5 = ruleArray3[n];
                }
                if (ruleArray4 != null && (n2 = ruleArray4[n].length) > 0) {
                    n4 += n2;
                    ++n3;
                    ruleArray5 = ruleArray4[n];
                }
                if (this.fallbackRules != null && (n2 = this.fallbackRules[n].length) > 0) {
                    n4 += n2;
                    ++n3;
                    ruleArray5 = this.fallbackRules[n];
                }
                switch (n3) {
                    case 0: {
                        ruleArray[n] = NO_RULES;
                        break;
                    }
                    case 1: {
                        ruleArray[n] = ruleArray5;
                        break;
                    }
                    default: {
                        Rule[] ruleArray6 = new Rule[n4];
                        n4 = 0;
                        if (ruleArray2 != null && (n2 = ruleArray2[n].length) > 0) {
                            System.arraycopy(ruleArray2[n], 0, ruleArray6, n4, n2);
                            n4 += n2;
                        }
                        if (ruleArray3 != null && (n2 = ruleArray3[n].length) > 0) {
                            System.arraycopy(ruleArray3[n], 0, ruleArray6, n4, n2);
                            n4 += n2;
                        }
                        if (ruleArray4 != null && (n2 = ruleArray4[n].length) > 0) {
                            System.arraycopy(ruleArray4[n], 0, ruleArray6, n4, n2);
                            n4 += n2;
                        }
                        if (this.fallbackRules != null && (n2 = this.fallbackRules[n].length) > 0) {
                            System.arraycopy(this.fallbackRules[n], 0, ruleArray6, n4, n2);
                            n4 += n2;
                        }
                        Arrays.sort(ruleArray6, ruleCompare);
                        ruleArray[n] = ruleArray6;
                    }
                }
                ++n;
            }
            this.elementNameToRules.put(name, ruleArray);
        }
        return ruleArray;
    }

    public int findStyleSpec(Element element, StyleSpec[] styleSpecArray) {
        Rule[][] ruleArray = this.findRules(element.getName());
        int n = 0;
        int n2 = 0;
        while (n2 <= 2) {
            StyleSpec styleSpec = styleSpecArray[n2];
            if (styleSpec != null) {
                Rule[] ruleArray2 = ruleArray[n2];
                int n3 = 1 << n2;
                int n4 = 0;
                while (n4 < ruleArray2.length) {
                    Rule rule = ruleArray2[n4];
                    if (rule.getSelector().match(element)) {
                        styleSpec.put(rule.getStyleSpec());
                        n |= n3;
                    }
                    ++n4;
                }
                switch (n2) {
                    case 1: 
                    case 2: {
                        if ((n & n3) == 0 || styleSpec.content != null) break;
                        n &= ~n3;
                    }
                }
            }
            ++n2;
        }
        return n;
    }

    public boolean findStyleSpec(Comment comment, StyleSpec styleSpec) {
        Element element = comment.getParentElement();
        if (element == null) {
            return false;
        }
        Rule[][] ruleArray = this.findRules(element.getName());
        boolean bl = false;
        Rule[] ruleArray2 = ruleArray[3];
        int n = 0;
        while (n < ruleArray2.length) {
            Rule rule = ruleArray2[n];
            if (rule.getSelector().match(element)) {
                styleSpec.put(rule.getStyleSpec());
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    public boolean findStyleSpec(ProcessingInstruction processingInstruction, StyleSpec styleSpec) {
        Object object;
        Object object2;
        Element element = processingInstruction.getParentElement();
        if (element == null) {
            return false;
        }
        Rule[][] ruleArray = this.findRules(element.getName());
        boolean bl = false;
        Rule[] ruleArray2 = ruleArray[4];
        int n = 0;
        while (n < ruleArray2.length) {
            object2 = ruleArray2[n];
            Selector selector = ((Rule)object2).getSelector();
            object = selector.getPseudoElementParameter();
            if (object == null && selector.match(element)) {
                styleSpec.put(((Rule)object2).getStyleSpec());
                bl = true;
            }
            ++n;
        }
        object2 = processingInstruction.getTarget();
        int n2 = 0;
        while (n2 < ruleArray2.length) {
            object = ruleArray2[n2];
            Selector selector = ((Rule)object).getSelector();
            Object object3 = selector.getPseudoElementParameter();
            if (object3 != null && object3.equals(object2) && selector.match(element)) {
                styleSpec.put(((Rule)object).getStyleSpec());
                bl = true;
            }
            ++n2;
        }
        return bl;
    }

    public boolean findStyleSpec(Element element, Name name, StyleSpec styleSpec) {
        Object object;
        Object object2;
        Rule[][] ruleArray = this.findRules(element.getName());
        boolean bl = false;
        Rule[] ruleArray2 = ruleArray[5];
        int n = 0;
        while (n < ruleArray2.length) {
            Rule rule = ruleArray2[n];
            object2 = rule.getSelector();
            object = ((Selector)object2).getPseudoElementParameter();
            if (object == null && ((Selector)object2).match(element)) {
                styleSpec.put(rule.getStyleSpec());
                bl = true;
            }
            ++n;
        }
        if (name != null) {
            int n2 = 0;
            while (n2 < ruleArray2.length) {
                object2 = ruleArray2[n2];
                object = ((Rule)object2).getSelector();
                Object object3 = ((Selector)object).getPseudoElementParameter();
                if (object3 == name && ((Selector)object).match(element)) {
                    styleSpec.put(((Rule)object2).getStyleSpec());
                    bl = true;
                }
                ++n2;
            }
        }
        return bl;
    }

    public static class RuleCompare
    implements Comparator {
        public int compare(Object object, Object object2) {
            int n;
            Rule rule = (Rule)object;
            Rule rule2 = (Rule)object2;
            int n2 = rule.getSelector().getSpecificity();
            if (n2 == (n = rule2.getSelector().getSpecificity())) {
                return rule.getId() - rule2.getId();
            }
            return n2 - n;
        }
    }

    public static final class ExtensionInfo {
        public String className;
        public String[] parameters;

        public ExtensionInfo(String string, String[] stringArray) {
            if (stringArray == null) {
                stringArray = new String[]{};
            }
            this.className = string;
            this.parameters = stringArray;
        }
    }
}

