/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.stylesheet;

import com.xmlmind.xmledit.cssparser.AttributeSelector;
import com.xmlmind.xmledit.cssparser.HandlerBase;
import com.xmlmind.xmledit.cssparser.ParseUtil;
import com.xmlmind.xmledit.cssparser.Parser;
import com.xmlmind.xmledit.cssparser.ParserEx;
import com.xmlmind.xmledit.cssparser.SelectorComponent;
import com.xmlmind.xmledit.cssparser.ValueComponent;
import com.xmlmind.xmledit.stylesheet.Msg;
import com.xmlmind.xmledit.stylesheet.Selector;
import com.xmlmind.xmledit.stylesheet.StyleSheet;
import com.xmlmind.xmledit.stylesheet.StyleSpec;
import com.xmlmind.xmledit.stylesheet.StyleValue;
import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.util.StringUtil;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.Namespace;
import com.xmlmind.xmledit.xmlutil.XMLCatalogs;
import com.xmlmind.xmledit.xmlutil.XMLUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;

public final class StyleSheetLoader
extends HandlerBase {
    public static final String[] SCREEN = new String[]{"screen"};
    public static final String[] PRINT = new String[]{"print"};
    private Parser parser;
    private String[] handledMedia = SCREEN;
    private ArrayList warnings = new ArrayList();
    private StyleSheet styleSheet;
    private ArrayList selectors;
    private StyleSpec spec;
    private URL baseURL;
    private static boolean usingDefaultBuiltInRules;
    private static URL builtInRulesURL;
    private static StyleSheet builtInScreenRules;
    private static StyleSheet builtInPrintRules;
    private static HashMap propertyHandlers;
    static /* synthetic */ Class class$com$xmlmind$xmledit$stylesheet$StyleSheetLoader;

    public static void useDefaultBuiltInRules() {
        URL uRL;
        if (!usingDefaultBuiltInRules && StyleSheetLoader.doSetBuiltInRules(uRL = (class$com$xmlmind$xmledit$stylesheet$StyleSheetLoader == null ? (class$com$xmlmind$xmledit$stylesheet$StyleSheetLoader = StyleSheetLoader.class$("com.xmlmind.xmledit.stylesheet.StyleSheetLoader")) : class$com$xmlmind$xmledit$stylesheet$StyleSheetLoader).getResource("builtin.css"))) {
            usingDefaultBuiltInRules = true;
        }
    }

    public static boolean usingDefaultBuiltInRules() {
        return usingDefaultBuiltInRules;
    }

    public static boolean setBuiltInRules(URL uRL) {
        if (StyleSheetLoader.doSetBuiltInRules(uRL)) {
            usingDefaultBuiltInRules = false;
            return true;
        }
        return false;
    }

    private static boolean doSetBuiltInRules(URL uRL) {
        StyleSheet styleSheet = null;
        StyleSheet styleSheet2 = null;
        if (uRL != null) {
            StyleSheetLoader styleSheetLoader = new StyleSheetLoader();
            String string = null;
            StyleSheet styleSheet3 = null;
            try {
                string = ParseUtil.loadSource(uRL);
                styleSheet3 = styleSheetLoader.doLoad(string, uRL, null, null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (styleSheet3 == null || styleSheetLoader.getWarnings().length > 0) {
                return false;
            }
            styleSheet = styleSheet2 = styleSheet3;
            String[] stringArray = styleSheet3.getOtherMedia();
            if (stringArray != null && StringUtil.contains(stringArray, PRINT[0])) {
                styleSheetLoader.setHandledMedia(PRINT);
                styleSheet3 = null;
                try {
                    styleSheet3 = styleSheetLoader.doLoad(string, uRL, null, null);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (styleSheet3 == null || styleSheetLoader.getWarnings().length > 0) {
                    return false;
                }
                styleSheet2 = styleSheet3;
            }
        }
        builtInRulesURL = uRL;
        builtInScreenRules = styleSheet;
        builtInPrintRules = styleSheet2;
        return true;
    }

    public static URL getBuiltInRules() {
        return builtInRulesURL;
    }

    public StyleSheetLoader() {
        this.parser = new ParserEx();
        this.parser.setHandler(this);
    }

    public void setHandledMedia(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            stringArray = SCREEN;
        }
        this.handledMedia = new String[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            this.handledMedia[n] = stringArray[n].toLowerCase();
            ++n;
        }
    }

    public String[] getHandledMedia() {
        return this.handledMedia;
    }

    public StyleSheet load(File file) throws IOException {
        return this.load(file, null);
    }

    public StyleSheet load(File file, String[] stringArray) throws IOException {
        return this.load(FileUtil.fileToURL(file), stringArray);
    }

    public StyleSheet load(URL uRL, String[] stringArray) throws IOException {
        return this.load(ParseUtil.loadSource(uRL), uRL, stringArray);
    }

    public StyleSheet load(InputStream inputStream, String string, URL uRL, String[] stringArray) throws IOException {
        return this.load(ParseUtil.loadSource(inputStream, string), uRL, stringArray);
    }

    public StyleSheet load(String string, URL uRL, String[] stringArray) throws IOException {
        StyleSheet styleSheet = StringUtil.contains(this.handledMedia, PRINT[0]) ? builtInPrintRules : builtInScreenRules;
        return this.doLoad(string, uRL, stringArray, styleSheet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StyleSheet doLoad(String string, URL uRL, String[] stringArray, StyleSheet styleSheet) throws IOException {
        this.styleSheet = new StyleSheet();
        this.styleSheet.setURL(uRL);
        this.styleSheet.setDefaultMedia(stringArray);
        if (styleSheet != null) {
            this.styleSheet.addRules(styleSheet);
        }
        StyleSheet styleSheet2 = null;
        this.warnings.clear();
        try {
            this.parser.parse(string, uRL, stringArray);
            styleSheet2 = this.styleSheet;
        }
        finally {
            this.baseURL = null;
            this.selectors = null;
            this.spec = null;
            this.styleSheet = null;
        }
        return styleSheet2;
    }

    public Warning[] getWarnings() {
        Warning[] warningArray = new Warning[this.warnings.size()];
        this.warnings.toArray(warningArray);
        return warningArray;
    }

    public URL resolveURI(String string, URL uRL) {
        try {
            return XMLCatalogs.resolveURI(string, uRL);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public boolean beginStyleSheet(URL uRL, String string, String[] stringArray) {
        this.styleSheet.addOtherMedia(stringArray);
        if (!this.containsHandledMedia(stringArray)) {
            return false;
        }
        this.baseURL = string == null ? uRL : this.resolveURI(string, uRL);
        return true;
    }

    public void endStyleSheet(URL uRL, String string, String[] stringArray) {
        this.baseURL = uRL;
    }

    public boolean beginMedia(String[] stringArray) {
        this.styleSheet.addOtherMedia(stringArray);
        return this.containsHandledMedia(stringArray);
    }

    public boolean beginPage(String string, String string2) {
        return false;
    }

    public boolean beginFontFace() {
        return false;
    }

    public void namespace(String string, String string2) {
        if (string == null) {
            string = "";
        }
        this.styleSheet.addNamespacePrefix(string, string2);
    }

    public void atRule(String string, String string2, String string3) {
        if (string.equals("extension")) {
            String[] stringArray;
            if (string2 == null || string3 != null || (stringArray = StringUtil.splitArguments(string2)).length == 0 || !StyleSheetLoader.isJavaClassName(stringArray[0])) {
                this.warning(Msg.msg("invalidAtExtension"));
                return;
            }
            String string4 = stringArray[0];
            String[] stringArray2 = null;
            if (stringArray.length > 1) {
                stringArray2 = new String[stringArray.length - 1];
                System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
            }
            this.styleSheet.putExtensionInfo(new StyleSheet.ExtensionInfo(string4, stringArray2));
        }
    }

    private static final boolean isJavaClassName(String string) {
        String[] stringArray = StringUtil.split(string, '.');
        if (stringArray.length == 0) {
            return false;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (!StyleSheetLoader.isJavaIdentifier(stringArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private static final boolean isJavaIdentifier(String string) {
        int n = string.length();
        if (n == 0 || !Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        int n2 = 1;
        while (n2 < n) {
            if (!Character.isJavaIdentifierPart(string.charAt(n2))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void beginRule() {
        this.selectors = new ArrayList();
        this.spec = new StyleSpec();
    }

    public void selector(SelectorComponent[] selectorComponentArray) {
        Selector.Matcher[] matcherArray;
        int n;
        ArrayList<Selector.Matcher> arrayList = new ArrayList<Selector.Matcher>();
        int n2 = 0;
        Object object = null;
        Selector.Matcher matcher = new Selector.Matcher();
        matcher.subject = 0;
        ArrayList<Selector.Test> arrayList2 = new ArrayList<Selector.Test>();
        int n3 = n = selectorComponentArray.length - 1;
        while (n3 >= 0) {
            Object object2;
            Selector.Test test;
            Namespace namespace;
            matcherArray = selectorComponentArray[n3];
            if (matcherArray.elementPrefix == null) {
                namespace = this.styleSheet.prefixToNamespace("");
                if (namespace == null) {
                    namespace = Selector.ANY_NAMESPACE;
                }
                if (matcherArray.elementName.charAt(0) == '*') {
                    if (namespace != Selector.ANY_NAMESPACE) {
                        test = new Selector.Test();
                        test.type = 1;
                        test.name = Name.get(namespace, "x");
                        arrayList2.add(test);
                    }
                } else {
                    test = new Selector.Test();
                    test.type = 0;
                    test.name = Name.get(namespace, matcherArray.elementName);
                    arrayList2.add(test);
                }
            } else {
                if (matcherArray.elementPrefix.length() == 0) {
                    namespace = Namespace.NONE;
                } else if (matcherArray.elementPrefix.charAt(0) == '*') {
                    namespace = Selector.ANY_NAMESPACE;
                } else {
                    namespace = this.styleSheet.prefixToNamespace(matcherArray.elementPrefix);
                    if (namespace == null) {
                        this.warning(Msg.msg("undeclaredPrefix", matcherArray.elementPrefix));
                        return;
                    }
                }
                if (matcherArray.elementName.charAt(0) == '*') {
                    if (namespace != Selector.ANY_NAMESPACE) {
                        test = new Selector.Test();
                        test.type = 1;
                        test.name = Name.get(namespace, "x");
                        arrayList2.add(test);
                    }
                } else {
                    test = new Selector.Test();
                    test.type = 0;
                    test.name = Name.get(namespace, matcherArray.elementName);
                    arrayList2.add(test);
                }
            }
            int n4 = 0;
            while (n4 < matcherArray.attributeSelectors.length) {
                AttributeSelector attributeSelector = matcherArray.attributeSelectors[n4];
                test = new Selector.Test();
                if (attributeSelector.name == null) {
                    if (attributeSelector.matcher == null || attributeSelector.matcher.length() == 0 || attributeSelector.value == null) {
                        this.warning(Msg.msg("invalidAttributeSelector"));
                        return;
                    }
                    switch (attributeSelector.matcher.charAt(0)) {
                        case '#': {
                            test.type = 4;
                            test.name = Selector.ID;
                            break;
                        }
                        case '.': {
                            test.type = 5;
                            test.name = Selector.CLASS;
                            break;
                        }
                        default: {
                            this.warning(Msg.msg("unknownAttributeSelector", attributeSelector.matcher));
                            return;
                        }
                    }
                    test.value = attributeSelector.value;
                } else {
                    if (attributeSelector.prefix == null) {
                        object2 = Namespace.NONE;
                    } else if (attributeSelector.prefix.length() == 0) {
                        object2 = Namespace.NONE;
                    } else if (attributeSelector.prefix.charAt(0) == '*') {
                        object2 = Selector.ANY_NAMESPACE;
                    } else {
                        object2 = this.styleSheet.prefixToNamespace(attributeSelector.prefix);
                        if (object2 == null) {
                            this.warning(Msg.msg("undeclaredPrefix", attributeSelector.prefix));
                            return;
                        }
                    }
                    test.name = Name.get((Namespace)object2, attributeSelector.name);
                    if (attributeSelector.matcher == null || attributeSelector.matcher.length() == 0 || attributeSelector.value == null) {
                        test.type = 3;
                    } else {
                        switch (attributeSelector.matcher.charAt(0)) {
                            case '=': {
                                test.type = 4;
                                break;
                            }
                            case '~': {
                                test.type = 5;
                                break;
                            }
                            case '|': {
                                test.type = 6;
                                break;
                            }
                            case '^': {
                                test.type = 14;
                                break;
                            }
                            case '$': {
                                test.type = 15;
                                break;
                            }
                            case '*': {
                                test.type = 16;
                                break;
                            }
                            default: {
                                this.warning(Msg.msg("unknownAttributeSelector", attributeSelector.matcher));
                                return;
                            }
                        }
                        test.value = attributeSelector.value;
                    }
                }
                arrayList2.add(test);
                ++n4;
            }
            int n5 = 0;
            while (n5 < matcherArray.pseudos.length) {
                Object object3;
                object2 = matcherArray.pseudos[n5];
                boolean bl = false;
                boolean bl2 = false;
                block12 : switch (((ValueComponent)object2).type) {
                    case -8: {
                        if (((ValueComponent)object2).stringValue.equals("before")) {
                            if (n3 != n) {
                                this.warning(Msg.msg("pseudoElementNotAllowed", "before"));
                                return;
                            }
                            n2 = 1;
                            break;
                        }
                        if (((ValueComponent)object2).stringValue.equals("after")) {
                            if (n3 != n) {
                                this.warning(Msg.msg("pseudoElementNotAllowed", "after"));
                                return;
                            }
                            n2 = 2;
                            break;
                        }
                        if (((ValueComponent)object2).stringValue.equals("first-child")) {
                            test = new Selector.Test();
                            test.type = 2;
                            arrayList2.add(test);
                            break;
                        }
                        if (((ValueComponent)object2).stringValue.equals("last-child")) {
                            test = new Selector.Test();
                            test.type = 8;
                            arrayList2.add(test);
                            break;
                        }
                        if (((ValueComponent)object2).stringValue.equals("first-of-type")) {
                            test = new Selector.Test();
                            test.type = 9;
                            arrayList2.add(test);
                            break;
                        }
                        if (((ValueComponent)object2).stringValue.equals("last-of-type")) {
                            test = new Selector.Test();
                            test.type = 10;
                            arrayList2.add(test);
                            break;
                        }
                        if (((ValueComponent)object2).stringValue.equals("comment")) {
                            if (n3 != n) {
                                this.warning(Msg.msg("pseudoElementNotAllowed", "comment"));
                                return;
                            }
                            n2 = 3;
                            break;
                        }
                        if (((ValueComponent)object2).stringValue.equals("processing-instruction")) {
                            if (n3 != n) {
                                this.warning(Msg.msg("pseudoElementNotAllowed", "processing-instruction"));
                                return;
                            }
                            n2 = 4;
                            break;
                        }
                        if (((ValueComponent)object2).stringValue.equals("attribute")) {
                            if (n3 != n) {
                                this.warning(Msg.msg("pseudoElementNotAllowed", "attribute"));
                                return;
                            }
                            n2 = 5;
                            break;
                        }
                        if (((ValueComponent)object2).stringValue.equals("read-only")) {
                            test = new Selector.Test();
                            test.type = 13;
                            arrayList2.add(test);
                            break;
                        }
                        bl = true;
                        break;
                    }
                    case -27: {
                        String string;
                        Object object4;
                        if (((ValueComponent)object2).functionName.equals("attribute")) {
                            if (n3 != n) {
                                this.warning(Msg.msg("pseudoElementNotAllowed", "attribute"));
                                return;
                            }
                            n2 = 5;
                            if (((ValueComponent)object2).functionArguments.length == 1) {
                                object3 = ((ValueComponent)object2).functionArguments[0];
                                object4 = null;
                                string = null;
                                switch (((ValueComponent)object3).type) {
                                    case -8: 
                                    case -7: {
                                        object4 = Namespace.NONE;
                                        string = ((ValueComponent)object3).stringValue;
                                        break;
                                    }
                                    case -31: {
                                        if (((ValueComponent)object3).prefix == null) {
                                            object4 = Namespace.NONE;
                                        } else if (((ValueComponent)object3).prefix.length() == 0) {
                                            object4 = Namespace.NONE;
                                        } else if (((ValueComponent)object3).prefix.charAt(0) != '*' && (object4 = this.styleSheet.prefixToNamespace(((ValueComponent)object3).prefix)) == null) {
                                            this.warning(Msg.msg("undeclaredPrefix", ((ValueComponent)object3).prefix));
                                            return;
                                        }
                                        string = ((ValueComponent)object3).stringValue;
                                    }
                                }
                                if (!StyleSheetLoader.checkName((Namespace)object4, string)) {
                                    bl2 = true;
                                    break;
                                }
                                object = Name.get((Namespace)object4, string);
                                break;
                            }
                            if (((ValueComponent)object2).functionArguments.length == 0) break;
                            bl2 = true;
                            break;
                        }
                        if (((ValueComponent)object2).functionName.equals("processing-instruction")) {
                            if (n3 != n) {
                                this.warning(Msg.msg("pseudoElementNotAllowed", "processing-instruction"));
                                return;
                            }
                            n2 = 4;
                            if (((ValueComponent)object2).functionArguments.length == 1) {
                                switch (((ValueComponent)object2).functionArguments[0].type) {
                                    case -8: 
                                    case -7: {
                                        object = ((ValueComponent)object2).functionArguments[0].stringValue;
                                        break block12;
                                    }
                                }
                                bl2 = true;
                                break;
                            }
                            if (((ValueComponent)object2).functionArguments.length == 0) break;
                            bl2 = true;
                            break;
                        }
                        if (((ValueComponent)object2).functionName.equals("property")) {
                            object3 = null;
                            object4 = null;
                            block23 : switch (((ValueComponent)object2).functionArguments.length) {
                                case 2: {
                                    switch (((ValueComponent)object2).functionArguments[1].type) {
                                        case -8: 
                                        case -7: {
                                            object4 = ((ValueComponent)object2).functionArguments[1].stringValue;
                                            break;
                                        }
                                        default: {
                                            bl2 = true;
                                        }
                                    }
                                }
                                case 1: {
                                    switch (((ValueComponent)object2).functionArguments[0].type) {
                                        case -8: 
                                        case -7: {
                                            object3 = ((ValueComponent)object2).functionArguments[0].stringValue;
                                            break block23;
                                        }
                                    }
                                    bl2 = true;
                                    break;
                                }
                                default: {
                                    bl2 = true;
                                }
                            }
                            if (bl2) break;
                            test = new Selector.Test();
                            if (object4 == null) {
                                test.type = 11;
                            } else {
                                test.type = 12;
                                test.value = object4;
                            }
                            test.key = object3;
                            arrayList2.add(test);
                            break;
                        }
                        if (((ValueComponent)object2).functionName.equals("contains-processing-instruction")) {
                            if (((ValueComponent)object2).functionArguments.length == 1) {
                                switch (((ValueComponent)object2).functionArguments[0].type) {
                                    case -8: 
                                    case -7: {
                                        test = new Selector.Test();
                                        test.type = 17;
                                        test.value = ((ValueComponent)object2).functionArguments[0].stringValue;
                                        arrayList2.add(test);
                                        break block12;
                                    }
                                }
                                bl2 = true;
                                break;
                            }
                            bl2 = true;
                            break;
                        }
                        if (((ValueComponent)object2).functionName.equals("contains-element")) {
                            if (((ValueComponent)object2).functionArguments.length == 1) {
                                object3 = ((ValueComponent)object2).functionArguments[0];
                                object4 = null;
                                string = null;
                                switch (((ValueComponent)object3).type) {
                                    case -8: 
                                    case -7: {
                                        object4 = this.styleSheet.prefixToNamespace("");
                                        if (object4 == null) {
                                            object4 = Selector.ANY_NAMESPACE;
                                        }
                                        string = ((ValueComponent)object3).stringValue;
                                        break;
                                    }
                                    case -31: {
                                        if (((ValueComponent)object3).prefix.length() == 0) {
                                            object4 = Namespace.NONE;
                                        } else if (((ValueComponent)object3).prefix.charAt(0) == '*') {
                                            object4 = Selector.ANY_NAMESPACE;
                                        } else {
                                            object4 = this.styleSheet.prefixToNamespace(((ValueComponent)object3).prefix);
                                            if (object4 == null) {
                                                this.warning(Msg.msg("undeclaredPrefix", ((ValueComponent)object3).prefix));
                                                return;
                                            }
                                        }
                                        string = ((ValueComponent)object3).stringValue;
                                        break;
                                    }
                                    default: {
                                        bl2 = true;
                                    }
                                }
                                if (!bl2 && !StyleSheetLoader.checkName((Namespace)object4, string)) {
                                    bl2 = true;
                                }
                                if (bl2) break;
                                test = new Selector.Test();
                                test.type = 18;
                                test.name = Name.get((Namespace)object4, string);
                                arrayList2.add(test);
                                break;
                            }
                            bl2 = true;
                            break;
                        }
                        if (((ValueComponent)object2).functionName.equals("lang")) {
                            if (((ValueComponent)object2).functionArguments.length == 1) {
                                switch (((ValueComponent)object2).functionArguments[0].type) {
                                    case -8: 
                                    case -7: {
                                        test = new Selector.Test();
                                        test.type = 7;
                                        test.value = ((ValueComponent)object2).functionArguments[0].stringValue;
                                        arrayList2.add(test);
                                        break block12;
                                    }
                                }
                                bl2 = true;
                                break;
                            }
                            bl2 = true;
                            break;
                        }
                        bl = true;
                        break;
                    }
                    default: {
                        bl = true;
                    }
                }
                if (bl || bl2) {
                    switch (((ValueComponent)object2).type) {
                        case -8: {
                            object3 = ((ValueComponent)object2).stringValue;
                            break;
                        }
                        case -27: {
                            object3 = ((ValueComponent)object2).functionName;
                            break;
                        }
                        default: {
                            object3 = "???";
                        }
                    }
                    this.warning(Msg.msg(bl ? "unknownPseudo" : "malformedPseudo", object3));
                    return;
                }
                ++n5;
            }
            matcher.tests = new Selector.Test[arrayList2.size()];
            arrayList2.toArray(matcher.tests);
            arrayList.add(matcher);
            matcher = new Selector.Matcher();
            arrayList2 = new ArrayList();
            switch (matcherArray.combinator) {
                case '>': {
                    matcher.subject = 1;
                    break;
                }
                case '+': {
                    matcher.subject = 2;
                    break;
                }
                default: {
                    matcher.subject = 3;
                }
            }
            --n3;
        }
        matcherArray = new Selector.Matcher[arrayList.size()];
        arrayList.toArray(matcherArray);
        this.selectors.add(new Selector(matcherArray, n2, object));
    }

    private static boolean checkName(Namespace namespace, String string) {
        return !(namespace == null || string == null || namespace == Namespace.NONE && !XMLUtil.isName(string) || namespace != Namespace.NONE && !XMLUtil.isNCName(string));
    }

    public void property(String string, ValueComponent[] valueComponentArray, boolean bl) {
        Method method = (Method)propertyHandlers.get(string);
        if (method == null) {
            this.unsupportedProperty(string);
            return;
        }
        try {
            method.invoke((Object)this, new Object[]{valueComponentArray});
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            throwable.printStackTrace();
            throw StyleSheetLoader.wrapException(throwable);
        }
        catch (Exception exception) {
            throw StyleSheetLoader.wrapException(exception);
        }
    }

    private static RuntimeException wrapException(Throwable throwable) {
        String string = throwable.getClass().getName();
        String string2 = throwable.getMessage();
        if (string2 != null) {
            string = string + ": " + string2;
        }
        return new RuntimeException(string);
    }

    public void endRule() {
        int n = this.selectors.size();
        if (n > 0) {
            this.styleSheet.addRule((Selector)this.selectors.get(0), this.spec);
            int n2 = 1;
            while (n2 < n) {
                StyleSpec styleSpec = this.spec.copy();
                this.styleSheet.addRule((Selector)this.selectors.get(n2), styleSpec);
                ++n2;
            }
        }
        this.selectors = null;
        this.spec = null;
    }

    public void error(URL uRL, int n, int n2, String string) {
        this.warnings.add(new Warning(uRL, n, n2, Msg.msg("syntaxError", string)));
    }

    private void warning(String string) {
        this.warnings.add(new Warning(this.parser.getURL(), this.parser.getLineNumber(), this.parser.getColumnNumber(), string));
    }

    private void unsupportedProperty(String string) {
        this.warning(Msg.msg("unsupportedProperty", string));
    }

    private void unsupportedPropertyValue(String string) {
        this.warning(Msg.msg("unsupportedPropertyValue", string));
    }

    private void unsupportedPropertyValue(String string, String string2) {
        this.warning(Msg.msg("unsupportedPropertyValue2", string, string2));
    }

    private boolean containsHandledMedia(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0 || StringUtil.contains(stringArray, "all") || StringUtil.contains(this.handledMedia, "all")) {
            return true;
        }
        int n = 0;
        while (n < this.handledMedia.length) {
            if (StringUtil.contains(stringArray, this.handledMedia[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void handleMarginTop(ValueComponent[] valueComponentArray) {
        this.spec.marginTop = this.getMargin(valueComponentArray[0]);
        if (this.spec.marginTop == null) {
            this.unsupportedPropertyValue("margin-top");
        }
    }

    private void handleMarginRight(ValueComponent[] valueComponentArray) {
        this.spec.marginRight = this.getMargin(valueComponentArray[0]);
        if (this.spec.marginRight == null) {
            this.unsupportedPropertyValue("margin-right");
        }
    }

    private void handleMarginBottom(ValueComponent[] valueComponentArray) {
        this.spec.marginBottom = this.getMargin(valueComponentArray[0]);
        if (this.spec.marginBottom == null) {
            this.unsupportedPropertyValue("margin-bottom");
        }
    }

    private void handleMarginLeft(ValueComponent[] valueComponentArray) {
        this.spec.marginLeft = this.getMargin(valueComponentArray[0]);
        if (this.spec.marginLeft == null) {
            this.unsupportedPropertyValue("margin-left");
        }
    }

    private void handleMargin(ValueComponent[] valueComponentArray) {
        switch (valueComponentArray.length) {
            case 1: {
                this.spec.marginRight = this.spec.marginTop = this.getMargin(valueComponentArray[0]);
                this.spec.marginBottom = this.spec.marginTop;
                this.spec.marginLeft = this.spec.marginTop;
                break;
            }
            case 2: {
                this.spec.marginTop = this.getMargin(valueComponentArray[0]);
                this.spec.marginRight = this.getMargin(valueComponentArray[1]);
                this.spec.marginBottom = this.spec.marginTop;
                this.spec.marginLeft = this.spec.marginRight;
                break;
            }
            case 3: {
                this.spec.marginTop = this.getMargin(valueComponentArray[0]);
                this.spec.marginRight = this.getMargin(valueComponentArray[1]);
                this.spec.marginBottom = this.getMargin(valueComponentArray[2]);
                this.spec.marginLeft = this.spec.marginRight;
                break;
            }
            case 4: {
                this.spec.marginTop = this.getMargin(valueComponentArray[0]);
                this.spec.marginRight = this.getMargin(valueComponentArray[1]);
                this.spec.marginBottom = this.getMargin(valueComponentArray[2]);
                this.spec.marginLeft = this.getMargin(valueComponentArray[3]);
                break;
            }
            default: {
                this.spec.marginLeft = null;
                this.spec.marginBottom = null;
                this.spec.marginRight = null;
                this.spec.marginTop = null;
            }
        }
        if (this.spec.marginTop == null || this.spec.marginRight == null || this.spec.marginBottom == null || this.spec.marginLeft == null) {
            this.spec.marginLeft = null;
            this.spec.marginBottom = null;
            this.spec.marginRight = null;
            this.spec.marginTop = null;
            this.unsupportedPropertyValue("margin");
        }
    }

    private StyleValue getMargin(ValueComponent valueComponent) {
        StyleValue styleValue = StyleValue.fromValueComponent(valueComponent, this.styleSheet);
        if (styleValue != null) {
            switch (styleValue.type) {
                case 28: {
                    styleValue.resolveURL(this.baseURL);
                    break;
                }
                case 29: 
                case 30: {
                    break;
                }
                default: {
                    styleValue = styleValue.asPositiveLength();
                }
            }
        }
        return styleValue;
    }

    private void handlePaddingTop(ValueComponent[] valueComponentArray) {
        this.spec.paddingTop = this.getPadding(valueComponentArray[0]);
        if (this.spec.paddingTop == null) {
            this.unsupportedPropertyValue("padding-top");
        }
    }

    private void handlePaddingRight(ValueComponent[] valueComponentArray) {
        this.spec.paddingRight = this.getPadding(valueComponentArray[0]);
        if (this.spec.paddingRight == null) {
            this.unsupportedPropertyValue("padding-right");
        }
    }

    private void handlePaddingBottom(ValueComponent[] valueComponentArray) {
        this.spec.paddingBottom = this.getPadding(valueComponentArray[0]);
        if (this.spec.paddingBottom == null) {
            this.unsupportedPropertyValue("padding-bottom");
        }
    }

    private void handlePaddingLeft(ValueComponent[] valueComponentArray) {
        this.spec.paddingLeft = this.getPadding(valueComponentArray[0]);
        if (this.spec.paddingLeft == null) {
            this.unsupportedPropertyValue("padding-left");
        }
    }

    private void handlePadding(ValueComponent[] valueComponentArray) {
        switch (valueComponentArray.length) {
            case 1: {
                this.spec.paddingRight = this.spec.paddingTop = this.getPadding(valueComponentArray[0]);
                this.spec.paddingBottom = this.spec.paddingTop;
                this.spec.paddingLeft = this.spec.paddingTop;
                break;
            }
            case 2: {
                this.spec.paddingTop = this.getPadding(valueComponentArray[0]);
                this.spec.paddingRight = this.getPadding(valueComponentArray[1]);
                this.spec.paddingBottom = this.spec.paddingTop;
                this.spec.paddingLeft = this.spec.paddingRight;
                break;
            }
            case 3: {
                this.spec.paddingTop = this.getPadding(valueComponentArray[0]);
                this.spec.paddingRight = this.getPadding(valueComponentArray[1]);
                this.spec.paddingBottom = this.getPadding(valueComponentArray[2]);
                this.spec.paddingLeft = this.spec.paddingRight;
                break;
            }
            case 4: {
                this.spec.paddingTop = this.getPadding(valueComponentArray[0]);
                this.spec.paddingRight = this.getPadding(valueComponentArray[1]);
                this.spec.paddingBottom = this.getPadding(valueComponentArray[2]);
                this.spec.paddingLeft = this.getPadding(valueComponentArray[3]);
                break;
            }
            default: {
                this.spec.paddingLeft = null;
                this.spec.paddingBottom = null;
                this.spec.paddingRight = null;
                this.spec.paddingTop = null;
            }
        }
        if (this.spec.paddingTop == null || this.spec.paddingRight == null || this.spec.paddingBottom == null || this.spec.paddingLeft == null) {
            this.spec.paddingLeft = null;
            this.spec.paddingBottom = null;
            this.spec.paddingRight = null;
            this.spec.paddingTop = null;
            this.unsupportedPropertyValue("padding");
        }
    }

    private StyleValue getPadding(ValueComponent valueComponent) {
        StyleValue styleValue = StyleValue.fromValueComponent(valueComponent, this.styleSheet);
        if (styleValue != null) {
            switch (styleValue.type) {
                case 28: {
                    styleValue.resolveURL(this.baseURL);
                    break;
                }
                case 29: {
                    break;
                }
                default: {
                    styleValue = styleValue.asPositiveLength();
                }
            }
        }
        return styleValue;
    }

    private void handleBorderStyle(ValueComponent[] valueComponentArray) {
        this.spec.borderStyle = this.getBorderStyle(valueComponentArray[0]);
        if (this.spec.borderStyle == null) {
            this.unsupportedPropertyValue("border-style");
        }
    }

    private StyleValue getBorderStyle(ValueComponent valueComponent) {
        StyleValue styleValue = StyleValue.fromValueComponent(valueComponent, this.styleSheet);
        if (styleValue != null) {
            switch (styleValue.type) {
                case 28: {
                    styleValue.resolveURL(this.baseURL);
                    break;
                }
                case 29: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: {
                    break;
                }
                default: {
                    styleValue = null;
                }
            }
        }
        return styleValue;
    }

    private void handleBorderWidth(ValueComponent[] valueComponentArray) {
        this.spec.borderWidth = this.getBorderWidth(valueComponentArray[0]);
        if (this.spec.borderWidth == null) {
            this.unsupportedPropertyValue("border-width");
        }
    }

    private StyleValue getBorderWidth(ValueComponent valueComponent) {
        StyleValue styleValue = StyleValue.fromValueComponent(valueComponent, this.styleSheet);
        if (styleValue != null) {
            switch (styleValue.type) {
                case 28: {
                    styleValue.resolveURL(this.baseURL);
                    break;
                }
                case 29: 
                case 41: 
                case 42: 
                case 43: {
                    break;
                }
                default: {
                    styleValue = styleValue.asPositiveLength();
                }
            }
        }
        return styleValue;
    }

    private void handleBorderTopColor(ValueComponent[] valueComponentArray) {
        this.spec.borderTopColor = this.getColor(valueComponentArray[0], true);
        if (this.spec.borderTopColor == null) {
            this.unsupportedPropertyValue("border-top-color");
        }
    }

    private void handleBorderRightColor(ValueComponent[] valueComponentArray) {
        this.spec.borderRightColor = this.getColor(valueComponentArray[0], true);
        if (this.spec.borderRightColor == null) {
            this.unsupportedPropertyValue("border-right-color");
        }
    }

    private void handleBorderBottomColor(ValueComponent[] valueComponentArray) {
        this.spec.borderBottomColor = this.getColor(valueComponentArray[0], true);
        if (this.spec.borderBottomColor == null) {
            this.unsupportedPropertyValue("border-bottom-color");
        }
    }

    private void handleBorderLeftColor(ValueComponent[] valueComponentArray) {
        this.spec.borderLeftColor = this.getColor(valueComponentArray[0], true);
        if (this.spec.borderLeftColor == null) {
            this.unsupportedPropertyValue("border-left-color");
        }
    }

    private StyleValue getColor(ValueComponent valueComponent, boolean bl) {
        StyleValue styleValue = StyleValue.fromValueComponent(valueComponent, this.styleSheet);
        if (styleValue != null) {
            switch (styleValue.type) {
                case 28: {
                    styleValue.resolveURL(this.baseURL);
                    break;
                }
                case 29: {
                    break;
                }
                case 44: {
                    if (bl) break;
                    styleValue = null;
                    break;
                }
                case 2: 
                case 27: {
                    styleValue = styleValue.asColor();
                    break;
                }
                default: {
                    styleValue = null;
                }
            }
        }
        return styleValue;
    }

    private void handleBorderColor(ValueComponent[] valueComponentArray) {
        switch (valueComponentArray.length) {
            case 1: {
                this.spec.borderRightColor = this.spec.borderTopColor = this.getColor(valueComponentArray[0], true);
                this.spec.borderBottomColor = this.spec.borderTopColor;
                this.spec.borderLeftColor = this.spec.borderTopColor;
                break;
            }
            case 2: {
                this.spec.borderTopColor = this.getColor(valueComponentArray[0], true);
                this.spec.borderRightColor = this.getColor(valueComponentArray[1], true);
                this.spec.borderBottomColor = this.spec.borderTopColor;
                this.spec.borderLeftColor = this.spec.borderRightColor;
                break;
            }
            case 3: {
                this.spec.borderTopColor = this.getColor(valueComponentArray[0], true);
                this.spec.borderRightColor = this.getColor(valueComponentArray[1], true);
                this.spec.borderBottomColor = this.getColor(valueComponentArray[2], true);
                this.spec.borderLeftColor = this.spec.borderRightColor;
                break;
            }
            case 4: {
                this.spec.borderTopColor = this.getColor(valueComponentArray[0], true);
                this.spec.borderRightColor = this.getColor(valueComponentArray[1], true);
                this.spec.borderBottomColor = this.getColor(valueComponentArray[2], true);
                this.spec.borderLeftColor = this.getColor(valueComponentArray[3], true);
                break;
            }
            default: {
                this.spec.borderLeftColor = null;
                this.spec.borderBottomColor = null;
                this.spec.borderRightColor = null;
                this.spec.borderTopColor = null;
            }
        }
        if (this.spec.borderTopColor == null || this.spec.borderRightColor == null || this.spec.borderBottomColor == null || this.spec.borderLeftColor == null) {
            this.spec.borderLeftColor = null;
            this.spec.borderBottomColor = null;
            this.spec.borderRightColor = null;
            this.spec.borderTopColor = null;
            this.unsupportedPropertyValue("border-color");
        }
    }

    private void handleBorder(ValueComponent[] valueComponentArray) {
        switch (valueComponentArray.length) {
            case 1: {
                this.spec.borderWidth = this.getBorderWidth(valueComponentArray[0]);
                if (this.spec.borderWidth == null) {
                    this.unsupportedPropertyValue("border");
                    break;
                }
                if (this.spec.borderWidth.type != 29) break;
                this.spec.borderBottomColor = this.spec.borderLeftColor = this.spec.borderWidth;
                this.spec.borderRightColor = this.spec.borderLeftColor;
                this.spec.borderTopColor = this.spec.borderLeftColor;
                this.spec.borderStyle = this.spec.borderLeftColor;
                break;
            }
            case 2: {
                this.spec.borderWidth = this.getBorderWidth(valueComponentArray[0]);
                this.spec.borderStyle = this.getBorderStyle(valueComponentArray[1]);
                if (this.spec.borderWidth != null && this.spec.borderStyle != null) break;
                this.spec.borderStyle = null;
                this.spec.borderWidth = null;
                this.unsupportedPropertyValue("border");
                break;
            }
            case 3: {
                this.spec.borderWidth = this.getBorderWidth(valueComponentArray[0]);
                this.spec.borderStyle = this.getBorderStyle(valueComponentArray[1]);
                this.spec.borderBottomColor = this.spec.borderLeftColor = this.getColor(valueComponentArray[2], true);
                this.spec.borderRightColor = this.spec.borderLeftColor;
                this.spec.borderTopColor = this.spec.borderLeftColor;
                if (this.spec.borderWidth != null && this.spec.borderStyle != null && this.spec.borderTopColor != null) break;
                this.spec.borderLeftColor = null;
                this.spec.borderBottomColor = null;
                this.spec.borderRightColor = null;
                this.spec.borderTopColor = null;
                this.spec.borderStyle = null;
                this.spec.borderWidth = null;
                this.unsupportedPropertyValue("border");
                break;
            }
            default: {
                this.unsupportedPropertyValue("border");
            }
        }
    }

    private void handleBackgroundColor(ValueComponent[] valueComponentArray) {
        this.spec.backgroundColor = this.getColor(valueComponentArray[0], true);
        if (this.spec.backgroundColor == null) {
            this.unsupportedPropertyValue("background-color");
        }
    }

    private void handleColor(ValueComponent[] valueComponentArray) {
        this.spec.color = this.getColor(valueComponentArray[0], false);
        if (this.spec.color == null) {
            this.unsupportedPropertyValue("color");
        }
    }

    private void handleFontFamily(ValueComponent[] valueComponentArray) {
        this.spec.fontFamily = this.getFontFamily(valueComponentArray, 0);
        if (this.spec.fontFamily == null) {
            this.unsupportedPropertyValue("font-family");
        }
    }

    private StyleValue getFontFamily(ValueComponent[] valueComponentArray, int n) {
        StyleValue styleValue = null;
        int n2 = n;
        while (n2 < valueComponentArray.length) {
            styleValue = StyleValue.fromValueComponent(valueComponentArray[n2], this.styleSheet);
            if (styleValue != null) {
                switch (styleValue.type) {
                    case 28: {
                        styleValue.resolveURL(this.baseURL);
                        break;
                    }
                    case 29: 
                    case 45: 
                    case 46: 
                    case 47: {
                        break;
                    }
                    default: {
                        styleValue = null;
                    }
                }
            }
            if (styleValue != null) break;
            ++n2;
        }
        return styleValue;
    }

    private void handleFontStyle(ValueComponent[] valueComponentArray) {
        this.spec.fontStyle = this.getFontStyle(valueComponentArray[0]);
        if (this.spec.fontStyle == null) {
            this.unsupportedPropertyValue("font-style");
        }
    }

    private StyleValue getFontStyle(ValueComponent valueComponent) {
        StyleValue styleValue = StyleValue.fromValueComponent(valueComponent, this.styleSheet);
        if (styleValue != null) {
            switch (styleValue.type) {
                case 28: {
                    styleValue.resolveURL(this.baseURL);
                    break;
                }
                case 29: 
                case 31: 
                case 48: 
                case 49: {
                    break;
                }
                default: {
                    styleValue = null;
                }
            }
        }
        return styleValue;
    }

    private void handleFontWeight(ValueComponent[] valueComponentArray) {
        this.spec.fontWeight = this.getFontWeight(valueComponentArray[0]);
        if (this.spec.fontWeight == null) {
            this.unsupportedPropertyValue("font-weight");
        }
    }

    private StyleValue getFontWeight(ValueComponent valueComponent) {
        StyleValue styleValue = StyleValue.fromValueComponent(valueComponent, this.styleSheet);
        if (styleValue != null) {
            switch (styleValue.type) {
                case 28: {
                    styleValue.resolveURL(this.baseURL);
                    break;
                }
                case 29: 
                case 31: 
                case 50: {
                    break;
                }
                default: {
                    styleValue = null;
                }
            }
        }
        return styleValue;
    }

    private void handleFontSize(ValueComponent[] valueComponentArray) {
        this.spec.fontSize = this.getFontSize(valueComponentArray[0]);
        if (this.spec.fontSize == null) {
            this.unsupportedPropertyValue("font-size");
        }
    }

    private StyleValue getFontSize(ValueComponent valueComponent) {
        StyleValue styleValue = StyleValue.fromValueComponent(valueComponent, this.styleSheet);
        if (styleValue != null) {
            switch (styleValue.type) {
                case 28: {
                    styleValue.resolveURL(this.baseURL);
                    break;
                }
                case 29: 
                case 42: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: {
                    break;
                }
                case 20: {
                    if (!(styleValue.number <= 0.0)) break;
                    styleValue = null;
                    break;
                }
                default: {
                    styleValue = styleValue.asStrictlyPositiveLength();
                }
            }
        }
        return styleValue;
    }

    private void handleFont(ValueComponent[] valueComponentArray) {
        ValueComponent valueComponent = valueComponentArray[0];
        switch (valueComponentArray.length) {
            case 1: {
                StyleValue styleValue = StyleValue.fromValueComponent(valueComponent, this.styleSheet);
                if (styleValue == null) {
                    this.unsupportedPropertyValue("font");
                    break;
                }
                if (styleValue.type != 29) break;
                this.spec.fontSize = this.spec.fontFamily = styleValue;
                this.spec.fontWeight = this.spec.fontFamily;
                this.spec.fontStyle = this.spec.fontFamily;
                break;
            }
            case 2: {
                this.spec.fontSize = this.getFontSize(valueComponent);
                this.spec.fontFamily = this.getFontFamily(valueComponentArray, 1);
                if (this.spec.fontSize != null && this.spec.fontFamily != null) break;
                this.spec.fontFamily = null;
                this.spec.fontSize = null;
                this.unsupportedPropertyValue("font");
                break;
            }
            case 3: {
                this.spec.fontStyle = this.getFontStyle(valueComponent);
                this.spec.fontSize = this.getFontSize(valueComponentArray[1]);
                this.spec.fontFamily = this.getFontFamily(valueComponentArray, 2);
                if (this.spec.fontStyle != null && this.spec.fontSize != null && this.spec.fontFamily != null) break;
                this.spec.fontFamily = null;
                this.spec.fontSize = null;
                this.spec.fontStyle = null;
                this.unsupportedPropertyValue("font");
                break;
            }
            case 4: {
                this.spec.fontStyle = this.getFontStyle(valueComponent);
                this.spec.fontWeight = this.getFontWeight(valueComponentArray[1]);
                this.spec.fontSize = this.getFontSize(valueComponentArray[2]);
                this.spec.fontFamily = this.getFontFamily(valueComponentArray, 3);
                if (this.spec.fontStyle != null && this.spec.fontWeight != null && this.spec.fontSize != null && this.spec.fontFamily != null) break;
                this.spec.fontFamily = null;
                this.spec.fontSize = null;
                this.spec.fontWeight = null;
                this.spec.fontStyle = null;
                this.unsupportedPropertyValue("font");
                break;
            }
            default: {
                this.unsupportedPropertyValue("font");
            }
        }
    }

    private void handleTextDecoration(ValueComponent[] valueComponentArray) {
        this.spec.textDecoration = StyleValue.fromValueComponent(valueComponentArray[0], this.styleSheet);
        if (this.spec.textDecoration != null) {
            switch (this.spec.textDecoration.type) {
                case 28: {
                    this.spec.textDecoration.resolveURL(this.baseURL);
                    break;
                }
                case 29: 
                case 32: 
                case 59: 
                case 60: 
                case 61: {
                    break;
                }
                default: {
                    this.spec.textDecoration = null;
                }
            }
        }
        if (this.spec.textDecoration == null) {
            this.unsupportedPropertyValue("text-decoration");
        }
    }

    private void handleTextAlign(ValueComponent[] valueComponentArray) {
        this.spec.textAlign = StyleValue.fromValueComponent(valueComponentArray[0], this.styleSheet);
        if (this.spec.textAlign != null) {
            switch (this.spec.textAlign.type) {
                case 28: {
                    this.spec.textAlign.resolveURL(this.baseURL);
                    break;
                }
                case 29: 
                case 62: 
                case 63: 
                case 64: {
                    break;
                }
                default: {
                    this.spec.textAlign = null;
                }
            }
        }
        if (this.spec.textAlign == null) {
            this.unsupportedPropertyValue("text-align");
        }
    }

    private void handleTextIndent(ValueComponent[] valueComponentArray) {
        this.spec.textIndent = StyleValue.fromValueComponent(valueComponentArray[0], this.styleSheet);
        if (this.spec.textIndent != null) {
            switch (this.spec.textIndent.type) {
                case 28: {
                    this.spec.textIndent.resolveURL(this.baseURL);
                    break;
                }
                case 29: {
                    break;
                }
                default: {
                    this.spec.textIndent = this.spec.textIndent.asLength();
                }
            }
        }
        if (this.spec.textIndent == null) {
            this.unsupportedPropertyValue("text-indent");
        }
    }

    private void handleVerticalAlign(ValueComponent[] valueComponentArray) {
        this.spec.verticalAlign = StyleValue.fromValueComponent(valueComponentArray[0], this.styleSheet);
        if (this.spec.verticalAlign != null) {
            switch (this.spec.verticalAlign.type) {
                case 28: {
                    this.spec.verticalAlign.resolveURL(this.baseURL);
                    break;
                }
                case 29: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: {
                    break;
                }
                default: {
                    this.spec.verticalAlign = null;
                }
            }
        }
        if (this.spec.verticalAlign == null) {
            this.unsupportedPropertyValue("vertical-align");
        }
    }

    private void handleLineHeight(ValueComponent[] valueComponentArray) {
        this.spec.lineHeight = StyleValue.fromValueComponent(valueComponentArray[0], this.styleSheet);
        if (this.spec.lineHeight != null) {
            switch (this.spec.lineHeight.type) {
                case 28: {
                    this.spec.lineHeight.resolveURL(this.baseURL);
                    break;
                }
                case 29: 
                case 31: {
                    break;
                }
                case 0: {
                    if (!(this.spec.lineHeight.number <= 0.0)) break;
                    this.spec.lineHeight = null;
                    break;
                }
                default: {
                    this.spec.lineHeight = null;
                }
            }
        }
        if (this.spec.lineHeight == null) {
            this.unsupportedPropertyValue("line-height");
        }
    }

    private void handleWhiteSpace(ValueComponent[] valueComponentArray) {
        this.spec.whiteSpace = StyleValue.fromValueComponent(valueComponentArray[0], this.styleSheet);
        if (this.spec.whiteSpace != null) {
            switch (this.spec.whiteSpace.type) {
                case 28: {
                    this.spec.whiteSpace.resolveURL(this.baseURL);
                    break;
                }
                case 29: 
                case 31: 
                case 73: 
                case 74: {
                    break;
                }
                default: {
                    this.spec.whiteSpace = null;
                }
            }
        }
        if (this.spec.whiteSpace == null) {
            this.unsupportedPropertyValue("white-space");
        }
    }

    private void handleDisplay(ValueComponent[] valueComponentArray) {
        this.spec.display = StyleValue.fromValueComponent(valueComponentArray[0], this.styleSheet);
        if (this.spec.display != null) {
            switch (this.spec.display.type) {
                case 28: {
                    this.spec.display.resolveURL(this.baseURL);
                    break;
                }
                case 29: 
                case 32: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: {
                    break;
                }
                default: {
                    this.spec.display = null;
                }
            }
        }
        if (this.spec.display == null) {
            this.unsupportedPropertyValue("display");
        }
    }

    private void handleContent(ValueComponent[] valueComponentArray) {
        this.spec.content = this.getContent(valueComponentArray);
        if (this.spec.content == null) {
            String string = StyleValue.getLastParseError();
            if (string != null) {
                this.unsupportedPropertyValue("content", string);
            } else {
                this.unsupportedPropertyValue("content");
            }
        }
    }

    private StyleValue getContent(ValueComponent[] valueComponentArray) {
        StyleValue styleValue = StyleValue.fromValueComponents(valueComponentArray, this.styleSheet);
        if (styleValue != null) {
            StyleValue[] styleValueArray = styleValue.type == 4 ? styleValue.list : new StyleValue[]{styleValue};
            int n = 0;
            while (n < styleValueArray.length) {
                StyleValue styleValue2 = styleValueArray[n];
                switch (styleValue2.type) {
                    case 22: 
                    case 28: {
                        styleValue2.resolveURL(this.baseURL);
                        break;
                    }
                    case 1: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: 
                    case 96: 
                    case 97: {
                        break;
                    }
                    default: {
                        styleValue = null;
                    }
                }
                if (styleValue == null) break;
                ++n;
            }
        }
        return styleValue;
    }

    private void handleMarkerOffset(ValueComponent[] valueComponentArray) {
        this.spec.markerOffset = StyleValue.fromValueComponent(valueComponentArray[0], this.styleSheet);
        if (this.spec.markerOffset != null) {
            switch (this.spec.markerOffset.type) {
                case 28: {
                    this.spec.markerOffset.resolveURL(this.baseURL);
                    break;
                }
                case 30: {
                    break;
                }
                case 2: {
                    if ("fill".equals(this.spec.markerOffset.string)) {
                        this.spec.markerOffset.type = 0;
                        this.spec.markerOffset.number = 2.147483647E9;
                        this.spec.markerOffset.string = null;
                        break;
                    }
                    this.spec.markerOffset = null;
                    break;
                }
                default: {
                    this.spec.markerOffset = this.spec.markerOffset.asPositiveLength();
                }
            }
        }
        if (this.spec.markerOffset == null) {
            this.unsupportedPropertyValue("marker-offset");
        }
    }

    private void handleWidth(ValueComponent[] valueComponentArray) {
        this.spec.width = this.getSize(valueComponentArray[0]);
        if (this.spec.width == null) {
            this.unsupportedPropertyValue("width");
        }
    }

    private void handleHeight(ValueComponent[] valueComponentArray) {
        this.spec.height = this.getSize(valueComponentArray[0]);
        if (this.spec.height == null) {
            this.unsupportedPropertyValue("height");
        }
    }

    private StyleValue getSize(ValueComponent valueComponent) {
        StyleValue styleValue = StyleValue.fromValueComponent(valueComponent, this.styleSheet);
        if (styleValue != null) {
            switch (styleValue.type) {
                case 28: {
                    styleValue.resolveURL(this.baseURL);
                    break;
                }
                case 30: {
                    break;
                }
                case 20: {
                    if (!(styleValue.number <= 0.0)) break;
                    styleValue = null;
                    break;
                }
                default: {
                    styleValue = styleValue.asStrictlyPositiveLength();
                }
            }
        }
        return styleValue;
    }

    private void handleCaptionSide(ValueComponent[] valueComponentArray) {
        this.spec.captionSide = StyleValue.fromValueComponent(valueComponentArray[0], this.styleSheet);
        if (this.spec.captionSide != null) {
            switch (this.spec.captionSide.type) {
                case 28: {
                    this.spec.captionSide.resolveURL(this.baseURL);
                    break;
                }
            }
        }
        if (this.spec.captionSide == null) {
            this.unsupportedPropertyValue("caption-side");
        }
    }

    private void handleBorderSpacing(ValueComponent[] valueComponentArray) {
        switch (valueComponentArray.length) {
            case 1: {
                this.spec.borderHorizontalSpacing = this.spec.borderVerticalSpacing = this.getBorderSpacing(valueComponentArray[0]);
                break;
            }
            case 2: {
                this.spec.borderHorizontalSpacing = this.getBorderSpacing(valueComponentArray[0]);
                this.spec.borderVerticalSpacing = this.getBorderSpacing(valueComponentArray[1]);
                break;
            }
            default: {
                this.spec.borderVerticalSpacing = null;
                this.spec.borderHorizontalSpacing = null;
            }
        }
        if (this.spec.borderHorizontalSpacing == null || this.spec.borderVerticalSpacing == null) {
            this.spec.borderVerticalSpacing = null;
            this.spec.borderHorizontalSpacing = null;
            this.unsupportedPropertyValue("border-spacing");
        }
    }

    private StyleValue getBorderSpacing(ValueComponent valueComponent) {
        StyleValue styleValue = StyleValue.fromValueComponent(valueComponent, this.styleSheet);
        if (styleValue != null) {
            switch (styleValue.type) {
                case 28: {
                    styleValue.resolveURL(this.baseURL);
                    break;
                }
                default: {
                    styleValue = styleValue.asPositiveLength();
                }
            }
        }
        return styleValue;
    }

    private void handleRowSpan(ValueComponent[] valueComponentArray) {
        this.spec.rowSpan = this.getPositiveCount(valueComponentArray[0]);
        if (this.spec.rowSpan == null) {
            this.unsupportedPropertyValue("row-span");
        }
    }

    private void handleColumnSpan(ValueComponent[] valueComponentArray) {
        this.spec.columnSpan = this.getPositiveCount(valueComponentArray[0]);
        if (this.spec.columnSpan == null) {
            this.unsupportedPropertyValue("column-span");
        }
    }

    private StyleValue getPositiveCount(ValueComponent valueComponent) {
        StyleValue styleValue = StyleValue.fromValueComponent(valueComponent, this.styleSheet);
        if (styleValue != null) {
            switch (styleValue.type) {
                case 28: {
                    styleValue.resolveURL(this.baseURL);
                    break;
                }
                case 0: {
                    if ((int)styleValue.number > 0) break;
                    styleValue = null;
                    break;
                }
                default: {
                    styleValue = null;
                }
            }
        }
        return styleValue;
    }

    private void handleStartColumn(ValueComponent[] valueComponentArray) {
        this.spec.startColumn = this.getCount(valueComponentArray[0]);
        if (this.spec.startColumn == null) {
            this.unsupportedPropertyValue("start-column");
        }
    }

    private StyleValue getCount(ValueComponent valueComponent) {
        StyleValue styleValue = StyleValue.fromValueComponent(valueComponent, this.styleSheet);
        if (styleValue != null) {
            switch (styleValue.type) {
                case 28: {
                    styleValue.resolveURL(this.baseURL);
                    break;
                }
                case 0: {
                    if ((int)styleValue.number >= 0) break;
                    styleValue = null;
                    break;
                }
                default: {
                    styleValue = null;
                }
            }
        }
        return styleValue;
    }

    private void handleShowRowColumnLabels(ValueComponent[] valueComponentArray) {
        this.spec.showRowColumnLabels = this.getBoolean(valueComponentArray[0]);
        if (this.spec.showRowColumnLabels == null) {
            this.unsupportedPropertyValue("show-row-column-labels");
        }
    }

    private void handleCollapsible(ValueComponent[] valueComponentArray) {
        this.spec.collapsible = this.getBoolean(valueComponentArray[0]);
        if (this.spec.collapsible == null) {
            this.unsupportedPropertyValue("collapsible");
        }
    }

    private void handleCollapsed(ValueComponent[] valueComponentArray) {
        this.spec.collapsed = this.getBoolean(valueComponentArray[0]);
        if (this.spec.collapsed == null) {
            this.unsupportedPropertyValue("collapsed");
        }
    }

    private StyleValue getBoolean(ValueComponent valueComponent) {
        StyleValue styleValue = StyleValue.fromValueComponent(valueComponent, this.styleSheet);
        if (styleValue != null) {
            switch (styleValue.type) {
                case 28: {
                    styleValue.resolveURL(this.baseURL);
                    break;
                }
                case 103: 
                case 104: {
                    break;
                }
                default: {
                    styleValue = null;
                }
            }
        }
        return styleValue;
    }

    private void handleNotCollapsibleHead(ValueComponent[] valueComponentArray) {
        this.spec.notCollapsibleHead = this.getCount(valueComponentArray[0]);
        if (this.spec.notCollapsibleHead == null) {
            this.unsupportedPropertyValue("not-collapsible-head");
        }
    }

    private void handleNotCollapsibleFoot(ValueComponent[] valueComponentArray) {
        this.spec.notCollapsibleFoot = this.getCount(valueComponentArray[0]);
        if (this.spec.notCollapsibleFoot == null) {
            this.unsupportedPropertyValue("not-collapsible-foot");
        }
    }

    private void handleCollapsedContent(ValueComponent[] valueComponentArray) {
        this.spec.collapsedContent = this.getContent(valueComponentArray);
        if (this.spec.collapsedContent == null) {
            this.unsupportedPropertyValue("collapsed-content");
        }
    }

    private void handleCollapsedContentAlign(ValueComponent[] valueComponentArray) {
        this.spec.collapsedContentAlign = StyleValue.fromValueComponent(valueComponentArray[0], this.styleSheet);
        if (this.spec.collapsedContentAlign != null) {
            switch (this.spec.collapsedContentAlign.type) {
                case 28: {
                    this.spec.collapsedContentAlign.resolveURL(this.baseURL);
                    break;
                }
                case 30: 
                case 62: 
                case 63: 
                case 64: {
                    break;
                }
                default: {
                    this.spec.collapsedContentAlign = null;
                }
            }
        }
        if (this.spec.collapsedContentAlign == null) {
            this.unsupportedPropertyValue("collapsed-content-align");
        }
    }

    private void handleAttributeContentLeft(ValueComponent[] valueComponentArray) {
        this.spec.attributeContentLeft = this.getContent(valueComponentArray);
        if (this.spec.attributeContentLeft == null) {
            this.unsupportedPropertyValue("attribute-content-left");
        }
    }

    private void handleAttributeContentMiddle(ValueComponent[] valueComponentArray) {
        this.spec.attributeContentMiddle = this.getContent(valueComponentArray);
        if (this.spec.attributeContentMiddle == null) {
            this.unsupportedPropertyValue("attribute-content-middle");
        }
    }

    private void handleAttributeContentRight(ValueComponent[] valueComponentArray) {
        this.spec.attributeContentRight = this.getContent(valueComponentArray);
        if (this.spec.attributeContentRight == null) {
            this.unsupportedPropertyValue("attribute-content-right");
        }
    }

    private void handleShowAttribute(ValueComponent[] valueComponentArray) {
        this.spec.showAttribute = StyleValue.fromValueComponent(valueComponentArray[0], this.styleSheet);
        if (this.spec.showAttribute != null) {
            switch (this.spec.showAttribute.type) {
                case 28: {
                    this.spec.showAttribute.resolveURL(this.baseURL);
                    break;
                }
                case 105: 
                case 106: 
                case 107: {
                    break;
                }
                default: {
                    this.spec.showAttribute = null;
                }
            }
        }
        if (this.spec.showAttribute == null) {
            this.unsupportedPropertyValue("show-attribute");
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1 || !new File(stringArray[0]).isFile()) {
            System.err.println("usage: java com.xmlmind.xmledit.stylesheet.StyleSheetLoader css_file");
            System.exit(1);
        }
        StyleSheetLoader styleSheetLoader = new StyleSheetLoader();
        StyleSheet styleSheet = null;
        try {
            styleSheet = styleSheetLoader.load(new File(stringArray[0]));
        }
        catch (IOException iOException) {
            String string = iOException.getMessage();
            if (string == null) {
                string = iOException.getClass().getName();
            }
            System.err.println("cannot load '" + stringArray[0] + "': " + string);
            System.exit(2);
        }
        Warning[] warningArray = styleSheetLoader.getWarnings();
        if (warningArray.length > 0) {
            int n = 0;
            while (n < warningArray.length) {
                Warning warning = warningArray[n];
                System.err.println(warning.url.toExternalForm() + ":W:" + warning.lineNumber + ":" + warning.columnNumber + ": " + warning.message);
                ++n;
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        propertyHandlers = new HashMap();
        Method[] methodArray = (class$com$xmlmind$xmledit$stylesheet$StyleSheetLoader == null ? (class$com$xmlmind$xmledit$stylesheet$StyleSheetLoader = StyleSheetLoader.class$("com.xmlmind.xmledit.stylesheet.StyleSheetLoader")) : class$com$xmlmind$xmledit$stylesheet$StyleSheetLoader).getDeclaredMethods();
        int n = 0;
        while (n < methodArray.length) {
            Method method = methodArray[n];
            String string = method.getName();
            int n2 = string.length();
            if (n2 > 6 && string.indexOf("handle") == 0) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(Character.toLowerCase(string.charAt(6)));
                int n3 = 7;
                while (n3 < n2) {
                    char c = string.charAt(n3);
                    if (Character.isUpperCase(c)) {
                        stringBuffer.append('-');
                        stringBuffer.append(Character.toLowerCase(c));
                    } else {
                        stringBuffer.append(c);
                    }
                    ++n3;
                }
                propertyHandlers.put(stringBuffer.toString(), method);
            }
            ++n;
        }
    }

    public static class Warning {
        public URL url;
        public int lineNumber;
        public int columnNumber;
        public String message;

        public Warning(URL uRL, int n, int n2, String string) {
            this.url = uRL;
            this.lineNumber = n;
            this.columnNumber = n2;
            this.message = string;
        }
    }
}

