/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.stylesheet;

import com.xmlmind.xmledit.cssparser.ParseUtil;
import com.xmlmind.xmledit.cssparser.ValueComponent;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.edit.SimpleDocumentCache;
import com.xmlmind.xmledit.stylesheet.Msg;
import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.Namespace;
import com.xmlmind.xmledit.xmlutil.PrefixToNamespace;
import com.xmlmind.xmledit.xmlutil.XMLCatalogs;
import com.xmlmind.xmledit.xmlutil.XMLUtil;
import com.xmlmind.xmledit.xpath.EvalException;
import com.xmlmind.xmledit.xpath.ExprParser;
import com.xmlmind.xmledit.xpath.ParseException;
import com.xmlmind.xmledit.xpath.SimpleExprContext;
import com.xmlmind.xmledit.xpath.StringExpr;
import java.awt.Color;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.StringTokenizer;

public final class StyleValue {
    public static final Namespace ANY_NAMESPACE = Namespace.get("*");
    public static final int UNKNOWN_TYPE = -1;
    public static final int NUMBER = 0;
    public static final int STRING = 1;
    public static final int IDENTIFIER = 2;
    public static final int NAME = 3;
    public static final int LIST = 4;
    public static final int LENGTH_PX = 5;
    public static final int LENGTH_IN = 6;
    public static final int LENGTH_CM = 7;
    public static final int LENGTH_MM = 8;
    public static final int LENGTH_PT = 9;
    public static final int LENGTH_PC = 10;
    public static final int LENGTH_EM = 11;
    public static final int LENGTH_EX = 12;
    public static final int ANGLE_DEG = 13;
    public static final int ANGLE_GRAD = 14;
    public static final int ANGLE_RAD = 15;
    public static final int TIME_MS = 16;
    public static final int TIME_S = 17;
    public static final int FREQUENCY_HZ = 18;
    public static final int FREQUENCY_KHZ = 19;
    public static final int PERCENTAGE = 20;
    public static final int DIMENSION = 21;
    public static final int URI = 22;
    public static final int ATTRIBUTE = 23;
    public static final int XPATH = 24;
    public static final int COUNTER = 25;
    public static final int COUNTERS = 26;
    public static final int COLOR = 27;
    public static final int FUNCTION = 28;
    public static final int INHERIT = 29;
    public static final int AUTO = 30;
    public static final int NORMAL = 31;
    public static final int NONE = 32;
    public static final int DOTTED = 33;
    public static final int DASHED = 34;
    public static final int SOLID = 35;
    public static final int DOUBLE = 36;
    public static final int GROOVE = 37;
    public static final int RIDGE = 38;
    public static final int INSET = 39;
    public static final int OUTSET = 40;
    public static final int THIN = 41;
    public static final int MEDIUM = 42;
    public static final int THICK = 43;
    public static final int TRANSPARENT = 44;
    public static final int SERIF = 45;
    public static final int SANS_SERIF = 46;
    public static final int MONOSPACE = 47;
    public static final int ITALIC = 48;
    public static final int OBLIQUE = 49;
    public static final int BOLD = 50;
    public static final int SMALL = 51;
    public static final int LARGE = 52;
    public static final int X_SMALL = 53;
    public static final int X_LARGE = 54;
    public static final int XX_SMALL = 55;
    public static final int XX_LARGE = 56;
    public static final int LARGER = 57;
    public static final int SMALLER = 58;
    public static final int UNDERLINE = 59;
    public static final int OVERLINE = 60;
    public static final int LINE_THROUGH = 61;
    public static final int LEFT = 62;
    public static final int RIGHT = 63;
    public static final int CENTER = 64;
    public static final int BASELINE = 65;
    public static final int TOP = 66;
    public static final int MIDDLE = 67;
    public static final int BOTTOM = 68;
    public static final int SUB = 69;
    public static final int SUPER = 70;
    public static final int TEXT_TOP = 71;
    public static final int TEXT_BOTTOM = 72;
    public static final int PRE = 73;
    public static final int NOWRAP = 74;
    public static final int INLINE = 75;
    public static final int BLOCK = 76;
    public static final int MARKER = 77;
    public static final int TABLE = 78;
    public static final int INLINE_TABLE = 79;
    public static final int TABLE_COLUMN_GROUP = 80;
    public static final int TABLE_COLUMN = 81;
    public static final int TABLE_ROW_GROUP = 82;
    public static final int TABLE_HEADER_GROUP = 83;
    public static final int TABLE_FOOTER_GROUP = 84;
    public static final int TABLE_ROW = 85;
    public static final int TABLE_CELL = 86;
    public static final int TABLE_CAPTION = 87;
    public static final int INLINE_BLOCK = 88;
    public static final int TREE = 89;
    public static final int SUBTABLE = 90;
    public static final int OPEN_QUOTE = 91;
    public static final int CLOSE_QUOTE = 92;
    public static final int NO_OPEN_QUOTE = 93;
    public static final int NO_CLOSE_QUOTE = 94;
    public static final int DISC = 95;
    public static final int CIRCLE = 96;
    public static final int SQUARE = 97;
    public static final int DECIMAL = 98;
    public static final int LOWER_ALPHA = 99;
    public static final int UPPER_ALPHA = 100;
    public static final int LOWER_ROMAN = 101;
    public static final int UPPER_ROMAN = 102;
    public static final int NO = 103;
    public static final int YES = 104;
    public static final int NEVER = 105;
    public static final int ALWAYS = 106;
    public static final int WHEN_ADDED = 107;
    public int type = -1;
    public double number = 0.0;
    public String string = null;
    public Name name = null;
    public StyleValue[] list = null;
    public Color color = null;
    public StringExpr xpath = null;
    private static String lastParseError = null;
    private static final KeywordValue[] keywordValues = new KeywordValue[]{new KeywordValue("inherit", 29), new KeywordValue("auto", 30), new KeywordValue("normal", 31), new KeywordValue("none", 32), new KeywordValue("dotted", 33), new KeywordValue("dashed", 34), new KeywordValue("solid", 35), new KeywordValue("double", 36), new KeywordValue("groove", 37), new KeywordValue("ridge", 38), new KeywordValue("inset", 39), new KeywordValue("outset", 40), new KeywordValue("thin", 41), new KeywordValue("medium", 42), new KeywordValue("thick", 43), new KeywordValue("transparent", 44), new KeywordValue("serif", 45), new KeywordValue("sans-serif", 46), new KeywordValue("monospace", 47), new KeywordValue("italic", 48), new KeywordValue("oblique", 49), new KeywordValue("bold", 50), new KeywordValue("small", 51), new KeywordValue("large", 52), new KeywordValue("x-small", 53), new KeywordValue("x-large", 54), new KeywordValue("xx-small", 55), new KeywordValue("xx-large", 56), new KeywordValue("larger", 57), new KeywordValue("smaller", 58), new KeywordValue("underline", 59), new KeywordValue("overline", 60), new KeywordValue("line-through", 61), new KeywordValue("left", 62), new KeywordValue("right", 63), new KeywordValue("center", 64), new KeywordValue("baseline", 65), new KeywordValue("top", 66), new KeywordValue("middle", 67), new KeywordValue("bottom", 68), new KeywordValue("sub", 69), new KeywordValue("super", 70), new KeywordValue("text-top", 71), new KeywordValue("text-bottom", 72), new KeywordValue("pre", 73), new KeywordValue("nowrap", 74), new KeywordValue("inline", 75), new KeywordValue("block", 76), new KeywordValue("marker", 77), new KeywordValue("table", 78), new KeywordValue("inline-table", 79), new KeywordValue("table-column-group", 80), new KeywordValue("table-column", 81), new KeywordValue("table-row-group", 82), new KeywordValue("table-header-group", 83), new KeywordValue("table-footer-group", 84), new KeywordValue("table-row", 85), new KeywordValue("table-cell", 86), new KeywordValue("table-caption", 87), new KeywordValue("inline-block", 88), new KeywordValue("tree", 89), new KeywordValue("subtable", 90), new KeywordValue("open-quote", 91), new KeywordValue("close-quote", 92), new KeywordValue("no-open-quote", 93), new KeywordValue("no-close-quote", 94), new KeywordValue("disc", 95), new KeywordValue("circle", 96), new KeywordValue("square", 97), new KeywordValue("decimal", 98), new KeywordValue("lower-alpha", 99), new KeywordValue("upper-alpha", 100), new KeywordValue("lower-latin", 99), new KeywordValue("upper-latin", 100), new KeywordValue("lower-roman", 101), new KeywordValue("upper-roman", 102), new KeywordValue("no", 103), new KeywordValue("yes", 104), new KeywordValue("never", 105), new KeywordValue("always", 106), new KeywordValue("when-added", 107)};
    private static HashMap keywordToValue = new HashMap();
    private static HashMap valueToKeyword = new HashMap();

    public StyleValue() {
    }

    public StyleValue(int n) {
        this.type = n;
    }

    public StyleValue(String string) {
        this.type = 1;
        this.string = string;
    }

    public StyleValue(double d) {
        this.type = 0;
        this.number = d;
    }

    public StyleValue(Color color) {
        this.type = 27;
        this.color = color;
    }

    public static StyleValue fromValueComponents(ValueComponent[] valueComponentArray, PrefixToNamespace prefixToNamespace) {
        switch (valueComponentArray.length) {
            case 0: {
                return null;
            }
            case 1: {
                return StyleValue.fromValueComponent(valueComponentArray[0], prefixToNamespace);
            }
        }
        StyleValue styleValue = new StyleValue();
        styleValue.type = 4;
        styleValue.list = new StyleValue[valueComponentArray.length];
        int n = 0;
        while (n < valueComponentArray.length) {
            styleValue.list[n] = StyleValue.fromValueComponent(valueComponentArray[n], prefixToNamespace);
            if (styleValue.list[n] == null) {
                return null;
            }
            ++n;
        }
        return styleValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StyleValue fromValueComponent(ValueComponent valueComponent, PrefixToNamespace prefixToNamespace) {
        lastParseError = null;
        StyleValue styleValue = new StyleValue();
        switch (valueComponent.type) {
            case -25: {
                styleValue.type = 0;
                styleValue.number = valueComponent.numericValue;
                return styleValue;
            }
            case -7: {
                styleValue.type = 1;
                styleValue.string = valueComponent.stringValue;
                return styleValue;
            }
            case -31: {
                Namespace namespace = StyleValue.prefixToNamespace(prefixToNamespace, valueComponent.prefix);
                if (namespace == null) {
                    return null;
                }
                styleValue.type = 3;
                styleValue.name = Name.get(namespace, valueComponent.stringValue);
                return styleValue;
            }
            case -8: {
                styleValue.type = StyleValue.getKeywordValue(valueComponent.stringValue);
                if (styleValue.type >= 0) return styleValue;
                styleValue.type = 2;
                styleValue.string = valueComponent.stringValue;
                return styleValue;
            }
            case -19: {
                styleValue.number = valueComponent.numericValue;
                if ("em".equals(valueComponent.unit)) {
                    styleValue.type = 11;
                    return styleValue;
                }
                if ("ex".equals(valueComponent.unit)) {
                    styleValue.type = 12;
                    return styleValue;
                }
                if ("pt".equals(valueComponent.unit)) {
                    styleValue.type = 9;
                    return styleValue;
                }
                if ("px".equals(valueComponent.unit)) {
                    styleValue.type = 5;
                    return styleValue;
                }
                if ("in".equals(valueComponent.unit)) {
                    styleValue.type = 6;
                    return styleValue;
                }
                if ("cm".equals(valueComponent.unit)) {
                    styleValue.type = 7;
                    return styleValue;
                }
                if ("mm".equals(valueComponent.unit)) {
                    styleValue.type = 8;
                    return styleValue;
                }
                if (!"pc".equals(valueComponent.unit)) return null;
                styleValue.type = 10;
                return styleValue;
            }
            case -20: {
                styleValue.number = valueComponent.numericValue;
                if ("deg".equals(valueComponent.unit)) {
                    styleValue.type = 13;
                    return styleValue;
                }
                if ("rad".equals(valueComponent.unit)) {
                    styleValue.type = 15;
                    return styleValue;
                }
                if (!"grad".equals(valueComponent.unit)) return null;
                styleValue.type = 14;
                return styleValue;
            }
            case -21: {
                styleValue.number = valueComponent.numericValue;
                if ("ms".equals(valueComponent.unit)) {
                    styleValue.type = 16;
                    return styleValue;
                }
                if (!"s".equals(valueComponent.unit)) return null;
                styleValue.type = 17;
                return styleValue;
            }
            case -22: {
                styleValue.number = valueComponent.numericValue;
                if ("hz".equals(valueComponent.unit)) {
                    styleValue.type = 18;
                    return styleValue;
                }
                if (!"mhz".equals(valueComponent.unit)) return null;
                styleValue.type = 19;
                return styleValue;
            }
            case -24: {
                styleValue.type = 20;
                styleValue.number = valueComponent.numericValue;
                return styleValue;
            }
            case -23: {
                styleValue.type = 21;
                styleValue.number = valueComponent.numericValue;
                styleValue.string = valueComponent.unit;
                return styleValue;
            }
            case -26: {
                styleValue.type = 22;
                styleValue.string = valueComponent.stringValue;
                return styleValue;
            }
            case -27: {
                String string = valueComponent.functionName;
                ValueComponent[] valueComponentArray = valueComponent.functionArguments;
                if (string.equals("attr")) {
                    if (valueComponentArray.length != 1) {
                        return null;
                    }
                    switch (valueComponentArray[0].type) {
                        case -8: 
                        case -7: {
                            Namespace namespace = StyleValue.prefixToNamespace(prefixToNamespace, null);
                            if (namespace == null) {
                                return null;
                            }
                            styleValue.name = Name.get(namespace, valueComponentArray[0].stringValue);
                            break;
                        }
                        case -31: {
                            Namespace namespace = StyleValue.prefixToNamespace(prefixToNamespace, valueComponentArray[0].prefix);
                            if (namespace == null) {
                                return null;
                            }
                            styleValue.name = Name.get(namespace, valueComponentArray[0].stringValue);
                            break;
                        }
                        default: {
                            return null;
                        }
                    }
                    styleValue.type = 23;
                    return styleValue;
                }
                if (string.equals("counter")) {
                    StyleValue styleValue2;
                    styleValue.list = new StyleValue[1];
                    styleValue.list[0] = styleValue2 = new StyleValue();
                    styleValue2.type = 98;
                    switch (valueComponentArray.length) {
                        case 2: {
                            if (valueComponentArray[1].type != -8) return null;
                            styleValue2.type = StyleValue.getKeywordValue(valueComponentArray[1].stringValue);
                            switch (styleValue2.type) {
                                case 98: 
                                case 99: 
                                case 100: 
                                case 101: 
                                case 102: {
                                    break;
                                }
                                default: {
                                    return null;
                                }
                            }
                        }
                        case 1: {
                            if (valueComponentArray[0].type != -8) return null;
                            styleValue.type = 25;
                            styleValue.string = valueComponentArray[0].stringValue;
                            return styleValue;
                        }
                    }
                    return null;
                }
                if (string.equals("counters")) {
                    StyleValue styleValue3;
                    StyleValue styleValue4;
                    styleValue.list = new StyleValue[2];
                    styleValue.list[0] = styleValue4 = new StyleValue();
                    styleValue.list[1] = styleValue3 = new StyleValue();
                    styleValue3.type = 98;
                    switch (valueComponentArray.length) {
                        case 3: {
                            if (valueComponentArray[2].type != -8) return null;
                            styleValue3.type = StyleValue.getKeywordValue(valueComponentArray[2].stringValue);
                            switch (styleValue3.type) {
                                case 98: 
                                case 99: 
                                case 100: 
                                case 101: 
                                case 102: {
                                    break;
                                }
                                default: {
                                    return null;
                                }
                            }
                        }
                        case 2: {
                            if (valueComponentArray[0].type != -8 || valueComponentArray[1].type != -7) return null;
                            styleValue.type = 26;
                            styleValue.string = valueComponentArray[0].stringValue;
                            styleValue4.type = 1;
                            styleValue4.string = valueComponentArray[1].stringValue;
                            return styleValue;
                        }
                    }
                    return null;
                }
                if (string.equals("rgb")) {
                    int[] nArray = ParseUtil.functionArgumentsToRGB(valueComponentArray);
                    if (nArray == null) {
                        return null;
                    }
                    styleValue.type = 27;
                    styleValue.color = new Color(nArray[0], nArray[1], nArray[2]);
                    return styleValue;
                }
                if (string.equals("xpath")) {
                    StringExpr stringExpr = null;
                    if (valueComponentArray.length == 1 && valueComponentArray[0].type == -7) {
                        try {
                            stringExpr = ExprParser.parseStringExpr(valueComponentArray[0].stringValue, prefixToNamespace, true);
                        }
                        catch (ParseException parseException) {
                            lastParseError = Msg.msg("cannotParseXPath", valueComponentArray[0].stringValue, MiscUtil.reason(parseException));
                        }
                    }
                    if (stringExpr == null) {
                        return null;
                    }
                    styleValue.type = 24;
                    styleValue.xpath = stringExpr;
                    return styleValue;
                }
                styleValue.type = 28;
                styleValue.string = string;
                int n = valueComponentArray.length;
                styleValue.list = new StyleValue[n];
                int n2 = 0;
                while (n2 < n) {
                    styleValue.list[n2] = StyleValue.fromValueComponent(valueComponentArray[n2], prefixToNamespace);
                    if (styleValue.list[n2] == null) {
                        return null;
                    }
                    ++n2;
                }
                return styleValue;
            }
            case -9: {
                styleValue.type = 27;
                styleValue.color = new Color(valueComponent.hexColor[0], valueComponent.hexColor[1], valueComponent.hexColor[2]);
                return styleValue;
            }
            default: {
                return null;
            }
        }
    }

    public static String getLastParseError() {
        return lastParseError;
    }

    private static int getKeywordValue(String string) {
        KeywordValue keywordValue = (KeywordValue)keywordToValue.get(string);
        if (keywordValue == null) {
            return -1;
        }
        return keywordValue.value;
    }

    public static String getKeyword(int n) {
        KeywordValue keywordValue = new KeywordValue(null, n);
        KeywordValue keywordValue2 = (KeywordValue)valueToKeyword.get(keywordValue);
        if (keywordValue2 == null) {
            return null;
        }
        return keywordValue2.keyword;
    }

    private static Namespace prefixToNamespace(PrefixToNamespace prefixToNamespace, String string) {
        Namespace namespace = string == null ? Namespace.NONE : (string.length() == 0 ? Namespace.NONE : (string.charAt(0) == '*' ? ANY_NAMESPACE : (prefixToNamespace == null ? null : prefixToNamespace.prefixToNamespace(string))));
        return namespace;
    }

    public StyleValue asLength() {
        switch (this.type) {
            case 0: {
                this.type = 5;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return this;
            }
        }
        return null;
    }

    public StyleValue asPositiveLength() {
        switch (this.type) {
            case 0: {
                this.type = 5;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return this.number >= 0.0 ? this : null;
            }
        }
        return null;
    }

    public StyleValue asStrictlyPositiveLength() {
        switch (this.type) {
            case 0: {
                this.type = 5;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return this.number > 0.0 ? this : null;
            }
        }
        return null;
    }

    public StyleValue asColor() {
        switch (this.type) {
            case 27: {
                return this;
            }
            case 2: {
                int[] nArray = ParseUtil.nameToRGB(this.string);
                if (nArray == null) {
                    return null;
                }
                this.type = 27;
                this.string = null;
                this.color = new Color(nArray[0], nArray[1], nArray[2]);
                return this;
            }
        }
        return null;
    }

    public void resolveURL(URL uRL) {
        switch (this.type) {
            case 22: {
                String string = this.string;
                if (uRL != null) {
                    try {
                        URL uRL2 = XMLCatalogs.resolveURI(this.string, uRL);
                        string = uRL2.toExternalForm();
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
                this.string = string;
                break;
            }
            case 4: 
            case 28: {
                int n = 0;
                while (n < this.list.length) {
                    this.list[n].resolveURL(uRL);
                    ++n;
                }
                break;
            }
        }
    }

    public String stringValue() {
        return this.stringValue(null);
    }

    public String stringValue(Element element) {
        switch (this.type) {
            case 23: {
                if (element != null) {
                    return element.getAttribute(this.name);
                }
                return null;
            }
            case 24: {
                if (element != null) {
                    return StyleValue.evalXPath(this.xpath, element);
                }
                return null;
            }
            case 28: {
                if (element != null) {
                    if ("element-label".equals(this.string)) {
                        return XMLUtil.nameToLabel(element.getLocalName());
                    }
                    if ("element-local-name".equals(this.string)) {
                        return element.getLocalName();
                    }
                    if ("element-name".equals(this.string)) {
                        return element.getName().format(false, element);
                    }
                    if ("element-namespace-uri".equals(this.string)) {
                        return element.getNamespace().getURI();
                    }
                    return null;
                }
                return null;
            }
            case 1: 
            case 2: {
                return this.string;
            }
        }
        return StyleValue.getKeyword(this.type);
    }

    private static String evalXPath(StringExpr stringExpr, Element element) {
        SimpleDocumentCache.installDefaultDocumentManager();
        SimpleExprContext simpleExprContext = new SimpleExprContext();
        String string = null;
        try {
            string = stringExpr.eval(element, simpleExprContext);
        }
        catch (EvalException evalException) {}
        return string;
    }

    public Name nameValue(PrefixToNamespace prefixToNamespace) {
        return this.nameValue(null, prefixToNamespace);
    }

    public Name nameValue(Element element, PrefixToNamespace prefixToNamespace) {
        String string = null;
        switch (this.type) {
            case 23: {
                if (element == null) break;
                string = element.getAttribute(this.name);
                prefixToNamespace = element;
                break;
            }
            case 24: {
                if (element == null) break;
                string = StyleValue.evalXPath(this.xpath, element);
                prefixToNamespace = element;
                break;
            }
            case 28: {
                if (element == null) break;
                if ("element-name".equals(this.string)) {
                    return element.getName();
                }
                if (!"element-local-name".equals(this.string)) break;
                return Name.get(element.getLocalName());
            }
            case 1: 
            case 2: {
                string = this.string;
                break;
            }
            case 3: {
                return this.name;
            }
            default: {
                string = StyleValue.getKeyword(this.type);
            }
        }
        if (string != null) {
            Name name = Name.parse(string, true, prefixToNamespace);
            if (name == null && XMLUtil.isName(string)) {
                name = Name.get(string);
            }
            return name;
        }
        return null;
    }

    public boolean booleanValue(boolean bl) {
        return this.booleanValue(null, bl);
    }

    public boolean booleanValue(Element element, boolean bl) {
        String string = null;
        switch (this.type) {
            case 23: {
                if (element == null) break;
                string = element.getAttribute(this.name);
                break;
            }
            case 24: {
                if (element == null) break;
                string = StyleValue.evalXPath(this.xpath, element);
                break;
            }
            case 1: 
            case 2: {
                string = this.string;
                break;
            }
            case 0: {
                return this.number != 0.0;
            }
            case 104: {
                return true;
            }
            case 103: {
                return false;
            }
            default: {
                return bl;
            }
        }
        if (string != null) {
            if (string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("true") || string.equalsIgnoreCase("on") || string.equalsIgnoreCase("1")) {
                return true;
            }
            if (string.equalsIgnoreCase("no") || string.equalsIgnoreCase("false") || string.equalsIgnoreCase("off") || string.equalsIgnoreCase("0")) {
                return false;
            }
            return bl;
        }
        return bl;
    }

    public double doubleValue(double d) {
        return this.doubleValue(null, d);
    }

    public double doubleValue(Element element, double d) {
        String string = null;
        switch (this.type) {
            case 23: {
                if (element == null) break;
                string = element.getAttribute(this.name);
                break;
            }
            case 24: {
                if (element == null) break;
                string = StyleValue.evalXPath(this.xpath, element);
                break;
            }
            case 1: {
                string = this.string;
                break;
            }
            case 0: {
                return this.number;
            }
            default: {
                return d;
            }
        }
        if (string != null) {
            try {
                return Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                return d;
            }
        }
        return d;
    }

    public int intValue(int n) {
        return this.intValue(null, n);
    }

    public int intValue(Element element, int n) {
        String string = null;
        switch (this.type) {
            case 23: {
                if (element == null) break;
                string = element.getAttribute(this.name);
                break;
            }
            case 24: {
                if (element == null) break;
                string = StyleValue.evalXPath(this.xpath, element);
                break;
            }
            case 1: {
                string = this.string;
                break;
            }
            case 0: {
                return (int)this.number;
            }
            default: {
                return n;
            }
        }
        if (string != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                return n;
            }
        }
        return n;
    }

    public Color colorValue() {
        return this.colorValue(null);
    }

    public Color colorValue(Element element) {
        String string = null;
        switch (this.type) {
            case 23: {
                if (element == null) break;
                string = element.getAttribute(this.name);
                break;
            }
            case 24: {
                if (element == null) break;
                string = StyleValue.evalXPath(this.xpath, element);
                break;
            }
            case 1: 
            case 2: {
                string = this.string;
                break;
            }
            case 27: {
                return this.color;
            }
            default: {
                return null;
            }
        }
        if (string != null) {
            return StyleValue.parseColor(string);
        }
        return null;
    }

    public static final Color parseColor(String string) {
        int n;
        int n2;
        int n3;
        if (string == null || (string = string.trim()).length() == 0) {
            return null;
        }
        if (string.startsWith("#")) {
            int[] nArray = ParseUtil.lexemeToHexColor(string);
            if (nArray == null) {
                return null;
            }
            n3 = nArray[0];
            n2 = nArray[1];
            n = nArray[2];
        } else if (string.startsWith("rgb(")) {
            int n4 = string.length();
            if (n4 == 5 || string.charAt(n4 - 1) != ')') {
                return null;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string.substring(4, n4 - 1), ", \t\r\n");
            if (stringTokenizer.countTokens() != 3) {
                return null;
            }
            try {
                n3 = Integer.parseInt(stringTokenizer.nextToken());
                n2 = Integer.parseInt(stringTokenizer.nextToken());
                n = Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                n3 = -1;
                n2 = -1;
                n = -1;
            }
            if (n3 < 0 || n3 > 255 || n2 < 0 || n2 > 255 || n < 0 || n > 255) {
                return null;
            }
        } else {
            int[] nArray = ParseUtil.nameToRGB(string);
            if (nArray == null) {
                return null;
            }
            n3 = nArray[0];
            n2 = nArray[1];
            n = nArray[2];
        }
        return new Color(n3, n2, n);
    }

    static {
        int n = 0;
        while (n < keywordValues.length) {
            KeywordValue keywordValue = keywordValues[n];
            keywordToValue.put(keywordValue.keyword, keywordValue);
            if (!valueToKeyword.containsKey(keywordValue)) {
                valueToKeyword.put(keywordValue, keywordValue);
            }
            ++n;
        }
    }

    private static final class KeywordValue {
        public String keyword;
        public int value;

        public KeywordValue(String string, int n) {
            this.keyword = string;
            this.value = n;
        }

        public int hashCode() {
            return this.value;
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof KeywordValue)) {
                return false;
            }
            return ((KeywordValue)object).value == this.value;
        }
    }
}

