/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class PlatformUtil {
    public static final int GENERIC_UNIX = 1;
    public static final int WINDOWS = 2;
    public static final int MAC_OS = 3;
    public static final int PLATFORM = PlatformUtil.platform();
    public static final boolean IS_GENERIC_UNIX = PLATFORM == 1;
    public static final boolean IS_WINDOWS = PLATFORM == 2;
    public static final boolean IS_MAC_OS = PLATFORM == 3;

    private static final int platform() {
        if (File.pathSeparatorChar == ';') {
            return 2;
        }
        String string = System.getProperty("os.name");
        if (string != null && string.toLowerCase().indexOf("mac") >= 0) {
            return 3;
        }
        return 1;
    }

    public static String homeDir() {
        String string = System.getProperty("HOME");
        if (string == null || string.length() == 0) {
            string = System.getProperty("user.home");
        }
        if (!new File(string).isDirectory()) {
            string = null;
        }
        return string;
    }

    public static String rcFileName(String string) {
        String string2 = PlatformUtil.homeDir();
        if (string2 == null) {
            return null;
        }
        String string3 = IS_WINDOWS ? string2 + File.separatorChar + string + ".ini" : string2 + File.separatorChar + "." + string;
        return string3;
    }

    public static String tmpFileName() {
        return PlatformUtil.tmpFileName(".tmp");
    }

    public static String tmpFileName(String string) {
        String string2 = Long.toString(System.currentTimeMillis(), 36) + string;
        String string3 = PlatformUtil.tmpDir();
        String string4 = string3 == null ? string2 : new File(string3, string2).getPath();
        return string4;
    }

    public static String tmpDir() {
        String string;
        if (IS_WINDOWS) {
            string = System.getProperty("TMP");
            if (!(string != null && string.length() != 0 || (string = System.getProperty("TEMP")) != null && string.length() != 0)) {
                string = "C:\\";
            }
        } else {
            string = "/tmp";
        }
        if (!new File(string).isDirectory()) {
            string = null;
        }
        return string;
    }

    public static String commandSeparator() {
        return IS_WINDOWS ? "&&" : ";";
    }

    public static Process shellStart(String string) throws IOException {
        return PlatformUtil.shellStart(string, null, null);
    }

    public static Process shellStart(String string, String[] stringArray, File file) throws IOException {
        Process process = IS_WINDOWS ? Runtime.getRuntime().exec(new String[]{"cmd.exe", "/s", "/c", "\"" + string + "\""}, stringArray, file) : Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", string}, stringArray, file);
        return process;
    }

    public static int shellExec(String string) throws IOException, InterruptedException {
        return PlatformUtil.shellExec(string, null, null, false);
    }

    public static int shellExec(String string, String[] stringArray, File file) throws IOException, InterruptedException {
        return PlatformUtil.shellExec(string, stringArray, file, false);
    }

    public static int shellExec(String string, boolean bl) throws IOException, InterruptedException {
        return PlatformUtil.shellExec(string, null, null, bl);
    }

    public static int shellExec(String string, String[] stringArray, File file, boolean bl) throws IOException, InterruptedException {
        InputConsumer inputConsumer;
        InputConsumer inputConsumer2;
        if (bl) {
            System.out.println(string);
        }
        Process process = PlatformUtil.shellStart(string, stringArray, file);
        if (bl) {
            inputConsumer2 = new InputConsumer(process.getInputStream(), System.out);
            inputConsumer = new InputConsumer(process.getErrorStream(), System.err);
        } else {
            inputConsumer2 = new InputConsumer(process.getInputStream());
            inputConsumer = new InputConsumer(process.getErrorStream());
        }
        inputConsumer2.start();
        inputConsumer.start();
        int n = process.waitFor();
        inputConsumer2.join();
        inputConsumer.join();
        return n;
    }

    public static int shellExec(String string, String[] stringArray) throws IOException, InterruptedException {
        return PlatformUtil.shellExec(string, null, null, stringArray);
    }

    public static int shellExec(String string, String[] stringArray, File file, String[] stringArray2) throws IOException, InterruptedException {
        Process process = PlatformUtil.shellStart(string, stringArray, file);
        return PlatformUtil.captureOutput(process, stringArray2);
    }

    public static int captureOutput(Process process, String[] stringArray) throws InterruptedException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        InputConsumer inputConsumer = new InputConsumer(process.getInputStream(), byteArrayOutputStream);
        InputConsumer inputConsumer2 = new InputConsumer(process.getErrorStream(), byteArrayOutputStream2);
        inputConsumer.start();
        inputConsumer2.start();
        int n = process.waitFor();
        inputConsumer.join();
        inputConsumer2.join();
        stringArray[0] = byteArrayOutputStream.toString();
        stringArray[1] = byteArrayOutputStream2.toString();
        return n;
    }

    private static class InputConsumer
    extends Thread {
        private InputStream in;
        private OutputStream out;
        private byte[] bytes = new byte[4096];

        public InputConsumer(InputStream inputStream) {
            this(inputStream, null);
        }

        public InputConsumer(InputStream inputStream, OutputStream outputStream) {
            this.in = inputStream;
            this.out = outputStream;
        }

        public void run() {
            while (true) {
                int n;
                try {
                    n = this.in.read(this.bytes);
                }
                catch (IOException iOException) {
                    n = -1;
                }
                if (n < 0) break;
                if (n <= 0 || this.out == null) continue;
                try {
                    this.out.write(this.bytes, 0, n);
                    this.out.flush();
                }
                catch (IOException iOException) {
                    this.out = null;
                }
            }
        }
    }
}

