/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.util;

import java.util.ArrayList;
import java.util.StringTokenizer;

public final class StringUtil {
    public static final String[] EMPTY_LIST = new String[0];

    public static int indexOf(String[] stringArray, String string) {
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static boolean contains(String[] stringArray, String string) {
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static boolean containsIgnoreCase(String[] stringArray, String string) {
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equalsIgnoreCase(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static String[] insertAt(String[] stringArray, String string, int n) {
        int n2;
        String[] stringArray2 = new String[stringArray.length + 1];
        if (n > 0) {
            System.arraycopy(stringArray, 0, stringArray2, 0, n);
        }
        if ((n2 = stringArray.length - n) > 0) {
            System.arraycopy(stringArray, n, stringArray2, n + 1, n2);
        }
        stringArray2[n] = string;
        return stringArray2;
    }

    public static String[] prepend(String[] stringArray, String string) {
        String[] stringArray2 = new String[stringArray.length + 1];
        stringArray2[0] = string;
        System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
        return stringArray2;
    }

    public static String[] append(String[] stringArray, String string) {
        String[] stringArray2 = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        stringArray2[stringArray.length] = string;
        return stringArray2;
    }

    public static String[] remove(String[] stringArray, String string) {
        int n = StringUtil.indexOf(stringArray, string);
        if (n < 0) {
            return stringArray;
        }
        return StringUtil.removeAt(stringArray, n);
    }

    public static String[] removeAt(String[] stringArray, int n) {
        int n2;
        int n3;
        String string = stringArray[n];
        String[] stringArray2 = new String[stringArray.length - 1];
        if (n > 0) {
            System.arraycopy(stringArray, 0, stringArray2, 0, n);
        }
        if ((n3 = stringArray.length - (n2 = n + 1)) > 0) {
            System.arraycopy(stringArray, n2, stringArray2, n, n3);
        }
        return stringArray2;
    }

    public static String protect(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\"');
        StringUtil.escape(string, stringBuffer);
        stringBuffer.append('\"');
        return stringBuffer.toString();
    }

    public static String escape(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringUtil.escape(string, stringBuffer);
        return stringBuffer.toString();
    }

    public static void escape(String string, StringBuffer stringBuffer) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '\b': {
                    stringBuffer.append('\\');
                    stringBuffer.append('b');
                    break;
                }
                case '\t': {
                    stringBuffer.append('\\');
                    stringBuffer.append('t');
                    break;
                }
                case '\n': {
                    stringBuffer.append('\\');
                    stringBuffer.append('n');
                    break;
                }
                case '\f': {
                    stringBuffer.append('\\');
                    stringBuffer.append('f');
                    break;
                }
                case '\r': {
                    stringBuffer.append('\\');
                    stringBuffer.append('r');
                    break;
                }
                case '\"': {
                    stringBuffer.append('\\');
                    stringBuffer.append('\"');
                    break;
                }
                case '\'': {
                    stringBuffer.append('\\');
                    stringBuffer.append('\'');
                    break;
                }
                case '\\': {
                    stringBuffer.append('\\');
                    stringBuffer.append('\\');
                    break;
                }
                default: {
                    if (c >= ' ' && c <= '~') {
                        stringBuffer.append(c);
                        break;
                    }
                    StringUtil.escape(c, stringBuffer);
                }
            }
            ++n2;
        }
    }

    public static String escape(char c) {
        StringBuffer stringBuffer = new StringBuffer();
        StringUtil.escape(c, stringBuffer);
        return stringBuffer.toString();
    }

    public static void escape(char c, StringBuffer stringBuffer) {
        stringBuffer.append("\\u");
        String string = Integer.toString(c, 16);
        int n = string.length();
        while (n < 4) {
            stringBuffer.append('0');
            ++n;
        }
        stringBuffer.append(string);
    }

    public static String unprotect(String string) {
        int n = string.length();
        if (n >= 2 && string.charAt(0) == '\"' && string.charAt(n - 1) == '\"') {
            return StringUtil.unescape(string, 1, n - 2);
        }
        return StringUtil.unescape(string, 0, n);
    }

    public static String unescape(String string) {
        return StringUtil.unescape(string, 0, string.length());
    }

    private static String unescape(String string, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = n + n2;
        int n4 = n;
        while (n4 < n3) {
            char c = string.charAt(n4);
            block1 : switch (c) {
                case '\\': {
                    if (n4 + 1 == n3) {
                        stringBuffer.append(c);
                        break;
                    }
                    switch (string.charAt(n4 + 1)) {
                        case 'b': {
                            stringBuffer.append('\b');
                            ++n4;
                            break block1;
                        }
                        case 't': {
                            stringBuffer.append('\t');
                            ++n4;
                            break block1;
                        }
                        case 'n': {
                            stringBuffer.append('\n');
                            ++n4;
                            break block1;
                        }
                        case 'f': {
                            stringBuffer.append('\f');
                            ++n4;
                            break block1;
                        }
                        case 'r': {
                            stringBuffer.append('\r');
                            ++n4;
                            break block1;
                        }
                        case '\"': {
                            stringBuffer.append('\"');
                            ++n4;
                            break block1;
                        }
                        case '\'': {
                            stringBuffer.append('\'');
                            ++n4;
                            break block1;
                        }
                        case '\\': {
                            stringBuffer.append('\\');
                            ++n4;
                            break block1;
                        }
                        case 'u': {
                            if (n4 + 5 >= n3) break;
                            int n5 = -1;
                            try {
                                n5 = Integer.parseInt(string.substring(n4 + 2, n4 + 6), 16);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            if (n5 < 0) break;
                            stringBuffer.append((char)n5);
                            n4 += 5;
                            break block1;
                        }
                    }
                    stringBuffer.append(c);
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n4;
        }
        return stringBuffer.toString();
    }

    public static String capitalize(String string) {
        int n = string.length();
        if (n == 0) {
            return string;
        }
        if (n == 1) {
            return string.toUpperCase();
        }
        return Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    public static String uncapitalize(String string) {
        int n = string.length();
        if (n == 0) {
            return string;
        }
        if (n == 1) {
            return string.toLowerCase();
        }
        return Character.toLowerCase(string.charAt(0)) + string.substring(1);
    }

    public static String[] split(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = stringTokenizer.nextToken();
            ++n;
        }
        return stringArray;
    }

    public static String[] split(String string, char c) {
        int n;
        int n2 = 0;
        int n3 = 0;
        while ((n3 = string.indexOf(c, n3)) >= 0) {
            ++n2;
            ++n3;
        }
        String[] stringArray = new String[++n2];
        n2 = 0;
        n3 = 0;
        while ((n = string.indexOf(c, n3)) >= 0) {
            stringArray[n2++] = n3 == n ? "" : string.substring(n3, n);
            n3 = n + 1;
        }
        stringArray[n2++] = string.substring(n3);
        return stringArray;
    }

    public static String join(String[] stringArray, char c) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = stringArray.length;
        if (n > 0) {
            stringBuffer.append(stringArray[0]);
            int n2 = 1;
            while (n2 < n) {
                stringBuffer.append(c);
                stringBuffer.append(stringArray[n2]);
                ++n2;
            }
        }
        return stringBuffer.toString();
    }

    public static String join(String[] stringArray, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = stringArray.length;
        if (n > 0) {
            stringBuffer.append(stringArray[0]);
            int n2 = 1;
            while (n2 < n) {
                stringBuffer.append(string);
                stringBuffer.append(stringArray[n2]);
                ++n2;
            }
        }
        return stringBuffer.toString();
    }

    public static String replaceAll(String string, String string2, String string3) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = string2.length();
        int n3 = 0;
        while ((n = string.indexOf(string2, n3)) >= 0) {
            if (n > n3) {
                stringBuffer.append(string.substring(n3, n));
            }
            stringBuffer.append(string3);
            n3 = n + n2;
        }
        if (n3 < string.length()) {
            stringBuffer.append(string.substring(n3));
        }
        return stringBuffer.toString();
    }

    public static String[] splitArguments(String string) {
        int n = string.length();
        ArrayList<String> arrayList = new ArrayList<String>();
        char c = '\u0000';
        StringBuffer stringBuffer = null;
        int n2 = 0;
        while (n2 < n) {
            char c2 = string.charAt(n2);
            if (Character.isWhitespace(c2)) {
                if (c != '\u0000') {
                    stringBuffer.append(c2);
                } else if (stringBuffer != null) {
                    arrayList.add(stringBuffer.toString());
                    stringBuffer = null;
                }
            } else if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
                switch (c2) {
                    case '\"': 
                    case '\'': {
                        c = c2;
                        break;
                    }
                    default: {
                        stringBuffer.append(c2);
                        break;
                    }
                }
            } else if (c2 == c) {
                int n3 = stringBuffer.length() - 1;
                if (n3 > 0 && stringBuffer.charAt(n3) == '\\') {
                    stringBuffer.setCharAt(n3, c);
                } else {
                    arrayList.add(stringBuffer.toString());
                    stringBuffer = null;
                    c = '\u0000';
                }
            } else {
                stringBuffer.append(c2);
            }
            ++n2;
        }
        if (stringBuffer != null) {
            arrayList.add(stringBuffer.toString());
        }
        String[] stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }

    public static String joinArguments(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            if (n > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(StringUtil.quoteArgument(stringArray[n]));
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String quoteArgument(String string) {
        boolean bl;
        int n = string.length();
        if (n == 0) {
            bl = true;
        } else {
            block0 : switch (string.charAt(0)) {
                case '\"': 
                case '\'': {
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                    int n2 = 0;
                    while (n2 < n) {
                        if (Character.isWhitespace(string.charAt(n2))) {
                            bl = true;
                            break block0;
                        }
                        ++n2;
                    }
                    break block0;
                }
            }
        }
        if (!bl) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\"');
        int n3 = 0;
        while (n3 < n) {
            char c = string.charAt(n3);
            if (c == '\"') {
                stringBuffer.append("\\\"");
            } else {
                stringBuffer.append(c);
            }
            ++n3;
        }
        stringBuffer.append('\"');
        return stringBuffer.toString();
    }

    public static String substituteVars(String string, String[] stringArray) {
        return StringUtil.substituteVars(string, stringArray, null, null);
    }

    public static String substituteVars(String string, char[] cArray, Object[] objectArray) {
        return StringUtil.substituteVars(string, null, cArray, objectArray);
    }

    public static String substituteVars(String string, String[] stringArray, char[] cArray, Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            char c = string.charAt(n3);
            block0 : switch (n) {
                case 1: {
                    int n4;
                    Object object;
                    switch (c) {
                        case '%': {
                            stringBuffer.append('%');
                            n = 0;
                            break block0;
                        }
                        case '{': {
                            n = 2;
                            break block0;
                        }
                        case '*': 
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            if (stringArray == null) {
                                stringBuffer.append('%');
                                stringBuffer.append(c);
                            } else if (c == '*') {
                                stringBuffer.append(StringUtil.joinArguments(stringArray));
                            } else if (c - 48 < stringArray.length) {
                                stringBuffer.append(stringArray[c - 48]);
                            }
                            n = 0;
                            break block0;
                        }
                    }
                    if (cArray == null) {
                        stringBuffer.append('%');
                        stringBuffer.append(c);
                    } else {
                        object = null;
                        n4 = 0;
                        while (n4 < cArray.length) {
                            if (c == cArray[n4]) {
                                object = objectArray[n4];
                                break;
                            }
                            ++n4;
                        }
                        if (object == null) {
                            stringBuffer.append('%');
                            stringBuffer.append(c);
                        } else {
                            stringBuffer.append(object.toString());
                        }
                    }
                    n = 0;
                    break;
                }
                case 2: {
                    switch (c) {
                        case '*': 
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            if (stringArray == null) {
                                stringBuffer.append("%{");
                                stringBuffer.append(c);
                                n = 0;
                                break block0;
                            }
                            if (c == '*') {
                                stringBuffer.append(StringUtil.joinArguments(stringArray));
                            } else if (c - 48 < stringArray.length) {
                                stringBuffer.append(stringArray[c - 48]);
                            }
                            n = 3;
                            break block0;
                        }
                    }
                    if (cArray == null) {
                        stringBuffer.append("%{");
                        stringBuffer.append(c);
                        n = 0;
                        break;
                    }
                    Object object = null;
                    int n4 = 0;
                    while (n4 < cArray.length) {
                        if (c == cArray[n4]) {
                            object = objectArray[n4];
                            break;
                        }
                        ++n4;
                    }
                    if (object == null) {
                        stringBuffer.append("%{");
                        stringBuffer.append(c);
                        n = 0;
                        break;
                    }
                    stringBuffer.append(object.toString());
                    n = 3;
                    break;
                }
                case 3: {
                    if (c != '}') {
                        stringBuffer.append(c);
                    }
                    n = 0;
                    break;
                }
                default: {
                    if (c == '%') {
                        n = 1;
                        break;
                    }
                    stringBuffer.append(c);
                }
            }
            ++n3;
        }
        switch (n) {
            case 1: {
                stringBuffer.append('%');
                break;
            }
            case 2: {
                stringBuffer.append("%{");
            }
        }
        return stringBuffer.toString();
    }
}

