/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.util;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;

public final class URIUtil {
    private static final int[] fromHexDigit = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15};
    private static final int LEAD2 = 2;
    private static final int LEAD3 = 3;
    private static final int LEAD4 = 4;
    private static final int LEAD2_FIRST = 192;
    private static final int LEAD3_FIRST = 224;
    private static final int LEAD4_FIRST = 240;
    private static final int LEAD4_END = 248;

    public static String joinQuotedComponents(String string, String string2, String string3, String string4, int n, String string5, String string6, String string7) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            stringBuffer.append(string);
            stringBuffer.append(':');
        }
        if (string4 != null) {
            stringBuffer.append("//");
            if (string2 != null) {
                stringBuffer.append(string2);
                if (string3 != null) {
                    stringBuffer.append(':');
                    stringBuffer.append(string3);
                }
                stringBuffer.append('@');
            }
            stringBuffer.append(string4);
            if (n >= 0) {
                stringBuffer.append(':');
                stringBuffer.append(n);
            }
        }
        if (string5 != null) {
            stringBuffer.append(string5);
        }
        if (string6 != null) {
            stringBuffer.append('?');
            stringBuffer.append(string6);
        }
        if (string7 != null) {
            stringBuffer.append('#');
            stringBuffer.append(string7);
        }
        return stringBuffer.toString();
    }

    public static String trimFragment(String string) {
        int n = string.lastIndexOf(35);
        if (n >= 0) {
            return string.substring(0, n);
        }
        return string;
    }

    public static String quoteUserInfo(String string) {
        URI uRI;
        try {
            uRI = new URI("http", string, "localhost", 80, "/x", null, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
            return string;
        }
        return uRI.getRawUserInfo();
    }

    public static String quotePath(String string) {
        URI uRI;
        try {
            uRI = new URI("http", null, "localhost", 80, "/x" + string, null, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
            return string;
        }
        return uRI.getRawPath().substring(2);
    }

    public static String quoteQuery(String string) {
        URI uRI;
        try {
            uRI = new URI("http", null, "localhost", 80, "/x", string, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
            return string;
        }
        return uRI.getRawQuery();
    }

    public static String quoteFragment(String string) {
        URI uRI;
        try {
            uRI = new URI("http", null, "localhost", 80, "/x", null, string);
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
            return string;
        }
        return uRI.getRawFragment();
    }

    public static final String unescape(String string) {
        byte[] byArray;
        if (string.indexOf(37) < 0) {
            return string;
        }
        try {
            byArray = string.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return string;
        }
        int n = byArray.length;
        byte[] byArray2 = new byte[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            int n4;
            int n5;
            int n6;
            int n7 = byArray[n3];
            if (n7 == 37 && n3 + 2 < n && (n6 = URIUtil.fromHexDigit(byArray[n3 + 1])) >= 0 && (n5 = URIUtil.fromHexDigit(byArray[n3 + 2])) >= 0) {
                n4 = n6 << 4 | n5;
                n3 += 2;
            } else {
                n4 = n7;
            }
            byArray2[n2++] = (byte)n4;
            ++n3;
        }
        try {
            return new String(byArray2, 0, n2, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return string;
        }
    }

    private static final int fromHexDigit(int n) {
        if (n < 48 || n > 102) {
            return -1;
        }
        return fromHexDigit[n - 48];
    }

    public static String encodeToUTF8(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c <= '\u007f') {
                stringBuffer.append(c);
            } else {
                byte[] byArray;
                try {
                    byArray = Character.toString(c).getBytes("UTF8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    unsupportedEncodingException.printStackTrace();
                    byArray = new byte[]{};
                }
                int n3 = 0;
                while (n3 < byArray.length) {
                    String string2 = Integer.toHexString(byArray[n3] & 0xFF);
                    stringBuffer.append('%');
                    if (string2.length() == 1) {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(string2);
                    ++n3;
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String decodeFromUTF8(String string) {
        if (string.indexOf(37) < 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = -1;
        int n3 = -1;
        int n4 = 0;
        byte by = 0;
        byte by2 = 0;
        int n5 = string.length();
        int n6 = 0;
        while (n6 < n5) {
            int n7;
            int n8;
            char c = string.charAt(n6);
            if (c == '%' && n6 + 2 < n5 && (n8 = URIUtil.fromHexDigit(string.charAt(n6 + 1))) >= 0 && (n7 = URIUtil.fromHexDigit(string.charAt(n6 + 2))) >= 0) {
                int n9 = n8 << 4 | n7;
                block0 : switch (n) {
                    case 0: {
                        if (n9 <= 127) {
                            stringBuffer.append('%');
                            stringBuffer.append(string.charAt(n6 + 1));
                            stringBuffer.append(string.charAt(n6 + 2));
                            break;
                        }
                        n2 = n9 >= 192 && n9 < 224 ? 2 : (n9 >= 224 && n9 < 240 ? 3 : (n9 >= 240 && n9 < 248 ? 4 : -1));
                        switch (n2) {
                            case 2: 
                            case 3: 
                            case 4: {
                                n3 = n6;
                                n4 = (byte)n9;
                                n = 1;
                                break block0;
                            }
                        }
                        stringBuffer.append('%');
                        stringBuffer.append(string.charAt(n6 + 1));
                        stringBuffer.append(string.charAt(n6 + 2));
                        break;
                    }
                    case 1: {
                        char c2;
                        by = (byte)n9;
                        if (n2 == 2) {
                            c2 = (char)((n4 & 0x1F) << 6 | by & 0x3F);
                            if (!Character.isSpaceChar(c2) && !Character.isISOControl(c2)) {
                                stringBuffer.append(c2);
                            } else {
                                stringBuffer.append(string.substring(n3, n3 + 6));
                            }
                            n = 0;
                            break;
                        }
                        n = 2;
                        break;
                    }
                    case 2: {
                        char c2;
                        by2 = (byte)n9;
                        if (n2 == 3) {
                            c2 = (char)((n4 & 0xF) << 12 | (by & 0x3F) << 6 | by2 & 0x3F);
                            if (!Character.isSpaceChar(c2) && !Character.isISOControl(c2)) {
                                stringBuffer.append(c2);
                            } else {
                                stringBuffer.append(string.substring(n3, n3 + 9));
                            }
                            n = 0;
                            break;
                        }
                        n = 3;
                        break;
                    }
                    case 3: {
                        stringBuffer.append(string.substring(n3, n3 + 12));
                        n = 0;
                        break;
                    }
                    default: {
                        throw new RuntimeException("invalid state = " + n);
                    }
                }
                n6 += 2;
            } else {
                switch (n) {
                    case 0: {
                        stringBuffer.append(c);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        stringBuffer.append('?');
                        n = 0;
                        break;
                    }
                    default: {
                        throw new RuntimeException("invalid state = " + n);
                    }
                }
            }
            ++n6;
        }
        return stringBuffer.toString();
    }
}

