/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.util;

import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.util.URIUtil;
import com.xmlmind.xmledit.util.URLPathUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;

public final class URLUtil {
    public static String getRawUserName(URL uRL) {
        String string = uRL.getUserInfo();
        if (string != null) {
            int n = string.indexOf(58);
            if (n < 0) {
                return string;
            }
            if (n > 0) {
                return string.substring(0, n);
            }
            return null;
        }
        return null;
    }

    public static String getRawUserPassword(URL uRL) {
        String string = uRL.getUserInfo();
        if (string != null) {
            int n = string.indexOf(58);
            if (n + 1 < string.length()) {
                return string.substring(n + 1);
            }
            return null;
        }
        return null;
    }

    public static String getRawDirName(URL uRL) {
        String string = uRL.getPath();
        return string == null ? null : URLPathUtil.dirName(string);
    }

    public static String getRawBaseName(URL uRL) {
        String string = uRL.getPath();
        return string == null ? null : URLPathUtil.baseName(string);
    }

    public static String getRawExtension(URL uRL) {
        String string = uRL.getPath();
        return string == null ? null : URLPathUtil.extension(string);
    }

    public static String getRelativeRawPath(URL uRL, URL uRL2) {
        return URLUtil.getRelativeRawPath(uRL, uRL2, true);
    }

    public static String getRelativeRawPath(URL uRL, URL uRL2, boolean bl) {
        if (bl && !URLUtil.getRoot(uRL, true).equals(URLUtil.getRoot(uRL2, true))) {
            return null;
        }
        return URLPathUtil.relativize(uRL.getPath(), uRL2.getPath());
    }

    public static URL getRoot(URL uRL) {
        return URLUtil.getRoot(uRL, false);
    }

    public static URL getRoot(URL uRL, boolean bl) {
        URL uRL2;
        int n = uRL.getPort();
        if (n < 0 && bl) {
            n = uRL.getDefaultPort();
        }
        String string = URIUtil.joinQuotedComponents(uRL.getProtocol(), uRL.getUserInfo(), null, uRL.getHost(), n, "/", null, null);
        try {
            uRL2 = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            uRL2 = null;
        }
        return uRL2;
    }

    public static URL getDirectory(URL uRL) {
        return URLUtil.getDirectory(uRL, false);
    }

    public static URL getDirectory(URL uRL, boolean bl) {
        URL uRL2;
        int n = uRL.getPort();
        if (n < 0 && bl) {
            n = uRL.getDefaultPort();
        }
        String string = URIUtil.joinQuotedComponents(uRL.getProtocol(), uRL.getUserInfo(), null, uRL.getHost(), n, URLPathUtil.dirName(uRL.getPath()), null, null);
        try {
            uRL2 = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            uRL2 = null;
        }
        return uRL2;
    }

    public static URL trimFragment(URL uRL) {
        if (uRL.getRef() == null) {
            return uRL;
        }
        String string = uRL.toExternalForm();
        string = string.substring(0, string.lastIndexOf(35));
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static String toLabel(URL uRL) {
        String string = FileUtil.urlToFileName(uRL);
        if (string != null) {
            return string;
        }
        return URLUtil.toDisplayForm(uRL);
    }

    public static String toDisplayForm(URL uRL) {
        URI uRI;
        URI uRI2 = URLUtil.urlToURI(uRL);
        if (uRI2 == null || uRI2.isOpaque()) {
            return uRL.toExternalForm();
        }
        String string = URLUtil.hideUserInfo(uRI2);
        try {
            uRI = new URI(uRI2.getScheme(), string, uRI2.getHost(), uRI2.getPort(), uRI2.getPath(), uRI2.getQuery(), uRI2.getFragment());
        }
        catch (URISyntaxException uRISyntaxException) {
            return uRL.toExternalForm();
        }
        return uRI.toString();
    }

    private static String hideUserInfo(URI uRI) {
        String string = uRI.getUserInfo();
        if (string != null) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            int n = string.length();
            int n2 = 0;
            while (n2 < n) {
                char c = string.charAt(n2);
                if (!bl) {
                    stringBuffer.append(c);
                    if (c == ':') {
                        bl = true;
                    }
                } else {
                    stringBuffer.append('*');
                }
                ++n2;
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    public static String toShortLabel(URL uRL, int n) {
        String string = FileUtil.urlToFileName(uRL);
        if (string != null) {
            return URLPathUtil.truncate(string, File.separatorChar, n);
        }
        return URLUtil.toShortDisplayForm(uRL, n);
    }

    public static String toShortDisplayForm(URL uRL, int n) {
        URI uRI;
        URI uRI2 = URLUtil.urlToURI(uRL);
        if (uRI2 == null || uRI2.isOpaque()) {
            return uRL.toExternalForm();
        }
        String string = URLUtil.hideUserInfo(uRI2);
        try {
            uRI = new URI(uRI2.getScheme(), string, uRI2.getHost(), uRI2.getPort(), "/", null, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            return uRL.toExternalForm();
        }
        int n2 = 2 * n / 3;
        if (n2 <= 0) {
            n2 = 10;
        }
        n2 = Math.max(n2, n - uRI.toString().length());
        String string2 = URLPathUtil.truncate(uRI2.getPath(), '/', n2);
        try {
            uRI = new URI(uRI2.getScheme(), string, uRI2.getHost(), uRI2.getPort(), string2, uRI2.getQuery(), uRI2.getFragment());
        }
        catch (URISyntaxException uRISyntaxException) {
            return uRL.toExternalForm();
        }
        return uRI.toString();
    }

    public static URI urlToURI(URL uRL) {
        URI uRI = null;
        try {
            uRI = new URI(uRL.toString());
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        if (uRI == null) {
            try {
                uRI = new URI(uRL.getProtocol(), uRL.getUserInfo(), uRL.getHost(), uRL.getPort(), uRL.getPath(), uRL.getQuery(), uRL.getRef());
            }
            catch (URISyntaxException uRISyntaxException) {
                return null;
            }
        }
        return uRI;
    }

    public static String getAnonymousFTPPassword() {
        String string;
        String string2 = URLUtil.getSystemUserName();
        if (string2 == null) {
            string2 = "xxe";
        }
        if ((string = URLUtil.getLocalHostName()) != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string2);
            stringBuffer.append('@');
            stringBuffer.append(string);
            return stringBuffer.toString();
        }
        return string2;
    }

    public static String getSystemUserName() {
        return System.getProperty("user.name");
    }

    public static String getLocalHostName() {
        String string;
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            string = null;
        }
        return string;
    }

    public static boolean exists(URL uRL) {
        try {
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setUseCaches(false);
            uRLConnection.setIfModifiedSince(0L);
            InputStream inputStream = uRLConnection.getInputStream();
            inputStream.close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

