/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.view;

import com.xmlmind.xmledit.doc.Attribute;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.gadget.PaintUtil;
import com.xmlmind.xmledit.view.ElementView;
import com.xmlmind.xmledit.view.ElementViewPart;
import com.xmlmind.xmledit.view.NodeView;
import com.xmlmind.xmledit.view.Outline;
import com.xmlmind.xmledit.view.TreeViewFactory;
import com.xmlmind.xmledit.view.ViewSettings;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;

public class AttributeView
extends Gadget
implements ElementViewPart {
    private Element element;
    private Settings settings;
    private static AttributeCompare attributeCompare = new AttributeCompare();

    public AttributeView(Element element, Settings settings) {
        this.element = element;
        this.settings = settings;
    }

    public NodeView getView() {
        return this.getElementView();
    }

    public ElementView getElementView() {
        return (ElementView)((Object)this.parent);
    }

    public void layout(int n, int n2, boolean bl) {
        this.layoutContent();
        this.width = TreeViewFactory.Settings.collapseBitmapWidth + 5 + this.width + 2 * this.settings.margin;
        if (Outline.hasOutline(this.settings)) {
            Dimension dimension = Outline.computeSize(this, this.settings, this.element);
            this.width = Math.max(dimension.width, this.width);
            this.height = dimension.height + this.height + 2 * this.settings.margin;
        } else {
            this.height = Math.max(TreeViewFactory.Settings.collapseBitmapHeight / 2, this.settings.margin) + this.height + this.settings.margin;
        }
        if (n > 0 && this.width > n) {
            this.width = n;
        }
    }

    private void layoutContent() {
        int n = this.element.getAttributeCount();
        if (n == 0) {
            this.height = 1;
            this.width = 1;
            return;
        }
        FontMetrics fontMetrics = this.getFontMetrics(this.settings.font);
        int n2 = fontMetrics.getAscent() + fontMetrics.getDescent();
        int n3 = 0;
        int n4 = 0;
        Enumeration enumeration = this.element.getAttributes();
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            int n5 = fontMetrics.stringWidth(attribute.name.format(true, this.element));
            if (n5 > n3) {
                n3 = n5;
            }
            if ((n5 = fontMetrics.stringWidth(AttributeView.truncate(attribute.value))) <= n4) continue;
            n4 = n5;
        }
        this.width = 1 + this.settings.pad + n3 + this.settings.pad + 1 + this.settings.pad + n4 + this.settings.pad + 1;
        this.height = 1 + n * (this.settings.pad + n2 + this.settings.pad + 1);
    }

    private static final String truncate(String string) {
        if (string.length() <= 1024) {
            return string;
        }
        return string.substring(0, 1020) + " ...";
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        if (this.settings.backgroundColor != null) {
            graphics.setColor(this.settings.backgroundColor);
            graphics.fillRect(0, 0, this.width, this.height);
        }
        int n3 = TreeViewFactory.Settings.collapseBitmapWidth + 5 + this.settings.margin;
        if (Outline.hasOutline(this.settings)) {
            n2 = Outline.paintOutline(this, this.settings, this.element, graphics);
            n = n2 + this.settings.margin;
        } else {
            n2 = Math.max(TreeViewFactory.Settings.collapseBitmapHeight / 2, this.settings.margin);
            Outline.paintArc(this, this.settings, this.element, 2 * n2, graphics);
            n = n2;
        }
        n2 = this.element.getAttributeCount();
        if (n2 == 0) {
            return;
        }
        this.paintContent(graphics, n2, n3, n);
    }

    private void paintContent(Graphics graphics, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6 = this.settings.pad;
        PaintUtil.configureTextRendering(graphics);
        FontMetrics fontMetrics = graphics.getFontMetrics(this.settings.font);
        int n7 = fontMetrics.getAscent();
        int n8 = n7 + fontMetrics.getDescent();
        int n9 = 1 + n6 + n8 + n6;
        int n10 = 0;
        int n11 = 0;
        String[][] stringArrayArray = new String[n][];
        int n12 = 0;
        Enumeration enumeration = this.element.getAttributes();
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            String[] stringArray = new String[]{attribute.name.format(true, this.element), AttributeView.truncate(attribute.value)};
            stringArrayArray[n12++] = stringArray;
            n5 = fontMetrics.stringWidth(stringArray[0]);
            if (n5 > n10) {
                n10 = n5;
            }
            if ((n5 = fontMetrics.stringWidth(stringArray[1])) <= n11) continue;
            n11 = n5;
        }
        if (n > 1) {
            Arrays.sort(stringArrayArray, 0, n, attributeCompare);
        }
        int n13 = 1 + n6 + n10 + n6 + 1 + n6 + n11 + n6 + 1;
        int n14 = 1 + n * (n6 + n8 + n6 + 1);
        if (n2 + n13 + this.settings.margin > this.width) {
            int n15;
            n13 = this.width - n2 - this.settings.margin;
            if (n13 <= 0) {
                n13 = 1;
            }
            if (n13 < (n15 = 1 + n6 + n10 + n6 + 1 + n6 + 1 + n6 + 1) && (n10 = n13 - 4 * n6 - 4) <= 0) {
                n10 = 1;
            }
        }
        if (this.settings.contentBackgroundColor != null) {
            graphics.setColor(this.settings.contentBackgroundColor);
            graphics.fillRect(n2, n3, n13, n14);
        }
        if (this.settings.borderColor != null) {
            graphics.setColor(this.settings.borderColor);
            graphics.drawRect(n2, n3, n13 - 1, n14 - 1);
            int n16 = n2 + n13 - 1;
            n4 = n3 + n9;
            n12 = 0;
            while (n12 < n) {
                graphics.drawLine(n2, n4, n16, n4);
                n4 += n9;
                ++n12;
            }
            n16 = n2 + 1 + n6 + n10 + n6 + 1;
            graphics.drawLine(n16, n3, n16, n3 + n14 - 1);
        }
        Graphics graphics2 = graphics.create(n2 + 1 + n6, n3 + 1 + n6, n10, n14 - 2 - 2 * n6);
        graphics2.setColor(this.settings.textColor);
        n4 = n7;
        n12 = 0;
        while (n12 < n) {
            graphics2.drawString(stringArrayArray[n12][0], 0, n4);
            n4 += n9;
            ++n12;
        }
        graphics2.dispose();
        n5 = 1 + n6 + n10 + n6 + 1 + n6;
        graphics2 = graphics.create(n2 + n5, n3 + 1 + n6, n13 - n5 - n6, n14 - 2 - 2 * n6);
        graphics2.setColor(this.settings.textColor);
        n4 = n7;
        n12 = 0;
        while (n12 < n) {
            graphics2.drawString(stringArrayArray[n12][1], 0, n4);
            n4 += n9;
            ++n12;
        }
        graphics2.dispose();
    }

    private static class AttributeCompare
    implements Comparator {
        private AttributeCompare() {
        }

        public int compare(Object object, Object object2) {
            return ((String[])object)[0].compareTo(((String[])object2)[0]);
        }
    }

    public static class Settings
    extends ViewSettings {
        public int margin;
        public Color borderColor;
        public int pad;
        public Color contentBackgroundColor;

        public Settings() {
            this.backgroundColor = null;
            this.textColor = Color.black;
            this.arcColor = Color.gray;
            this.font = new Font("SansSerif", 0, 10);
            this.icon = null;
            this.label = null;
            this.autoLabel = false;
            this.margin = 2;
            this.borderColor = Color.blue;
            this.pad = 1;
            this.contentBackgroundColor = new Color(192, 192, 255);
        }
    }
}

