/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.view;

import com.xmlmind.xmledit.edit.Mark;
import com.xmlmind.xmledit.edit.NodeMark;
import com.xmlmind.xmledit.edit.TextLocation;
import com.xmlmind.xmledit.view.DocumentView;
import com.xmlmind.xmledit.view.Highlight;
import com.xmlmind.xmledit.view.HighlightFactory;
import com.xmlmind.xmledit.view.HighlightSettings;
import com.xmlmind.xmledit.view.NodeHighlight;
import com.xmlmind.xmledit.view.TextHighlight;
import com.xmlmind.xmledit.view.TextLocationHighlight;
import java.awt.Color;
import java.util.Enumeration;
import java.util.Hashtable;

public class BasicHighlightFactory
extends HighlightFactory {
    protected Settings settings = new Settings();

    public BasicHighlightFactory(DocumentView documentView) {
        super(documentView);
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
        this.applySettings();
    }

    public void applySettings() {
        this.docView.repaint();
    }

    public Settings getSettings() {
        return this.settings;
    }

    public Highlight createHighlight(Mark mark) {
        Object object = mark.getId();
        if (object == "DOT") {
            return new TextLocationHighlight(this.docView, (TextLocation)mark, this.settings.dotSettings);
        }
        if (object == "MARK") {
            TextLocation textLocation = mark.getManager().getDot();
            if (textLocation == null) {
                return null;
            }
            return new TextHighlight(this.docView, (TextLocation)mark, textLocation, this.settings.textSelectionSettings);
        }
        if (object == "SELECTED") {
            return new NodeHighlight(this.docView, (NodeMark)mark, null, this.settings.nodeSelectionSettings);
        }
        if (object == "SELECTED2") {
            NodeMark nodeMark = mark.getManager().getSelected();
            if (nodeMark == null) {
                return null;
            }
            return new NodeHighlight(this.docView, nodeMark, (NodeMark)mark, this.settings.nodeSelectionSettings);
        }
        if (object instanceof String) {
            String string = (String)object;
            if (string.startsWith("bookmark.")) {
                if (mark.getType() != 1) {
                    return null;
                }
                return new TextLocationHighlight(this.docView, (TextLocation)mark, this.findBookmarkSettings(mark));
            }
            if (string.startsWith("highlight.")) {
                String string2 = string.length() > 10 ? string.substring(10) : "";
                Mark mark2 = mark.getManager().get("highlight2." + string2);
                int n = mark.getType();
                if (mark2 != null && mark2.getType() != n) {
                    return null;
                }
                switch (n) {
                    case 1: {
                        if (mark2 == null) {
                            return null;
                        }
                        return new TextHighlight(this.docView, (TextLocation)mark, (TextLocation)mark2, this.findTextHighlightSettings(mark));
                    }
                    case 0: {
                        return new NodeHighlight(this.docView, (NodeMark)mark, (NodeMark)mark2, this.findNodeHighlightSettings(mark));
                    }
                }
                return null;
            }
            if (string.startsWith("highlight2.")) {
                String string3 = string.length() > 11 ? string.substring(11) : "";
                Mark mark3 = mark.getManager().get("highlight." + string3);
                if (mark3 == null) {
                    return null;
                }
                int n = mark.getType();
                if (mark3.getType() != n) {
                    return null;
                }
                switch (n) {
                    case 1: {
                        return new TextHighlight(this.docView, (TextLocation)mark3, (TextLocation)mark, this.findTextHighlightSettings(mark));
                    }
                    case 0: {
                        return new NodeHighlight(this.docView, (NodeMark)mark3, (NodeMark)mark, this.findNodeHighlightSettings(mark));
                    }
                }
                return null;
            }
            return null;
        }
        return null;
    }

    private TextLocationHighlight.Settings findBookmarkSettings(Mark mark) {
        String string = BasicHighlightFactory.getClassValue(mark);
        if (string != null) {
            HighlightSettings highlightSettings = this.settings.get(string);
            if (highlightSettings == null || !(highlightSettings instanceof TextLocationHighlight.Settings)) {
                return this.settings.bookmarkSettings;
            }
            return (TextLocationHighlight.Settings)highlightSettings;
        }
        return this.settings.bookmarkSettings;
    }

    private TextHighlight.Settings findTextHighlightSettings(Mark mark) {
        String string = BasicHighlightFactory.getClassValue(mark);
        if (string != null) {
            HighlightSettings highlightSettings = this.settings.get(string);
            if (highlightSettings == null || !(highlightSettings instanceof TextHighlight.Settings)) {
                return this.settings.textHighlightSettings;
            }
            return (TextHighlight.Settings)highlightSettings;
        }
        return this.settings.textHighlightSettings;
    }

    private NodeHighlight.Settings findNodeHighlightSettings(Mark mark) {
        String string = BasicHighlightFactory.getClassValue(mark);
        if (string != null) {
            HighlightSettings highlightSettings = this.settings.get(string);
            if (highlightSettings == null || !(highlightSettings instanceof NodeHighlight.Settings)) {
                return this.settings.nodeHighlightSettings;
            }
            return (NodeHighlight.Settings)highlightSettings;
        }
        return this.settings.nodeHighlightSettings;
    }

    private static final String getClassValue(Mark mark) {
        Object object = mark.getProperty("class");
        if (object == null || !(object instanceof String)) {
            return null;
        }
        return (String)object;
    }

    public static class Settings {
        public TextLocationHighlight.Settings dotSettings;
        public TextHighlight.Settings textSelectionSettings;
        public NodeHighlight.Settings nodeSelectionSettings;
        public TextLocationHighlight.Settings bookmarkSettings;
        public TextHighlight.Settings textHighlightSettings;
        public NodeHighlight.Settings nodeHighlightSettings;
        private Hashtable highlightSettingsMap = new Hashtable();

        public Settings() {
            this.dotSettings = new TextLocationHighlight.Settings();
            this.dotSettings.color = Color.red;
            this.dotSettings.blinkDelay = 500;
            this.dotSettings.blinkColor = Color.black;
            this.dotSettings.blinkWhenEditable = true;
            this.textSelectionSettings = new TextHighlight.Settings();
            this.textSelectionSettings.color = Color.pink;
            this.nodeSelectionSettings = new NodeHighlight.Settings();
            this.nodeSelectionSettings.color = Color.red;
            this.bookmarkSettings = new TextLocationHighlight.Settings();
            this.bookmarkSettings.color = new Color(96, 96, 152);
            this.textHighlightSettings = new TextHighlight.Settings();
            this.textHighlightSettings.color = new Color(200, 200, 248);
            this.nodeHighlightSettings = new NodeHighlight.Settings();
            this.nodeHighlightSettings.color = new Color(96, 96, 152);
        }

        public void put(String string, HighlightSettings highlightSettings) {
            this.highlightSettingsMap.put(string, highlightSettings);
        }

        public HighlightSettings remove(String string) {
            HighlightSettingsEntry highlightSettingsEntry = (HighlightSettingsEntry)this.highlightSettingsMap.remove(string);
            return highlightSettingsEntry == null ? null : highlightSettingsEntry.settings;
        }

        public HighlightSettings get(String string) {
            HighlightSettingsEntry highlightSettingsEntry = (HighlightSettingsEntry)this.highlightSettingsMap.get(string);
            return highlightSettingsEntry == null ? null : highlightSettingsEntry.settings;
        }

        public Enumeration enumerate() {
            return this.highlightSettingsMap.elements();
        }
    }

    public static final class HighlightSettingsEntry {
        public String classValue;
        public HighlightSettings settings;

        public HighlightSettingsEntry(String string, HighlightSettings highlightSettings) {
            this.classValue = string;
            this.settings = highlightSettings;
        }
    }
}

