/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.view;

import com.xmlmind.xmledit.edit.Commands;
import com.xmlmind.xmledit.gadget.Binding;
import com.xmlmind.xmledit.gadget.BindingBase;
import com.xmlmind.xmledit.gadget.Command;
import com.xmlmind.xmledit.gadget.MenuItemSpec;
import com.xmlmind.xmledit.gadget.MenuSpec;
import com.xmlmind.xmledit.gadget.UserInput;
import java.util.HashMap;

public final class BindingSpec
extends BindingBase {
    private String commandName;
    private String commandParameter;
    private Menu menu;

    public BindingSpec(UserInput userInput, String string, String string2) {
        this(new UserInput[]{userInput}, string, string2);
    }

    public BindingSpec(UserInput userInput, UserInput userInput2, String string, String string2) {
        this(new UserInput[]{userInput, userInput2}, string, string2);
    }

    public BindingSpec(UserInput userInput, UserInput userInput2, UserInput userInput3, String string, String string2) {
        this(new UserInput[]{userInput, userInput2, userInput3}, string, string2);
    }

    public BindingSpec(UserInput[] userInputArray, String string, String string2) {
        super(userInputArray);
        this.commandName = string;
        this.commandParameter = string2;
        this.check();
    }

    public BindingSpec(UserInput userInput, Menu menu) {
        super(new UserInput[]{userInput});
        this.menu = menu;
        this.check();
    }

    public BindingSpec(String string, String string2, String string3) {
        super(string);
        this.commandName = string2;
        this.commandParameter = string3;
        this.check();
    }

    protected void check() throws IllegalArgumentException {
        super.check();
        if (this.commandName == null && this.menu == null) {
            throw new IllegalArgumentException("one of commandName or menu must be specified");
        }
        if (this.userInputs != null && this.userInputs[0].getMouseEventId() == 508 && this.menu != null) {
            throw new IllegalArgumentException("cannot bind a menu to a keyboard input");
        }
    }

    public String getCommandName() {
        return this.commandName;
    }

    public String getCommandParameter() {
        return this.commandParameter;
    }

    public Menu getMenu() {
        return this.menu;
    }

    public Binding toBinding() {
        if (this.menu != null) {
            MenuItemSpec[] menuItemSpecArray = BindingSpec.toMenuItemSpecs(this.menu.items);
            if (menuItemSpecArray == null) {
                return null;
            }
            return new Binding(this.userInputs[0], new MenuSpec(this.menu.label, menuItemSpecArray));
        }
        Command command = Commands.getCommand(this.commandName);
        if (command == null) {
            return null;
        }
        if (this.userInputs != null) {
            return new Binding(this.userInputs, command, this.commandParameter);
        }
        return new Binding(this.appEventName, command, this.commandParameter);
    }

    private static final MenuItemSpec[] toMenuItemSpecs(MenuItem[] menuItemArray) {
        MenuItemSpec[] menuItemSpecArray = new MenuItemSpec[menuItemArray.length];
        int n = 0;
        while (n < menuItemArray.length) {
            Object object;
            MenuItem menuItem = menuItemArray[n];
            if (menuItem instanceof Menu) {
                object = (Menu)menuItem;
                MenuItemSpec[] menuItemSpecArray2 = BindingSpec.toMenuItemSpecs(((Menu)object).items);
                menuItemSpecArray[n] = new MenuSpec(((Menu)object).label, menuItemSpecArray2);
            } else if (menuItem.label == null) {
                menuItemSpecArray[n] = new MenuItemSpec();
            } else {
                object = Commands.getCommand(menuItem.commandName);
                if (object == null) {
                    return null;
                }
                menuItemSpecArray[n] = new MenuItemSpec(menuItem.label, null, (Command)object, menuItem.commandParameter);
            }
            ++n;
        }
        return menuItemSpecArray;
    }

    public static BindingSpec[] merge(BindingSpec[] bindingSpecArray, BindingSpec[] bindingSpecArray2) {
        BindingSpec[] bindingSpecArray3;
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        int n = 0;
        while (n < bindingSpecArray.length) {
            BindingSpec bindingSpec = bindingSpecArray[n];
            hashMap.put(bindingSpec, bindingSpec);
            ++n;
        }
        int n2 = 0;
        while (n2 < bindingSpecArray2.length) {
            bindingSpecArray3 = bindingSpecArray2[n2];
            hashMap.put(bindingSpecArray3, bindingSpecArray3);
            ++n2;
        }
        bindingSpecArray3 = new BindingSpec[hashMap.size()];
        hashMap.values().toArray(bindingSpecArray3);
        return bindingSpecArray3;
    }

    public static Binding[] toBindings(BindingSpec[] bindingSpecArray) throws IllegalArgumentException {
        Binding[] bindingArray = new Binding[bindingSpecArray.length];
        int n = 0;
        while (n < bindingSpecArray.length) {
            BindingSpec bindingSpec = bindingSpecArray[n];
            bindingArray[n] = bindingSpec.toBinding();
            if (bindingArray[n] == null) {
                throw new IllegalArgumentException("command triggered by '" + bindingSpec.triggerToString() + "' is unknown");
            }
            ++n;
        }
        return bindingArray;
    }

    public static class Menu
    extends MenuItem {
        public MenuItem[] items;

        public Menu(String string, MenuItem[] menuItemArray) {
            super(string, null, null);
            this.items = menuItemArray;
        }

        public Menu copy() {
            return (Menu)this.doCopy();
        }

        protected MenuItem doCopy() {
            Menu menu;
            try {
                menu = (Menu)this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
            menu.items = new MenuItem[this.items.length];
            int n = 0;
            while (n < this.items.length) {
                menu.items[n] = this.items[n].doCopy();
                ++n;
            }
            return menu;
        }
    }

    public static class MenuItem
    implements Cloneable {
        public String label;
        public String commandName;
        public String commandParameter;

        public MenuItem() {
            this(null, null, null);
        }

        public MenuItem(String string, String string2, String string3) {
            this.label = string;
            this.commandName = string2;
            this.commandParameter = string3;
        }

        protected MenuItem doCopy() {
            try {
                return (MenuItem)this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }
    }
}

