/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.view;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.TextNode;
import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.gadget.PaintUtil;
import com.xmlmind.xmledit.guiutil.Bitmap;
import com.xmlmind.xmledit.view.GadgetList;
import com.xmlmind.xmledit.view.NodeView;
import com.xmlmind.xmledit.view.Outline;
import com.xmlmind.xmledit.view.RectangleList;
import com.xmlmind.xmledit.view.TextNodeView;
import com.xmlmind.xmledit.view.TextNodeViewText;
import com.xmlmind.xmledit.view.TreeViewFactory;
import com.xmlmind.xmledit.view.ViewSettings;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;

public class CharView
extends Gadget
implements TextNodeView,
TextNodeViewText {
    private TextNode text;
    private Settings settings;
    private int[] lineOffsets = new int[0];
    private short textLeft;
    private short textTop;

    public CharView(TextNode textNode, Settings settings) {
        this.text = textNode;
        this.settings = settings;
    }

    public Node getModel() {
        return this.text;
    }

    public void getGadgets(GadgetList gadgetList, int n) {
        gadgetList.appendGadget(this);
    }

    public void detachingFromModel(Document document, int n) {
    }

    public TextNode getTextNode() {
        return this.text;
    }

    public void getTextGadgets(GadgetList gadgetList, int n) {
        gadgetList.appendGadget(this);
    }

    public NodeView getView() {
        return this;
    }

    public TextNodeView getTextNodeView() {
        return this;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void layout(int n, int n2, boolean bl) {
        int n3 = this.settings.margin + 1 + this.settings.padding;
        this.textLeft = (short)(TreeViewFactory.Settings.collapseBitmapWidth + 5 + n3);
        if (Outline.hasOutline(this.settings)) {
            Dimension dimension = Outline.computeSize(this, this.settings, this.text);
            this.textTop = (short)(dimension.height + n3);
            if (n > 0 && dimension.width > n) {
                n = dimension.width;
            }
        } else {
            this.textTop = (short)(Math.max(TreeViewFactory.Settings.collapseBitmapHeight / 2, this.settings.margin) + 1 + this.settings.padding);
        }
        this.relayoutLines(n, 0);
    }

    private int relayoutLines(int n, int n2) {
        int n3;
        int n4;
        int[] nArray = new int[10];
        int n5 = 0;
        if (this.lineOffsets.length <= 1) {
            n2 = 0;
        } else {
            n4 = 1;
            while (true) {
                if (n4 == this.lineOffsets.length || this.lineOffsets[n4] > n2) {
                    n2 = this.lineOffsets[n4 - 1];
                    break;
                }
                nArray = CharView.addLineOffset(nArray, n5, this.lineOffsets[n4 - 1]);
                ++n5;
                ++n4;
            }
        }
        n4 = n5;
        char[] cArray = this.text.getTextChars();
        int n6 = this.text.getTextLength();
        int n7 = this.settings.padding + 1 + this.settings.margin;
        FontMetrics fontMetrics = this.getFontMetrics(this.settings.font);
        int n8 = fontMetrics.charWidth('x');
        int n9 = this.settings.wrappedIcon.getWidth(null);
        int n10 = n3 = n > 0 ? n - this.textLeft - n7 - n9 : Integer.MAX_VALUE;
        if (n3 <= 0) {
            n3 = 1;
        }
        int n11 = n2;
        int n12 = 0;
        int n13 = 0;
        int n14 = n2;
        while (n14 < n6) {
            char c = cArray[n14];
            if (c == '\n') {
                nArray = CharView.addLineOffset(nArray, n5, n11);
                ++n5;
                if (n12 > n13) {
                    n13 = n12;
                }
                n11 = n14 + 1;
                n12 = 0;
            } else if (n12 + n8 > n3 && n12 > 0) {
                nArray = CharView.addLineOffset(nArray, n5, n11);
                ++n5;
                if (n12 > n13) {
                    n13 = n12;
                }
                n11 = n14;
                n12 = n8;
            } else {
                n12 += n8;
            }
            ++n14;
        }
        nArray = CharView.addLineOffset(nArray, n5, n11);
        ++n5;
        if (n12 > n13) {
            n13 = n12;
        }
        this.lineOffsets = new int[n5];
        System.arraycopy(nArray, 0, this.lineOffsets, 0, n5);
        this.width = this.textLeft + n13 + n9 + n7;
        this.height = this.textTop + (fontMetrics.getAscent() + fontMetrics.getDescent()) + (n5 - 1) * fontMetrics.getHeight() + n7;
        if (n > 0 && this.width < n) {
            this.width = n;
        }
        return n4;
    }

    private static final int[] addLineOffset(int[] nArray, int n, int n2) {
        if (n + 1 > nArray.length) {
            int[] nArray2 = new int[Math.max(n + 1, 2 * nArray.length)];
            System.arraycopy(nArray, 0, nArray2, 0, n);
            nArray = nArray2;
        }
        nArray[n] = n2;
        return nArray;
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        if (this.settings.backgroundColor != null) {
            graphics.setColor(this.settings.backgroundColor);
            graphics.fillRect(0, 0, this.width, this.height);
        }
        int n3 = TreeViewFactory.Settings.collapseBitmapWidth + 5 + this.settings.margin;
        if (Outline.hasOutline(this.settings)) {
            n2 = Outline.paintOutline(this, this.settings, this.text, graphics);
            n = n2 + this.settings.margin;
        } else {
            n2 = Math.max(TreeViewFactory.Settings.collapseBitmapHeight / 2, this.settings.margin);
            Outline.paintArc(this, this.settings, this.text, 2 * n2, graphics);
            n = n2;
        }
        n2 = this.width - n3 - this.settings.margin;
        int n4 = this.height - n - this.settings.margin;
        if (this.settings.contentBackgroundColor != null) {
            graphics.setColor(this.settings.contentBackgroundColor);
            graphics.fillRect(n3, n, n2, n4);
        }
        if (this.settings.borderColor != null) {
            graphics.setColor(this.settings.borderColor);
            graphics.drawRect(n3, n, n2 - 1, n4 - 1);
        }
    }

    public void paintText(Graphics graphics) {
        int n = this.lineOffsets.length;
        if (n == 0) {
            return;
        }
        char[] cArray = this.text.getTextChars();
        int n2 = this.text.getTextLength();
        PaintUtil.configureTextRendering(graphics);
        graphics.setColor(this.settings.textColor);
        graphics.setFont(this.settings.font);
        FontMetrics fontMetrics = graphics.getFontMetrics(this.settings.font);
        int n3 = fontMetrics.getHeight();
        Rectangle rectangle = graphics.getClipBounds();
        int n4 = rectangle.y - this.textTop + fontMetrics.getLeading();
        int n5 = n4 / n3;
        if (n5 < 0) {
            n5 = 0;
        } else if (n5 >= n) {
            n5 = n - 1;
        }
        int n6 = (n4 += rectangle.height - 1) / n3;
        if (n6 < 0) {
            n6 = 0;
        } else if (n6 >= n) {
            n6 = n - 1;
        }
        Image image = this.settings.wrappedIcon;
        int n7 = image.getHeight(null);
        int n8 = this.settings.padding + 1 + this.settings.margin;
        int n9 = this.width - n8 - image.getWidth(null);
        int n10 = this.textTop + fontMetrics.getAscent() + n5 * n3;
        int n11 = n5;
        while (n11 <= n6) {
            boolean bl;
            int n12;
            int n13 = this.lineOffsets[n11];
            if (n13 >= n2) break;
            boolean bl2 = n11 == n - 1;
            int n14 = bl2 ? n2 : this.lineOffsets[n11 + 1];
            if (cArray[n14 - 1] == '\n') {
                n12 = n14 - n13 - 1;
                bl = false;
            } else {
                n12 = n14 - n13;
                boolean bl3 = bl = !bl2;
            }
            if (n12 > 0) {
                PaintUtil.drawChars2(graphics, fontMetrics, cArray, n13, n12, this.textLeft, n10);
            }
            if (bl) {
                graphics.drawImage(image, n9, n10 - n7, null);
            }
            n10 += n3;
            ++n11;
        }
    }

    public int gadgetToModel(int n, int n2) {
        char[] cArray = this.text.getTextChars();
        int n3 = this.text.getTextLength();
        int n4 = this.lineOffsets.length;
        FontMetrics fontMetrics = this.getFontMetrics(this.settings.font);
        int n5 = fontMetrics.charWidth('x');
        int n6 = fontMetrics.getHeight();
        int n7 = (n2 = n2 - this.textTop + fontMetrics.getLeading()) / n6;
        if (n7 < 0) {
            n7 = 0;
        } else if (n7 >= n4) {
            n7 = n4 - 1;
        }
        n -= this.textLeft;
        int n8 = this.lineOffsets[n7];
        if (n8 >= n3) {
            return n3;
        }
        if (n <= 0) {
            return n8;
        }
        int n9 = n7 == n4 - 1 ? n3 : this.lineOffsets[n7 + 1];
        if (cArray[n9 - 1] == '\n') {
            --n9;
        }
        if (n >= n5 * (n9 - n8)) {
            return n9;
        }
        return n8 + (int)Math.rint((double)n / (double)n5);
    }

    public int modelToGadget(int n, int n2, RectangleList rectangleList) {
        int n3;
        int n4;
        char[] cArray = this.text.getTextChars();
        int n5 = this.text.getTextLength();
        int n6 = this.lineOffsets.length;
        FontMetrics fontMetrics = this.getFontMetrics(this.settings.font);
        int n7 = fontMetrics.charWidth('x');
        int n8 = fontMetrics.getHeight();
        int n9 = fontMetrics.getAscent() + fontMetrics.getDescent();
        if (n < 0) {
            n = 0;
        } else if (n > n5) {
            n = n5;
        }
        if (n2 < 0) {
            n2 = 0;
        } else if (n + n2 > n5) {
            n2 = n5 - n;
        }
        int n10 = 0;
        while (n10 < n6) {
            n4 = this.lineOffsets[n10];
            if (n4 >= n5) {
                rectangleList.appendRectangle(this.textLeft, this.textTop + n10 * n8, 0, n9);
                return 1;
            }
            n3 = n10 == n6 - 1 ? n5 : this.lineOffsets[n10 + 1];
            if (cArray[n3 - 1] == '\n') {
                --n3;
            }
            if (n <= n3) {
                if (n2 != 0) break;
                int n11 = this.textLeft + n7 * (n - n4);
                rectangleList.appendRectangle(n11, this.textTop + n10 * n8, 0, n9);
                return 1;
            }
            ++n10;
        }
        n4 = 0;
        n3 = n6 > 0 && this.lineOffsets[n6 - 1] >= n5 && n + n2 >= n5 ? 1 : 0;
        while (n10 < n6) {
            int n12;
            int n13 = this.lineOffsets[n10];
            int n14 = n10 == n6 - 1 ? (n12 = n5) : (n12 = this.lineOffsets[n10 + 1]);
            if (cArray[n14 - 1] == '\n') {
                --n14;
            }
            int n15 = n > n13 ? this.textLeft + n7 * (n - n13) : this.textLeft;
            int n16 = n15 + n7 * (n + n2 <= n14 ? n2 : n14 - n);
            rectangleList.appendRectangle(n15, this.textTop + n10 * n8, n16 - n15, n9);
            ++n4;
            int n17 = n;
            n = n12;
            if ((n2 -= n12 - n17) <= 0) break;
            ++n10;
        }
        if (n3 != 0) {
            rectangleList.appendRectangle(this.textLeft, this.textTop + (n6 - 1) * n8, 0, n9);
            ++n4;
        }
        return n4;
    }

    public boolean acceptsControlChar(char c) {
        switch (c) {
            case '\t': 
            case '\n': {
                return true;
            }
        }
        return false;
    }

    public void charInserted(char c, int n) {
        char[] cArray = this.text.getTextChars();
        int n2 = this.text.getTextLength();
        int n3 = CharView.lineNumberOfChar(this.lineOffsets, n);
        int n4 = this.lineOffsets[n3];
        if (c == '\n') {
            if (n == n4 && n > 0 && cArray[n - 1] != '\n') {
                this.refreshFrom(n - 1);
            } else {
                this.refreshFrom(n);
            }
            return;
        }
        int n5 = this.lineOffsets.length;
        FontMetrics fontMetrics = this.getFontMetrics(this.settings.font);
        int n6 = fontMetrics.charWidth('x');
        int n7 = this.settings.padding + 1 + this.settings.margin;
        int n8 = n3 == n5 - 1 ? n2 : this.lineOffsets[n3 + 1] + 1;
        if (cArray[n8 - 1] == '\n') {
            --n8;
        }
        if (n6 * (n8 - n4) <= this.width - this.textLeft - n7 - this.settings.wrappedIcon.getWidth(null)) {
            int n9 = n3 + 1;
            while (n9 < n5) {
                int n10 = n9++;
                this.lineOffsets[n10] = this.lineOffsets[n10] + 1;
            }
            int n11 = this.textTop + n3 * fontMetrics.getHeight();
            int n12 = fontMetrics.getAscent() + fontMetrics.getDescent();
            this.repaint(0, n11, this.width, n12);
            return;
        }
        this.refreshFrom(n);
    }

    private static final int lineNumberOfChar(int[] nArray, int n) {
        int n2 = 1;
        while (n2 != nArray.length && nArray[n2] <= n) {
            ++n2;
        }
        return n2 - 1;
    }

    public void charDeleted(char c, int n) {
        int n2 = this.text.getTextLength();
        if (n2 == 0) {
            this.refreshFrom(0);
            return;
        }
        char[] cArray = this.text.getTextChars();
        int n3 = CharView.lineNumberOfChar(this.lineOffsets, n);
        int n4 = this.lineOffsets[n3];
        if (n == n4 && n > 0 && cArray[n - 1] != '\n') {
            this.refreshFrom(n - 1);
            return;
        }
        int n5 = this.lineOffsets.length;
        int n6 = n3 == n5 - 1 ? n2 : this.lineOffsets[n3 + 1] - 1;
        if (n4 == n6) {
            this.refreshFrom(n);
            return;
        }
        if (cArray[n6 - 1] == '\n') {
            int n7 = n3 + 1;
            while (n7 < n5) {
                int n8 = n7++;
                this.lineOffsets[n8] = this.lineOffsets[n8] - 1;
            }
            FontMetrics fontMetrics = this.getFontMetrics(this.settings.font);
            int n9 = this.textTop + n3 * fontMetrics.getHeight();
            int n10 = fontMetrics.getAscent() + fontMetrics.getDescent();
            this.repaint(0, n9, this.width, n10);
            return;
        }
        this.refreshFrom(n);
    }

    private void refreshFrom(int n) {
        if (this.parent == null) {
            return;
        }
        int n2 = this.width;
        int n3 = this.height;
        Dimension dimension = new Dimension();
        this.parent.getSizeConstraints(this, dimension);
        int n4 = dimension.width;
        if (n4 > 0 && Outline.hasOutline(this.settings)) {
            Outline.computeSize(this, this.settings, this.text, dimension);
            if (dimension.width > n4) {
                n4 = dimension.width;
            }
        }
        int n5 = this.relayoutLines(n4, n);
        if (this.width == n2 && this.height == n3) {
            int n6 = this.getFontMetrics(this.settings.font).getHeight();
            int n7 = this.textTop + n5 * n6;
            this.repaint(0, n7, this.width, this.height - n7);
        } else {
            int n8;
            int n9;
            if (this.width == n2) {
                int n10 = this.getFontMetrics(this.settings.font).getHeight();
                int n11 = this.textTop + n5 * n10;
                n9 = 2;
                n8 = this.height - n11;
            } else {
                n9 = 0;
                n8 = -1;
            }
            this.parent.paintRelayout(this, n2, n3, n9, n8);
        }
    }

    public static class Settings
    extends ViewSettings {
        public static final Bitmap wrappedBitmap = new Bitmap(9, 7, new byte[]{-2, 0, -18, 0, -18, 0, -126, 0, -18, 0, -18, 0, -2, 0});
        public int margin;
        public Color borderColor;
        public int padding;
        public Color contentBackgroundColor;
        public Image wrappedIcon;

        public Settings() {
            this.backgroundColor = null;
            this.textColor = Color.black;
            this.arcColor = Color.gray;
            this.font = new Font("Monospaced", 0, 10);
            this.icon = null;
            this.label = null;
            this.autoLabel = false;
            this.margin = 2;
            this.borderColor = Color.gray;
            this.padding = 2;
            this.contentBackgroundColor = new Color(192, 192, 192);
            this.wrappedIcon = wrappedBitmap.getImage(this.textColor);
        }
    }
}

