/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.view;

import com.xmlmind.xmledit.doc.Comment;
import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.ProcessingInstruction;
import com.xmlmind.xmledit.doc.Text;
import com.xmlmind.xmledit.doc.TextNode;
import com.xmlmind.xmledit.doc.Traversal;
import com.xmlmind.xmledit.edit.MarkManager;
import com.xmlmind.xmledit.edit.TextLocation;
import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.view.DocumentPane;
import com.xmlmind.xmledit.view.DocumentView;
import com.xmlmind.xmledit.view.GadgetListImpl;
import com.xmlmind.xmledit.view.TextNodeView;
import com.xmlmind.xmledit.view.TextNodeViewText;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import javax.swing.LayoutFocusTraversalPolicy;

public class DocumentFocusTraversalPolicy
extends LayoutFocusTraversalPolicy
implements Traversal.Handler {
    public static final DocumentFocusTraversalPolicy INSTANCE = new DocumentFocusTraversalPolicy();
    private int docViewWidth = -1;
    private int docViewHeight = -1;
    private int viewIndex = -1;
    private GadgetListImpl gadgetList = new GadgetListImpl();
    private Point point = new Point();

    public Component getComponentAfter(Container container, Component component) {
        if (container instanceof DocumentPane) {
            return this.doGetComponentAfter((DocumentPane)container, component);
        }
        return super.getComponentAfter(container, component);
    }

    public Component getComponentBefore(Container container, Component component) {
        if (container instanceof DocumentPane) {
            return this.doGetComponentBefore((DocumentPane)container, component);
        }
        return super.getComponentBefore(container, component);
    }

    public Component getFirstComponent(Container container) {
        if (container instanceof DocumentPane) {
            return this.doGetFirstComponent((DocumentPane)container);
        }
        return super.getFirstComponent(container);
    }

    public Component getLastComponent(Container container) {
        if (container instanceof DocumentPane) {
            return this.doGetLastComponent((DocumentPane)container);
        }
        return super.getLastComponent(container);
    }

    public Component getDefaultComponent(Container container) {
        if (container instanceof DocumentPane) {
            return this.doGetDefaultComponent((DocumentPane)container);
        }
        return super.getDefaultComponent(container);
    }

    private Component doGetComponentAfter(DocumentPane documentPane, Component component) {
        TextNode textNode = this.getCaretNode(documentPane, component);
        if (textNode == null) {
            return null;
        }
        TextNode textNode2 = this.traverseAfter(documentPane, textNode);
        if (textNode2 == null) {
            return documentPane;
        }
        DocumentFocusTraversalPolicy.moveCaret(documentPane, textNode2, false);
        return documentPane;
    }

    private TextNode getCaretNode(DocumentPane documentPane, Component component) {
        if (component != documentPane) {
            return null;
        }
        MarkManager markManager = documentPane.getDocumentView().getMarkManager();
        if (markManager == null) {
            return null;
        }
        TextLocation textLocation = markManager.getDot();
        if (textLocation == null) {
            return null;
        }
        return textLocation.getTextNode();
    }

    public static final void moveCaret(DocumentPane documentPane, TextNode textNode, boolean bl) {
        String string;
        DocumentView documentView = documentPane.getDocumentView();
        if (!documentView.hasCommandListeners()) {
            DocumentFocusTraversalPolicy.doMoveCaret(documentView, textNode, bl);
            return;
        }
        String string2 = string = bl ? "previousTextNode" : "nextTextNode";
        if (!documentView.notifyCommandListeners("moveDotTo", string, -1, -1, 0, null)) {
            return;
        }
        DocumentFocusTraversalPolicy.doMoveCaret(documentView, textNode, bl);
        documentView.notifyCommandListeners("moveDotTo", string, -1, -1, 3, null);
    }

    private static final void doMoveCaret(DocumentView documentView, TextNode textNode, boolean bl) {
        MarkManager markManager = documentView.getMarkManager();
        markManager.beginBatchMarking();
        markManager.remove("SELECTED");
        markManager.remove("SELECTED2");
        markManager.remove("MARK");
        int n = 0;
        markManager.set("DOT", textNode, n, true);
        markManager.endBatchMarking();
    }

    private Component doGetComponentBefore(DocumentPane documentPane, Component component) {
        TextNode textNode = this.getCaretNode(documentPane, component);
        if (textNode == null) {
            return null;
        }
        TextNode textNode2 = this.traverseBefore(documentPane, textNode);
        if (textNode2 == null) {
            return documentPane;
        }
        DocumentFocusTraversalPolicy.moveCaret(documentPane, textNode2, true);
        return documentPane;
    }

    private Component doGetFirstComponent(DocumentPane documentPane) {
        Document document = documentPane.getDocumentView().getDocument();
        if (document == null) {
            return null;
        }
        TextNode textNode = this.traverse(documentPane, document.getRootElement());
        if (textNode == null) {
            return null;
        }
        DocumentFocusTraversalPolicy.moveCaret(documentPane, textNode, false);
        return documentPane;
    }

    private Component doGetLastComponent(DocumentPane documentPane) {
        Document document = documentPane.getDocumentView().getDocument();
        if (document == null) {
            return null;
        }
        TextNode textNode = this.traverseBackwards(documentPane, document.getRootElement());
        if (textNode == null) {
            return null;
        }
        DocumentFocusTraversalPolicy.moveCaret(documentPane, textNode, true);
        return documentPane;
    }

    private Component doGetDefaultComponent(DocumentPane documentPane) {
        return documentPane;
    }

    private TextNode traverseAfter(DocumentPane documentPane, Node node) {
        this.initTraversal(documentPane);
        TextNode textNode = (TextNode)Traversal.traverseAfter(node, this);
        this.finishTraversal();
        return textNode;
    }

    private TextNode traverseBefore(DocumentPane documentPane, Node node) {
        this.initTraversal(documentPane);
        TextNode textNode = (TextNode)Traversal.traverseBefore(node, this);
        this.finishTraversal();
        return textNode;
    }

    private TextNode traverse(DocumentPane documentPane, Node node) {
        this.initTraversal(documentPane);
        TextNode textNode = (TextNode)Traversal.traverse(node, this);
        this.finishTraversal();
        return textNode;
    }

    private TextNode traverseBackwards(DocumentPane documentPane, Node node) {
        this.initTraversal(documentPane);
        TextNode textNode = (TextNode)Traversal.traverseBackwards(node, this);
        this.finishTraversal();
        return textNode;
    }

    private void initTraversal(DocumentPane documentPane) {
        DocumentView documentView = documentPane.getDocumentView();
        this.docViewWidth = documentView.width;
        this.docViewHeight = documentView.height;
        this.viewIndex = documentView.getDocument().documentListenerIndex(documentView);
    }

    private void finishTraversal() {
        this.docViewHeight = -1;
        this.docViewWidth = -1;
        this.viewIndex = -1;
        this.gadgetList.removeAll();
    }

    public Object processText(Text text) {
        return this.processTextNode(text);
    }

    public Object processPI(ProcessingInstruction processingInstruction) {
        return this.processTextNode(processingInstruction);
    }

    public Object processComment(Comment comment) {
        return this.processTextNode(comment);
    }

    private Object processTextNode(TextNode textNode) {
        if (this.isFocusable(textNode)) {
            return textNode;
        }
        return null;
    }

    private boolean isFocusable(TextNode textNode) {
        TextNodeView textNodeView = (TextNodeView)textNode.getDocumentListenerData(this.viewIndex);
        boolean bl = false;
        if (textNodeView != null) {
            this.gadgetList.removeAll();
            textNodeView.getTextGadgets(this.gadgetList, this.viewIndex);
            int n = 0;
            while (n < this.gadgetList.size) {
                Gadget gadget = this.gadgetList.list[n];
                if (gadget instanceof TextNodeViewText) {
                    this.point.y = 0;
                    this.point.x = 0;
                    gadget.gadgetToRoot(this.point);
                    if (this.point.x < this.docViewWidth && this.point.y < this.docViewHeight && this.point.x + gadget.width > 0 && this.point.y + gadget.height > 0) {
                        bl = true;
                        break;
                    }
                }
                ++n;
            }
        }
        return bl;
    }

    public Object enterElement(Element element) {
        return null;
    }

    public Object leaveElement(Element element) {
        return null;
    }
}

