/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.view;

import com.xmlmind.xmledit.gadget.GadgetPanel;
import com.xmlmind.xmledit.gadget.RootGadget;
import com.xmlmind.xmledit.view.DocumentFocusTraversalPolicy;
import com.xmlmind.xmledit.view.DocumentView;
import com.xmlmind.xmledit.view.JScrollPaneSupport;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.util.TreeSet;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.Scrollable;

public class DocumentPane
extends GadgetPanel
implements Scrollable {
    private int horizScrollUnit;
    private int vertScrollUnit;
    private static TreeSet forwardTraversalKeys = new TreeSet();
    private static TreeSet backwardTraversalKeys = new TreeSet();

    public DocumentPane() {
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(DocumentFocusTraversalPolicy.INSTANCE);
        this.setFocusTraversalKeys(0, forwardTraversalKeys);
        this.setFocusTraversalKeys(1, backwardTraversalKeys);
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        this.horizScrollUnit = fontMetrics.getMaxAdvance();
        this.vertScrollUnit = fontMetrics.getHeight();
    }

    public boolean isFocusable() {
        DocumentView documentView = (DocumentView)this.root;
        return documentView.isEditable() && documentView.getDocument() != null;
    }

    protected RootGadget createRootGadget() {
        return new DocumentView(this);
    }

    public JScrollPaneSupport addToScrollPane(JScrollPane jScrollPane) {
        jScrollPane.setViewportView(this);
        return new JScrollPaneSupport(this, jScrollPane);
    }

    public DocumentView getDocumentView() {
        return (DocumentView)this.root;
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 0) {
            return this.horizScrollUnit;
        }
        return this.vertScrollUnit;
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 0) {
            return rectangle.width;
        }
        return rectangle.height;
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    static {
        forwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 0));
        backwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 1));
    }
}

