/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.view;

import com.xmlmind.xmledit.doc.BatchEditingEvent;
import com.xmlmind.xmledit.doc.Comment;
import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.DocumentEvent;
import com.xmlmind.xmledit.doc.DocumentListener;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.ElementAttributeEvent;
import com.xmlmind.xmledit.doc.ElementStructureEvent;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.ProcessingInstruction;
import com.xmlmind.xmledit.doc.ProcessingInstructionEvent;
import com.xmlmind.xmledit.doc.Text;
import com.xmlmind.xmledit.doc.TextEvent;
import com.xmlmind.xmledit.doc.TextNode;
import com.xmlmind.xmledit.doc.Traversal;
import com.xmlmind.xmledit.doctype.DocumentType;
import com.xmlmind.xmledit.edit.CommandHistory;
import com.xmlmind.xmledit.edit.Commands;
import com.xmlmind.xmledit.edit.ElementEditor;
import com.xmlmind.xmledit.edit.Mark;
import com.xmlmind.xmledit.edit.MarkChangeEvent;
import com.xmlmind.xmledit.edit.MarkChangeListener;
import com.xmlmind.xmledit.edit.MarkManager;
import com.xmlmind.xmledit.edit.NodeMark;
import com.xmlmind.xmledit.edit.TextCollector;
import com.xmlmind.xmledit.edit.TextEditor;
import com.xmlmind.xmledit.edit.TextLocation;
import com.xmlmind.xmledit.edit.TextOffset;
import com.xmlmind.xmledit.edit.TextRange;
import com.xmlmind.xmledit.edit.TextRangeList;
import com.xmlmind.xmledit.edit.UndoManager;
import com.xmlmind.xmledit.gadget.AppEvent;
import com.xmlmind.xmledit.gadget.Binding;
import com.xmlmind.xmledit.gadget.Bindings;
import com.xmlmind.xmledit.gadget.CollapsibleGadget;
import com.xmlmind.xmledit.gadget.Command;
import com.xmlmind.xmledit.gadget.EventDispatcher;
import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.gadget.GadgetContainer;
import com.xmlmind.xmledit.gadget.RootGadget;
import com.xmlmind.xmledit.guiutil.AWTUtil;
import com.xmlmind.xmledit.util.PlatformUtil;
import com.xmlmind.xmledit.view.BasicHighlightFactory;
import com.xmlmind.xmledit.view.BindingSpec;
import com.xmlmind.xmledit.view.CommandEvent;
import com.xmlmind.xmledit.view.CommandListener;
import com.xmlmind.xmledit.view.DefaultBindingSpecs;
import com.xmlmind.xmledit.view.DocumentViewEventDispatcher;
import com.xmlmind.xmledit.view.ElementView;
import com.xmlmind.xmledit.view.GadgetListImpl;
import com.xmlmind.xmledit.view.Highlight;
import com.xmlmind.xmledit.view.HighlightFactory;
import com.xmlmind.xmledit.view.NodeView;
import com.xmlmind.xmledit.view.NodeViewPart;
import com.xmlmind.xmledit.view.RectangleList;
import com.xmlmind.xmledit.view.RectangleListImpl;
import com.xmlmind.xmledit.view.TextNodeView;
import com.xmlmind.xmledit.view.TextNodeViewText;
import com.xmlmind.xmledit.view.TreeViewFactory;
import com.xmlmind.xmledit.view.ViewFactory;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;

public class DocumentView
extends RootGadget
implements DocumentListener,
MarkChangeListener,
RectangleList {
    private ViewFactory viewFactory;
    private HighlightFactory highlightFactory;
    private Bindings bindings;
    private boolean editable = true;
    private CommandListener[] commandListeners = null;
    private Document document = null;
    private MarkManager markManager = null;
    private UndoManager undoManager = null;
    private CommandHistory commandHistory = null;
    private static final Highlight[] NO_HIGHLIGHTS = new Highlight[0];
    private Highlight[] highlights = NO_HIGHLIGHTS;
    private boolean batchEditing = false;
    private Gadget refreshRoot = null;
    private int magicX = -1;
    private TextEditor textEditor = new TextEditor();
    private ElementEditor elementEditor = new ElementEditor();
    private ViewTreeAttacher attachViewTree = new ViewTreeAttacher();
    private ViewTreeDetacher detachViewTree = new ViewTreeDetacher();
    private static final Binding[] NO_BINDINGS = new Binding[0];
    private static final CommandListener[] NO_COMMAND_LISTENERS = new CommandListener[0];
    private GadgetListImpl gadgetList = new GadgetListImpl();
    private Point point = new Point();
    private Rectangle appendRect = null;
    private TextRangeList rangeList = new TextRangeList();
    private TextCollector textCollector = new TextCollector();
    private Rectangle rect = new Rectangle();
    private RectangleListImpl rectList = new RectangleListImpl();
    private TextOffset textOffset = new TextOffset();
    private Rectangle damaged = new Rectangle();
    private CommandEvent commandEvent = null;
    private static final int SPACE_CHAR = 32;
    private static final int FIRST_KEY_CHAR1 = 32;
    private static final int LAST_KEY_CHAR1 = 126;
    private static final int NBSP_CHAR = 160;
    private static final int FIRST_KEY_CHAR2 = 160;
    private static final int LAST_KEY_CHAR2 = 255;
    private char[] chars1 = new char[1];
    private static String[] charStrings = new String[256];

    public DocumentView(Container container) {
        super(container);
        this.viewFactory = this.createViewFactory();
        this.highlightFactory = this.createHighlightFactory();
        this.bindings = new Bindings(this, NO_BINDINGS);
        this.replaceBindings(DefaultBindingSpecs.ALL);
        this.commandEvent = new CommandEvent(this, null, null, -1, -1, 0, null);
    }

    protected EventDispatcher createEventDispatcher() {
        return new DocumentViewEventDispatcher(this);
    }

    protected ViewFactory createViewFactory() {
        return new TreeViewFactory(this);
    }

    protected HighlightFactory createHighlightFactory() {
        return new BasicHighlightFactory(this);
    }

    public void setViewFactory(ViewFactory viewFactory) {
        if (viewFactory.getDocumentView() != this) {
            throw new IllegalArgumentException("viewFactory not attached to this DocumentView");
        }
        Document document = this.document;
        if (document != null) {
            this.setDocument(null);
        }
        this.viewFactory = viewFactory;
        if (document != null) {
            this.setDocument(document);
        }
    }

    public ViewFactory getViewFactory() {
        return this.viewFactory;
    }

    public void setHighlightFactory(HighlightFactory highlightFactory) {
        if (highlightFactory.getDocumentView() != this) {
            throw new IllegalArgumentException("highlightFactory not attached to this DocumentView");
        }
        this.removeAllHighlights();
        this.highlightFactory = highlightFactory;
        if (this.markManager != null) {
            this.addAllHighlights();
        }
    }

    private void removeAllHighlights() {
        if (this.highlights.length > 0) {
            int n = 0;
            while (n < this.highlights.length) {
                this.highlights[n].dispose();
                ++n;
            }
            this.highlights = NO_HIGHLIGHTS;
        }
    }

    private void addAllHighlights() {
        Mark[] markArray = this.markManager.getAll();
        ArrayList<Highlight> arrayList = new ArrayList<Highlight>();
        int n = 0;
        while (n < markArray.length) {
            Highlight highlight = this.highlightFactory.createHighlight(markArray[n]);
            if (highlight != null) {
                arrayList.add(highlight);
            }
            ++n;
        }
        this.highlights = arrayList.toArray(NO_HIGHLIGHTS);
    }

    public HighlightFactory getHighlightFactory() {
        return this.highlightFactory;
    }

    public void addBindings(BindingSpec[] bindingSpecArray) {
        this.addBindings(bindingSpecArray, false);
    }

    public void replaceBindings(BindingSpec[] bindingSpecArray) {
        this.addBindings(bindingSpecArray, true);
    }

    private void addBindings(BindingSpec[] bindingSpecArray, boolean bl) {
        Binding[] bindingArray;
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        Binding[] bindingArray2 = this.getBindings();
        int n = 0;
        while (n < bindingArray2.length) {
            hashMap.put(bindingArray2[n], bindingArray2[n]);
            ++n;
        }
        int n2 = 0;
        while (n2 < bindingSpecArray.length) {
            bindingArray = bindingSpecArray[n2].toBinding();
            if (bindingArray == null) {
                throw new IllegalArgumentException("command triggered by '" + bindingSpecArray[n2].triggerToString() + "' is unknown");
            }
            if (bl || !hashMap.containsKey(bindingArray)) {
                hashMap.put(bindingArray, bindingArray);
            }
            ++n2;
        }
        bindingArray = hashMap.values().toArray(NO_BINDINGS);
        this.setBindings(bindingArray);
    }

    public void removeBindings(BindingSpec[] bindingSpecArray) {
        Binding[] bindingArray;
        ArrayList<Binding> arrayList = new ArrayList<Binding>();
        Binding[] bindingArray2 = this.getBindings();
        int n = 0;
        while (n < bindingArray2.length) {
            bindingArray = bindingArray2[n];
            boolean bl = false;
            int n2 = 0;
            while (n2 < bindingSpecArray.length) {
                if (bindingArray.hasSameTrigger(bindingSpecArray[n2])) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (!bl) {
                arrayList.add(bindingArray2[n]);
            }
            ++n;
        }
        bindingArray = arrayList.toArray(NO_BINDINGS);
        this.setBindings(bindingArray);
    }

    public void removeAllBindings() {
        this.setBindings(NO_BINDINGS);
    }

    public void setBindings(Binding[] bindingArray) {
        this.bindings = new Bindings(this, bindingArray);
    }

    public Binding[] getBindings() {
        return this.bindings.getAll();
    }

    public Binding findBinding(Command command, String string) {
        return DocumentView.findBinding(this.bindings.getAll(), command, string);
    }

    public static final Binding findBinding(Binding[] bindingArray, Command command, String string) {
        int n = 0;
        while (n < bindingArray.length) {
            String string2;
            Binding binding = bindingArray[n];
            if (binding.getCommand() == command && ((string2 = binding.getParameter()) == null && string == null || string2 != null && string2.equals(string))) {
                return binding;
            }
            ++n;
        }
        return null;
    }

    public Bindings getBindingsDelegate() {
        return this.bindings;
    }

    public boolean executeCommand(String string, String string2, int n, int n2) {
        Command command = Commands.getCommand(string);
        if (command != null && command.prepareCommand(this, string2, n, n2)) {
            command.executeCommand(this, string2, n, n2);
            return true;
        }
        return false;
    }

    public void setDocument(Document document) {
        if (this.document != null) {
            this.removeAllHighlights();
            if (this.getChildCount() > 0) {
                this.removeChild(0);
            }
            this.viewFactory.setDocument(null);
            this.highlightFactory.setDocument(null);
            this.textEditor.setDocumentType(null);
            this.elementEditor.setEditedElement(null);
            this.elementEditor.setDocumentType(null);
            this.markManager.removeMarkChangeListener(this);
            this.markManager = null;
            this.undoManager = null;
            this.commandHistory = null;
            this.document.removeDocumentListener(this);
            this.document = null;
            this.batchEditing = false;
            this.refreshRoot = null;
            this.magicX = -1;
            this.gadgetList.removeAll();
        }
        if (document != null) {
            this.document = document;
            this.document.addDocumentListener(this, true, true);
            this.markManager = (MarkManager)document.getProperty("MARK_MANAGER");
            if (this.markManager == null) {
                this.markManager = new MarkManager(document);
            }
            this.markManager.addMarkChangeListener(this);
            this.undoManager = (UndoManager)document.getProperty("UNDO_MANAGER");
            this.commandHistory = (CommandHistory)document.getProperty("COMMAND_HISTORY");
            DocumentType documentType = (DocumentType)document.getProperty("DOCUMENT_TYPE");
            this.textEditor.setDocumentType(documentType);
            this.elementEditor.setDocumentType(documentType);
            this.viewFactory.setDocument(this.document);
            this.highlightFactory.setDocument(this.document);
            Element element = this.document.getRootElement();
            this.attachViewTree.run(element);
            int n = this.document.documentListenerIndex(this);
            ElementView elementView = (ElementView)element.getDocumentListenerData(n);
            this.gadgetList.removeAll();
            elementView.getGadgets(this.gadgetList, n);
            if (this.gadgetList.size > 0) {
                this.addChild(this.gadgetList.list[this.gadgetList.size - 1]);
            }
            this.addAllHighlights();
        }
    }

    public Document getDocument() {
        return this.document;
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public Node getSelectedNode() {
        if (this.markManager != null) {
            NodeMark nodeMark = this.markManager.getSelected();
            return nodeMark == null ? null : nodeMark.getNode();
        }
        return null;
    }

    public Node getSelectedNode2() {
        if (this.markManager != null) {
            NodeMark nodeMark = this.markManager.getSelected2();
            return nodeMark == null ? null : nodeMark.getNode();
        }
        return null;
    }

    public String getSelectedChars() {
        if (this.markManager == null || this.markManager.getSelected() != null) {
            return "";
        }
        TextLocation textLocation = this.markManager.getDot();
        if (textLocation == null) {
            return "";
        }
        TextLocation textLocation2 = this.markManager.getMark();
        if (textLocation2 == null) {
            return "";
        }
        TextNode textNode = textLocation2.getTextNode();
        int n = textLocation2.getOffset();
        TextNode textNode2 = textLocation.getTextNode();
        int n2 = textLocation.getOffset();
        if (textNode == textNode2 && n == n2) {
            return "";
        }
        return this.textEditor.copyChars(textNode, n, textNode2, n2);
    }

    public Gadget getGadgetContainingView(NodeView nodeView) {
        this.gadgetList.removeAll();
        int n = this.document.documentListenerIndex(this);
        nodeView.getGadgets(this.gadgetList, n);
        if (this.gadgetList.size == 0) {
            return null;
        }
        Gadget gadget = this.gadgetList.list[0];
        int n2 = 1;
        while (n2 < this.gadgetList.size) {
            Gadget gadget2 = this.gadgetList.list[n2];
            if ((gadget = DocumentView.findCommonAncestor(gadget, gadget2)) == null) {
                return null;
            }
            ++n2;
        }
        return gadget;
    }

    public boolean refreshView(Node node) {
        if (this.document == null || node.getDocument() != this.document) {
            return false;
        }
        this.refreshNodeView(node, this.document.documentListenerIndex(this));
        return true;
    }

    public boolean rebuildView(Node node) {
        if (this.document == null || node.getDocument() != this.document) {
            return false;
        }
        this.rebuildNodeView(node, this.document.documentListenerIndex(this));
        return true;
    }

    public Rectangle modelToView(Node node) {
        this.modelToView(node, this.rectList);
        return DocumentView.rectListToRect(this.rectList, this.rect);
    }

    private static final Rectangle rectListToRect(RectangleListImpl rectangleListImpl, Rectangle rectangle) {
        int n = rectangleListImpl.size;
        if (n == 0) {
            return null;
        }
        Rectangle[] rectangleArray = rectangleListImpl.list;
        rectangle.height = 0;
        rectangle.width = 0;
        rectangle.y = 0;
        rectangle.x = 0;
        int n2 = 0;
        while (n2 < n) {
            Rectangle rectangle2 = rectangleArray[n2];
            if (rectangle2.height > 0) {
                if (rectangle2.width <= 0) {
                    rectangle2.width = 1;
                }
                AWTUtil.union(rectangle, rectangle2);
            }
            ++n2;
        }
        rectangleListImpl.removeAll();
        return rectangle.width > 0 && rectangle.height > 0 ? rectangle : null;
    }

    public Rectangle modelToVisibleView(Node node) {
        this.modelToVisibleView(node, this.rectList);
        return DocumentView.rectListToRect(this.rectList, this.rect);
    }

    public Rectangle modelToView(TextLocation textLocation) {
        return this.modelToView(textLocation.getTextNode(), textLocation.getOffset());
    }

    public Rectangle modelToView(TextNode textNode, int n) {
        this.modelToView(textNode, n, this.rect);
        if (this.rect.height <= 0) {
            return null;
        }
        this.rect.width = 1;
        return this.rect;
    }

    public Rectangle modelToView(TextLocation textLocation, TextLocation textLocation2) {
        return this.modelToView(textLocation.getTextNode(), textLocation.getOffset(), textLocation2.getTextNode(), textLocation2.getOffset());
    }

    public Rectangle modelToView(TextNode textNode, int n, TextNode textNode2, int n2) {
        if (textNode == textNode2 && n == n2) {
            return this.modelToView(textNode, n);
        }
        this.modelToView(textNode, n, textNode2, n2, this.rectList);
        int n3 = this.rectList.size;
        if (n3 == 0) {
            return null;
        }
        Rectangle[] rectangleArray = this.rectList.list;
        this.rect.height = 0;
        this.rect.width = 0;
        this.rect.y = 0;
        this.rect.x = 0;
        int n4 = 0;
        while (n4 < n3) {
            Rectangle rectangle = rectangleArray[n4];
            if (rectangle.height > 0) {
                if (rectangle.width <= 0) {
                    rectangle.width = 1;
                }
                AWTUtil.union(this.rect, rectangle);
            }
            ++n4;
        }
        this.rectList.removeAll();
        return this.rect.width > 0 && this.rect.height > 0 ? this.rect : null;
    }

    public boolean ensureDotIsVisible() {
        int n;
        int n2;
        Object object;
        if (this.document == null) {
            return false;
        }
        Rectangle rectangle = this.getVisibleRectangle();
        if (rectangle.height <= 0) {
            return false;
        }
        TextLocation textLocation = this.markManager.getDot();
        if (textLocation == null) {
            return false;
        }
        Object object2 = null;
        int n3 = 0;
        while (n3 < this.highlights.length) {
            object = this.highlights[n3];
            Mark mark = object.getMark();
            Mark mark2 = object.getMark2();
            if (mark == textLocation && mark2 == null) {
                object2 = object;
                break;
            }
            ++n3;
        }
        if (object2 == null) {
            return false;
        }
        object = object2.relayout();
        RootGadget.intersection((Rectangle)object, rectangle, this.rect);
        if (this.rect.height > 0) {
            return true;
        }
        int n4 = rectangle.x + rectangle.width / 2;
        int n5 = rectangle.y + rectangle.height;
        int n6 = rectangle.height / 10;
        if (n6 == 0) {
            n6 = 1;
        }
        if ((n2 = n6 / (n = 2)) == 0) {
            n2 = 1;
        }
        int n7 = 0;
        while (n7 < n) {
            int n8 = rectangle.y + n7 * n2;
            while (n8 < n5) {
                if (this.pickText(n4, n8, this.textOffset)) {
                    textLocation.moveTo(this.textOffset.text, this.textOffset.offset);
                    return true;
                }
                n8 += n6;
            }
            ++n7;
        }
        return false;
    }

    public boolean ensureViewIsExpanded(Node node) {
        if (this.document == null) {
            return false;
        }
        NodeView nodeView = this.getNodeView(node);
        if (nodeView == null) {
            return false;
        }
        Gadget gadget = this.getGadgetContainingView(nodeView);
        if (gadget == null) {
            return false;
        }
        this.ensureGadgetIsExpanded(gadget);
        return true;
    }

    private void ensureGadgetIsExpanded(Gadget gadget) {
        Gadget gadget2 = null;
        while (gadget != null) {
            CollapsibleGadget collapsibleGadget;
            if (gadget instanceof CollapsibleGadget && (collapsibleGadget = (CollapsibleGadget)((Object)gadget)).isCollapsed()) {
                collapsibleGadget.setCollapsed(false);
                gadget2 = gadget;
            }
            gadget = gadget.parent;
        }
        if (gadget2 != null) {
            gadget2.refresh();
        }
    }

    public MarkManager getMarkManager() {
        return this.markManager;
    }

    public Element getSelectedElement(boolean bl) {
        if (this.markManager == null) {
            return null;
        }
        NodeMark nodeMark = this.markManager.getSelected();
        if (nodeMark != null) {
            Node node = nodeMark.getNode();
            if (!(node instanceof Element)) {
                return null;
            }
            NodeMark nodeMark2 = this.markManager.getSelected2();
            if (nodeMark2 != null && nodeMark2.getNode() != node) {
                return null;
            }
            return (Element)node;
        }
        if (!bl) {
            return null;
        }
        TextLocation textLocation = this.markManager.getDot();
        if (textLocation == null) {
            return null;
        }
        TextLocation textLocation2 = this.markManager.getMark();
        if (textLocation2 != null && (textLocation2.getTextNode() != textLocation.getTextNode() || textLocation2.getOffset() != textLocation.getOffset())) {
            return null;
        }
        return textLocation.getTextNode().getParentElement();
    }

    public Node getSelectedNode(boolean bl) {
        if (this.markManager == null) {
            return null;
        }
        NodeMark nodeMark = this.markManager.getSelected();
        if (nodeMark != null) {
            Node node = nodeMark.getNode();
            NodeMark nodeMark2 = this.markManager.getSelected2();
            if (nodeMark2 != null && nodeMark2.getNode() != node) {
                return null;
            }
            return node;
        }
        if (!bl) {
            return null;
        }
        TextLocation textLocation = this.markManager.getDot();
        if (textLocation == null) {
            return null;
        }
        TextLocation textLocation2 = this.markManager.getMark();
        if (textLocation2 != null && (textLocation2.getTextNode() != textLocation.getTextNode() || textLocation2.getOffset() != textLocation.getOffset())) {
            return null;
        }
        return textLocation.getTextNode();
    }

    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    public void describeUndo(String string) {
        UndoManager.Action action;
        if (this.undoManager != null && (action = this.undoManager.getTopUndoAction()) != null && action.getDescription() == null) {
            action.setDescription(string);
        }
    }

    public CommandHistory getCommandHistory() {
        return this.commandHistory;
    }

    public void addToCommandHistory(Command command, String string, String string2) {
        if (this.commandHistory != null) {
            this.commandHistory.addCommand(command, string, string2);
        }
    }

    public void notifyContextChangeListeners() {
        if (this.markManager != null) {
            this.markManager.notifyContextChangeListeners();
        }
    }

    public TextEditor getTextEditor() {
        return this.textEditor;
    }

    public ElementEditor getElementEditor() {
        return this.elementEditor;
    }

    public Node viewToModel(int n, int n2) {
        this.point.x = n;
        this.point.y = n2;
        Gadget gadget = this.findGadgetAt(this.point);
        if (gadget == null || !(gadget instanceof NodeViewPart)) {
            return null;
        }
        return ((NodeViewPart)((Object)gadget)).getView().getModel();
    }

    public boolean viewToModel(int n, int n2, TextOffset textOffset) {
        this.point.x = n;
        this.point.y = n2;
        Gadget gadget = this.findGadgetAt(this.point);
        if (gadget == null || !(gadget instanceof TextNodeViewText)) {
            textOffset.text = null;
            textOffset.offset = 0;
            return false;
        }
        TextNodeViewText textNodeViewText = (TextNodeViewText)((Object)gadget);
        textOffset.text = textNodeViewText.getTextNodeView().getTextNode();
        textOffset.offset = textNodeViewText.gadgetToModel(this.point.x, this.point.y);
        return true;
    }

    public boolean pickText(int n, int n2, TextOffset textOffset) {
        Gadget gadget;
        TextNodeViewText textNodeViewText = null;
        this.point.x = n;
        this.point.y = n2;
        Gadget gadget2 = this.findGadgetAt(this.point);
        if (gadget2 != null) {
            if (gadget2 instanceof TextNodeViewText) {
                textNodeViewText = (TextNodeViewText)((Object)gadget2);
            } else if (gadget2 instanceof GadgetContainer) {
                n = this.point.x;
                n2 = this.point.y;
                gadget = (GadgetContainer)gadget2;
                while (true) {
                    Gadget[] gadgetArray = ((GadgetContainer)gadget).getChildren();
                    Gadget gadget3 = null;
                    int n3 = Integer.MAX_VALUE;
                    int n4 = 0;
                    while (n4 < gadgetArray.length) {
                        Gadget gadget4 = gadgetArray[n4];
                        if (n2 >= gadget4.y && n2 < gadget4.y + gadget4.height && (gadget4 instanceof TextNodeViewText || gadget4 instanceof GadgetContainer)) {
                            int n5 = 0;
                            if (n < gadget4.x) {
                                n5 = gadget4.x - n;
                            } else if (n >= gadget4.x + gadget4.width) {
                                n5 = n - (gadget4.x + gadget4.width);
                            }
                            if (gadget3 == null || n5 < n3) {
                                gadget3 = gadget4;
                                n3 = n5;
                            }
                        }
                        ++n4;
                    }
                    if (gadget3 == null) break;
                    n -= gadget3.x;
                    n2 -= gadget3.y;
                    if (gadget3 instanceof TextNodeViewText) {
                        this.point.x = n;
                        this.point.y = n2;
                        textNodeViewText = (TextNodeViewText)((Object)gadget3);
                        break;
                    }
                    gadget = (GadgetContainer)gadget3;
                }
            }
        }
        if (textNodeViewText == null) {
            textOffset.text = null;
            textOffset.offset = 0;
            return false;
        }
        gadget = (Gadget)((Object)textNodeViewText);
        int n6 = this.point.x;
        if (n6 < 0) {
            n6 = 0;
        } else if (n6 >= gadget.width) {
            n6 = gadget.width - 1;
        }
        textOffset.text = textNodeViewText.getTextNodeView().getTextNode();
        textOffset.offset = textNodeViewText.gadgetToModel(n6, this.point.y);
        return true;
    }

    public boolean selectNodeRange(Node node, Node node2) {
        if (node == node2) {
            return this.selectNode(node);
        }
        if (this.document == null || node.getDocument() != this.document || !node2.isSiblingOf(node)) {
            return false;
        }
        this.markManager.beginBatchMarking();
        this.markManager.remove("MARK");
        this.markManager.set("SELECTED", node);
        this.markManager.set("SELECTED2", node2);
        this.ensureDotIsInside(node2);
        this.markManager.endBatchMarking();
        return true;
    }

    public boolean selectNode(Node node) {
        if (this.document == null || node.getDocument() != this.document) {
            return false;
        }
        this.markManager.beginBatchMarking();
        this.markManager.remove("MARK");
        this.markManager.remove("SELECTED2");
        this.markManager.set("SELECTED", node);
        this.ensureDotIsInside(node);
        this.markManager.endBatchMarking();
        return true;
    }

    public boolean ensureDotIsInside(Node node) {
        TextNode textNode;
        if (this.document == null || node.getDocument() != this.document) {
            return false;
        }
        TextLocation textLocation = this.markManager.getDot();
        if (textLocation != null && node.isAncestorOf(textNode = textLocation.getTextNode())) {
            return true;
        }
        return this.moveDotInto(node, false);
    }

    public boolean moveDotInto(Node node) {
        return this.moveDotInto(node, false);
    }

    public boolean moveDotInto(Node node, boolean bl) {
        if (this.document == null || node.getDocument() != this.document) {
            return false;
        }
        TextNode textNode = (TextNode)Traversal.traverse(node, Traversal.textNodeFinder);
        if (textNode == null && !bl) {
            return false;
        }
        this.markManager.beginBatchMarking();
        this.markManager.remove("MARK");
        if (textNode == null) {
            this.markManager.remove("SELECTED2");
            this.markManager.set("SELECTED", node);
        } else {
            this.markManager.set("DOT", textNode, 0, true);
        }
        this.markManager.endBatchMarking();
        return true;
    }

    public boolean selectText(TextNode textNode, int n, TextNode textNode2, int n2) {
        if (this.document == null || textNode.getDocument() != this.document || textNode2.getDocument() != this.document) {
            return false;
        }
        this.markManager.beginBatchMarking();
        this.markManager.remove("SELECTED");
        this.markManager.remove("SELECTED2");
        this.markManager.set("MARK", textNode, n);
        this.markManager.set("DOT", textNode2, n2, true);
        this.markManager.endBatchMarking();
        return true;
    }

    public boolean selectShowText(TextNode textNode, int n, TextNode textNode2, int n2) {
        boolean bl = this.selectText(textNode, n, textNode2, n2);
        if (bl) {
            Rectangle rectangle;
            this.ensureViewIsExpanded(textNode2);
            if (textNode != textNode2) {
                this.ensureViewIsExpanded(textNode);
            }
            if ((rectangle = this.modelToView(textNode2, n2)) != null) {
                this.makeRectangleVisible(rectangle);
            }
        }
        return bl;
    }

    public boolean canInsertString() {
        TextNode textNode;
        boolean bl;
        if (this.document == null) {
            return false;
        }
        TextLocation textLocation = this.markManager.getDot();
        if (textLocation == null) {
            return false;
        }
        TextLocation textLocation2 = this.markManager.getMark();
        boolean bl2 = bl = textLocation2 != null && (textLocation2.getTextNode() != textLocation.getTextNode() || textLocation2.getOffset() != textLocation.getOffset());
        return !(bl ? !this.textEditor.canPasteString(textLocation2, textLocation) : !(textNode = textLocation.getTextNode()).isEditable());
    }

    public boolean insertString(String string) {
        boolean bl;
        if (this.document == null) {
            return false;
        }
        TextLocation textLocation = this.markManager.getDot();
        if (textLocation == null) {
            return false;
        }
        TextLocation textLocation2 = this.markManager.getMark();
        boolean bl2 = bl = textLocation2 != null && (textLocation2.getTextNode() != textLocation.getTextNode() || textLocation2.getOffset() != textLocation.getOffset());
        if (bl) {
            if (!this.textEditor.canPasteString(textLocation2, textLocation)) {
                return false;
            }
            if (textLocation2.isAfter(textLocation)) {
                this.markManager.beginBatchMarking();
                textLocation2.swapWith(textLocation);
                boolean bl3 = this.textEditor.pasteString(textLocation2, textLocation, string) != null;
                this.markManager.endBatchMarking();
                return bl3;
            }
            return this.textEditor.pasteString(textLocation2, textLocation, string) != null;
        }
        TextNode textNode = textLocation.getTextNode();
        if (!textNode.isEditable()) {
            return false;
        }
        this.markManager.remove("SELECTED");
        this.markManager.remove("SELECTED2");
        textNode.insertText(textLocation.getOffset(), string);
        return true;
    }

    public void repaintHighlights(Mark[] markArray) {
        this.rect.height = 0;
        this.rect.width = 0;
        this.rect.y = 0;
        this.rect.x = 0;
        int n = 0;
        while (n < this.highlights.length) {
            Object object;
            Highlight highlight = this.highlights[n];
            Mark mark = highlight.getMark();
            Mark mark2 = highlight.getMark2();
            boolean bl = false;
            int n2 = 0;
            while (n2 < markArray.length) {
                object = markArray[n2];
                if (mark == object || mark2 == object) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (bl) {
                object = highlight.getBounds();
                AWTUtil.union(this.rect, (Rectangle)object);
                object = highlight.relayout();
                AWTUtil.union(this.rect, (Rectangle)object);
            }
            ++n;
        }
        if (this.rect.width > 0 && this.rect.height > 0) {
            this.repaint(this.rect.x, this.rect.y, this.rect.width, this.rect.height);
        }
    }

    public void setMagicX(int n) {
        this.magicX = n;
    }

    public int getMagicX() {
        return this.magicX;
    }

    public void modelToView(Node node, RectangleListImpl rectangleListImpl) {
        rectangleListImpl.removeAll();
        int n = this.document.documentListenerIndex(this);
        NodeView nodeView = (NodeView)node.getDocumentListenerData(n);
        if (nodeView != null) {
            this.gadgetList.removeAll();
            nodeView.getGadgets(this.gadgetList, n);
            int n2 = 0;
            while (n2 < this.gadgetList.size) {
                Gadget gadget = this.gadgetList.list[n2];
                this.point.y = 0;
                this.point.x = 0;
                gadget.gadgetToRoot(this.point);
                if (this.point.x < this.width && this.point.y < this.height && this.point.x + gadget.width > 0 && this.point.y + gadget.height > 0) {
                    rectangleListImpl.appendRectangle(this.point.x, this.point.y, gadget.width, gadget.height);
                }
                ++n2;
            }
        }
    }

    public void modelToVisibleView(Node node, RectangleListImpl rectangleListImpl) {
        rectangleListImpl.removeAll();
        int n = this.document.documentListenerIndex(this);
        while (node != null) {
            NodeView nodeView = (NodeView)node.getDocumentListenerData(n);
            if (nodeView != null) {
                this.gadgetList.removeAll();
                nodeView.getGadgets(this.gadgetList, n);
                int n2 = 0;
                while (n2 < this.gadgetList.size) {
                    Gadget gadget = this.gadgetList.list[n2];
                    this.point.y = 0;
                    this.point.x = 0;
                    gadget.gadgetToRoot(this.point);
                    if (this.point.x < this.width && this.point.y < this.height && this.point.x + gadget.width > 0 && this.point.y + gadget.height > 0) {
                        rectangleListImpl.appendRectangle(this.point.x, this.point.y, gadget.width, gadget.height);
                    }
                    ++n2;
                }
                if (rectangleListImpl.size > 0) break;
            }
            node = node.getParentElement();
        }
    }

    public NodeView getNodeView(Node node) {
        int n = this.document.documentListenerIndex(this);
        return (NodeView)node.getDocumentListenerData(n);
    }

    public void modelToView(TextNode textNode, int n, Rectangle rectangle) {
        rectangle.height = 0;
        rectangle.width = 0;
        rectangle.y = 0;
        rectangle.x = 0;
        this.appendRect = rectangle;
        int n2 = this.document.documentListenerIndex(this);
        TextNodeView textNodeView = (TextNodeView)textNode.getDocumentListenerData(n2);
        if (textNodeView != null) {
            this.gadgetList.removeAll();
            textNodeView.getTextGadgets(this.gadgetList, n2);
            int n3 = 0;
            while (n3 < this.gadgetList.size) {
                Gadget gadget = this.gadgetList.list[n3];
                if (gadget instanceof TextNodeViewText) {
                    this.point.y = 0;
                    this.point.x = 0;
                    gadget.gadgetToRoot(this.point);
                    if (this.point.x < this.width && this.point.y < this.height && this.point.x + gadget.width > 0 && this.point.y + gadget.height > 0 && ((TextNodeViewText)((Object)gadget)).modelToGadget(n, 0, this) > 0) {
                        rectangle.x += this.point.x;
                        rectangle.y += this.point.y;
                        break;
                    }
                }
                ++n3;
            }
        }
    }

    public void appendRectangle(int n, int n2, int n3, int n4) {
        this.appendRect.x = n;
        this.appendRect.y = n2;
        this.appendRect.width = n3;
        this.appendRect.height = n4;
    }

    public void modelToView(TextNode textNode, int n, TextNode textNode2, int n2, RectangleListImpl rectangleListImpl) {
        rectangleListImpl.removeAll();
        int n3 = this.document.documentListenerIndex(this);
        this.textCollector.collect(textNode, n, textNode2, n2, this.rangeList);
        TextRange[] textRangeArray = this.rangeList.list;
        int n4 = this.rangeList.size;
        int n5 = 0;
        while (n5 < n4) {
            TextRange textRange = textRangeArray[n5];
            TextNodeView textNodeView = (TextNodeView)textRange.text.getDocumentListenerData(n3);
            if (textNodeView != null) {
                this.gadgetList.removeAll();
                textNodeView.getTextGadgets(this.gadgetList, n3);
                int n6 = 0;
                while (n6 < this.gadgetList.size) {
                    Gadget gadget = this.gadgetList.list[n6];
                    if (gadget instanceof TextNodeViewText) {
                        int n7;
                        this.point.y = 0;
                        this.point.x = 0;
                        gadget.gadgetToRoot(this.point);
                        if (this.point.x < this.width && this.point.y < this.height && this.point.x + gadget.width > 0 && this.point.y + gadget.height > 0 && (n7 = ((TextNodeViewText)((Object)gadget)).modelToGadget(textRange.offset, textRange.count, rectangleListImpl)) > 0) {
                            Rectangle[] rectangleArray = rectangleListImpl.list;
                            int n8 = rectangleListImpl.size;
                            int n9 = n8 - n7;
                            while (n9 < n8) {
                                Rectangle rectangle = rectangleArray[n9];
                                rectangle.x += this.point.x;
                                rectangle.y += this.point.y;
                                ++n9;
                            }
                        }
                    }
                    ++n6;
                }
            }
            ++n5;
        }
    }

    public void batchEditingStarted(BatchEditingEvent batchEditingEvent, int n) {
        this.batchEditing = true;
    }

    public void batchEditingCompleted(BatchEditingEvent batchEditingEvent, int n) {
        this.batchEditing = false;
        if (this.refreshRoot != null) {
            if (this.refreshRoot.getRoot() == null) {
                this.refreshRoot = this;
            }
            this.refreshRoot.refresh();
            this.refreshRoot = null;
        }
        this.elementEditor.setEditedElement(null);
    }

    public void processingInstructionChanged(ProcessingInstructionEvent processingInstructionEvent, int n) {
        ProcessingInstruction processingInstruction = processingInstructionEvent.getProcessingInstructionSource();
        this.rebuildNodeView(processingInstruction, n);
    }

    public void elementAttributeChanged(ElementAttributeEvent elementAttributeEvent, int n) {
        Element element = elementAttributeEvent.getElementSource();
        switch (this.viewFactory.elementAttributeChanged(elementAttributeEvent, n)) {
            case 1: {
                this.refreshNodeView(element, n);
                break;
            }
            case 2: {
                this.rebuildNodeView(element, n);
            }
        }
        if (!this.batchEditing) {
            this.elementEditor.setEditedElement(null);
        }
    }

    private void refreshNodeView(Node node, int n) {
        NodeView nodeView = (NodeView)node.getDocumentListenerData(n);
        if (nodeView == null) {
            return;
        }
        Gadget gadget = this.findRefreshedGadget(nodeView, n);
        if (gadget != null) {
            this.refreshGadget(gadget);
        }
    }

    private void rebuildNodeView(Node node, int n) {
        Gadget gadget;
        Element element = node.getParentElement();
        if (element == null) {
            if (this.getChildCount() > 0) {
                this.removeChild(0);
            }
            gadget = this;
        } else {
            gadget = this.removeChildViewGadgets(element, node, n);
        }
        this.detachViewTree.run(node);
        Gadget gadget2 = this.attachViewTree.run(node);
        this.refreshGadget(gadget, gadget2);
    }

    private Gadget removeChildViewGadgets(Element element, Node node, int n) {
        NodeView nodeView = (NodeView)node.getDocumentListenerData(n);
        if (nodeView == null) {
            return null;
        }
        ElementView elementView = (ElementView)element.getDocumentListenerData(n);
        if (elementView == null) {
            return this;
        }
        return elementView.removeChildViewGadgets(nodeView, n);
    }

    private void refreshGadget(Gadget gadget, Gadget gadget2) {
        if (gadget == null) {
            if (gadget2 != null) {
                this.refreshGadget(gadget2);
            }
        } else if (gadget2 == null) {
            this.refreshGadget(gadget);
        } else if ((gadget = DocumentView.findCommonAncestor(gadget, gadget2)) == null) {
            this.refreshGadget(this);
        } else {
            this.refreshGadget(gadget);
        }
    }

    public void elementStructureChanged(ElementStructureEvent elementStructureEvent, int n) {
        Element element = elementStructureEvent.getElementSource();
        switch (elementStructureEvent.getId()) {
            case 10: {
                Gadget gadget = this.attachViewTree.run(elementStructureEvent.getNewChild());
                if (gadget == null) break;
                this.refreshGadget(gadget);
                break;
            }
            case 11: {
                Node node = elementStructureEvent.getOldChild();
                Gadget gadget = this.removeChildViewGadgets(element, node, n);
                this.detachViewTree.run(node);
                Gadget gadget2 = this.attachViewTree.run(elementStructureEvent.getNewChild());
                this.refreshGadget(gadget, gadget2);
                break;
            }
            case 12: {
                Node node = elementStructureEvent.getOldChild();
                Gadget gadget = this.removeChildViewGadgets(element, node, n);
                this.detachViewTree.run(node);
                if (gadget == null) break;
                this.refreshGadget(gadget);
            }
        }
        if (!this.batchEditing) {
            this.elementEditor.setEditedElement(null);
        }
    }

    public void customEventHappened(DocumentEvent documentEvent, int n) {
    }

    public void textChanged(TextEvent textEvent, int n) {
        TextNode textNode = textEvent.getTextSource();
        TextNodeView textNodeView = (TextNodeView)textNode.getDocumentListenerData(n);
        if (textNodeView == null) {
            return;
        }
        if (this.batchEditing) {
            Gadget gadget = this.findRefreshedGadget(textNodeView, n);
            if (gadget != null) {
                this.refreshGadget(gadget);
            }
        } else {
            switch (textEvent.getId()) {
                case 0: {
                    String string = textEvent.getNewString();
                    if (string.length() == 1) {
                        textNodeView.charInserted(string.charAt(0), textEvent.getOffset());
                        break;
                    }
                    Gadget gadget = this.findRefreshedGadget(textNodeView, n);
                    if (gadget == null) break;
                    gadget.refresh();
                    break;
                }
                case 2: {
                    String string = textEvent.getOldString();
                    if (string.length() == 1) {
                        textNodeView.charDeleted(string.charAt(0), textEvent.getOffset());
                        break;
                    }
                    Gadget gadget = this.findRefreshedGadget(textNodeView, n);
                    if (gadget == null) break;
                    gadget.refresh();
                    break;
                }
                default: {
                    Gadget gadget = this.findRefreshedGadget(textNodeView, n);
                    if (gadget == null) break;
                    gadget.refresh();
                }
            }
        }
    }

    private Gadget findRefreshedGadget(NodeView nodeView, int n) {
        this.gadgetList.removeAll();
        nodeView.getGadgets(this.gadgetList, n);
        int n2 = this.gadgetList.size;
        Gadget[] gadgetArray = this.gadgetList.list;
        switch (n2) {
            case 0: {
                return null;
            }
            case 1: {
                return gadgetArray[0];
            }
        }
        Gadget gadget = gadgetArray[0].parent;
        int n3 = 1;
        while (n3 < n2) {
            if (gadgetArray[n3].parent != gadget) break;
            ++n3;
        }
        if (n3 < n2) {
            gadget = gadgetArray[0];
            n3 = 1;
            while (n3 < n2) {
                if ((gadget = DocumentView.findCommonAncestor(gadget, gadgetArray[n3])) == null) break;
                ++n3;
            }
        }
        return gadget == null ? this : gadget;
    }

    private void refreshGadget(Gadget gadget) {
        if (!this.batchEditing) {
            gadget.refresh();
            return;
        }
        if (this.refreshRoot == null) {
            this.refreshRoot = gadget;
            return;
        }
        if (this.refreshRoot == gadget || this.refreshRoot == this) {
            return;
        }
        Gadget gadget2 = DocumentView.findCommonAncestor(this.refreshRoot, gadget);
        this.refreshRoot = gadget2 == null ? this : gadget2;
    }

    private static final Gadget findCommonAncestor(Gadget gadget, Gadget gadget2) {
        Gadget gadget3 = gadget2;
        while (gadget3 != null) {
            if (gadget3 == gadget) {
                return gadget;
            }
            gadget3 = gadget3.parent;
        }
        Gadget[] gadgetArray = gadget.getAncestors();
        gadget3 = gadget2;
        while (gadget3 != null) {
            int n = gadgetArray.length - 1;
            while (n >= 0) {
                if (gadget3 == gadgetArray[n]) {
                    return gadget3;
                }
                --n;
            }
            gadget3 = gadget3.parent;
        }
        return null;
    }

    public void markChanged(MarkChangeEvent markChangeEvent) {
        this.damaged.height = 0;
        this.damaged.width = 0;
        this.damaged.y = 0;
        this.damaged.x = 0;
        Object object = null;
        Object object2 = null;
        MarkChangeEvent.Change[] changeArray = markChangeEvent.getChanges();
        int n = 0;
        while (n < changeArray.length) {
            MarkChangeEvent.Change change = changeArray[n];
            Object object3 = change.mark.getId();
            if (object3 == "DOT") {
                this.magicX = -1;
            }
            switch (change.type) {
                case 0: 
                case 3: {
                    Highlight highlight = this.highlightFactory.createHighlight(change.mark);
                    if (highlight == null) break;
                    this.addHighlight(highlight);
                    Rectangle rectangle = highlight.relayout();
                    AWTUtil.union(this.damaged, rectangle);
                    if (object3 == "DOT") {
                        object = rectangle;
                        break;
                    }
                    if (object3 != "SELECTED") break;
                    object2 = rectangle;
                    break;
                }
                case 1: 
                case 4: {
                    Object object4;
                    Mark mark;
                    Object object5;
                    int n2 = 0;
                    while (n2 < this.highlights.length) {
                        Highlight highlight = this.highlights[n2];
                        object5 = highlight.getMark();
                        mark = highlight.getMark2();
                        if (((Mark)object5).getId().equals(object3) || mark != null && mark.getId().equals(object3)) {
                            AWTUtil.union(this.damaged, highlight.getBounds());
                            object4 = highlight.relayout();
                            AWTUtil.union(this.damaged, (Rectangle)object4);
                            if (object3 == "DOT") {
                                object = object4;
                            } else if (object3 == "SELECTED") {
                                object2 = object4;
                            }
                        }
                        ++n2;
                    }
                    break;
                }
                case 2: 
                case 5: {
                    Object object4;
                    Mark mark;
                    Object object5;
                    boolean bl = false;
                    int n3 = 0;
                    while (n3 < this.highlights.length) {
                        object5 = this.highlights[n3];
                        mark = object5.getMark();
                        object4 = object5.getMark2();
                        if (mark.getId().equals(object3) || object4 != null && ((Mark)object4).getId().equals(object3)) {
                            AWTUtil.union(this.damaged, object5.getBounds());
                            this.highlights[n3].dispose();
                            this.highlights[n3] = null;
                            bl = true;
                        }
                        ++n3;
                    }
                    if (!bl) break;
                    this.trimHighlights();
                }
            }
            ++n;
        }
        if (this.damaged.width > 0 && this.damaged.height > 0) {
            this.repaint(this.damaged.x, this.damaged.y, this.damaged.width, this.damaged.height);
        }
        if (object != null) {
            if (((Rectangle)object).width > 0 && ((Rectangle)object).height > 0) {
                this.makeRectangleVisible(((Rectangle)object).x, ((Rectangle)object).y, ((Rectangle)object).width, ((Rectangle)object).height);
            }
        } else if (object2 != null && this.markManager.getDot() == null && ((Rectangle)object2).width > 0 && ((Rectangle)object2).height > 0) {
            this.makeRectangleVisible(((Rectangle)object2).x, ((Rectangle)object2).y, ((Rectangle)object2).width, ((Rectangle)object2).height);
        }
    }

    private void addHighlight(Highlight highlight) {
        Highlight[] highlightArray = new Highlight[this.highlights.length + 1];
        System.arraycopy(this.highlights, 0, highlightArray, 0, this.highlights.length);
        highlightArray[this.highlights.length] = highlight;
        this.highlights = highlightArray;
    }

    private void trimHighlights() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.highlights.length) {
            if (this.highlights[n2] != null) {
                ++n;
            }
            ++n2;
        }
        Highlight[] highlightArray = new Highlight[n];
        n = 0;
        int n3 = 0;
        while (n3 < this.highlights.length) {
            if (this.highlights[n3] != null) {
                highlightArray[n++] = this.highlights[n3];
            }
            ++n3;
        }
        this.highlights = highlightArray;
    }

    public void print(Graphics graphics) {
        super.print(graphics);
        DocumentView.paintText(this, graphics);
    }

    public void paint(Graphics graphics) {
        Object object;
        super.paint(graphics);
        Rectangle rectangle = graphics.getClipBounds();
        int n = 0;
        while (n < this.highlights.length) {
            Highlight highlight = this.highlights[n];
            if (!highlight.isAboveText()) {
                object = highlight.relayout();
                if (rectangle == null || ((Rectangle)object).x < rectangle.x + rectangle.width && ((Rectangle)object).y < rectangle.y + rectangle.height && ((Rectangle)object).x + ((Rectangle)object).width > rectangle.x && ((Rectangle)object).y + ((Rectangle)object).height > rectangle.y) {
                    highlight.paint(graphics);
                }
            }
            ++n;
        }
        DocumentView.paintText(this, graphics);
        int n2 = 0;
        while (n2 < this.highlights.length) {
            object = this.highlights[n2];
            if (object.isAboveText()) {
                Rectangle rectangle2 = object.relayout();
                if (rectangle == null || rectangle2.x < rectangle.x + rectangle.width && rectangle2.y < rectangle.y + rectangle.height && rectangle2.x + rectangle2.width > rectangle.x && rectangle2.y + rectangle2.height > rectangle.y) {
                    object.paint(graphics);
                }
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void paintText(GadgetContainer gadgetContainer, Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        Gadget[] gadgetArray = gadgetContainer.getChildren();
        int n = gadgetArray.length;
        int n2 = gadgetContainer.width;
        int n3 = 0;
        while (n3 < n) {
            Graphics graphics2;
            Gadget gadget = gadgetArray[n3];
            if (gadget instanceof TextNodeViewText) {
                if (rectangle == null || gadget.x < rectangle.x + rectangle.width && gadget.y < rectangle.y + rectangle.height && gadget.x + gadget.width > rectangle.x && gadget.y + gadget.height > rectangle.y) {
                    Object var10_9;
                    graphics2 = graphics.create(gadget.x, gadget.y, n2 - gadget.x, gadget.height);
                    try {
                        ((TextNodeViewText)((Object)gadget)).paintText(graphics2);
                        var10_9 = null;
                        graphics2.dispose();
                    }
                    catch (Throwable throwable) {
                        var10_9 = null;
                        graphics2.dispose();
                        throw throwable;
                    }
                }
            } else if (gadget instanceof GadgetContainer && (rectangle == null || gadget.x < rectangle.x + rectangle.width && gadget.y < rectangle.y + rectangle.height && gadget.x + gadget.width > rectangle.x && gadget.y + gadget.height > rectangle.y)) {
                Object var12_10;
                graphics2 = graphics.create(gadget.x, gadget.y, gadget.width, gadget.height);
                try {
                    DocumentView.paintText((GadgetContainer)gadget, graphics2);
                    var12_10 = null;
                    graphics2.dispose();
                }
                catch (Throwable throwable) {
                    var12_10 = null;
                    graphics2.dispose();
                    throw throwable;
                }
            }
            ++n3;
        }
    }

    public boolean grabsMouseButton(MouseEvent mouseEvent) {
        return this.bindings.grabsMouseButton(mouseEvent);
    }

    public void handleMouseEvent(MouseEvent mouseEvent) {
        this.bindings.handleMouseEvent(mouseEvent);
    }

    public boolean handleKeyEvent(KeyEvent keyEvent) {
        if (this.bindings.handleKeyEvent(keyEvent)) {
            return true;
        }
        if (keyEvent.getID() == 400 && this.editable) {
            int n = keyEvent.getModifiers();
            if (!PlatformUtil.IS_MAC_OS && (n & 8) == (n & 2) || PlatformUtil.IS_MAC_OS && (n & 6) == 0) {
                char c = keyEvent.getKeyChar();
                if (c >= ' ' && c <= '~' || c >= '\u00a0' && c <= '\u00ff') {
                    if (this.commandListeners != null && !this.notifyCommandListeners("insertString", Character.toString(c), -1, -1, 0, null)) {
                        return false;
                    }
                    this.insertString(charStrings[c]);
                    if (this.commandListeners != null) {
                        this.notifyCommandListeners("insertString", Character.toString(c), -1, -1, 3, null);
                    }
                    return true;
                }
                if (c > '\u00ff' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd') {
                    if (this.commandListeners != null && !this.notifyCommandListeners("insertString", Character.toString(c), -1, -1, 0, null)) {
                        return false;
                    }
                    this.chars1[0] = c;
                    this.insertString(new String(this.chars1, 0, 1));
                    if (this.commandListeners != null) {
                        this.notifyCommandListeners("insertString", Character.toString(c), -1, -1, 3, null);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isAppEventHandler(AppEvent appEvent) {
        return this.bindings.isAppEventHandler(appEvent);
    }

    public void handleAppEvent(AppEvent appEvent) {
        this.bindings.handleAppEvent(appEvent);
    }

    public void addCommandListener(CommandListener commandListener) {
        if (this.commandListeners == null) {
            this.commandListeners = new CommandListener[]{commandListener};
            return;
        }
        if (this.indexOfCommandListener(commandListener) >= 0) {
            return;
        }
        CommandListener[] commandListenerArray = new CommandListener[this.commandListeners.length + 1];
        System.arraycopy(this.commandListeners, 0, commandListenerArray, 0, this.commandListeners.length);
        commandListenerArray[this.commandListeners.length] = commandListener;
        this.commandListeners = commandListenerArray;
    }

    private int indexOfCommandListener(CommandListener commandListener) {
        int n = this.commandListeners.length - 1;
        while (n >= 0) {
            if (this.commandListeners[n] == commandListener) {
                return n;
            }
            --n;
        }
        return -1;
    }

    public void removeCommandListener(CommandListener commandListener) {
        int n;
        int n2;
        int n3;
        if (this.commandListeners == null || (n3 = this.indexOfCommandListener(commandListener)) < 0) {
            return;
        }
        if (this.commandListeners.length == 1) {
            this.commandListeners = null;
            return;
        }
        CommandListener[] commandListenerArray = new CommandListener[this.commandListeners.length - 1];
        if (n3 > 0) {
            System.arraycopy(this.commandListeners, 0, commandListenerArray, 0, n3);
        }
        if ((n2 = this.commandListeners.length - (n = n3 + 1)) > 0) {
            System.arraycopy(this.commandListeners, n, commandListenerArray, n3, n2);
        }
        this.commandListeners = commandListenerArray;
    }

    public CommandListener[] getCommandListeners() {
        if (this.commandListeners == null) {
            return NO_COMMAND_LISTENERS;
        }
        return this.commandListeners;
    }

    public boolean hasCommandListeners() {
        return this.commandListeners != null;
    }

    public void notifyCommandListeners(String string, String string2, int n, int n2) {
        if (this.commandListeners == null) {
            return;
        }
        Command command = Commands.getCommand(string);
        if (command == null) {
            return;
        }
        this.notifyCommandListeners(command, string2, n, n2);
    }

    public void notifyCommandListeners(Command command, String string, int n, int n2) {
        if (this.notifyCommandListeners(command, string, n, n2, 0, null)) {
            this.notifyCommandListeners(command, string, n, n2, 3, null);
        }
    }

    public boolean notifyCommandListeners(String string, String string2, int n, int n2, int n3, Object object) {
        if (this.commandListeners == null) {
            return true;
        }
        Command command = Commands.getCommand(string);
        if (command == null) {
            return true;
        }
        return this.notifyCommandListeners(command, string2, n, n2, n3, object);
    }

    public boolean notifyCommandListeners(Command command, String string, int n, int n2, int n3, Object object) {
        if (this.commandListeners == null) {
            return true;
        }
        this.commandEvent.command = command;
        this.commandEvent.parameter = string;
        this.commandEvent.x = n;
        this.commandEvent.y = n2;
        this.commandEvent.status = n3;
        this.commandEvent.result = object;
        return this.notifyCommandListeners(this.commandEvent);
    }

    public boolean notifyCommandListeners(CommandEvent commandEvent) {
        int n;
        CommandListener[] commandListenerArray = this.commandListeners;
        if (commandListenerArray == null) {
            return true;
        }
        boolean bl = commandEvent.status != 0;
        boolean bl2 = false;
        if (!bl) {
            n = commandListenerArray.length - 1;
            while (n >= 0) {
                boolean bl3 = commandListenerArray[n].executingCommand(commandEvent);
                if (!bl3) {
                    bl2 = true;
                }
                --n;
            }
            if (bl2) {
                commandEvent.status = 1;
                bl = true;
            }
        }
        if (bl) {
            n = commandListenerArray.length - 1;
            while (n >= 0) {
                commandListenerArray[n].commandExecuted(commandEvent);
                --n;
            }
        }
        return !bl2;
    }

    static {
        char[] cArray = new char[1];
        int n = 0;
        while (n < charStrings.length) {
            cArray[0] = (char)n;
            DocumentView.charStrings[n] = new String(cArray, 0, 1);
            ++n;
        }
    }

    private final class ViewTreeDetacher
    extends Traversal.HandlerBase {
        private int viewIndex;

        private ViewTreeDetacher() {
        }

        public void run(Node node) {
            this.viewIndex = DocumentView.this.document.documentListenerIndex(DocumentView.this);
            NodeView nodeView = (NodeView)node.getDocumentListenerData(this.viewIndex);
            if (nodeView == null) {
                return;
            }
            Traversal.traverse(node, this);
        }

        public Object enterElement(Element element) {
            ElementView elementView = (ElementView)element.getDocumentListenerData(this.viewIndex);
            if (elementView == null) {
                return Traversal.LEAVE_ELEMENT;
            }
            elementView.detachingFromModel(DocumentView.this.document, this.viewIndex);
            return null;
        }

        public Object processText(Text text) {
            NodeView nodeView = (NodeView)text.getDocumentListenerData(this.viewIndex);
            if (nodeView != null) {
                nodeView.detachingFromModel(DocumentView.this.document, this.viewIndex);
                text.setDocumentListenerData(this.viewIndex, null);
            }
            return null;
        }

        public Object processComment(Comment comment) {
            NodeView nodeView = (NodeView)comment.getDocumentListenerData(this.viewIndex);
            if (nodeView != null) {
                nodeView.detachingFromModel(DocumentView.this.document, this.viewIndex);
                comment.setDocumentListenerData(this.viewIndex, null);
            }
            return null;
        }

        public Object processPI(ProcessingInstruction processingInstruction) {
            NodeView nodeView = (NodeView)processingInstruction.getDocumentListenerData(this.viewIndex);
            if (nodeView != null) {
                nodeView.detachingFromModel(DocumentView.this.document, this.viewIndex);
                processingInstruction.setDocumentListenerData(this.viewIndex, null);
            }
            return null;
        }

        public Object leaveElement(Element element) {
            element.setDocumentListenerData(this.viewIndex, null);
            return null;
        }
    }

    private final class ViewTreeAttacher
    extends Traversal.HandlerBase {
        private Stack stack = new Stack();
        private int viewIndex;
        private Gadget refreshed;

        private ViewTreeAttacher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public Gadget run(Node var1_1) {
            block6: {
                this.viewIndex = DocumentView.access$200(DocumentView.this).documentListenerIndex(DocumentView.this);
                var2_2 = var1_1.getParentElement();
                if (var2_2 != null) {
                    var3_3 = (ElementView)var2_2.getDocumentListenerData(this.viewIndex);
                    if (var3_3 == null) {
                        return null;
                    }
                    this.stack.push(var3_3);
                }
                this.refreshed = null;
                try {
                    Traversal.traverse(var1_1, this);
                    var5_4 = null;
                    ** while (!this.stack.empty())
                }
                catch (Throwable var4_6) {
                    var5_5 = null;
                    ** while (!this.stack.empty())
                }
lbl-1000:
                // 1 sources

                {
                    this.stack.pop();
                    continue;
lbl19:
                    // 1 sources

                    break block6;
                }
lbl-1000:
                // 1 sources

                {
                    this.stack.pop();
                    continue;
                }
lbl27:
                // 1 sources

                throw var4_6;
            }
            var4_7 = this.refreshed;
            this.refreshed = null;
            return var4_7;
        }

        public Object enterElement(Element element) {
            ElementView elementView = this.stack.empty() ? null : (ElementView)this.stack.peek();
            ElementView elementView2 = DocumentView.this.viewFactory.createElementView(element, elementView);
            if (elementView2 == null) {
                return Traversal.LEAVE_ELEMENT;
            }
            this.stack.push(elementView2);
            return null;
        }

        public Object processText(Text text) {
            ElementView elementView = this.stack.empty() ? null : (ElementView)this.stack.peek();
            TextNodeView textNodeView = DocumentView.this.viewFactory.createTextView(text, elementView);
            if (textNodeView != null) {
                text.setDocumentListenerData(this.viewIndex, textNodeView);
                this.refreshed = elementView.addChildViewGadgets(textNodeView, this.viewIndex);
            }
            return null;
        }

        public Object processComment(Comment comment) {
            ElementView elementView = this.stack.empty() ? null : (ElementView)this.stack.peek();
            TextNodeView textNodeView = DocumentView.this.viewFactory.createCommentView(comment, elementView);
            if (textNodeView != null) {
                comment.setDocumentListenerData(this.viewIndex, textNodeView);
                this.refreshed = elementView.addChildViewGadgets(textNodeView, this.viewIndex);
            }
            return null;
        }

        public Object processPI(ProcessingInstruction processingInstruction) {
            ElementView elementView = this.stack.empty() ? null : (ElementView)this.stack.peek();
            TextNodeView textNodeView = DocumentView.this.viewFactory.createProcessingInstructionView(processingInstruction, elementView);
            if (textNodeView != null) {
                processingInstruction.setDocumentListenerData(this.viewIndex, textNodeView);
                this.refreshed = elementView.addChildViewGadgets(textNodeView, this.viewIndex);
            }
            return null;
        }

        public Object leaveElement(Element element) {
            ElementView elementView = (ElementView)this.stack.peek();
            this.stack.pop();
            ElementView elementView2 = this.stack.empty() ? null : (ElementView)this.stack.peek();
            element.setDocumentListenerData(this.viewIndex, elementView);
            if (elementView2 == null) {
                GadgetListImpl gadgetListImpl = DocumentView.this.gadgetList;
                gadgetListImpl.removeAll();
                elementView.getGadgets(gadgetListImpl, this.viewIndex);
                if (DocumentView.this.getChildCount() > 0) {
                    DocumentView.this.removeChild(0);
                }
                if (gadgetListImpl.size > 0) {
                    DocumentView.this.addChild(gadgetListImpl.list[gadgetListImpl.size - 1]);
                }
                this.refreshed = DocumentView.this;
            } else {
                this.refreshed = elementView2.addChildViewGadgets(elementView, this.viewIndex);
            }
            return null;
        }
    }
}

