/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.view;

import com.xmlmind.xmledit.edit.MarkManager;
import com.xmlmind.xmledit.view.DocumentPane;
import com.xmlmind.xmledit.view.DocumentView;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JScrollPaneSupport
extends ComponentAdapter
implements ChangeListener,
Runnable {
    private DocumentView docView;
    private JViewport viewport;
    private boolean tracksViewportWidth;
    private boolean ensureDotIsVisible;
    private Dimension dim = new Dimension();

    public JScrollPaneSupport(DocumentPane documentPane, JScrollPane jScrollPane) {
        this.docView = documentPane.getDocumentView();
        this.viewport = jScrollPane.getViewport();
        this.tracksViewportWidth = true;
        this.ensureDotIsVisible = true;
        this.viewport.setScrollMode(1);
        this.viewport.addComponentListener(this);
        this.viewport.addChangeListener(this);
    }

    public DocumentView getDocumentView() {
        return this.docView;
    }

    public JViewport getViewport() {
        return this.viewport;
    }

    public void setViewportWidthTracked(boolean bl) {
        this.tracksViewportWidth = bl;
    }

    public boolean isViewportWidthTracked() {
        return this.tracksViewportWidth;
    }

    public void setDotAlwaysVisible(boolean bl) {
        this.ensureDotIsVisible = bl;
    }

    public boolean isDotAlwaysVisible() {
        return this.ensureDotIsVisible;
    }

    public void componentResized(ComponentEvent componentEvent) {
        if (this.tracksViewportWidth) {
            this.viewport.getSize(this.dim);
            this.docView.layout(this.dim.width, -1);
            this.docView.repaint();
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        MarkManager markManager;
        if (this.ensureDotIsVisible && (markManager = this.docView.getMarkManager()) != null && markManager.getMark() == null && markManager.getSelected() == null) {
            SwingUtilities.invokeLater(this);
        }
    }

    public void run() {
        this.docView.ensureDotIsVisible();
    }
}

