/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.view;

import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.edit.Mark;
import com.xmlmind.xmledit.edit.NodeMark;
import com.xmlmind.xmledit.guiutil.AWTUtil;
import com.xmlmind.xmledit.view.DocumentView;
import com.xmlmind.xmledit.view.Highlight;
import com.xmlmind.xmledit.view.HighlightSettings;
import com.xmlmind.xmledit.view.RectangleListImpl;
import com.xmlmind.xmledit.view.RectangularEnvelope;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

public class NodeHighlight
implements Highlight {
    private DocumentView docView;
    private NodeMark mark;
    private NodeMark mark2;
    private Settings settings;
    private Rectangle bounds = new Rectangle();
    private Rectangle[][] rectLists = new Rectangle[0][];
    private RectangleListImpl rectList = new RectangleListImpl();
    private RectangularEnvelope envelope = new RectangularEnvelope();
    private RectangularEnvelope.Points points = new RectangularEnvelope.Points();

    public NodeHighlight(DocumentView documentView, NodeMark nodeMark, Settings settings) {
        this(documentView, nodeMark, null, settings);
    }

    public NodeHighlight(DocumentView documentView, NodeMark nodeMark, NodeMark nodeMark2, Settings settings) {
        this.docView = documentView;
        this.mark = nodeMark;
        this.mark2 = nodeMark2;
        this.settings = settings;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public DocumentView getDocumentView() {
        return this.docView;
    }

    public boolean isAboveText() {
        return false;
    }

    public Mark getMark() {
        return this.mark;
    }

    public Mark getMark2() {
        return this.mark2;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public Rectangle relayout() {
        Node node;
        int n;
        int n2;
        Node node2;
        Node node3 = this.mark.getNode();
        if (this.mark2 == null) {
            node2 = node3;
            n2 = 1;
        } else {
            node2 = this.mark2.getNode();
            if (node2.getParent() != node3.getParent()) {
                node2 = node3;
                n2 = 1;
            } else {
                n = 1;
                n2 = 0;
                node = node3;
                while (node != null) {
                    ++n2;
                    if (node == node2) {
                        n = 0;
                        break;
                    }
                    node = node.getNextSibling();
                }
                if (n != 0) {
                    node = node3;
                    node3 = node2;
                    node2 = node;
                    n2 = 0;
                    node = node3;
                    while (node != null) {
                        ++n2;
                        if (node == node2) break;
                        node = node.getNextSibling();
                    }
                }
            }
        }
        this.rectLists = new Rectangle[n2][];
        n2 = 0;
        this.bounds.height = 0;
        this.bounds.width = 0;
        this.bounds.y = 0;
        this.bounds.x = 0;
        node = node3;
        while (node != null) {
            this.docView.modelToView(node, this.rectList);
            n = this.rectList.size;
            Rectangle[] rectangleArray = this.rectList.list;
            Rectangle[] rectangleArray2 = new Rectangle[this.rectList.size];
            int n3 = 0;
            while (n3 < n) {
                Rectangle rectangle = rectangleArray[n3];
                if (rectangle.height > 0) {
                    if (rectangle.width <= 0) {
                        rectangle.width = 1;
                    }
                    AWTUtil.union(this.bounds, rectangle);
                }
                rectangleArray2[n3] = new Rectangle(rectangle);
                ++n3;
            }
            this.rectList.removeAll();
            this.rectLists[n2++] = rectangleArray2;
            if (node == node2) break;
            node = node.getNextSibling();
        }
        return this.bounds;
    }

    public void paint(Graphics graphics) {
        graphics.setColor(this.settings.color);
        int n = 0;
        while (n < this.rectLists.length) {
            Rectangle[] rectangleArray = this.rectLists[n];
            if (rectangleArray.length == 1) {
                Rectangle rectangle = rectangleArray[0];
                graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
            } else {
                this.envelope.compute(rectangleArray, rectangleArray.length, this.points);
                graphics.drawPolygon(this.points.x, this.points.y, this.points.count);
            }
            ++n;
        }
    }

    public void dispose() {
    }

    public static class Settings
    extends HighlightSettings {
        public Settings() {
            this.color = Color.red;
        }
    }
}

