/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.view;

import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.ProcessingInstruction;
import com.xmlmind.xmledit.doc.Text;
import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.gadget.PaintUtil;
import com.xmlmind.xmledit.view.Msg;
import com.xmlmind.xmledit.view.TreeViewFactory;
import com.xmlmind.xmledit.view.ViewSettings;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

public abstract class Outline
extends Gadget {
    protected Settings settings;
    protected static final int TEXT_AUTO_LABEL_MAX_LENGTH = 18;
    private static String attributeLabel = " " + Msg.msg("O.attribute");
    private static String attributesLabel = " " + Msg.msg("O.attributes");
    private static String textLabel = Msg.msg("O.text");
    private static String commentLabel = Msg.msg("O.comment");
    private static String processingInstructionLabel = Msg.msg("O.processingInstruction") + " ";

    protected Outline(Settings settings) {
        this.settings = settings;
    }

    public Settings getSettings() {
        return this.settings;
    }

    protected abstract Node getNode();

    public void layout(int n, int n2, boolean bl) {
        Dimension dimension = Outline.computeSize(this, this.settings, this.getNode());
        this.width = dimension.width;
        this.height = dimension.height;
    }

    public static final boolean hasOutline(ViewSettings viewSettings) {
        return viewSettings.icon != null || viewSettings.label != null || viewSettings.autoLabel;
    }

    public static final Dimension computeSize(Gadget gadget, ViewSettings viewSettings, Node node) {
        Dimension dimension = new Dimension();
        Outline.computeSize(gadget, viewSettings, node, dimension);
        return dimension;
    }

    public static final void computeSize(Gadget gadget, ViewSettings viewSettings, Node node, Dimension dimension) {
        FontMetrics fontMetrics = gadget.getFontMetrics(viewSettings.font);
        int n = fontMetrics.getAscent() + fontMetrics.getDescent();
        int n2 = fontMetrics.charWidth('x');
        int n3 = TreeViewFactory.Settings.collapseBitmapWidth + 5;
        int n4 = TreeViewFactory.Settings.collapseBitmapHeight;
        if (viewSettings.icon != null) {
            n3 += n2 + viewSettings.icon.getHeight(null);
            n4 = Math.max(n4, viewSettings.icon.getHeight(null));
        }
        if (viewSettings.label != null) {
            n3 += n2 + fontMetrics.stringWidth(viewSettings.label);
            n4 = Math.max(n4, n);
        }
        if (viewSettings.autoLabel) {
            n3 = node instanceof Text ? (n3 += n2 + 20 * n2) : (n3 += n2 + fontMetrics.stringWidth(Outline.getAutoLabel(node)));
            n4 = Math.max(n4, n);
        }
        dimension.width = n3 += n2;
        dimension.height = n4;
    }

    public static final String getAutoLabel(Node node) {
        switch (node.getNodeType()) {
            case 4: {
                int n = ((Element)node).getAttributeCount();
                if (n > 1) {
                    return Integer.toString(n) + attributesLabel;
                }
                return Integer.toString(n) + attributeLabel;
            }
            case 0: {
                char[] cArray = ((Text)node).getTextChars();
                StringBuffer stringBuffer = new StringBuffer();
                if (cArray.length <= 18) {
                    Outline.compressWhiteSpace(cArray, cArray.length, stringBuffer);
                } else {
                    Outline.compressWhiteSpace(cArray, 15, stringBuffer);
                    stringBuffer.append("...");
                }
                return stringBuffer.toString();
            }
            case 1: {
                return commentLabel;
            }
            case 2: {
                return processingInstructionLabel + ((ProcessingInstruction)node).getTarget();
            }
        }
        return "???";
    }

    private static final void compressWhiteSpace(char[] cArray, int n, StringBuffer stringBuffer) {
        int n2 = 63;
        int n3 = 0;
        while (n3 < n) {
            int n4 = cArray[n3];
            switch (n4) {
                case 9: 
                case 10: 
                case 13: {
                    n4 = 32;
                }
            }
            if (n4 == 32) {
                if (n2 != 32) {
                    stringBuffer.append((char)n4);
                    n2 = n4;
                }
            } else {
                stringBuffer.append((char)n4);
                n2 = n4;
            }
            ++n3;
        }
    }

    public void paint(Graphics graphics) {
        if (this.settings.backgroundColor != null) {
            graphics.setColor(this.settings.backgroundColor);
            graphics.fillRect(0, 0, this.width, this.height);
        }
        Outline.paintOutline(this, this.settings, this.getNode(), graphics);
    }

    public static final int paintOutline(Gadget gadget, ViewSettings viewSettings, Node node, Graphics graphics) {
        PaintUtil.configureTextRendering(graphics);
        FontMetrics fontMetrics = graphics.getFontMetrics(viewSettings.font);
        int n = fontMetrics.getAscent();
        int n2 = n + fontMetrics.getDescent();
        int n3 = fontMetrics.charWidth('x');
        int n4 = TreeViewFactory.Settings.collapseBitmapHeight;
        if (viewSettings.icon != null) {
            n4 = Math.max(n4, viewSettings.icon.getHeight(null));
        }
        if (viewSettings.label != null) {
            n4 = Math.max(n4, n2);
        }
        if (viewSettings.autoLabel) {
            n4 = Math.max(n4, n2);
        }
        Outline.paintArc(gadget, viewSettings, node, n4, graphics);
        int n5 = TreeViewFactory.Settings.collapseBitmapWidth + 5 + n3;
        int n6 = n4 / 2;
        if (viewSettings.icon != null) {
            graphics.drawImage(viewSettings.icon, n5, n6 - viewSettings.icon.getHeight(null) / 2, null);
            n5 += viewSettings.icon.getWidth(null) + n3;
        }
        graphics.setColor(viewSettings.textColor);
        graphics.setFont(viewSettings.font);
        n6 = n6 - n2 / 2 + n;
        if (viewSettings.label != null) {
            graphics.drawString(viewSettings.label, n5, n6);
            n5 += fontMetrics.stringWidth(viewSettings.label) + n3;
        }
        if (viewSettings.autoLabel) {
            String string = Outline.getAutoLabel(node);
            graphics.drawString(string, n5, n6);
        }
        return n4;
    }

    public static final void paintArc(Gadget gadget, ViewSettings viewSettings, Node node, int n, Graphics graphics) {
        boolean bl;
        int n2 = TreeViewFactory.Settings.collapseBitmapWidth / 2;
        int n3 = n / 2;
        graphics.setColor(viewSettings.arcColor);
        graphics.drawLine(n2, 0, n2, n3);
        if (node.getNodeType() == 4) {
            bl = ((Element)node).getFirstChild() != null;
        } else {
            boolean bl2 = bl = node.getNextSibling() != null;
        }
        if (bl) {
            graphics.drawLine(n2, n3, n2, gadget.height - 1);
        }
        int n4 = TreeViewFactory.Settings.collapseBitmapWidth + 5;
        graphics.drawLine(n2, n3, n4 - 1, n3);
    }

    public static class Settings
    extends ViewSettings {
        public Settings() {
            this.backgroundColor = null;
            this.textColor = Color.black;
            this.arcColor = Color.gray;
            this.font = new Font("SansSerif", 0, 10);
            this.icon = null;
            this.label = null;
            this.autoLabel = true;
        }
    }
}

