/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.view;

import com.xmlmind.xmledit.doc.TextNode;
import com.xmlmind.xmledit.edit.Mark;
import com.xmlmind.xmledit.edit.TextLocation;
import com.xmlmind.xmledit.guiutil.AWTUtil;
import com.xmlmind.xmledit.view.DocumentView;
import com.xmlmind.xmledit.view.Highlight;
import com.xmlmind.xmledit.view.HighlightSettings;
import com.xmlmind.xmledit.view.RectangleListImpl;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

public class TextHighlight
implements Highlight {
    private DocumentView docView;
    private TextLocation textLocation;
    private TextLocation textLocation2;
    private Settings settings;
    private Rectangle bounds = new Rectangle();
    private RectangleListImpl rectList = new RectangleListImpl();

    public TextHighlight(DocumentView documentView, TextLocation textLocation, TextLocation textLocation2, Settings settings) {
        this.docView = documentView;
        this.textLocation = textLocation;
        this.textLocation2 = textLocation2;
        this.settings = settings;
    }

    public DocumentView getDocumentView() {
        return this.docView;
    }

    public TextLocation getTextLocation() {
        return this.textLocation;
    }

    public TextLocation getTextLocation2() {
        return this.textLocation2;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public boolean isAboveText() {
        return false;
    }

    public Mark getMark() {
        return this.textLocation;
    }

    public Mark getMark2() {
        return this.textLocation2;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public Rectangle relayout() {
        TextNode textNode = this.textLocation.getTextNode();
        int n = this.textLocation.getOffset();
        TextNode textNode2 = this.textLocation2.getTextNode();
        int n2 = this.textLocation2.getOffset();
        if (textNode == textNode2 && n == n2) {
            this.docView.modelToView(textNode, n, this.bounds);
            if (this.bounds.height > 0) {
                this.bounds.width = 1;
                this.rectList.removeAll();
                this.rectList.appendRectangle(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
            }
        } else {
            this.docView.modelToView(textNode, n, textNode2, n2, this.rectList);
            int n3 = this.rectList.size;
            Rectangle[] rectangleArray = this.rectList.list;
            this.bounds.height = 0;
            this.bounds.width = 0;
            this.bounds.y = 0;
            this.bounds.x = 0;
            int n4 = 0;
            while (n4 < n3) {
                Rectangle rectangle = rectangleArray[n4];
                if (rectangle.height > 0) {
                    if (rectangle.width <= 0) {
                        rectangle.width = 1;
                    }
                    AWTUtil.union(this.bounds, rectangle);
                }
                ++n4;
            }
        }
        return this.bounds;
    }

    public void paint(Graphics graphics) {
        int n = this.rectList.size;
        if (n <= 0) {
            return;
        }
        Rectangle rectangle = graphics.getClipBounds();
        graphics.setColor(this.settings.color);
        Rectangle[] rectangleArray = this.rectList.list;
        int n2 = 0;
        while (n2 < n) {
            Rectangle rectangle2 = rectangleArray[n2];
            if (rectangle == null || rectangle2.x < rectangle.x + rectangle.width && rectangle2.y < rectangle.y + rectangle.height && rectangle2.x + rectangle2.width > rectangle.x && rectangle2.y + rectangle2.height > rectangle.y) {
                graphics.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            }
            ++n2;
        }
    }

    public void dispose() {
    }

    public static class Settings
    extends HighlightSettings {
        public Settings() {
            this.color = Color.gray;
        }
    }
}

